/*
 * Decompiled with CFR 0.152.
 */
package PSG_Emu;

import PSG_Emu.Speaker;

public class PSG_Chip {
    Speaker sp;
    private float[] f_downsampling_buffer = new float[32];
    private int i_downsampling_buffer_pointer;
    private final int ONESECOND = 223721;
    private final int NTSC_FRAME = 3732;
    private final int PAL_FRAME = 4474;
    private float[] amplitude = new float[32];
    private float actual_output_height;
    private float actual_output_center;
    public float[] output_stream = new float[4474];
    private int down_sampling;
    private int[] period = new int[4];
    private byte[] attenuation = new byte[4];
    private int[] counter = new int[4];
    private boolean[] flipflop = new boolean[4];
    private int ShiftRegister;
    private int ShiftRegister_PRESET = 16384;
    private byte noise_code;
    private boolean freq3;
    private boolean white_noise;
    private final byte max_attenuation = (byte)15;
    private final int[] NoiseFreqs = new int[]{32, 64, 128, 0};

    public PSG_Chip() {
        this.initialize_amplitude_table();
        this.initialize_chip();
        this.sp = new Speaker();
        this.down_sampling = 6;
        this.sp.set_framerate(223721 / this.down_sampling);
        new Thread(this.sp).start();
    }

    private void initialize_amplitude_table() {
        this.amplitude[0] = 1.0f;
        for (int i = 1; i < 15; ++i) {
            this.amplitude[i] = this.amplitude[i - 1] / 1.2589254f;
        }
        this.amplitude[15] = 0.0f;
    }

    public void initialize_chip() {
        for (int i = 0; i < 4; ++i) {
            this.period[i] = 0;
            this.attenuation[i] = 15;
            this.counter[i] = 0;
            this.flipflop[i] = false;
        }
        this.freq3 = false;
        this.white_noise = true;
        this.noise_code = (byte)-1;
        this.actual_output_height = 0.0f;
        this.actual_output_center = 0.0f;
        this.ShiftRegister = this.ShiftRegister_PRESET;
    }

    private void update_noise_period() {
        if (this.freq3) {
            this.period[0] = this.period[3] * 2;
        }
    }

    public void clear_stream() {
        this.sp.clean_stream();
    }

    public void start_playing() {
        this.sp.start_playing();
    }

    public void stop_playing() {
        this.sp.stop_playing();
    }

    public void kill() {
        this.sp.kill();
    }

    public void mute(byte by) {
        this.attenuation[by] = 15;
    }

    public void mute() {
        this.attenuation[0] = 15;
        this.attenuation[1] = 15;
        this.attenuation[2] = 15;
        this.attenuation[3] = 15;
    }

    public void tone(byte by, int n, byte by2) {
        this.attenuation[by] = by2;
        this.period[by] = n;
    }

    public void noise(byte by, byte by2) {
        this.attenuation[0] = by2;
        if (by != this.noise_code) {
            this.noise_code = by;
            this.ShiftRegister = this.ShiftRegister_PRESET;
        }
        this.white_noise = (by & 4) == 4;
        if ((by = (byte)(by & 3)) == 3) {
            this.freq3 = true;
        } else {
            this.freq3 = false;
            this.period[0] = this.NoiseFreqs[by];
        }
    }

    private float tick() {
        float f = 0.0f;
        this.update_noise_period();
        for (int i = 0; i < 4; ++i) {
            if (this.attenuation[i] == 15) {
                this.counter[i] = 0;
                continue;
            }
            if (this.period[i] != 0) {
                int n = i;
                this.counter[n] = this.counter[n] + 1;
            }
            if (this.counter[i] >= this.period[i]) {
                this.counter[i] = 0;
                if (i == 0) {
                    this.flipflop[0] = (this.ShiftRegister & 1) == 1;
                    int n = this.white_noise ? (this.ShiftRegister ^ this.ShiftRegister >>> 1) & 1 : this.ShiftRegister & 1;
                    this.ShiftRegister = this.ShiftRegister >>> 1 | n << 14;
                } else {
                    boolean bl = this.flipflop[i] = !this.flipflop[i];
                }
            }
            if (!this.flipflop[i]) continue;
            f -= this.amplitude[this.attenuation[i]];
        }
        return f;
    }

    public int refresh(boolean bl) {
        if (bl) {
            this.dorefresh(3732);
            return 3732;
        }
        this.dorefresh(4474);
        return 4474;
    }

    private void dorefresh(int n) {
        for (int i = 0; i < n; ++i) {
            this.output_stream[i] = this.tick();
            this.output_stream[i] = (this.output_stream[i] + this.actual_output_height * 15.0f) / 16.0f;
            this.actual_output_height = this.output_stream[i];
            int n2 = i;
            this.output_stream[n2] = this.output_stream[n2] + this.actual_output_center;
            float f = -this.output_stream[i] / 360.0f;
            this.actual_output_center += f;
        }
        this.downsampling(n);
    }

    private void downsampling(int n) {
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            this.f_downsampling_buffer[this.i_downsampling_buffer_pointer++] = this.output_stream[i];
            if (this.i_downsampling_buffer_pointer != this.down_sampling) continue;
            f = 0.0f;
            for (int j = 0; j < this.down_sampling; ++j) {
                f += this.f_downsampling_buffer[j];
            }
            int n2 = Math.round(f * 91.5f / ((float)this.down_sampling * 1.0f));
            if (n2 < -128) {
                n2 = -128;
            }
            if (n2 > 127) {
                n2 = 127;
            }
            this.sp.add_data((byte)(n2 & 0xFF));
            this.i_downsampling_buffer_pointer = 0;
        }
    }
}

