;***************************************************************************
;**                                                                       **
;**                       SERIAL port,baudrate,stats                      **
;**                                                                       **
;**                       SmartBASIC 1.x version 20Y                      **
;**                 (c) 1991, 1994 by Richard F. Drushel                  **
;**                                                                       **
;**                                                                       **
;**       version 3.2    9410.01   ;no BLOAD header                       **
;**       version 3.1    9410.01   ;SmartBASIC 1.x test environment;      **
;**                                ;makes a BLOAD file; fixes fatal       **                    
;**                                ;stack bug and corrected typo which    **
;**                                ;replaced (BAUDRATE) with (BASEPORT)   **
;**                                ;in CHECK_BAUDRATE.                    **
;**       version 3.0    9408.26   ;modified for Dale Wick; cleans up     **
;**                                ;spaghetti from patched binary;        **
;**                                ;removes token extraction CALLs and    **
;**                                ;other interpreter-dependent code;     **
;**                                ;new entry/exit parameter passing.     **
;**       version 2.0    91xx.xx   ;added MIB2 and ADAMlink modem;        **
;**       version 1.0    90xx.xx   ;original Eve/Orphanware support       **
;**                                ;this is the release version 20X-Y     **
;**                                                                       **
;**  On entry, C=serial baseport, HL=baudrate, and B=data/parity/stop     **
;**  flag (0=7E1, 1=8N1).  On exit, ZF=1 and A=0 if the initialization    **
;**  successful, ZF=0 and A=error code if not.                            **
;**                                                                       **
;**  Destroys AF, BC, DE, HL.                                             **
;**                                                                       **
;***************************************************************************

;serial baseports

     SER_MIB21_PORT      EQU  24
     SER_MIB22_PORT      EQU  16
     SER68_PORT          EQU  68
     SER76_PORT          EQU  76
     SER84_PORT          EQU  84
     SER92_PORT          EQU  92
     ALINK_MODEM_PORT    EQU  94

     N_BASEPORTS         EQU  7    ;make sure you update this if you add
                                   ;new serial ports (like SydModem)

     ILLEGAL_QUANT_ERR   EQU  4    ;SmartBASIC error number; replace it
                                   ;with your favorite non-zero error code.

;***************************************************************************

;;make a BLOAD header
;
;     ORG     35550-5            ;make assembler happy
;     DB      1,0,2              ;magic header
;     DW      START              ;load address
;     ORG     35550              ;start of SmartBASIC 1.x LOMEM  
                                ;i.e. MEM(0))

START:

;***************************************************************************
__SERIAL:

          LD A,C
          LD (BASEPORT),A          ;save the baseport
          LD (BAUDRATE),HL         ;save the baudrate
          LD A,B
          LD (DPS_STATS),A         ;save the stats

;now verify the baseport:

          LD A,C                   ;A=baseport
          LD B,N_BASEPORTS         ;number of possible baseports
          LD DE,4                  ;length of each CURRENT_PORTS entry
          LD HL,CURRENT_PORTS      ;point to table
PCHECK_LOOP:
          CP (HL)                  ;does it match?
          JR Z,CHECK_BAUDRATE      ;yes
          ADD HL,DE                ;no, so offset to next entry
          DJNZ PCHECK_LOOP         ;and keep looking
          JR SERIAL_ERR            ;error out
SERIAL_ERR_2:
          POP HL
SERIAL_ERR:          
          LD A,ILLEGAL_QUANT_ERR   ;get error code
          OR A                     ;ZF=0 for error
          RET                      

;********

;now let's verify the baudrate:

CHECK_BAUDRATE:
          PUSH HL                  ;save our table offset
          LD HL,(BAUDRATE)         ;get the entry baudrate
          EX DE,HL                 ;into DE
          LD HL,EOA_BAUDRATE_TABLE ;assume it's Eve/Orphanware/ADAMlink
          CP SER68_PORT            ;is it really?
          JR NC, GET_BAUDRATE_DATA ;yes
          LD HL,MIB2_BAUDRATE_TABLE ;no, it's MIB2
GET_BAUDRATE_DATA:
          LD B,6                   ;number of entries in table
BLCHECK_LOOP:
          LD A,(HL)                ;get baudrate lobyte
          CP E                     ;does it match entry lobyte?
          JR Z,BHCHECK_LOOP        ;yes, so now check hibyte
          INC HL                   ;no, so skip to next entry
          INC HL
          INC HL
BCHECK_DJNZ:
          DJNZ BLCHECK_LOOP        ;keep going until done
          JR SERIAL_ERR_2          ;sorry, no match

;********
BHCHECK_LOOP:
          INC HL                   ;point to hibyte
          LD A,(HL)                ;get it
          CP D                     ;does it match entry hibyte?
          JR NZ,BCHECK_DJNZ        ;no

;baudrate matches; now must check that ADAMlink modem was not initialized
;to anything except 300 baud.

          LD A,C                   ;A=baseport
          CP ALINK_MODEM_PORT      ;was it the ADAMlink modem?
          JR NZ,SAVE_BAUDRATE_DATA ;no, so save everything
          LD HL,300                ;yes, so now check for 300 baud
          OR A                     ;clear CF
          SBC HL,DE                ;was it 300 baud?
          JR NZ,SERIAL_ERR_2       ;no, so error exit
          JR SAVE_BAUDRATE         ;yes, so save it
                                   ;we skip saving the raw data because
                                   ;the ADAMlink modem has its own special
                                   ;wakeup routine (even though it has a
                                   ;2651 UART like Eve/Orphanware)
;********
SAVE_BAUDRATE_DATA:
          INC HL                   ;point to raw baudrate data
          LD A,(HL)                ;get it
          LD (BAUDRATE_DATA),A     ;save the raw data
SAVE_BAUDRATE:
          LD (BAUDRATE),DE         ;save the entry baudrate

;now we have to verify the data/parity/stop stats:

          LD A,(DPS_STATS)         ;get the stats flag
          CP 2                     ;is it valid? (0 or 1 only)
          JR NC,SERIAL_ERR_2       ;sorry, bad stats

          LD A,C                   ;A=baseport
          LD HL,MIB2_DPS_TABLE     ;guess that it's MIB2
          CP SER68_PORT            ;is it really?
          JR C,GET_DPS             ;yes
          LD HL,EO_DPS_TABLE       ;no, so guess that it's Eve/Orphanware
          CP ALINK_MODEM_PORT      ;is it really?
          JR NZ,GET_DPS            ;yes
          LD HL,ALINK_DPS_TABLE    ;no, it's really the ADAMlink modem
GET_DPS:
          LD A,(DPS_STATS)         ;get the entry stats
          ADD A,L                  ;offset into table
          LD L,A                   ;partial sum
          JR NC,GET_DPS_DATA       ;no carry needed
          INC H                    ;do the carry
GET_DPS_DATA:
          LD A,(HL)                ;get the raw data
          LD (DPS_STATS_DATA),A    ;save the raw data

;now we can update this baseport's entry in the CURRENT_PORTS table:          

          POP HL                   ;restore the CURRENT_PORTS offset
          INC HL                   ;point to baudrate entry
          LD BC,(BAUDRATE)         ;get current baudrate
          LD (HL),C                ;save lobyte
          INC HL                   ;point to hibyte
          LD (HL),B                ;save hibyte
          INC HL                   ;point to next
          LD A,(DPS_STATS)         ;get the data/parity/stop stats
          LD (HL),A                ;save them

;now we're all set to do the actual port initializations:

          LD A,(BASEPORT)          ;baseport to initialize
          CP SER68_PORT            ;is it MIB2?
          JR C,MIB2_INIT           ;yes, so do MIB2 init
          CP ALINK_MODEM_PORT      ;no, but is it the ADAMlink modem?
          JR NZ,EO_INIT            ;no, so do Eve/Orphanware init

;***************************************************************************
;ADAMlink modem initialization:  300 baud *only*.

ALINK_MODEM_INIT:

          LD A,128
          OUT (ALINK_MODEM_PORT+1),A    ;wake it up at 300 baud
          LD A,64
          OUT (ALINK_MODEM_PORT+1),A    ;here comes the data/parity/stop
          LD A,(DPS_STATS_DATA)
          OUT (ALINK_MODEM_PORT+1),A    ;send the data/parity/stop

          XOR A                         ;A=0, ZF=1 for okay exit
          RET

;***************************************************************************
;Eve/Orphanware initialization.  On entry, A=serial baseport.

EO_INIT:
          ADD A,3
          LD C,A
          IN A,(C)                 ;yoo-hoo...
          XOR A
          OUT (C),A                ;here I am...
          DEC C
          LD A,(DPS_STATS_DATA)
          OUT (C),A                ;send the data/parity/stop
          LD A,(BAUDRATE_DATA)
          OUT (C),A                ;send the baudrate
          INC C
          LD A,39
          OUT (C),A                ;take that, you brute...

          XOR A                    ;A=0, ZF=1 for okay exit
          RET

;***************************************************************************
;MIB2 initialization.  On entry, A=serial baseport.

;This routine comes from Mark Gordon's docs for the MIB2.  I don't like it,
;because it requires *both* MIB2 ports to be initialized at once.  Problem
;is, when I have modified it to only init one of the two ports, the other
;port is damaged somehow--it gets inactivated.  I'm not sure if this is
;a hardware design problem or just lack of detailed docs from Mark Gordon.

;The best solution I was able to come up with was to establish boot-up
;defaults for both ports, and to save the current status of each port.
;Thus, when you want to change one port, the second is effectively
;re-initialized at its current baudrate/data/parity/stop.  I realize that
;this would be fatal to an open modem connection, but it seems to cause
;no problems with serial terminals and/or printers.

MIB2_INIT:

     LD HL,BAUDRATE_DATA           ;raw baudrate data for UART
     LD B,(HL)                     ;get it
     INC HL                        ;point to raw data/parity/stop data
     LD C,(HL)                     ;get it
     CP SER_MIB22_PORT             ;is this MIB2 port 2?
     JR Z,MIB22_INIT               ;yes, so init MIB22

MIB21_INIT:
     LD A,C                        ;no, MIB21, so get data/parity/stop
     LD (MIB21_DPS_DATA),A         ;save it in MIB2_INIT_TABLE
     LD A,B                        ;get baudrate
     LD (MIB21_BAUDRATE_DATA),A    ;save it in MIB2_INIT_TABLE
     JR MIB2_COMMON

;********
MIB22_INIT:
     LD A,C                        ;get data/parity/stop
     LD (MIB22_DPS_DATA),A         ;save it in MIB2_INIT_TABLE
     LD A,B                        ;get baudrate
     LD (MIB22_BAUDRATE_DATA),A    ;save it in MIB2_INIT_TABLE

;now we can send the init table:

MIB2_COMMON:
     LD HL,MIB2_INIT_TABLE         ;point to start of table
MIB2_OTIR_LOOP:
     LD C,(HL)                     ;get the port to write
     LD A,C                        ;into A
     INC A                         ;one more (test end-of-table)
     INC HL                        ;point to number of bytes to send
     JR Z,MIB2_EXIT                ;end of table reached, so exit
     LD B,(HL)                     ;get # of bytes to send
     INC HL                        ;point to 1st data byte
     OTIR                          ;send all the data in this record
     JR MIB2_OTIR_LOOP             ;go back for more data
;********
MIB2_EXIT:
          XOR A                    ;A=0, ZF=1 for okay exit
          RET

;***************************************************************************
;Current SERIAL parameters for MIB2/Eve/Orphanware/ADAMlink modem, in
;baseport order.  Baudrate and stats entries are updated by the SERIAL
;command, so that the SER(port) function can return current initialization
;parameters on demand.  Note:  the baseport entries in this table are used
;to verify the entry baseport, so don't delete it!

CURRENT_PORTS:

          DB SER_MIB21_PORT        ;MIB2 port 1
          DW 0                     ;baudrate
          DB 0                     ;stats
;
          DB SER_MIB22_PORT        ;MIB2 port 2
          DW 0                     ;baudrate
          DB 0                     ;stats
;          
          DB SER68_PORT            ;Eve/Orphanware port
          DW 0                     ;baudrate
          DB 0                     ;stats
;
          DB SER76_PORT            ;Eve/Orphanware port
          DW 0                     ;baudrate
          DB 0                     ;stats
;
          DB SER84_PORT            ;Eve/Orphanware port
          DW 0                     ;baudrate
          DB 0                     ;stats
;
          DB SER92_PORT            ;Eve/Orphanware port
          DW 0                     ;baudrate
          DB 0                     ;stats
;
          DB ALINK_MODEM_PORT      ;ADAMlink modem port
          DW 0                     ;baudrate
          DB 0                     ;stats

;***************************************************************************
;MIB2 baudrate data for initialization.
;Format:  baudrate (word), data (byte).

MIB2_BAUDRATE_TABLE:

          DW 300
          DB 68
;
          DW 1200
          DB 102
;
          DW 2400
          DB 136
;
          DW 4800
          DB 153
;
          DW 9600
          DB 187
;
          DW 19200
          DB 204

;***************************************************************************
;Eve/Orphanware/ADAMlink modem baudrate data for initialization.
;Format:  baudrate (word), data (byte).

EOA_BAUDRATE_TABLE:

          DW 300
          DB 53
;
          DW 1200
          DB 55
;
          DW 2400
          DB 58
;
          DW 4800
          DB 60
;
          DW 9600
          DB 62
;
          DW 19200
          DB 63

;***************************************************************************
;MIB2 data/parity/stop data for initialization.

MIB2_DPS_TABLE:
          DB 2      ;7E1
          DB 19     ;8N1

;***************************************************************************
;Eve/Orphanware data/parity/stop data for initialization.

EO_DPS_TABLE:
          DB 122    ;Eve/Orphanware 7E1
          DB 78     ;Eve Orphanware 8N1

;***************************************************************************
;ADAMlink modem data/parity/stop data for initialization.

ALINK_DPS_TABLE:
          DB 251    ;ADAMlink 7E1
          DB 79     ;ADAMlink 8N1

;***************************************************************************
;SERIAL temporary data.

BASEPORT:
          DB 0      ;port
BAUDRATE:
          DW 0      ;baudrate
DPS_STATS:
          DB 0      ;stats (as 0 or 1)
BAUDRATE_DATA:
          DB 0      ;baudrate (actual data sent to UART)
DPS_STATS_DATA:
          DB 0      ;stats (actual data sent to UART)
                    ;NOTE:  this entry *MUST* follow BAUDRATE_DATA!!!

;***************************************************************************
;MIB2 serial board initialization data.
;Format:  port, # bytes to send, data.  Port 255=end of table.

MIB2_INIT_TABLE:

MIB22_DPS_DATA      EQU  MIB2_INIT_TABLE+6   ;data/parity/stop port 2
MIB21_DPS_DATA      EQU  MIB2_INIT_TABLE+10  ;data/parity/stop port 1
MIB22_BAUDRATE_DATA EQU  MIB2_INIT_TABLE+14  ;baudrate port 2
MIB21_BAUDRATE_DATA EQU  MIB2_INIT_TABLE+17  ;baudrate port 1

          DB   1,2,255,247      ;wakeup
          DB   16,2,19,7        ;8N1 default port 2
          DB   24,2,19,7        ;8N1 default port 1
          DB   17,1,204         ;19200 baud default port 2
          DB   25,1,136         ;2400 baud default port 1
          DB   18,1,5           ;
          DB   26,1,5           ;
          DB   20,1,240         ;
          DB   30,1,255         ;
          DB   255              ;end of table

;***************************************************************************




