;****************************************************************************
;****************************************************************************
;****************************************************************************
;***                                                                      ***
;***                                                                      ***
;***     SBOOTxx.ASM -- ADAMserve Serially-Linked Device Server Boot      ***
;***                                                                      ***
;***                      block 0 boot for boot disk/tape                 ***
;***                                                                      ***
;***                  (c) 1994 by Richard F. Drushel, Ph.D.               ***
;***                                                                      ***
;***                         All Rights Reserved                          ***
;***                                                                      ***
;***                                                                      ***
;****************************************************************************
;****************************************************************************
;****************************************************************************

;version history:

;     2.a       9507.15        ;formatted for direct inclusion in HARDDISK.
;     2.0       9507.15        ;pass C=serial baseport to HARDDISK/SERVBOOTx
;     1.0       9410.01        ;initial coding

;****************************************************************************

;EOS equates

COLD_BOOT      EQU  51200
EOS_STACK_TOP  EQU  65112
CURRENT_DEV    EQU  64879
_OPEN_FILE     EQU  64704
_READ_FILE     EQU  64722
_CLOSE_FILE    EQU  64707
_GOTO_WP       EQU  64743
READ_MODE      EQU  1

;server serial port equates

SER_MIB21_PORT    EQU  24
SER_MIB22_PORT    EQU  16
SER68_PORT        EQU  68
SER76_PORT        EQU  76
SER84_PORT        EQU  84
SER92_PORT        EQU  92
ALINK_MODEM_PORT  EQU  94     ;you're an idiot if you try to use this as the
                              ;server serial port, don'tcha know...

;other equates

FILE_SIZE      EQU  1024
START2         EQU  COLD_BOOT-FILE_SIZE
INIT_BAUDRATE  EQU  19200
N81            EQU  1

;****************************************************************************

;     ORG COLD_BOOT
     .PHASE COLD_BOOT

;****************************************************************************

START0:

     JR SKIPPER               ;skip the default server serial baseport

;****************************************************************************

SERVER_BASEPORT:

     DB   SER76_PORT          ;default is port 76; poke in a new value if
                              ;you want a different server serial port

;****************************************************************************

SKIPPER:

;first do some setup

     DI                       ;disable maskable interrupts
     LD SP,EOS_STACK_TOP      ;use EOS stack
     LD A,B                   ;get current device #
     LD (CURRENT_DEV),A       ;save it

;now relocate ourselves (to make way for the next boot block)

     LD HL,START1
     LD DE,START2
     LD BC,PROG_SIZE2
     LDIR                     ;copy it

     JP START2                ;and resume

;****************************************************************************

START1:     

     .DEPHASE
     .PHASE START2

;now initialize the desired serial port

     LD A,(SERVER_BASEPORT)   ;get the server serial baseport
     PUSH AF                  ;save it
     LD C,A                   ;into C
     LD HL,INIT_BAUDRATE      ;get speed to initialize port at
     LD B,N81                 ;no parity, 8 data, 1 stop
     CALL __SERIAL            ;initialize the port
     JP NZ,_GOTO_WP           ;initialization failed, goto SmartWriter

;now load the next file

     LD A,(CURRENT_DEV)       ;get current device #
     LD HL,SERVBOOT2_FILENAME ;point to filename string
     LD B,READ_MODE           ;read-only
     CALL _OPEN_FILE          ;EOS open file
     JP NZ,_GOTO_WP           ;failed, so goto SmartWriter

     PUSH AF                  ;save the file number
     LD BC,FILE_SIZE          ;how many bytes to read
     LD HL,COLD_BOOT          ;where to load it
     CALL _READ_FILE          ;EOS read file
     JP NZ,_GOTO_WP           ;failed, so goto SmartWriter

     POP AF                   ;restore file number
     CALL _CLOSE_FILE         ;EOS close file
     JP NZ,_GOTO_WP           ;failed, so goto SmartWriter

;now run the next file

     POP AF                   ;restore serial baseport
     LD C,A                   ;into C
     LD A,(CURRENT_DEV)       ;get our boot device
     LD B,A                   ;into B because boot blocks expect it
     JP COLD_BOOT             ;run it

;****************************************************************************
     
SERVBOOT2_FILENAME:

     DB   "SERVBOOT2",2,3

;****************************************************************************
     
     $INCLUDE SIOINI32.ASM    ;the server serial port initialization routines

;****************************************************************************

END2:

     .DEPHASE

PROG_SIZE2     EQU  END2-START2
PROG_SIZE1     EQU  START1-START0
PROG_SIZE0     EQU  PROG_SIZE1+PROG_SIZE2

     DS   FILE_SIZE-PROG_SIZE0          ;pad it out with zeroes

;****************************************************************************

