;***************************************************************************
;*                                                                         *
;*          HARDDISK shell EOS program loader for the Coleco ADAM          *
;*                         (c) 1991 by Tony Morehen                        *
;*                                                                         *
;*        Modified for the ADAMserve serially-linked device protocol       *
;*                           by Richard F. Drushel                         *
;*    ADAMserve modifications (c) 1994, 1995, 2000 by Richard F. Drushel   *      *
;*                                                                         *
;*                                                                         *
;*                                                                         *
;*  version history                                                        *
;*                                                                         *
;*  4.203  0008.13           ;Same as 4.202 except uses 1ST2BLK5.ASM       *
;*                           ;(which changed year to 2000 and had some     *
;*                           ;fixed comments).                             *
;*                                                                         *
;*  4.202  0007.21           ;Patched to preserve contents of              *
;*                           ;SERIAL_BASEPORT when loading EOS4.X.  This   *
;*                           ;should have been done in 4.200, because the  *
;*                           ;boot SERIAL_BASEPORT also gets wiped when    *
;*                           ;the new EOS is loaded in.  If you weren't    *
;*                           ;using the same serial port as when EOS4.X    *
;*                           ;was compiled, you lose the serial link.      *
;*                           ;Defined VERLO1 and VERLO2 for extra version  *
;*                           ;string information; requires DATA5.Z80.      *
;*                                                                         *
;*  4.201  9609.01           ;slight patch to set new EOS global variable, *
;*                           ;PRINT_UNDERLINE_FLAG, to disable underline   * 
;*                           ;printing from _CONS_DISP.  It restores the   * 
;*                           ;flag to the default state before launching   * 
;*                           ;any programs.                                *
;*                           ;Also sets EOS REV_NUM to 6.                  *
;*                           ;Also changed version and copyright strings;  *
;*                           ;Requires 1ST2BLK4.ASM and DATA4.Z80.         *
;*                                                                         *
;*  4.200  9608.24           ;modifications for new EOS550.ASM which is    *
;*                           ;required for the ADAMserve FILEMAN program.  *
;*                           ;Specifically, whenever we want to load       *
;*                           ;a new EOS file (e.g. EOS4.X for SmartLOGO),  *
;*                           ;we have to make sure that (1) we save the    *
;*                           ;current ANET2SERVER table; (2) restore it    *
;*                           ;after the new EOS is loaded, and (3) do a    *
;*                           ;_SCAN_ACTIVE in order to update all the      *
;*                           ;DCBs.  Also, every boot of HARDDISK should   *
;*                           ;also do a _SCAN_ACTIVE, to clean up after    *
;*                           ;programs (like PowerPaint) which may have    *
;*                           ;put code up in the DCB area.  Allocated a    *
;*                           ;64-byte buffer at TEMP_ANET2SERVER to hold   *
;*                           ;the table.                                   *
;*                           ;Commented out incomplete INSTALL patches.    *
;*                                                                         *
;*  4.107  9507.15           ;patched INSTALL to write an ADAMserve boot   *
;*                           ;disk.  Added include of SBOOT20.ASM, which   *
;*                           ;is the block 0 boot for the boot disk/tape.  *
;*                           ;Got rid of BIGINSTALL and all the old EOS    *
;*                           ;and SmartBASIC patch code which is useless   *
;*                           ;now.  NOTE:  the INSTALL patch is not yet    *
;*                           ;finished, and this version does not assemble *
;*                           ;without errors.                              *
;*                                                                         *
;*  4.106  9507.15           ;add PowerPaint to alternate EOS list.        *
;*                           ;This disables the miserable boot song.       *
;*                                                                         *
;*  4.105  9507.15           ;patch to boot alternate EOS for ADAMcalc     *
;*                           ;and SmartLOGO.                               *
;*                                                                         *
;*  4.104  9507.15           ;patch to dynamically allocate serial base    *
;*                           ;port.  Requires 1ST2BLK3.ASM, EOS545.ASM,    *
;*                           ;and SBOOT2x.ASM.                             *
;*                                                                         *
;*  4.103  9507.13           ;Disable search for CPM partition table in    *
;*                           ;volume 0 boot block.                         *
;*                                                                         *
;*  4.102  9507.13           ;Disable hard disk FORMAT, PARTITION, and     *
;*                           ;INSTALL SYSTEM menus (irrelevant for now).   *
;*                           ;Requires DATA3.Z80.                          *
;*                                                                         *
;*  4.101  9507.13           ;send CHR$(0) to ADAM printer (device 2) to   *
;*                           ;force ADAMserve to flush print buffer and    *
;*                           ;reset printer.                               *
;*                           ;rename EOS function calls in all modules to  *
;*                           ;Coleco canonical names.  Requires DATA2.Z80, *
;*                           ;S-SPEC2.Z80, and 1ST2BLK2.ASM.               *
;*                                                                         *
;*  4.100  9507.12           ;ADAM/parallel printer toggle.  Requires      *
;*                           ;defined pointer PTR_TO_ANET2SERVER at        *
;*                           ;reserved address 58340 (2 bytes before       *
;*                           ;reserved address HD_VOLMAXCOUNT (58342).     *
;*                           ;Also requires DATA1.Z80.                     *
;*  4.006  9507.12           ;stable interim development version.          *
;*                                                                         *
;*  4.005  9409.24           ;final working version before ADAMcon 06.     *
;*                                                                         *
;*  too many ADAMserve development versions before 4.005 to record here    *
;*                                                                         *
;*  3.9    91xx.xx           ;initial Tony Morehen code from ADAMcon 04.   *
;*                                                                         *
;***************************************************************************

VERHI   EQU     '4'     ;for boot screen & menus
VERLO   EQU     '2'
VERLO1  EQU     '0'
VERLO2  EQU     '3'
DYEAR   EQU     00H     ;for directory
DMONTH  EQU     08H
DDAY    EQU     13H
;
FALSE   EQU     0
TRUE    EQU     NOT     FALSE
;

;***************************************************************************
;*                                                                         *
;*                          ADAMserve equates                              *
;*                                                                         *
;***************************************************************************

PTR_2_SERIAL_BASEPORT EQU 58338   ;pointer to ADAMserve serial baseport in EOS
PTR_2_ANET2SERVER     EQU 58340   ;pointer to ADAMnet-to-ADAMserve device table
NULLDEV               EQU 255     ;code for real ADAMnet device in ANET2SERVE
PP0                   EQU 6       ;ADAMserve parallel printer which emulates
                                  ;the ADAM printer
ADAM_PRINTER          EQU 2       ;ADAMnet device number for ADAM printer
PRINT_UNDERLINE_FLAG  EQU 64863   ;0=print underlines, 255=don't

        .ACCEPT MI
        .ACCEPT IDE
        .ACCEPT SERVER
        .ACCEPT RAMDISK
;
;
BUFFERSIZE EQU  16              ;FOR KRUNCH
;
;characters and function keys
;
CTLC    EQU     3
CR      EQU     13
LF      EQU     10
BS      EQU     8
FF      EQU     12
CLRSCR  EQU     FF
ESC     EQU     27
HOME    EQU     80H
LEFT    EQU     0A3H
UP      EQU     0A0H
RIGHT   EQU     0A1H
DOWN    EQU     0A2H
SK1     EQU     81H
SK2     EQU     82H
SK3     EQU     83H
SK4     EQU     84H
SK5     EQU     85H
SK6     EQU     86H
SSK5    EQU     85H+8
SSK6    EQU     86H+8
WILDCARD        EQU     90H
;
;file attributes
;
BLEFT   EQU     1
DELETED EQU     4
SYSFILE EQU     8
;
;OS7 Equates
;
MODE1ON EQU     01F85H
LDASCII EQU     01F7FH
XYPOS   EQU     00204H
SETFRME EQU     0080BH
;
;EOS jump table vectors
;
_CONS_DISP      EQU     0FC33H
_CONS_INIT      EQU     0FC36H
_CONS_OUT       EQU     0FC39H
_END_RD_KBD     EQU     0FC4BH
_FIND_DCB       EQU     0FC54H
_HARD_INIT      EQU     0FC5DH
_SOFT_INIT      EQU     0FC8DH
_START_RD_KBD   EQU     0FCA8H
_FMGR_INIT      EQU     0FCBAH
_OPEN_FILE      EQU     0FCC0H
_CLOSE_FILE     EQU     0FCC3H
_READ_FILE      EQU     0FCD2H
_GOTO_WP        EQU     0FCE7H
_READ_BLOCK     EQU     0FCF3H
_WRITE_BLOCK    EQU     0FCF6H
_SCAN_ACTIVE    EQU     0FC8AH
PORT_COLLECTION EQU     0FD11H
PUT_ASCII       EQU     0FD17H
WRITE_REGISTER  EQU     0FD20H
FILL_VRAM       EQU     0FD26H
WRITE_VRAM      EQU     0FD1AH
INIT_TABLE      EQU     0FD29H
LOAD_ASCII      EQU     0FD38H
TURN_OFF_SOUND  EQU     0FD53H
_INIT_TAPE_DIR  EQU     0FCBDH  ;@@@
_REQUEST_STATUS EQU     0FC7EH  ;@@@
_PR_CH          EQU     0FC66H  ;@@@

;
;EOS data areas and pointers
;
SPRITEPAT       EQU     3800H
SPRITEATTR      EQU     3880H
;
EOSFCB          EQU     0D390H
THREEBLKS       EQU     0D400H
REV_NUM         EQU     0FD60H
CUR_BANK        EQU     0FD6EH
EOSDEVICE       EQU     0FD6FH
SYSTEM_DATE     EQU     0FDE0H
CURSOR          EQU     0FEA5H
EOS_STACK       EQU     0FE58H
CLEAR_RAM_START EQU     REV_NUM
CLEAR_RAM_SIZE  EQU     0147H
KEYBOARD_BUFFER EQU     0FD75H
VDP_REG_1       EQU     0FD62H
;
;EOS routine patch addresses
;note:  NOT USED IN ADAMSERVE HARDDISK!!!
;
KEYPATCH        EQU     0E3ABH
PATCHHEADER     EQU     0E3E7H
READBLOCK       EQU     0F17BH
WRITEBLOCK      EQU     0F1E6H
INITDIR         EQU     0F325H
GETDCB          EQU     0F446H
REQSTATUS       EQU     0F473H
BOOTDEVICE      EQU     0F8C8H  ;BOOT with device in A
STARTSOUND      EQU     0FD56H  ;JUMP TABLE VECTORS
;
MAXDRIVE        EQU     1       ;number of logical drives
DISK1           EQU     4H
DISK2           EQU     5H
TAPE1           EQU     8H
TAPE2           EQU     18H     ;tape 2 device accesses hard drive
;
;Pointers list for hard drive configuration data
;
PTRACK          EQU     BUFFER+3
PSEEK           EQU     BUFFER+5
PSPT            EQU     BUFFER+6
PNHSPT          EQU     BUFFER+7
PPRECOMP        EQU     BUFFER+8
PMAXDR          EQU     BUFFER+9
PDRVSIZE        EQU     BUFFER+10
POFFSET         EQU     BUFFER+20
PCPM            EQU     BUFFER+43
;
;Parallel Printer patch equates
;
OUTPORT         EQU     40H
PARASTART       EQU     0F501H
BKSPC           EQU     8
LF              EQU     0AH
HLF             EQU     0BH
FF              EQU     0CH
CR              EQU     0DH
REV             EQU     0EH
PARABUF         EQU     0FF90H
CHRINBUF        EQU     0FFF1H
CHARACTER       EQU     0FFF2H
HALF            EQU     0FFF3H
PBUFFLOC        EQU     0FFF4H
DIRECTION       EQU     0FFF6H
;

;miscellaneous equates
;
IF      SERVER

HEADR           EQU     58343           ;where current HD volume is kept;
                                        ;followed by HD volume offset table


ELSE
ENDIF


;
;REPORT MACRO TO SHOW WHERE THINGS ARE
;
REPORT  MACRO   MESSAGE,VALUE
.PRINTX MESSAGE = VALUE
        ENDM
;
;**************************************************
;*                                                *
;*                 HARDDISK START                 *
;*                                                *
;**************************************************

PGMSTART EQU    $
;
        $INCLUDE        1ST2BLK5.ASM
;
        .PHASE  100H
;
        DI

        LD      SP,STACK        
        
        LD      HL,45EDH
        LD      (66H),HL
        LD      (DEFDRV),A
;@@@        LD      (TEMP_DATE),BC
;@@@        LD      A,D
;@@@        LD      (TEMP2_DATE),A

;added 9507.15
        LD      A,C                     ;get serial baseport
        PUSH    AF                      ;save it
;

        XOR     A
        OUT     (42H),A
        LD      HL,0C800H
        LD      DE,BOOTBUF
        LD      BC,400H
        LDIR

;now load our new version of EOS

        LD      A,(EOSDEVICE)
        LD      HL,EOS_STRING
        LD      B,1
        CALL    _OPEN_FILE
        JP      NZ,_GOTO_WP
        PUSH    AF
        LD      HL,32768
        LD      BC,8192
        CALL    _READ_FILE
        JP      NZ,_GOTO_WP
        POP     AF
        CALL    _CLOSE_FILE
        JP      NZ,_GOTO_WP

        LD      HL,32768
        LD      DE,57344
        LD      BC,7519
        LDIR                            ;copy it

;** added 9608.24 **

        CALL    _SCAN_ACTIVE            ;rebuild the DCBs for EOS550+

;** end 9608.24   **

;** added 9609.01 HD4201.ASM **

        LD      A,255
        LD      (PRINT_UNDERLINE_FLAG),A        ;disable underline printing
        LD      A,6
        LD      (REV_NUM),A                     ;set new version of EOS=6

;** end 9609.01 **

        JR      RESET_RETURN

EOS_STRING:
        DB "EOS4.0",2,3

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

;
RESET_RETURN:
;@@@        LD     SP,STACK

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

IF RAMDISK        
        
        CALL 40288                      ;this probably will destroy SP.
                                        ;make sure we don't lose our
                                        ;serial baseport now on the stack.
        LD A,(40455)
        CP 26
        JR Z,SKIP_INIT
        LD A,(40520)
        LD C,A
        LD A,26
        LD HL,(40521)
        INC HL
        EX DE,HL
        LD HL,40512
        CALL _INIT_TAPE_DIR
        JP NZ,_GOTO_WP

ELSE
ENDIF

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

;@@@         LD      HL,0
;@@@ TEMP_DATE       EQU     $-2
;@@@         LD      (SYSTEM_DATE),HL
;@@@         LD      A,0
;@@@ TEMP2_DATE      EQU     $-1
;@@@         LD      (SYSTEM_DATE+2),A
;@@@ ;

SKIP_INIT:

;added 9507.15
        POP     AF                              ;restore A=serial baseport
        LD      HL,(PTR_2_SERIAL_BASEPORT)      ;get vector
        LD      (HL),A                          ;save it into EOS RAM


;

        CALL    SETBORD0        ;set up screen
        LD      BC,0
        CALL    WRITE_REGISTER
        LD      BC,01C0H
        CALL    WRITE_REGISTER
        LD      HL,0
        LD      A,2
        CALL    INIT_TABLE
        LD      HL,0340H
        LD      A,4
        CALL    INIT_TABLE
        LD      HL,0800H
        LD      A,3
        CALL    INIT_TABLE
        LD      HL,SPRITEPAT
        LD      A,1
        CALL    INIT_TABLE
        LD      HL,SPRITEATTR
        XOR     A
        CALL    INIT_TABLE
        LD      BC,18H
        LD      DE,SPRITEPAT
        LD      HL,CURSPAT
        CALL    WRITE_VRAM
        LD      BC,5
        LD      DE,SPRITEATTR
        LD      HL,CURSATTR
        CALL    WRITE_VRAM
        CALL    SETNORM
        CALL    SETINV
        LD      A,' '
        LD      DE,0300H
        LD      HL,0
        PUSH    HL
        CALL    FILL_VRAM
        CALL    LOAD_ASCII
        POP     HL
        PUSH    HL
        LD      BC,80H
        LD      DE,0C00H
        CALL    PUT_ASCII
        LD      BC,1F17H
        POP     HL
        LD      DE,100H
        CALL    _CONS_INIT
;
        CALL    _START_RD_KBD

HDTEST:
        CALL    NAME
        CALL    CUROFF
        LD      HL,DRVINFO
        CALL    PRTSTR
;
        CALL    INIT_HARD_DRV   ;only valid for real hard drives
        CALL    TEST_HARD_DRV   ;do various setup things
;
        XOR     A               ;build table of logical drive names
        LD      (HEADR),A
        LD      A,(MAXD1)
        LD      B,A
        LD      DE,DRVNAMES
RDDRVNAM1:
        PUSH    BC
        PUSH    DE
        LD      HL,BUFFER
        LD      BC,0
        LD      DE,1
        LD      A,TAPE2
        CALL    _READ_BLOCK
        POP     DE
        LD      HL,BUFFER
        LD      B,11
RDDRVNAM2:
        LD      A,(HL)
        CP      ' '
        JR      C,RDDRVNAM3
        LD      (DE),A
        INC     HL
        INC     DE
        DJNZ    RDDRVNAM2
        JR      RDDRVNAM4
RDDRVNAM3:
        LD      A,' '
        LD      (DE),A
        INC     DE
        DJNZ    RDDRVNAM3
RDDRVNAM4:
        XOR     A
        LD      (DE),A
        INC     DE
        LD      HL,HEADR
        INC     (HL)
        POP     BC
        DJNZ    RDDRVNAM1
        XOR     A
        LD      (HEADR),A

;@@@        LD      A,TAPE2
;@@@        LD      BC,0
;@@@        LD      DE,(CPMTRK)
;@@@        LD      HL,BUFFER
;@@@        CALL    _READ_BLOCK
;@@@        LD      HL,(BUFFER)
;@@@        LD      DE,0118H
;@@@        OR      A
;@@@        SBC     HL,DE
;@@@        LD      A,L
;@@@        OR      H

        LD      A,1
        OR      A               ;set A nonzero and ZF=0 to flag no CP/M

        LD      (CPM_PRES),A
        LD      A,WILDCARD
        LD      (CPMX1),A
        LD      A,SK6
        LD      (CPMX2),A
        JR      Z,RESET_ADAMSERVE_PP0
        LD      A,0FFH
        LD      (CPMX1),A
        LD      (CPMX2),A

RESET_ADAMSERVE_PP0:

;this routine is neccesary to get rid of any garbage which might
;be lying around in the print line buffer, and also to home the print
;head if it's stopped halfway across a page.

        LD HL,(PTR_2_ANET2SERVER)       ;get address of ADAMnet to ADAMserve
                                        ;device table
        LD DE,ADAM_PRINTER*2            ;offset amount
        ADD HL,DE                       ;point to ADAM printer entry
        LD A,(HL)                       ;get current value
        PUSH AF                         ;save it
        LD A,PP0                        ;emulated ADAMnet printer pp0
        LD (HL),A                       ;temporarily make device 2 --> pp0
        XOR A                           ;ADAMserve code:  reset pp0/flush buffer
        CALL _PR_CH                     ;print the character to device 2
        POP AF                          ;get old value for device 2
        LD (HL),A                       ;and save it

;*************************************************
;*                                               *
;*                    MAIN LOOP                  *
;*                                               *
;*************************************************

RESTART:
        LD      SP,STACK
MAIN:
        CALL    CUROFF
        CALL    NAME
        CALL    FIX_MAINMENU_FOR_PRINTERS       ;patch the SmartKey VI string
        LD      HL,MAINMENU
        CALL    PRTSTR
        LD      DE,1601H
        CALL    PRESS
        LD      DE,1607H
        LD      HL,WPMSG
        CALL    PRTLOC
        LD      A,(CPM_PRES)
        OR      A
        JR      NZ,MAIN0
        LD      DE,1707H
        LD      HL,CPMMSG
        CALL    PRTLOC
MAIN0:
        LD      BC,(HEADR)
        LD      DE,0416H
        CALL    GOTORC
        LD      B,0
        PUSH    BC
        CALL    DCOUT2
        POP     BC
        LD      DE,050FH
        CALL    PRTVNAME
        CALL    CIN
        CP      ESC
        JR      Z,QUIT
        CP      CTLC
        JR      Z,QUIT
        CP      SK1
        JP      Z,CHANGELOGICAL
        CP      SK3
        JP      Z,BOOTHD
        CP      SK4
        JP      Z,BOOT
        CP      SSK6
        JP      Z,SETDATE
        CP      SK5
        JP      Z,MAINTENANCE
        CP      WILDCARD
CPMX1   EQU     $-1
        JP      Z,BOOTCPM
;
        IF      MI
;
        CP      SK2
        JP      Z,CHANGEFLOPP
;
        ENDIF
;
        CP      SK6
        JP      Z,PARAPATCH
        JR      MAIN0
;
QUIT:
        CALL    CLS
        LD      SP,EOS_STACK
;
DEFPGM:                         ;This code is also used by SYSGEN
        XOR     A
        LD      (KEYBOARD_BUFFER),A             ;clear keyboard buffer

;** added 9609.01 HD4201.ASM **

        LD      (PRINT_UNDERLINE_FLAG),A        ;enable underline printing

;** end 9609.01 **

        LD      BC,45EDH
        LD      (66H),BC
        JP      _GOTO_WP

;***************************************************
;*                                                 *
;*               CHANGE LOGICAL DRIVE              *
;*                                                 *
;***************************************************

CHANGELOGICAL:
        CALL    CHANGEL
        JP      MAIN0
CHANGEL:
        LD      A,(HEADR)
        INC     A
        CP      MAXDRIVE
MAXD1   EQU     $-1
        JR      C,CHANGE1
        XOR     A
CHANGE1:
        LD      (HEADR),A
        RET
;
SET_INITDRV:
        CALL    CHANGEL
        LD      A,(MAXD3)
        LD      C,A
        LD      A,(HEADR)
        LD      B,A
        SUB     C
        LD      C,'1'
        JR      C,SET_INITDRVB
        LD      C,'2'
        LD      B,A
SET_INITDRVB:
        LD      A,C
        LD      (INITDRV),A
        LD      A,B
        LD      D,0
        LD      E,A
        ADD     A,'0'
        LD      (INITVOL),A
        LD      HL,DRIVESIZES
        ADD     HL,DE
        LD      E,D
        LD      D,(HL)
        LD      (VOLXSIZE),DE
        LD      A,D
        LD      (FX1LEN),A
        LD      (FX1USED),A
        ADD     A,80H
        LD      (DIRXSIZE),A
        LD      HL,SAVE_VOLNAME
        LD      DE,VOLXNAME
        LD      BC,11
        LDIR
        RET


;**************************************************************
;*                                                            *
;*                       SET SYSTEM DATE                      *
;*                                                            *
;**************************************************************


TRYAGAIN:
        POP     HL
        POP     HL              ;clear stack
SETDATE:
        CALL    NAME
        LD      HL,DATES
        CALL    PRTSTR
        LD      DE,0608H
        CALL    GET2N
        LD      (SYSTEM_DATE),HL        ;get L into year 
GETMONTH:
        LD      DE,0808H
        CALL    GET2N
        LD      A,L
        OR      A
        JR      Z,GETMONTH
        CP      13H
        JR      NC,GETMONTH
        LD      (SYSTEM_DATE+1),A
GETDAY:
        LD      DE,0A08H
        CALL    GET2N
        LD      A,L
        OR      A
        JR      Z,GETDAY
        CP      '2'
        JR      NC,GETDAY
        LD      (SYSTEM_DATE+2),A
        JP      RESTART
GET2N:
        CALL    GOTORC
        LD      A,' '
        CALL    COUT
        CALL    COUT
        LD      B,2
BCDIN:
        CALL    GOTORC
        LD      HL,BUFFER
        PUSH    HL
        CALL    CINBUFF
        POP     HL
        CP      ESC
        JP      Z,TRYAGAIN
        EX      DE,HL
        LD      HL,0
BCDIN1: LD      A,(DE)
        CP      3
        RET     Z
        INC     DE
        CP      ' '
        JR      Z,BCDIN1
        SUB     '0'             ;make binary from ascii.
        RET     C
        CP      10
        RET     NC
        ADD     HL,HL           ;x2
        ADD     HL,HL           ;x4
        ADD     HL,HL           ;x8
        ADD     HL,HL           ;x16
        CALL    ADDAHL
        JR      BCDIN1

;****************************************************
;*                                                  *
;*                   BOOT SOFTWARE                  *
;*                                                  *
;****************************************************

BOOT:
        CALL    NAME
        LD      HL,DRIVEMSG
        CALL    PRTSTR
        LD      A,(CPM_PRES)
        OR      A
        JR      NZ,BOOT0A
        LD      HL,BOOTCPMMSG
        CALL    PRTSTR
BOOT0A:
        LD      DE,1702H
        CALL    PRESS
        CALL    ESCAPE
BOOT0:
        CALL    CINABORT
        CP      SK5
        JP      Z,QUIT          ;to smartwriter
        CP      SK6
CPMX2   EQU     $-1
        JP      Z,BOOTCPM
        LD      B,4
        CP      SK1
        JR      Z,GOTDEV
        LD      B,5
        CP      SK2
        JR      Z,GOTDEV
        LD      B,8
        CP      SK3
        JR      Z,GOTDEV
        CP      SK4
        JR      Z,BOOTHD
        JR      BOOT0
GOTDEV:
        LD      A,B
        CALL    CHKSTAT
        LD      (EOSDEVICE),A
;@@@        JP      BOOTDEVICE

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

        LD      HL,0C800H
        LD      BC,0
        LD      DE,0
        CALL    _READ_BLOCK
        JP      NZ,_GOTO_WP

;** added 9609.01 HD4201.ASM **

        XOR     A                               ;A=0
        LD      (PRINT_UNDERLINE_FLAG),A        ;enable underline printing

;** end 9609.01 **

        LD      A,(EOSDEVICE)
        LD      B,A
        JP      0C800H

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

BOOTHD:
        LD      A,TAPE2
        LD      (EOSDEVICE),A
        LD      A,(HEADR)       ;get logical drive
        LD      (SETLOGICAL),A  ;for reboot exit
        LD      A,TAPE2
        LD      (SDRVID),A
        XOR     A
        LD      (HEADR),A       ;use logical 0 for SYS files
        LD      (CFILE),A
        LD      (FFILE),A
        LD      (LFILE),A
        CALL    RDSDIR
        CALL    FINDBL
        JR      C,BOOTHD2
        CALL    NAME
        CALL    IVON
        LD      HL,NOTEOS
        LD      DE,506h
        CALL    PRTLOC
        CALL    IVOFF
OOPS:
        CALL    CIN
        JP      RESTART
BOOTHD2:
        CALL    SHOWDIR
        JR      NZ,OOPS
BOOTHD3: LD     B,0
CFILE   EQU     $-1
        LD      A,0
LFILE   EQU     $-1
        CP      B
        JR      NC,BOOTHD4
        LD      B,A
BOOTHD4:
        CALL    CURON
        LD      A,1
        CALL    CHGCUR
        CALL    SETFCURS
        CALL    LOOKUP
        CALL    CIN
        PUSH    AF
        XOR     A
        CALL    CHGCUR
        CALL    CUROFF
        CALL    SETFCURS
        POP     AF
        CALL    CHKABORT
        JR      Z,BOOTHD5
        LD      DE,BOOTHD3
        PUSH    DE
        CP      UP
        JP      Z,FUP
        CP      DOWN
        JP      Z,FDOWN
        CP      LEFT
        JP      Z,FLEFT
        CP      RIGHT
        JP      Z,FRIGHT
        CP      HOME
        JP      Z,FHOME
        RET
BOOTHD5:
        LD      A,C
        CALL    FINDFILE
;
;Copy file loader to safe area
;
        LD      DE,0CC00H
        LD      HL,FILEBOOT
        LD      BC,FBOOTSIZE
        LDIR
;@@@        LD      DE,0CD00H
;@@@        LD      HL,BASICPATCH
;@@@        LD      BC,BPATCHSZ
;@@@        LDIR
        CALL    FINDBOOT        ;check if boot block, ZF=1 if so
        JR      NZ,NOT_A_BOOT   ;not a boot block

;now check for ADAMcalc, SmartLOGO, and PowerPaint

        LD      DE,CALCNAME     ;point to "BOOTCALC/"
        LD      B,9             ;length of string
        CALL    COMPNAME        ;does it match?
        JR      Z,IS_CALC       ;yes
        LD      DE,LOGONAME     ;no, so point to "BOOTLOGO/"
        LD      B,9             ;length of string
        CALL    COMPNAME        ;does it match?
        JR      Z,IS_LOGO       ;yes
        LD      DE,PPNTNAME     ;point to "BOOTPPNT/"
        LD      B,9             ;length
        CALL    COMPNAME        ;does it match?
        JR      Z,IS_PPNT       ;yes
        XOR     A               ;no, but make sure ZF=1
        LD      HL,0C800H       ;set start address=51200
        JR      BOOTHD6         ;it's a boot block!
;*****
NOT_A_BOOT:
        LD      DE,BNAME        ;no, so check to see if it's "SmartBASIC"
        LD      B,10            ;length
        CALL    COMPNAME        ;compare names
        LD      HL,100H         ;start address=256
        SCF                     ;CF=1 for non-bootblock
BOOTHD6:
        LD      B,(IX+19)       ;FILE SIZE
        LD      E,(IX+13)
        LD      D,(IX+14)       ;START BLOCK

;** added 9609.01 HD4201.ASM **

        PUSH    AF                              ;save the flags
        XOR     A                               ;A=0
        LD      (PRINT_UNDERLINE_FLAG),A        ;enable underline printing
        POP     AF                              ;restore the flags

;** end 9609.01 **

        LD      A,0
SETLOGICAL EQU  $-1             ;exit logical drive
        JP      0CC00H
;****************************************************************************
IS_CALC:
IS_LOGO:
IS_PPNT:
        LD      A,(HEADR)       ;get current EOS volume
        PUSH    AF              ;save it
        XOR     A               ;A=0
        LD      (HEADR),A       ;temporarily reset to volume 0

;now load a special version of EOS

;** added 9608.24 **
;first save our current ANET2SERVER table

        LD      HL,(PTR_2_ANET2SERVER)  ;get table address
        LD      DE,TEMP_ANET2SERVER     ;where we're gonna stash it
        LD      BC,64                   ;32 entries of 2 bytes each
        LDIR                            ;copy it to safety

;** end 9608.24 **

        LD      A,TAPE2
        LD      HL,EOS_STRING_2
        LD      B,1
        CALL    _OPEN_FILE      ;open the file
        JP      NZ,_GOTO_WP
        PUSH    AF
        LD      HL,32768
        LD      BC,8192
        CALL    _READ_FILE      ;read 8K from the file
        JP      NZ,_GOTO_WP
        POP     AF
        CALL    _CLOSE_FILE     ;close the file
        JP      NZ,_GOTO_WP

;** added 0007.21
;save the contents of SERIAL_BASEPORT!!!

        LD      HL,(PTR_2_SERIAL_BASEPORT)   ;get serial baseport address
        LD      A,(HL)                       ;get the actual baseport
        PUSH    AF                           ;save it

;* end 0007.21

        LD      HL,32768
        LD      DE,57344
        LD      BC,7519
        LDIR                    ;copy the new EOS

;** added 0007.21
;now restore contents of SERIAL_BASEPORT

        POP     AF                           ;restore serial baseport
        LD      HL,(PTR_2_SERIAL_BASEPORT)   ;where to save the baseport
        LD      (HL),A                       ;save it

;end 0007.21

;** added 9608.24 **
;now restore the ANET2SERVER table and rescan the DCBs

        LD      HL,(PTR_2_ANET2SERVER)  ;get table address
        LD      DE,TEMP_ANET2SERVER     ;get stored table address
        EX      DE,HL                   ;swap 'em
        LD      BC,64                   ;length of table
        LDIR                            ;copy it up to EOS
        CALL    _SCAN_ACTIVE            ;rescan the DCB area

;** end 9608.24 **

;now reset to previous default HD volume

        POP     AF              ;restore it
        LD      (HEADR),A       ;save it back
        XOR     A               ;make sure ZF=1

        LD      HL,0C800H       ;set start address=51200
        JR      BOOTHD6         ;it's a boot block!
;*****
EOS_STRING_2:
        DB "EOS4.X",2,3

;****************************************************************************

BNAME:                  DB      "SmartBasic"
CALCNAME:               DB      "BOOTCALC/"
LOGONAME:               DB      "BOOTLOGO/"
PPNTNAME:               DB      "BOOTPPNT/"
TEMP_ANET2SERVER        DS      64              ;added 9608.24

;****************************************************************************

FILEBOOT:
        LD      SP,EOS_STACK    ;EOS STACK
        PUSH    AF              ;EXIT LOGICAL DRIVE
        LD      A,B
LOADMORE:
        PUSH    AF              ;save entry CF and ZF
                                ;CF=1 it was a boot block, CF=0 it loads at 256
                                ;ZF=1 it matched 'SmartBasic', ZF=0 it didn't
        LD      BC,0
        LD      A,TAPE2
        CALL    _READ_BLOCK
        JP      NZ,_GOTO_WP
        INC     H
        INC     H
        INC     H
        INC     H
        INC     DE              ;BLOCK
        POP     AF
        DEC     A
        JR      NZ,LOADMORE
;@@@        LD      A,0C3H
;@@@         LD      (0),A
;@@@         LD      HL,REBOOT
;@@@         LD      (1),HL
        POP     AF
        LD      B,TAPE2
        LD      (HEADR),A
        JP      NC,0C800H

;SmartBASIC patches to install volume prompt.  Since these make calls into
;EOS codespace (where there are no longer any drivers in ADAMserve), they
;have been removed.

;@@@        JR      NZ,NOTBASIC
;@@@        LD      HL,0CD00H
;@@@        LD      DE,05B6BH
;@@@        LD      BC,BPATCHSZ
;@@@        LDIR
;@@@        LD      HL,PROMPT
;@@@        LD      (3EA7H),HL
;@@@        LD      A,18H
;@@@        LD      (101H+10H*400H),A
;@@@        LD      A,0C9H
;@@@        LD      (630FH),A

NOTBASIC:
        LD      B,TAPE2 ;set tape2 boot device
        JP      0100H
FBOOTSIZE EQU   $-FILEBOOT

;****************************************************************************

;@@@ BASICPATCH:
;@@@        CALL    2E01H
;@@@        RET     Z
;@@@        CALL    2E6DH
;@@@        RET     NC
;@@@        SUB     '0'
;@@@        LD      L,A
;@@@        CALL    EPATCH
;@@@        RET     NC
;@@@        NOP
;@@@ BPATCHSZ        EQU     $-BASICPATCH

;****************************************************************************

BOOTCPM:
        LD      A,0
CPM_PRES        EQU     $-1
        OR      A
        RET     NZ
        LD      DE,1303H
        LD      HL,WAITMSG
        CALL    PRTLOC


IF      NOT     MI
        LD      HL,0
CPMTRK  EQU     $-2
        LD      (LASTTRK),HL
ELSE
        LD      DE,0
CPMTRK  EQU     $-2

ENDIF


        LD      HL,0C800H
        PUSH    HL              ;put boot address on stack
        
IF NOT SERVER
        
        PUSH    HL              ;BC
        PUSH    HL              ;DE
        PUSH    HL              ;HL load address for routine
        JP      HDREAD
        
ELSE        
        
;for server, we need to convert CPMTRK into an absolute block number,        
;using NHSPT1.  This can simply be CPMTRK * NHSPT1.

        POP     HL              ;clear stack for now
        CALL    BELL            ;error beep
        JP      MAIN            ;go back for more

ENDIF

;****************************************************************************

CHGCUR:
        PUSH    BC
        PUSH    DE
        PUSH    HL
        LD      DE,1
        LD      HL,SPRITEATTR+2
        CALL    FILL_VRAM
        POP     HL
        POP     DE
        POP     BC
        RET

;****************************************************************************

FUP:
        LD      A,B
        OR      A
        JR      Z,FLEFT1
        DEC     B
FLEFT:
        LD      A,B
        OR      A
        JR      Z,FLEFT1
        DEC     B
        JR      FARROW
FLEFT1:
        LD      A,(LFILE)
        LD      B,A
FARROW:
        LD      A,B
        LD      (CFILE),A
        RET
FDOWN:
        INC     B
FRIGHT:
        INC     B
        LD      A,(LFILE)
        CP      B
        JR      NC,FARROW
FHOME:
        LD      B,0
        JR      FARROW
FPGUP:
        LD      A,0
FFILE   EQU     $-1
        OR      A
        JR      Z,FARROW
        SUB     26
        JR      NC,FPAGE
        XOR     A
FPAGE:
        LD      (FFILE),A
        LD      B,0
        PUSH    BC
        CALL    SHOWDIR
        POP     BC
        JR      FARROW

;**********************************************************
;*                                                        *
;*                  PARALLEL PRINTER PATCH                *
;*                                                        *
;**********************************************************

PARAPATCH:


IF NOT SERVER

;@@@        LD      HL,PATCHPTR
;@@@        LD      DE,PARASTART
;@@@        LD      BC,PARALEN
;@@@        LDIR
;@@@        LD      A,0C9H
;@@@        LD      (_HARD_INIT),A
;@@@        LD      (_SOFT_INIT),A
;@@@        LD      HL,PARADONE
;@@@        LD      DE,1302H

        CALL    PRTGETKEY
        JP      MAIN

ELSE

;        CALL    BELL
;        JP      MAIN

        LD HL,(PTR_2_ANET2SERVER)       ;get pointer to ADAMnet-to-ADAMserve
                                        ;device table
        LD DE,ADAM_PRINTER*2            ;offset
        ADD HL,DE                       ;point to ADAM printer entry
        LD A,(HL)                       ;get current value
        CP NULLDEV                      ;is it the ADAM printer?
        JR Z,ANET_2_SERVER              ;yes, so change it to the server
SERVER_2_ANET:
        LD A,NULLDEV                    ;no, so get ADAMnet
        LD (HL),A                       ;and save it
        LD HL,INSTALL_SERVER_MSG        ;point to new menu prompt string
        LD DE,PRINTER_MAIN              ;destination in main menu
        LD BC,24                        ;length
        LDIR                            ;copy it
        LD HL,ANET_DONE_MSG             ;point to status message
PARA_EXIT:
        PUSH HL
        CALL BELL                       ;beep
        POP HL
        LD DE,1302h                     ;screen coordinates
        CALL PRTGETKEY                  ;show the message
        JP MAIN                         ;and exit
;*****
ANET_2_SERVER:
        LD A,PP0                        ;get server
        LD (HL),A                       ;and save it
        LD HL,INSTALL_ANET_MSG          ;point to new menu prompt string
        LD DE,PRINTER_MAIN              ;destination in main menu
        LD BC,24                        ;length
        LDIR                            ;copy it
        LD HL,SERVER_DONE_MSG           ;point to status message
        JR PARA_EXIT                    ;and exit
;*****

FIX_MAINMENU_FOR_PRINTERS:

        LD HL,(PTR_2_ANET2SERVER)       ;get pointer to ADAMnet-to-ADAMserve
                                        ;device table
        LD DE,ADAM_PRINTER*2            ;offset
        ADD HL,DE                       ;point to ADAM printer entry
        LD A,(HL)                       ;get current value
        CP NULLDEV                      ;is it the ADAM printer?
        JR Z,ANET_STRING                ;yes, so change it to the server
SERVER_STRING:
        LD HL,INSTALL_ANET_MSG          ;point to new menu prompt string
PARA_EXIT_2:
        LD DE,PRINTER_MAIN              ;destination in main menu
        LD BC,24                        ;length
        LDIR                            ;copy it
        RET                             ;and exit
;*****
ANET_STRING:
        LD HL,INSTALL_SERVER_MSG        ;point to new menu prompt string
        JR PARA_EXIT_2                  ;and exit
;*****


ENDIF


;@@@ PATCHPTR:
;@@@         .DEPHASE
;@@@         .PHASE PARASTART
;@@@ ;
;@@@ PSTART: 
;@@@         LD      (CHARACTER),A
;@@@         CP      BKSPC
;@@@         JR      Z,GOTBS
;@@@         CP      10H
;@@@         JR      C,GOTCTL
;@@@ GOTBS:  
;@@@         LD      HL,(PBUFFLOC)
;@@@         CP      BKSPC
;@@@         JR      Z,BACKSP
;@@@         LD      (HL),A
;@@@         LD      (CHRINBUF),A
;@@@         LD      A,(DIRECTION)
;@@@         CP      REV
;@@@         JR      NZ,ADVANCE
;@@@ BACKSP: 
;@@@         DEC     HL
;@@@         JR      SAVEPTR
;@@@ ADVANCE:        
;@@@         INC     HL
;@@@ SAVEPTR:        
;@@@         LD      (PBUFFLOC),HL
;@@@ PCHREXIT:       
;@@@         POP     IY
;@@@         POP     HL
;@@@         POP     DE
;@@@         POP     BC
;@@@         RET
;@@@ SAVEHLF:        
;@@@         LD      (HALF),A
;@@@         JR      PCHREXIT
;@@@ RESETPTR:       
;@@@         LD      HL,PARABUF
;@@@         LD      (PBUFFLOC),HL
;@@@         JR      PCHREXIT
;@@@ GOTCTL: 
;@@@         CP      REV
;@@@         JR      Z,REVERSE
;@@@         LD      A,(CHRINBUF)
;@@@         OR      A
;@@@         JR      NZ,PRTBUF
;@@@         LD      A,(CHARACTER)
;@@@         CP      HLF
;@@@         JR      Z,HALFLF
;@@@ CLRBUF: 
;@@@         LD      DE,50H
;@@@         LD      HL,PARABUF
;@@@ CLRBUF1:        
;@@@         LD      A,' '
;@@@         LD      (HL),A
;@@@         INC     HL
;@@@         DEC     DE
;@@@         LD      A,D
;@@@         OR      E
;@@@         JR      NZ,CLRBUF1
;@@@         XOR     A
;@@@         LD      (HALF),A
;@@@         LD      (DIRECTION),A
;@@@         LD      (CHRINBUF),A
;@@@         LD      A,(CHARACTER)
;@@@         CP      LF
;@@@         JR      Z,SOFTRET
;@@@         CP      HLF
;@@@         JR      Z,SAVEHLF
;@@@         CP      FF
;@@@         JR      Z,WAIT
;@@@         CP      CR
;@@@         JR      Z,RESETPTR
;@@@         CP      REV
;@@@         JR      NZ,PCHREXIT
;@@@ REVERSE:        
;@@@         LD      (DIRECTION),A
;@@@         JR      PCHREXIT
;@@@ SOFTRET:        
;@@@         LD      A,CR
;@@@         LD      (CHARACTER),A
;@@@ WAIT:   
;@@@         IN      A,(OUTPORT)
;@@@         AND     1
;@@@         JR      Z,WAIT
;@@@         LD      A,(CHARACTER)
;@@@         OUT     (OUTPORT),A
;@@@        CP      CR
;@@@        JR      NZ,PCHREXIT
;@@@         LD      A,LF
;@@@         LD      (CHARACTER),A
;@@@         JR      WAIT
;@@@ HALFLF: 
;@@@         LD      A,(HALF)
;@@@         CP      HLF
;@@@         JR      NZ,CLRBUF
;@@@         LD      A,CR
;@@@         LD      (CHARACTER),A
;@@@         LD      (HALF),A
;@@@         JR      WAIT
;@@@ PRTBUF: 
;@@@         LD      HL,PARABUF
;@@@         LD      DE,50H
;@@@ PRTBUF1:        
;@@@         IN      A,(OUTPORT)
;@@@         AND     1
;@@@         JR      Z,PRTBUF1
;@@@         LD      A,(HL)
;@@@         OUT     (OUTPORT),A
;@@@         INC     HL
;@@@         DEC     DE
;@@@         LD      A,D
;@@@         OR      E
;@@@         JR      Z,CLRBUF
;@@@         JR      PRTBUF1
;@@@ ;
;@@@ PARALEN EQU     $-PSTART
;@@@         .DEPHASE
;@@@         .PHASE  PATCHPTR+PARALEN

;***************************************************
;*                                                 *
;*               MAINTENANCE FUNCTIONS             *
;*                                                 *
;***************************************************

MAINTENANCE:
        LD      SP,STACK
        CALL    CUROFF
        CALL    NAME
        LD      HL,MAINTMENU
        CALL    PRTSTR
        LD      DE,1702H
        CALL    PRESS
        CALL    ESCAPE
MAINT0:
        CALL    CINABORT
        CP      SK1
        JP      Z,KRUNCH
        CP      SK2
        JP      Z,INITLOGICAL
        CP      SK3
        JP      Z,INSTALL
;        CP      SK4
;        JP      Z,BIGINSTALL
;        CP      SSK5
;        IF      NOT     IDE
;        JP      Z,FORMAT_HARD
;        CP      SSK6
;        ENDIF
;        JP      Z,DO_PART
        JR      MAINT0

;**************************************************
;*                                                *
;*                  KRUNCH HARD DISK              *
;*                                                *
;**************************************************

KRUNCH:
        LD      A,TAPE2
        LD      (SDRVID),A
        LD      (DDRVID),A
        CALL    NAME
        LD      HL,KRNCHMENU
        CALL    PRTSTR
        CALL    RETURN
        LD      DE,1612H
        LD      HL,KRUNCHMSG
        CALL    PRTLOC
        CALL    ESCAPE
KRUNCH0:
        LD      BC,(HEADR)
        LD      DE,0716H
        LD      B,0
        CALL    GOTORC
        CALL    DCOUT2
        LD      DE,0809H
        CALL    SHOWBKUP
        CALL    CIN
        CP      ESC
        JP      Z,MAINTENANCE
        CALL    CHKABORT
        JR      Z,KRUNCH1
        CP      SK1
        CALL    Z,CHANGEL
        CP      SK2
        CALL    Z,SETBKUP
        JR      KRUNCH0
KRUNCH1:
        CALL    BLANK
        XOR     A               ;zero KRUNCHED flag
        LD      (KRNCHFLG),A
        CALL    RDSDIR          ;read source directory
        LD      A,(DIRSIZE)
        CP      11H
        JP      NC,NOKRUNCH
        CALL    FINDBLX
        LD      L,(IX+13)       ;get start of file
        LD      H,(IX+14)
        LD      A,(DIRSIZE)     ;get directory size
        INC     A               ;increment to get start of first file
        LD      (NEXTBLK),A     ;save in start block
        XOR     A               ;note start Block is a word
        LD      (NEXTBLK+1),A
        LD      BC,2            ;# of first file enty-1
        PUSH    BC
KRUNCH2:
        POP     BC              ;get back file #
        INC     BC
        CALL    FINDFILEX       ;get its location in directory
        JP      NC,KRUNCH6      ;if not found, fix directory
        LD      A,(IX+12)       ;is it blocks left
        AND     BLEFT
        JP      NZ,KRUNCH6      ;if it is, fix directory
        PUSH    BC
        LD      A,(BKUPFLG)     ;deleting backup files?
        OR      A
        JR      Z,KRUNCH3       ;no skip next
        CALL    FINDTYPE        ;get the file type
        LD      A,(HL)
        CP      60H             ;is it lowercase?
        JR      C,KRUNCH3       ;no skip next
        LD      (IX+12),DELETED ;delete the file
KRUNCH3:
        LD      A,(IX+12)       ;is the file deleted?
        AND     DELETED
        JR      NZ,KRUNCH2      ;yes skip next
        LD      L,(IX+13)       ;get start of file
        LD      H,(IX+14)
        LD      E,(IX+19)       ;get blocks used
        LD      D,(IX+20)
        LD      (IX+17),E       ;put used in length
        LD      (IX+18),D
        PUSH    HL              ;save start of file
        LD      BC,(NEXTBLK)    ;get start block
        OR      A
        SBC     HL,BC           ;is start block same as start of file?
        LD      H,B
        LD      L,C
        ADD     HL,DE           ;calculate start block of next file
                                ;note zero flag is not affected
        LD      (NEXTBLK),HL    ;save in start block
        POP     HL              ;get back start of file
        JR      Z,KRUNCH2       ;skip next if start of file and start block
                                ;are the same
        PUSH    BC              ;save krunched start
        PUSH    DE              ;save file length
        PUSH    HL              ;save file start
        LD      A,(KRNCHFLG)    ;have we done any krunching yet
        OR      A
        JR      NZ,KRUNCH5      ;yes skip next
        LD      (DESTBLK),BC
KRUNCH5:
        POP     HL              ;get back start of file
        LD      (SRCBLK),HL     ;save it
        POP     DE              ;get back file length
        LD      (BLOCKS),DE     ;save it
        POP     BC              ;get back destination block
        LD      (IX+13),C       ;put new start in file entry
        LD      (IX+14),B
        CALL    ADDTOBUF
        LD      A,0FFH          ;set krunched flag
        LD      (KRNCHFLG),A
        JP      KRUNCH2         ;krunch next file
KRUNCH6:
        CALL    FLSHBUF
        LD      HL,(DIRBUF+17)  ;get drive size
        LD      BC,(NEXTBLK)    ;get start block for blocks left
        LD      (IX+13),C       ;put in directory
        LD      (IX+14),B
        OR      A
        SBC     HL,BC           ;calculate length of blocks left
        LD      (IX+17),L       ;put in directory
        LD      (IX+18),H
        LD      BC,3            ;start krunching directory at file 3
        LD      (KRUNCH8),BC
KRUNCH7:
        CALL    FINDFILEX       ;get source file entry location
        JR      NC,KRUNCH9      ;if not found
        LD      A,(IX+12)       ;is it deleted
        AND     DELETED
        INC     BC
        JR      NZ,KRUNCH7      ;if so skip next
        PUSH    BC              ;save file counters
        PUSH    IX              ;get source entrylocation in HL
        POP     HL
        LD      BC,3
KRUNCH8 EQU     $-2
        CALL    FINDFILEX
        INC     BC
        LD      (KRUNCH8),BC
        PUSH    IX              ;get that in DE
        POP     DE
        LD      BC,26           ;file entry size is 26 bytes
        LDIR                    ;transfer file entry
        POP     BC              ;get back file counters
        LD      A,(IX+12)       ;did we just transfer blocks left
        AND     BLEFT
        JR      Z,KRUNCH7       ;yes finish up
KRUNCH9:
        LD      H,D             ;zero rest of directory
        LD      L,E
        INC     DE
        LD      (HL),0
        LD      BC,10H*400H
        LDIR
        CALL    WRTDDX
        JP      KRUNCH
NOKRUNCH:
        LD      DE,0A0AH
        LD      HL,NKMSG
        CALL    PRTGETKEY
        JP      MAIN
;
SETBKUP:
        LD      A,0
BKUPFLG EQU     $-1
        CPL
        LD      (BKUPFLG),A
        RET
;
SHOWBKUP:
        LD      A,(BKUPFLG)
        OR      A
        LD      HL,BACKFMSG
        JP      NZ,PRTLOC
        LD      HL,NOBACKFMSG
        JP      PRTLOC

;************************************************************
;*                                                          *
;*                     INITIALIZE DIRECTORY                 *
;*                                                          *
;************************************************************

INITLOGICAL:
        CALL    NAME
        LD      HL,INITMENU
        CALL    PRTSTR
        CALL    RETURN
        LD      DE,1612H
        LD      HL,INITMSG
        CALL    PRTLOC
        CALL    ESCAPE
INIT0:
        LD      A,(MAXD3)
        LD      C,A
        LD      A,(HEADR)
        LD      B,A
        SUB     C
        LD      C,'1'
        JR      C,INIT0A
        LD      C,'2'
        LD      B,A
INIT0A: LD      A,C
        LD      (INITDRV),A
        LD      A,B
        LD      D,0
        LD      E,A
        ADD     A,'0'
        LD      (INITVOL),A     ;set default name
        LD      HL,DRIVESIZES
        ADD     HL,DE
        LD      E,D             ;=0
        LD      D,(HL)
        LD      (VOLXSIZE),DE   ;set volume size from table
        LD      A,D             ;vol size also directory size
        LD      (FX1LEN),A
        LD      (FX1USED),A
        ADD     A,80H
        LD      (DIRXSIZE),A
        LD      HL,SAVE_VOLNAME
        LD      DE,VOLXNAME
        LD      BC,11
        LDIR
INIT0B: LD      BC,(HEADR)
        LD      DE,0716H
        LD      B,0
        CALL    GOTORC
        CALL    DCOUT2
        LD      DE,919H
        CALL    GOTORC
        LD      BC,(FX1LEN)
        CALL    DCOUT2
        LD      DE,811H
        CALL    SHOWVNAME
        CALL    CIN
        CP      ESC
        JP      Z,MAINTENANCE
        CALL    CHKABORT
        JR      Z,INIT1
        CP      SK1
        CALL    Z,SET_INITDRV
        CP      SK2
        LD      DE,811H
        CALL    Z,SETVNAME
        CP      SK3
        CALL    Z,SETDSIZE
        JR      INIT0B
INIT1:
        CALL    CHECK
        JP      Z,INITLOGICAL
        AND     5FH
        CP      'Y'
        JP      NZ,INITLOGICAL
        CALL    BLANK
        LD      DE,1502H
        CALL    SYSGEN
        LD      A,(HEADR)
        LD      HL,DRVNAMES-12
        LD      DE,12
        INC     A
SAVENAME:
        ADD     HL,DE
        DEC     A
        JR      NZ,SAVENAME
        EX      DE,HL           ;send to DE
        LD      HL,VOLXNAME
        LD      B,11
SAVENAM2:
        LD      A,(HL)
        CP      ' '
        JR      C,SAVENAM3
        LD      (DE),A
        INC     HL
        INC     DE
        DJNZ    SAVENAM2
        JR      SAVENAM4
SAVENAM3:
        LD      A,' '
        LD      (DE),A
        INC     DE
        DJNZ    SAVENAM3
SAVENAM4:
        JP      INITLOGICAL
;
SETDSIZE:
        LD      A,(FX1LEN)
        INC     A
        CP      21H
        JR      C,SETDSIZE1
        LD      A,(VOLXSIZE+1)
SETDSIZE1:
        LD      (FX1LEN),A
        LD      (FX1USED),A
        ADD     A,80H
        LD      (DIRXSIZE),A
        XOR     A
        RET

;************************************************************
;*                                                          *
;*                       INSTALL BOOT                       *
;*                                                          *
;************************************************************

INSTALL:
        CALL    NAME
        LD      HL,CRBOOTMSG
        CALL    PRTSTR
        LD      DE,1702H
        CALL    PRESS
        CALL    ESCAPE
        CALL    CINABORT
        LD      B,DISK1
        CP      SK1
        JR      Z,GOT_IDRV
        LD      B,DISK2
        CP      SK2
        JR      Z,GOT_IDRV
        LD      B,TAPE1
        CP      SK3
        JR      NZ,INSTALL

GOT_IDRV:

;** added 9608.24 **

        JP      MAINTENANCE     ;this area under construction

;** end 9608.24 **

;        LD      A,B
;        LD      (INSTALL1),A    ;save device #
;INSTALL0:
;        CALL    NAME
;        LD      HL,INSERTNEW
;        LD      DE,1301H
;        CALL    PRTGETKEY
;;
;        LD      BC,PATCHSIZE    ;save current patch
;        LD      HL,HEADR        ;ie with floppy drivers (maybe)
;        LD      DE,BUFFER
;        LDIR
;;
;        LD      BC,PATCHSIZE    ;restore original patch
;        LD      HL,HEADER       ;no floppy drivers
;        LD      DE,HEADR
;        LDIR
;;
;        LD      HL,REBOOTBUF
;        LD      DE,BUFFER+400H
;        LD      BC,REBOOTSIZE
;        LDIR
;;
;        LD      HL,HEADER
;        LD      BC,PATCHSIZE
;        LDIR
;;
;        LD      A,0
;INSTALL1        EQU     $-1
;        CALL    CHKSTAT
;        LD      BC,0
;        LD      DE,0
;        LD      HL,BUFFER+400H
;        CALL    _WRITE_BLOCK
;;
;        LD      BC,PATCHSIZE    ;restore current patch
;        LD      HL,BUFFER
;        LD      DE,HEADR
;        LDIR
;;
;        LD      DE,1301H
;        CALL    GOTORC
;;       LD      HL,INSTDONE
;;       CALL    ANYKEY
;        JP      MAINTENANCE

;**************************************************************
;*                                                            *
;*                      INSTALL WHOLE SYSTEM                  *
;*                                                            *
;**************************************************************

BIGINSTALL:

        RET

;@@@         LD      A,(DEFDRV)
;@@@         CP      TAPE2
;@@@         JR      NZ,BIGINSTALL2
;@@@         LD      DE,1301H
;@@@         LD      HL,REBOOTMSG
;@@@         CALL    PRTGETKEY
;@@@         JP      RESTART
;@@@ BIGINSTALL2:
;@@@         XOR     A
;@@@         LD      (HEADR),A
;@@@         LD      (CFILE),A
;@@@         LD      (FFILE),A
;@@@         LD      (LFILE),A
;@@@         LD      A,TAPE2
;@@@         LD      (SDRVID),A
;@@@         CALL    RDSDIR
;@@@         CALL    FINDBL
;@@@         JR      C,INST1
;@@@ INST0:
;@@@         CALL    IVON
;@@@         LD      HL,NODIR
;@@@         LD      DE,1301H
;@@@         CALL    PRTLOC
;@@@         CALL    IVOFF
;@@@         CALL    CIN
;@@@         JP      MAINTENANCE
;@@@ INST1:
;@@@         LD      A,C
;@@@         CP      3
;@@@         JR      C,INST0         ;no files
;@@@         LD      HL,DIRBUF+26*3  ;Start of file one
;@@@         LD      DE,SPECIAL      ;Hard disk name
;@@@         LD      B,13
;@@@ CHECKNAME:
;@@@         LD      A,(DE)
;@@@         CP      (HL)
;@@@         JR      NZ,INST0        ;Bad name
;@@@         INC     DE
;@@@         INC     HL
;@@@         DJNZ    CHECKNAME
;@@@ ;
;@@@         LD      A,(HL)          ;get file start block
;@@@         LD      (NEWSTART),A
;@@@         INC     HL
;@@@         INC     HL
;@@@         INC     HL
;@@@         INC     HL
;@@@         LD      A,(HL)          ;file size
;@@@         CP      12
;@@@         JR      C,INST0         ;can't install if not 12K
;@@@         LD      A,TAPE2
;@@@         LD      (DDRVID),A
;@@@ ;
;@@@ ;finally, copy file
;@@@ ;
;@@@         LD      HL,COPYING
;@@@         LD      DE,1301H
;@@@         CALL    PRTLOC
;@@@         LD      HL,12           ;dummy file length
;@@@         LD      DE,100H
;@@@         LD      BC,0
;@@@ NEWSTART EQU    $-2             ;start block of file
;@@@ WRTF:
;@@@         CALL    WRTBUFF
;@@@         JR      NZ,WRTF
;@@@         XOR     A
;@@@         LD      (HEADR),A
;@@@         LD      A,TAPE2
;@@@         LD      BC,0
;@@@         LD      DE,0
;@@@         LD      HL,BUFFER
;@@@         CALL    _READ_BLOCK
;@@@ ;
;@@@         LD      DE,BOOTBUF+3
;@@@         LD      HL,BUFFER+3
;@@@         LD      BC,0C8H
;@@@         LDIR
;@@@ ;
;@@@         LD      HL,ADAMCOLOR-0C800H+bootbuf     ;BUFFER
;@@@         LD      (HL),0C0H       ;change logo colour to green
;@@@         LD      DE,ADAMCOLOR-0C800H+bootbuf+1   ;BUFFER+1
;@@@         LD      C,7
;@@@         LDIR
;@@@ ;
;@@@         LD      A,TAPE2
;@@@         LD      BC,0
;@@@         LD      DE,0
;@@@         LD      HL,BOOTBUF
;@@@         CALL    _WRITE_BLOCK
;@@@ ;
;@@@         CALL    BELL
;@@@         CALL    BELL
;@@@         LD      A,(DEFDRV)
;@@@         LD      (INSTALL1),A
;@@@         JP      INSTALL0
;@@@ ;
        IF      MI
        $INCLUDE MI-SPEC.Z80
        ELSE
        IF      IDE
        $INCLUDE IDE-SPEC.Z80
        ELSE
        IF      SERVER
        $INCLUDE S-SPEC2.Z80
        ELSE
        $INCLUDE BJ-SPEC.Z80
        ENDIF
        ENDIF
        ENDIF

;@@@ ;
;@@@ ;get the number just input
;@@@ ;on exit DE = number, Z if good entry, NZ else
;@@@ ;
;@@@ GETNUM:
;@@@         LD      HL,INBUF
;@@@         PUSH    HL
;@@@         LD      A,C
;@@@         ADD     A,L
;@@@         LD      L,A
;@@@         LD      A,0
;@@@         ADC     A,H
;@@@         LD      H,A
;@@@         LD      (HL),0          ;zero terminate string using length byte.
;@@@         POP     HL
;@@@         LD      DE,0            ;zero cumulative decimal value
;@@@ DIN1:
;@@@         LD      A,(HL)          ;decimal input loop: get char,
;@@@         INC     HL
;@@@         AND     7FH
;@@@         OR      A               ;end of string ?
;@@@         RET     Z               ;skip if yes
;@@@         CALL    TESTNUM         ;check if not numeric
;@@@         RET     NZ              ;skip if not, end of conversion
;@@@         PUSH    HL
;@@@         PUSH    AF              ;numeric, multiply cumulative decimal by 10
;@@@         LD      C,10
;@@@         CALL    MULT
;@@@         POP     AF
;@@@         SUB     '0'             ;remove ascii component,
;@@@         LD      C,A
;@@@         LD      B,0
;@@@         ADD     HL,BC           ;add to decimal total,
;@@@         PUSH    HL
;@@@         POP     DE              ;copy result to DE accumulated value
;@@@         POP     HL              ;restore pointer
;@@@         JR      DIN1            ;and get another char.
;@@@ ;test numeric range of ascii char in A.
;@@@ ;returns Z if 0-9, else NZ.  A is preserved.
;@@@ ;
;@@@ TESTNUM:
;@@@         CP      '0'             ;less than ascii 0 ?
;@@@         JR      C,NNUM          ;skip if yes
;@@@         CP      '9'+1           ;more than ascii 9 ?
;@@@         JR      NC,NNUM
;@@@         CP      A               ;numeric, set Z
;@@@         RET
;@@@ NNUM:
;@@@         CP      '0'             ;not numeric, set NZ
;@@@         RET
;@@@ ;
;@@@ ;Compare DE to HL
;@@@ ;
;@@@ ;  DE < HL  --> NC,NZ
;@@@ ;  DE = HL  --> NC,Z
;@@@ ;  DE > HL  --> C,NZ
;@@@ ;
;@@@ CPHL:   LD      A,H
;@@@         CP      D
;@@@         RET     NZ
;@@@         LD      A,L
;@@@         CP      E
;@@@         RET
;@@@ ;
;@@@ ;Multiply
;@@@ ;DE x C = AHL.  Be careful with input values.
;@@@ ;
;@@@ MULT:
;@@@         PUSH    BC
;@@@         XOR     A
;@@@         LD      H,A
;@@@         LD      L,A
;@@@         LD      B,C
;@@@         INC     B                       ;pre increment loop counter
;@@@         JR      MULT2
;@@@ MULT1:
;@@@         ADD     HL,DE
;@@@         ADC     A,0
;@@@ MULT2:
;@@@         DJNZ    MULT1
;@@@         POP     BC
;@@@         LD      C,0
;@@@         RET
;@@@ 
;@@@ ;Divide
;@@@ ;DE / BC = HL.  No test for 0 input.
;@@@ DIV:
;@@@         LD      HL,-1
;@@@         EX      DE,HL
;@@@         OR      A
;@@@ DIV1:
;@@@         INC     DE
;@@@         SBC     HL,BC
;@@@         JR      NC,DIV1
;@@@         EX      DE,HL                   ;return result to HL
;@@@         RET
;@@@ ;
;@@@ ANYKEY:
;@@@         CALL    PRTSTR
;@@@ ANYKEY1:
;@@@         LD      HL,ASK_ANYKEY
;@@@ ASKYN:
;@@@         CALL    PRTSTR
;@@@ ASKYN1:
;@@@         CALL    CIN             ;GO GET OPTION LETTER
;@@@         CALL    FIXCASE
;@@@         CP      3                       ;CONTROL C ?
;@@@         JP      Z,MAINTENANCE
;@@@         CP      'Y'
;@@@         PUSH    AF
;@@@         CALL    CRLF
;@@@         POP     AF
;@@@         RET
;@@@ ;
;@@@ FIXCASE:
;@@@         AND     7FH
;@@@         CP      'a'
;@@@         RET     C
;@@@         CP      'z'+1
;@@@         RET NC
;@@@         AND     5FH
;@@@         RET

;**************************************************************
;*                                                            *
;*                       CHARACTER ROUTINES                   *
;*                                                            *
;**************************************************************

SUBDIV:
        LD      B,0FFH
        OR      A
SUBDV1:
        SBC     HL,DE
        INC     B
        JR      NC,SUBDV1
        ADD     HL,DE
        LD      A,B
        OR      A
        JR      Z,ZERO
        LD      C,A
ZERO:
        LD      A,C
        OR      A
        JR      NZ,PR
        LD      A,' '
        JP      COUT
PR:
        LD      A,'0'
        ADD     A,B
        JP      COUT
;
DCOUT5:
        XOR     A
        JR      DECOUT
DCOUT2:
        LD      A,DOUT3-DOUT0
DECOUT:
        LD      (JMPSIZE),A
        PUSH    BC
        PUSH    HL
        LD      H,B
        LD      L,C
        LD      C,0
        JR      DOUT0
JMPSIZE EQU     $-1
DOUT0:
        LD      DE,10000
        CALL    SUBDIV
        LD      DE,1000
        CALL    SUBDIV
        LD      DE,100
        CALL    SUBDIV
DOUT3:
        LD      DE,10
        CALL    SUBDIV
        LD      B,L
        CALL    PR
        POP     HL
        POP     BC
        RET
;
BLANK:
        PUSH    AF
        LD      A,(INVERSE)
        OR      A
        PUSH    AF
        CALL    IVOFF
        LD      DE,1500H
        LD      HL,BLNK3L
        CALL    PRTLOC
        POP     AF
        CALL    NZ,IVON
        POP     AF
        RET
;
CRLF:
        LD      HL,CRLFMSG
        JR      PRTSTR
;
NAME:
        CALL    CLS
        CALL    IVON
        LD      HL,PNAME1
        CALL    PRTSTR
        CALL    IVOFF
        LD      HL,PNAME2
        JR      PRTSTR
;
GOTORC:
        PUSH    DE
        LD      A,D
        LD      D,E
        LD      E,A
        INC     D
        LD      A,1CH
        CALL    COUT
        CALL    POSCUR
        POP     DE
        RET
;
PRTVNAME:
        CALL    GOTORC
        LD      HL,DRVNAMES-12
        LD      B,C
        LD      DE,12
        INC     B
PRTVNAM1:
        ADD     HL,DE
        DJNZ    PRTVNAM1
        JR      PRTSTR
;
RETURN:
        LD      DE,1602H
        CALL    PRESS
        LD      DE,1608H
        LD      HL,RETMSG
        JR      PRTLOC
;
PRESS:
        LD      HL,PRESSMSG
        JR      PRTLOC
;
ESCAPE:
        LD      HL,ESCMSG
        LD      DE,1708H
;
PRTLOC:
        CALL    GOTORC
PRTSTR:
        LD      A,(HL)
        OR      A
        RET     Z
        CALL    COUT
        INC     HL
        JR      PRTSTR
;
IVOFF:
        XOR     A
        JR      IV0
IVON:
        LD      A,80H
IV0:
        LD      (INVERSE),A
        RET
;
CURON:
        LD      A,0AFH
CUROFF  EQU     $-1
        LD      (CURFLG),A
        OR      A
        JR      NZ,POSCUR
        LD      A,0D0H
        JR      POSCUR0
POSCUR:
        LD      A,0
CURFLG  EQU     $-1
        OR      A
        RET     Z
        LD      A,(CURSOR)
        ADD     A,A
        ADD     A,A
        ADD     A,A
POSCUR0:
        PUSH    BC
        PUSH    DE
        PUSH    HL
        LD      DE,1
        LD      HL,SPRITEATTR
        CALL    FILL_VRAM
        LD      A,(CURSOR+1)
        ADD     A,A
        ADD     A,A
        ADD     A,A
        LD      DE,1
        LD      HL,SPRITEATTR+1
        CALL    FILL_VRAM
        POP     HL
        POP     DE
        POP     BC
        RET
;
CLS:
        LD      A,CLRSCR
        JP      COUT
;
BELL:
        LD      A,(0FC2FH)
        LD      C,A
        LD      A,8FH
        OUT     (C),A
        LD      A,11H
        OUT     (C),A
        LD      A,90H
        OUT     (C),A
        LD      HL,0F00H
BELL1:
        EX      (SP),HL
        EX      (SP),HL
        DEC     HL
        LD      A,L
        OR      H
        JR      NZ,BELL1
        LD      A,9FH
        OUT     (C),A
        RET
;
CINBUFF:
        PUSH    HL
        PUSH    DE
        PUSH    BC
        PUSH    AF
        CALL    CURON
        POP     AF
        POP     BC
        POP     DE
        POP     HL
        LD      C,0
CINBUFF1:
        CALL    CIN
        CP      CR
        JR      Z,CINBUFF2
        CP      BS
        JR      Z,DESTBS
        CP      LEFT
        JR      Z,DESTBS
        CP      ESC
        JR      Z,CINBUFFX
        CP      CTLC
        JP      Z,RESTART
        CALL    COUT
        LD      (HL),A
        INC     C
        INC     HL
        DJNZ    CINBUFF1
        CP      BS
        JR      Z,DESTBS
        CP      LEFT
        JR      Z,DESTBS
        CP      ESC
        JR      Z,CINBUFFX
        CP      CTLC
        JP      Z,RESTART
CINBUFF2:
        LD      (HL),3
        LD      A,B
        OR      A
        JR      Z,CINBUFFX
CINBUFF3:
        INC     HL
        LD      (HL),' '
        DJNZ    CINBUFF3
CINBUFFX:
        PUSH    HL
        PUSH    DE
        PUSH    BC
        PUSH    AF
        CALL    CUROFF
        POP     AF
        POP     BC
        POP     DE
        POP     HL
        RET
DESTBS:
        LD      A,C
        OR      A
        JR      Z,CINBUFF1
        LD      A,BS
        CALL    COUT
        LD      A,' '
        CALL    COUT
        LD      A,BS
        CALL    COUT
        DEC     HL
        DEC     C
        INC     B
        JR      CINBUFF1
;
CINABORT:
        CALL    CIN
CHKABORT:
        CP      ESC
        JP      Z,RESTART
        CP      CTLC
        JP      Z,RESTART
        CP      CR
        RET
;
PRTGETKEY:
        CALL    PRTLOC
CIN:
        PUSH    BC
        PUSH    DE
        PUSH    HL
CIN1:
        CALL    _END_RD_KBD
        JR      NC,CIN1
        PUSH    AF
        CALL    _START_RD_KBD
        POP     AF
        POP     HL
        POP     DE
        POP     BC
        RET
;
CINOUT:
        CALL    CIN
        CP      127
        RET     NC
        CP      ' '
        RET     C
COUT:
        PUSH    AF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        CP      ' '
        JR      NC,COUT1
COUT0:
        CALL    _CONS_OUT
        JR      COUT2
COUT1:
        CP      80H
        JR      NC,COUT0
        OR      0
INVERSE EQU     $-1
        CALL    _CONS_DISP
COUT2:
        CALL    POSCUR
        CALL    _END_RD_KBD
        JR      NC,COUT3
        CALL    CIN
        CP      'S'-40H
        JR      NZ,COUT3
        CALL    CINABORT
COUT3:
        POP     HL
        POP     DE
        POP     BC
        POP     AF
        RET
;
SHOWVNAME:
        LD      IX,VOLXNAME
        LD      C,0
SHOWFILE:
        PUSH    HL
        CALL    GOTORC
        PUSH    DE
        PUSH    BC
        PUSH    IX
        POP     HL
        LD      B,0CH
PFN0:
        LD      A,(HL)
        LD      D,A
        INC     HL
        LD      A,(HL)
        CP      3
        JR      Z,PFN1
        LD      A,D
        CP      ' '
        CALL    NC,COUT
        DJNZ    PFN0
PFN1:
        CP      3
        JR      NZ,PFN3
        LD      A,C
        CP      3
        JR      C,PFN2
        LD      A,B
        CP      1
        JR      C,PFN2
        DEC     B
PFN1A:
        LD      A,' '
        CALL    COUT
        DJNZ    PFN1A
PFN2:
        LD      A,D
        CP      ' '
        CALL    NC,COUT
PFN3:
        LD      A,B
        CP      1
        JR      C,PFN5
        DEC     B
PFN4:
        LD      A,' '
        CALL    COUT
        DJNZ    PFN4
PFN5:
        POP     BC
        POP     DE
        POP     HL
        RET
;
CHECK:
        LD      DE,1608H
        LD      HL,BLNKLN
        CALL    PRTLOC
        CALL    IVON
        LD      DE,1202H
        LD      HL,INSERTMSG
        CALL    PRTLOC
        CALL    IVOFF
        CALL    CINOUT
        CP      CTLC
        JP      Z,RESTART
        CP      ESC
        RET
;
SETBORD0:
        LD      A,(BORDCOL)
        LD      C,A
        LD      B,7
        JP      WRITE_REGISTER
;
SETNORM:
        LD      A,(NCCOL)
        RLCA
        RLCA
        RLCA
        RLCA
        LD      D,A
        LD      A,(NBCOL)
        OR      D
        LD      DE,10H
        LD      HL,0340H
        JP      FILL_VRAM
;
SETINV:
        LD      A,(ICCOL)
        RLCA
        RLCA
        RLCA
        RLCA
        LD      D,A
        LD      A,(IBCOL)
        OR      D
        LD      DE,10H
        LD      HL,0350H
        JP      FILL_VRAM

;****************************************************************
;*                                                              *
;*                          DISK ROUTINES                       *
;*                                                              *
;****************************************************************

FILLBUFF:
        LD      DE,(BUFFPOS)
        LD      A,(SRAMLEFT)
        OR      A
        RET     Z
        DEC     A
        LD      (SRAMLEFT),A
        CALL    RDBLKMSG
        CALL    RDBUFF
        LD      (BUFFPOS),DE
        JR      NZ,FILLBUFF
        RET
RDBUFF:
        LD      A,L
        OR      H
        RET     Z
        LD      A,(SDRVID)      ;DEVICE NUMBER
        PUSH    HL
        CALL    RDBLK
        POP     HL
        LD      A,4
        ADD     A,D
        LD      D,A
        INC     BC
        DEC     HL
        LD      A,L
        OR      H
        RET
;
EMPTYBUFF:
        LD      BC,(DESTBLK)
        LD      A,BUFFERSIZE
        LD      HL,SRAMLEFT
        SUB     (HL)
        RET     Z
        LD      L,A
        LD      H,0
        LD      DE,BUFFER
EMPTY1:
        CALL    WRTBLKMSG
        CALL    WRTBUFF
        JR      NZ,EMPTY1
        RET
;
RDBLKMSG:
        PUSH    DE
        LD      DE,1318H
        JR      BLKMSG
WRTBLKMSG:
        PUSH    DE
        LD      DE,1418H
BLKMSG:
        CALL    GOTORC
        CALL    DCOUT5
        POP     DE
        RET
;
WRTBUFF:
        LD      A,L
        OR      H
        RET     Z
        LD      A,(DDRVID)      ;DRIVE NUMBER
        PUSH    HL
        CALL    WRTBLK
        POP     HL
        LD      A,4
        ADD     A,D
        LD      D,A
        INC     BC
        DEC     HL
        LD      A,L
        OR      H
        RET
ADDTOBUF:
        LD      A,0
MUSTWRT EQU     $-1
        OR      A
        CALL    Z,NRESET
ADDTOBUF1:
        LD      A,0FFH
        LD      (MUSTWRT),A
        CALL    IVON
        LD      HL,READ         ;STATUS MESSAGE
        LD      DE,1300H
        CALL    PRTLOC
        LD      HL,(BLOCKS)
        LD      BC,(SRCBLK)     ;get start block
        CALL    FILLBUFF
        LD      (SRCBLK),BC
        LD      (BLOCKS),HL
        LD      A,L
        OR      H
        RET     Z
        CALL    FLSHBUF0
        JR      ADDTOBUF1
;
FLSHBUF:
        XOR     A
        LD      (MUSTWRT),A
        CALL    FLSHBUF0
        JP      IVOFF
FLSHBUF0:
        CALL    IVON
        LD      HL,WRITE        ;STATUS MESSAGE
        LD      DE,1400H
        CALL    PRTLOC
        LD      BC,(DESTBLK)
        CALL    EMPTYBUFF
        LD      (DESTBLK),BC
NRESET:
        LD      DE,BUFFER
        LD      (BUFFPOS),DE
        LD      BC,BUFFERSIZE
        LD      (SRAMLEFT),BC
        RET
;
ABRTRYCONT:
        LD      BC,0708H
        CALL    WRITE_REGISTER
        LD      A,18H
        LD      DE,16
        LD      HL,350H
        CALL    FILL_VRAM
        LD      DE,1600H
        LD      HL,ABRMSG
        CALL    PRTLOC
        CALL    BELL
        CALL    CIN
        PUSH    AF
        CALL    SETBORD0
        CALL    SETINV
        POP     AF
        CALL    BLANK
        AND     05FH
        SUB     'A'
        JP      Z,RESTART
        SUB     8
        RET     Z
        SUB     9
        JR      NZ,ABRTRYCONT
        INC     A
        RET
;
WRTBLK:
        PUSH    HL
        LD      HL,_WRITE_BLOCK
        JR      RWBLK
RDBLK:
        PUSH    HL
        LD      HL,_READ_BLOCK
RWBLK:
        LD      (RWBLK2),HL
        POP     HL
RWBLK1:
        PUSH    HL
        PUSH    BC
        PUSH    AF
        PUSH    DE
        EX      DE,HL
        LD      D,B
        LD      E,C
        LD      BC,0
        CALL    _READ_BLOCK
RWBLK2  EQU     $-2
        POP     DE
        POP     BC
        LD      A,B
        POP     BC
        POP     HL
        RET     Z
        PUSH    BC
        PUSH    AF
        PUSH    DE
        PUSH    HL
        CALL    DRVSTATUS
        LD      H,A
        LD      L,0FH
        AND     L
        JR      NZ,RWBLK3
        LD      A,H
        SRL     A
        SRL     A
        SRL     A
        SRL     A
RWBLK3:
        PUSH    BC
        PUSH    AF
        LD      A,(INVERSE)
        OR      A
        POP     BC
        LD      A,B
        POP     BC
        PUSH    AF
        CALL    CRLF
        CALL    CRLF
        CALL    CRLF
        CALL    IVON
        POP     AF
        PUSH    AF
        LD      D,A
        INC     D
        LD      A,0
        LD      HL,ERRORMSGS-1
RWBLK4:
        LD      B,0FFH
        CPIR
        DEC     D
        JR      NZ,RWBLK4
        LD      DE,1500H
        CALL    PRTLOC
        CALL    ABRTRYCONT
        PUSH    AF
        LD      DE,1405H
        CALL    GOTORC
        POP     BC
        POP     AF
        PUSH    BC
        CALL    Z,IVOFF
        POP     AF
        POP     HL
        POP     DE
        POP     BC
        LD      A,B
        POP     BC
        JR      NZ,RWBLK1
        RET
;
ADDAHL:
        ADD     A,L
        LD      L,A
        RET     NC
        INC     H
        RET
;
DRVSTATUS:
        PUSH    AF
        CALL    _FIND_DCB
        POP     HL
        LD      A,44H
        RET     NZ
        CALL    DSTAT1
        RET     NC
DSTAT0:
        LD      (IY+0),1
DSTAT1:
        LD      A,(IY+0)
        OR      A
        JP      P,DSTAT1
        CP      9BH
        JR      Z,DSTAT0
        XOR     80H
        LD      A,66H
        RET     NZ
        LD      L,0F0H
        LD      A,H
        AND     L
        LD      A,L
        JR      NZ,DSTAT2
        CPL
DSTAT2:
        AND     (IY+14H)
        RET     NZ
        SCF
        RET
;
;write a clean directory with the drive size taken from table
;do not write JP WP in block 0 since an INIT of drive 0
;would then trash the REBOOT and FORMAT information
;
SYSGEN:
        CALL    IVON
        LD      HL,WRTSYSMSG
        CALL    PRTLOC
        CALL    IVOFF
        CALL    ZEROFILL
        LD      HL,(VOLXSIZE)
        LD      DE,(FX1LEN)
        INC     DE
        SBC     HL,DE
        LD      (FX2LEN),HL
        LD      (FX2START),DE
        LD      HL,VOLXNAME     ;directory start
        LD      DE,BUFFER
        LD      BC,DIREND-VOLXNAME
        LDIR
        LD      A,(HEADR)
        OR      A
        JR      NZ,SYS1         ;don't do special drive 0 INIT
        LD      HL,(VOLXSIZE)
        LD      DE,(FX1LEN)
        INC     DE
        SBC     HL,DE
        LD      (F$2START),DE
        PUSH    DE
        LD      DE,12           ;dummy length for sys file
        OR      A
        SBC     HL,DE
        LD      (F$3LEN),HL     ;disk space left
        POP     HL
        ADD     HL,DE
        LD      (F$3START),HL   ;start of blocks left
        LD      HL,VOLXNAME     ;directory start
        LD      DE,BUFFER
        LD      BC,FX1END-VOLXNAME
        LDIR
        LD      HL,SPECIAL
        LD      BC,SPECEND-SPECIAL
        LDIR
SYS1:   LD      A,(SDRVID)
        LD      BC,1
        LD      DE,BUFFER
        CALL    WRTBLK
        CALL    ZEROFILL
        LD      BC,2
        LD      HL,(FX1LEN)     ;dir size
        JR      SYS3            ;do decrement first to check for 1 blk dir
SYS2:   LD      A,(SDRVID)
        PUSH    BC
        PUSH    HL
        LD      DE,BUFFER
        CALL    WRTBLK
        POP     HL
        POP     BC
        INC     BC
SYS3:   DEC     L
        JR      NZ,SYS2
        CALL    NAME
        LD      A,(HEADR)
        OR      A
        RET     Z
        LD      DE,BUFFER
        PUSH    BC              ;save destination block
        PUSH    DE              ;save buffer
        LD      HL,DEFPGM       ;copy default program (_GOTO_WP)
        LD      BC,15
        LDIR
        POP     DE              ;restore buffer
        POP     BC              ;restore destination block
        LD      A,(SDRVID)      ;destination drive
        JP      WRTBLK          ;do it
;
ZEROFILL:
        LD      DE,BUFFER
        LD      H,D
        LD      L,E
        INC     DE
        LD      BC,3FFH
        LD      (HL),0
        LDIR
        RET
;
;check device active or missing media
;
CHKSTAT:
        PUSH    AF
        CALL    _REQUEST_STATUS
        JR      NZ,NODEVICE
        LD      A,(IY+20)
        AND     0FH
        JR      NZ,NOMEDIA
        POP     AF
        RET                     ;ok to continue
NODEVICE:
        LD      DE,1608H
        LD      HL,BADDRV
        CALL    PRTGETKEY
        JP      RESTART
NOMEDIA:
        LD      DE,1608H
        LD      HL,INSERTD
        CALL    PRTGETKEY
        CP      ESC
        JP      Z,RESTART
        POP     AF
        JR      CHKSTAT         ;try again

;********************************************************
;*                                                      *
;*                 DIRECTORY FUNCTIONS                  *
;*                                                      *
;********************************************************

WRTDDX:
        LD      DE,DIRBUF
        LD      HL,(DIRSIZE)
        LD      H,0
        LD      BC,1
WRTDIR1:
        CALL    WRTBUFF
        JR      NZ,WRTDIR1
        RET
;
RDSDIR:
        PUSH    BC
        PUSH    DE
        PUSH    HL
        LD      BC,DIRSIZE
        LD      DE,DIRBUF
        LD      HL,FINDBL
        CALL    RDDIR
        POP     HL
        POP     DE
        POP     BC
        RET
;
RDDIR:
        LD      (RDDIR2),HL
        LD      (RDDIR0A),BC
        LD      (RDDIR2B),BC
        INC     BC
        LD      (RDDIR3A),BC
        INC     BC
        LD      (RDDIR2A),BC
        PUSH    DE
        LD      HL,1
        LD      BC,1
        CALL    RDBUFF
        POP     IX
        LD      A,(IX+69)
        OR      A
        JR      NZ,RDDIR0
        LD      A,1
        JR      RDDIRZ
RDDIR0:
        CP      11H
        JR      C,RDDIRZ
        LD      A,10H
RDDIRZ:
        LD      (DIRSIZE),A
RDDIR0A EQU     $-2
        LD      L,A
        LD      H,0
        DEC     HL
        LD      BC,2
RDDIR1:
        CALL    RDBUFF
        JR      NZ,RDDIR1
        CALL    FINDBL
RDDIR2  EQU     $-2
        LD      A,C
        LD      (FILENUM),A
RDDIR2A EQU     $-2
        LD      A,(DIRSIZE)
RDDIR2B EQU     $-2
        LD      B,A
        XOR     A
RDDIR3:
        ADD     A,39
        DJNZ    RDDIR3
        DEC     A
        LD      (MAXFILE),A
RDDIR3A EQU     $-2
        RET
;
FINDTYPE:
        PUSH    IX
        POP     HL
FNDTYP1:
        LD      A,(HL)
        INC     HL
        CP      3
        JR      NZ,FNDTYP1
        DEC     HL
        DEC     HL
        RET
;
FINDFILE:
        LD      IX,DIRBUF
        PUSH    HL
        LD      HL,DIRSIZE
        LD      (FNDF2A),HL
        POP     HL
        PUSH    BC
        PUSH    DE
        LD      DE,400H
        LD      B,1
        LD      A,C
FNDF1:
        SUB     39
        JR      C,FNDF2
        ADD     IX,DE
        INC     B
        JR      FNDF1
FNDF2:
        PUSH    AF
        LD      A,(DIRSIZE)
FNDF2A  EQU     $-2
        CP      B
        JR      C,FNDF5
        POP     AF
        ADD     A,39
        JR      Z,FNDF4
        LD      B,A
        LD      DE,26
FNDF3:
        ADD     IX,DE
        DJNZ    FNDF3
FNDF4:
        POP     DE
        POP     BC
        SCF
        RET
FNDF5:
        POP     AF
        POP     DE
        POP     BC
        OR      A
        RET
;
FINDFILEX:
        LD      IX,DIRBUF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        LD      DE,400H
        LD      H,B
        LD      L,C
        LD      BC,27H
        LD      A,1
        OR      A
FINDFILEXA:
        SBC     HL,BC
        JR      C,FINDFILEXB
        ADD     IX,DE
        INC     A
        JR      FINDFILEXA
FINDFILEXB:
        LD      D,A
        LD      A,(DIRSIZE)
        CP      D
        CCF
        JR      NC,FINDFILEXE
        ADD     HL,BC
        LD      A,L
        OR      H
        JR      Z,FINDFILEXD
        LD      B,L
        LD      DE,1AH
FINDFILEXC:
        ADD     IX,DE
        DJNZ    FINDFILEXC
FINDFILEXD:
        SCF
FINDFILEXE:
        POP     HL
        POP     DE
        POP     BC
        RET
;
FINDBLX:
        LD      BC,1
        CALL    FINDFILEX
        CALL    FINDBOOT
        JR      NZ,FINDBLXB
        LD      BC,2
FINDBLXA:
        INC     BC
        CALL    FINDFILEX
        JR      NC,FINDBLXB
        LD      A,(IX+12)
        AND     BLEFT
        JR      Z,FINDBLXA
        SCF
        RET
FINDBLXB:
        DEC     BC
        OR      A
        RET
;
FINDBL:
        PUSH    HL
        LD      HL,FINDFILE
        LD      (FNDBL1),HL
        LD      (FNDBL3),HL
        POP     HL
        LD      C,1
        CALL    FINDFILE
FNDBL1  EQU     $-2
        CALL    FINDBOOT
        JR      NZ,FNDBL4
        LD      C,2
FNDBL2:
        INC     C
        CALL    FINDFILE
FNDBL3  EQU     $-2
        JR      NC,FNDBL4
        LD      A,(IX+12)
        AND     BLEFT
        JR      Z,FNDBL2
        SCF
        RET
FNDBL4:
        DEC     C
        OR      A
        RET
;****************************************************************************
;Find boot block.  If the first 4 characters of the filename at IX are 'BOOT',
;on exit, ZF=1, else ZF=0.

FINDBOOT:
        LD      B,4
        LD      DE,BOOTMSG
                                ;fall into COMPNAME
;****************************************************************************
;Compare filename.  On entry, IX and DE point to strings to compare, B=
;length of string.  On exit, if the strings match, ZF=1, else ZF=0.
       
COMPNAME:
        PUSH    IX
        POP     HL
CNAME1: LD      A,(DE)
        CP      (HL)
        RET     NZ
        INC     DE
        INC     HL
        DJNZ    CNAME1
        RET
;****************************************************************************

BOOTMSG:        
        DB      'BOOT'

;****************************************************************************

SETVNAME:
        LD      HL,VOLXNAME
        PUSH    BC
        PUSH    DE
        PUSH    HL
        LD      HL,BLANK1
        CALL    PRTLOC
        POP     HL
        POP     DE
        CALL    GOTORC
        LD      B,11
        CALL    CINBUFF
        POP     BC
        RET
;
SHOWDIR:
        CALL    NAME
        CALL    CRFLIST
        LD      A,(FFILE)
        LD      D,A
        LD      A,(NFILE)
        CP      D
        JP      C,FPGUP
        LD      DE,1405H
        LD      HL,SKMSG
        CALL    PRTLOC
        CALL    RETURN
        LD      DE,1612H
        LD      HL,SELMSG
        CALL    PRTLOC
        CALL    ESCAPE
        LD      HL,DIRMSG
        LD      DE,0301H
        CALL    PRTLOC
        LD      HL,DIRBUF
        LD      DE,0311H
        LD      C,0
        CALL    FINDFILE
        CALL    SHOWFILE
        LD      A,(FILENUM)
        CP      4
        JR      C,NOFILE
        LD      A,0
NFILE   EQU     $-1
        INC     A
        JR      Z,NOFILE
        LD      D,5H
        LD      B,0
SOURCEDIR1:
        LD      E,3H
        CALL    NEXTCFILE
        RET     Z
        LD      E,12H
        CALL    NEXTCFILE
        RET     Z
        INC     D
        LD      A,11H
        CP      D
        JR      NC,SOURCEDIR1
        LD      A,(FFILE)
        LD      D,A
        LD      A,(LFILE)
        ADD     A,D
        LD      D,A
        LD      A,(NFILE)
        CP      D
        RET     Z
        CALL    IVON
        LD      HL,MOREMSG
        LD      DE,120FH
        CALL    PRTLOC
        JP      IVOFF
;
NOFILE:
        LD      HL,NOFILEMSG
        LD      DE,0504H
        CALL    PRTLOC
        LD      A,1
        OR      A
        RET
;
NEXTCFILE:
        CALL    LOOKUP
        LD      A,C
        OR      A
        RET     Z
        CALL    FINDFILE
        PUSH    IX
        POP     HL
        CALL    SHOWFILE
        LD      A,B
        LD      (LFILE),A
        INC     B
        INC     A
        RET
;
CRFLIST:
        LD      HL,FILELIST
        LD      BC,0FF02H
CRFL1:
        LD      A,(FILENUM)
        DEC     A
        CP      C
        JR      Z,CRFL2
        INC     C
        CALL    FINDFILE
        LD      A,(IX+12)
        AND     DELETED
        JR      NZ,CRFL1                ;no sys attribute
        PUSH    HL
        CALL    FINDTYPE
        LD      A,(HL)
        CP      2               ;happy face
        POP     HL
        JR      NZ,CRFL1        ;not boot file
        LD      (HL),C
        INC     HL
        INC     B
        JR      CRFL1
CRFL2:
        LD      A,B
        LD      (NFILE),A
        LD      (HL),0
        RET
;
SETFCURS:
        PUSH    BC
        SRL     B
        JR      C,SETFC1
        LD      E,1
        JR      SETFC2
SETFC1:
        LD      E,10H
SETFC2:
        LD      A,5
        ADD     A,B
        LD      D,A
        CALL    GOTORC
        POP     BC
        RET
LOOKUP:
        LD      HL,FILELIST
        LD      A,(FFILE)
        CALL    ADDAHL
        LD      A,B
        CALL    ADDAHL
        LD      C,(HL)
        RET
NODRIVES:
        LD      DE,0A05H
        LD      HL,NODRVMSG
        CALL    PRTLOC
        JR      NODRIVES        ;lock up to prevent damage

;****************************************************************************

        $INCLUDE DATA5.Z80

        IF MI
                $INCLUDE MIPATCH.Z80
        ELSE
                IF IDE
                        $INCLUDE IDEPATCH.Z80
                ELSE
                        IF SERVER
                                $INCLUDE SPATCH.Z80
                        ELSE
                                $INCLUDE BJPATCH.Z80
                        ENDIF
                ENDIF
        ENDIF

;****************************************************************************
;Here is the block 0 boot for an external disk/tape.
;This does the cold boot of the server.

SERVER_BOOT_BLOCK_0:

.DEPHASE

        $INCLUDE SBOOT20A.ASM

.PHASE SERVER_BOOT_BLOCK_0+1024

;****************************************************************
;*                                                              *
;*                            BUFFERS                           *
;*                                                              *
;****************************************************************

DRVNAMES EQU    $
FILELIST EQU    DRVNAMES+20*12
STACK   EQU     FILELIST+300H
BOOTBUF EQU     STACK+2H
DIRBUF  EQU     BOOTBUF+400H
BUFFER  EQU     DIRBUF+(10H*400H)

PGMSIZE EQU     ($-PGMSTART+1023)/1024

.DEPHASE

REPORT  <System File Size>,%PGMSIZE

END

