;***************************************************************************
;*                                                                         *
;*                  1ST2BLKS.ASM     boot block and directory              *
;*                                                                         *
;*  5.0     0008.13     ;changed year to 2000; fixed some comments         *
;*                                                                         *
;*  4.0     9609.01     ;changed year to 1996                              *
;*                                                                         *
;*  3.0     9507.15     ;expects entry C=serial baseport; passes           *
;*                      ;C=serial baseport to HARDDISK.                    *
;*                                                                         *
;*  2.0     9507.15     ;used canonical Coleco names for EOS calls         *
;*                                                                         *
;***************************************************************************

CURRENT_DEV  EQU 0FD6Fh

        .PHASE  0C800H
;
        JP      STARTX          ;skip over program data
;***************************************************************************
        DB      66h, 02h, 00h, 09h, 24h, 20h
NUMBER_OF_HD_VOLUMES:
        DB      0Ah
EOS_VOLUME_LENGTHS:
        DB      04h, 04h, 04h, 04h, 04h, 04h, 04h, 04h, 04h, 04h
EOS_VOLUME_OFFSETS:
        DB      00h, 04h, 08h, 0Ch, 10h, 14h, 18h, 1Ch, 20h, 24h
TDOS_STUFF:
        DB      08h, 00h, 04h, 0Fh, 00h, 04h, 02h, 0FFh,00h, 0F0h
        DB      00h, 00h, 00h, 0Eh, 2Ch, 08h, 00h, 05h
        DB      1Fh, 01h, 2Fh, 03h, 0FFh,03h, 0FFh,00h
        DB      00h, 00h, 18h, 30h, 08h, 00h, 05h, 1Fh
        DB      01h, 2Fh, 03h, 0FFh,03h, 0FFh,00h, 00h
        DB      00h, 0D8h,3Ch, 08h, 00h, 05h, 1Fh, 01h
        DB      2Fh, 03h, 0FFh,03h, 0FFh,00h, 00h, 00h
        DB      98h, 49h, 00h, 00h, 00h, 00h, 00h, 00h
;***************************************************************************
BOOT_FLG:
        DB      0
PRGNAM:
        DB      'HARDDISK',2,3,'    ' ;program name
PRGDATA:
        DW      100H            ;where program starts
        DW      PGMSIZE         ;length of program
STARTX:

        DI
        LD      SP,EOS_STACK
;added 9507.15
        LD      A,C                     ;serial baseport
        PUSH    AF                      ;save it
;
        LD      A,B
        LD      (CURRENT_DEV),A
;added 9506.25
        XOR A                       ;A=0
        OUT (66),A                  ;reset to bank 0 of XRAM
;end
        LD      BC,003FH            ;select SmartWriter ROM
                                    ;if memory configuration 0 is chosen
        OUT     (C),B
        LD      BC,037FH            ;lo32K OS7/RAM, hi32K RAM
        OUT     (C),B
        LD      A,(VDP_REG_1)
        RES     5,A
        LD      C,A
        LD      B,1
        CALL    WRITE_REGISTER
        LD      HL,0
        LD      DE,03FFFH
        XOR     A
        CALL    FILL_VRAM
        CALL    MODE1ON
        CALL    LDASCII
        LD      IX,ADAM
        CALL    SETLOGO
        LD      IX,COLORS
        CALL    SETLOGO
        LD      HL,FRMEDATA
        LD      DE,XYPOS
        LD      B,(HL)
        INC     HL
        LD      C,(HL)
        INC     HL
        CALL    SETFRME
        LD      HL,COLECO
        CALL    ADVRTZE
        LD      BC,001C0H       ;DISPLAY ON
        CALL    WRITE_REGISTER
        LD      BC,0017FH       ;lo32K RAM, hi32K RAM
        OUT     (C),B

        LD      HL,EOSFCB
        LD      DE,THREEBLKS    ;3 1K buffers
        CALL    _FMGR_INIT      ;set up file buffers
        XOR     A
        LD      (0FD75H),A      ;clear keyboard buffer
        CALL    TURN_OFF_SOUND
;
        LD      A,(CURRENT_DEV) ;get current device
        LD      B,1             ;do a mode 1 open
        LD      HL,PRGNAM       ;point to program name
        CALL    _OPEN_FILE      ;open the file
        JP      NZ,_GOTO_WP     ;if unable to open
        LD      (DATA+4),A      ;save FCB number
        CALL    RDFILE          ;read the file
        JP      NZ,_GOTO_WP     ;if bad read
        LD      A,(DATA+4)      ;get back FCB number
        CALL    _CLOSE_FILE     ;close the file
        JP      NZ,_GOTO_WP     ;if unable to close
;
        LD      HL,(PRGDATA)    ;get start of program
;added 9507.15
        POP     AF              ;A=serial baseport
        LD      C,A             ;into C
;
        LD      A,(CURRENT_DEV) ;get current device
        JP      (HL)            ;jump to it
;****************************************************************************
RDFILE:
        LD      HL,PRGDATA
        LD      DE,DATA
        LD      BC,4
        LDIR
;
RDFIL2:
        LD      HL,DATA+2       ;point to file size (in 1K blocks)
        DEC     (HL)            ;decrement it (one less block)
        LD      A,(DATA+4)      ;get FCB number
        LD      HL,(DATA)       ;get file buffer (initialized to start of file)
        LD      BC,0400H        ;read 1K of
        CALL    _READ_FILE      ;read from file
        JR      NZ,BADRD        ;if bad read
        LD      BC,0400H        ;increment file buffer
        ADD     HL,BC
        LD      (DATA),HL       ;and save it
        LD      A,(DATA+2)      ;have we read all the file?
        OR      A
        JR      NZ,RDFIL2       ;no, read some more
        RET
;****************************************************************************
BADRD:
        LD      A,1             ;set A to non-zero to indicate bad read
        OR      A
        RET
;
;       SET UP BACKGROUND LOGO
SETLOGO:
        LD      H,(IX+1)
        LD      L,(IX+0)
        LD      D,(IX+3)
        LD      E,(IX+2)
        LD      B,(IX+5)
        LD      C,(IX+4)
        PUSH    BC
        PUSH    HL
        PUSH    DE
        INC     C
        DEC     C
        JR      Z,NEXT1
        LD      B,0
        CALL    WRITE_VRAM
NEXT1:
        POP     DE
        POP     HL
        POP     BC
        INC     B
        DEC     B
        RET     Z
        PUSH    BC
        LD      B,0
        ADD     HL,BC
        EX      DE,HL
        ADD     HL,BC
        EX      DE,HL
        POP     BC
        LD      C,0
        CALL    WRITE_VRAM
        RET
;****************************************************************************
;SEND OUT DEFINITION OF FRAME

ADVRTZE:
        LD      A,(HL)
        INC     A
        RET     Z
        LD      D,(HL)
        INC     HL
        LD      E,(HL)
        INC     HL
        LD      C,(HL)
        INC     HL
        PUSH    HL
;D = LINE IN FRAME
;E = HOW FAR IN ON LINE
;C = NUMBER OF CHARACTERS IN TEXT
;NEXT ENTRY FOLLOWS IN SAME FORM OR FF TO END
        LD      B,0
        ADD     HL,BC
        EX      (SP),HL
        LD      B,1
        CALL    SETFRME
        POP     HL
        JR      ADVRTZE
;****************************************************************************

COLORS: DW COLORS+6
        DB 0,32,20,0,80,80,80,80
        DB 240,240,240,240,240,240,240,240
ADAMCOLOR:
        DB 0A0H,0A0H,0A0H,0A0H,0A0H,0A0H,0A0H,0A0H            ;YELLOW
FRMEDATA:
        DB 5,24,0,97,99,99,100,0
        DB 97,99,99,99,110,0,97,99
        DB 99,100,0,97,99,100,0,122
        DB 99,123,0,98,96,102,101,0
        DB 98,96,111,112,96,0,98,96
        DB 102,101,0,98,96,101,0,106
        DB 96,0,0,105,103,104,96,124
        DB 0,96,113,114,96,0,105,103
        DB 104,96,124,0,96,96,121,96
        DB 96,0,0,106,96,96,96,101
        DB 0,96,115,116,96,0,106,96
        DB 96,96,101,0,96,117,96,119
        DB 96,0,105,96,107,108,109,96
        DB 124,96,96,96,125,105,96,107
        DB 108,109,96,124,96,118,96,120
        DB 96,0
COLECO:
        DB 9,12,8,'PRESENTS'
RE$BOOT EQU     $+16
;
        IF      MI
;
        DB 12,4,24,'MI HARD DISK SYSTEM V',VERHI,'.',VERLO
;
        ELSE
;
;       DB 12,4,23,'  HARD DISK SYSTEM V',VERHI,'.',VERLO

        DB 12,4,23,' THE ADAMSERVE HARDDISK'
;
        ENDIF
;
;       DB 14,2,28,'BY G. COUSINEAU & T. MOREHEN'
;       DB 16,13,5,'^1991'
;       DB 18,10,12,'AJM SOFTWARE'
;       DB 255

        DB 14,2,28,'DEVELOPED BY RICHARD DRUSHEL'
        DB 16,13,5,'^2000'
        DB 18,10,12,'RFD SOFTWARE'
        DB 255
ADAM:
        DW ADAM+6
        DB 224,2,16,1,0,250
        DB 35,34,0,0,0,0,0,32
        DB 96,160,0,0,0,0,124,130
        DB 186,162,186,130,124,0,60,66
        DB 185,165,185,173,66,60,255,255
        DB 255,255,255,255,255,255,0,0
        DB 0,0,15,15,31,31,63,63
        DB 127,127,1,0,0,0,0,0
        DB 0,0,255,255,255,255,0,0
        DB 0,0,192,192,224,224,240,240
        DB 248,248,252,252,254,254,255,255
        DB 255,255,207,207,135,135,255,255
        DB 255,255,254,254,252,252,135,3
        DB 3,3,1,1,0,0,0,0
        DB 1,1,3,3,7,7,15,15
        DB 31,31,63,63,127,127,255,255
        DB 192,192,128,128,0,0,255,255
        DB 0,0,0,0,0,0,255,255
        DB 3,3,1,1,0,0,0,0
        DB 0,0,240,252,254,254,255,255
        DB 255,255,255,128,128,128,255,255
        DB 255,255,255,3,1,1,128,128
        DB 128,128,128,128,128,128,1,1
        DB 1,1,1,1,1,1,128,128
        DB 128,128,128,128,128,255,1,1
        DB 1,1,1,1,3,255,127,127
        DB 63,63,31,31,15,15,7,7
        DB 3,3,1,1,0,0,254,254
        DB 252,252,248,248,240,240,224,224
        DB 192,192,128,128,0,0,0,0
        DB 129,129,195,195,231,231,0,0
        DB 0,0,3,3,7,7,243,85
        DB 81,81,0,0,0,0,0,0
        DB 128,128,192,192,224,224,255,255
        DB 255,255,254,254,252,240,0,0
;
DATA    EQU     $
;
BOOTSPACE EQU   0CC00H-$
        DS      BOOTSPACE       ;zero-fill rest of block
        REPORT  <BOOT BLOCK SPACE>,%BOOTSPACE
;
;Directory of Disk
;
        DB      'HARD DISK  ',3
        DB      81H
        DB      55H,0AAH,0,0FFH
        DW      160,0
        DB      0,0,0,0,0
;
        DB      'BOOT',3,'       '
        DB      0D8H
        DW      0,0
        DW      1,1
        DW      400H
        DB      0,0,0
;
        DB      'DIRECTORY',3,'  '
        DB      0D8H
        DW      1,0
        DW      1,1
        DW      400H
        DB      0,0,0
;
        DB      'HARDDISK',2,3,'  '     ;program name
        DB      0D8H
        DW      2,0
        DW      PGMSIZE,PGMSIZE
        DW      400H
        DB      DYEAR,DMONTH,DDAY
;
        DB      'BLOCKS LEFT',3
        DB      1
        DW      PGMSIZE+2,0
        DW      160-(PGMSIZE+2),0
        DW      0
        DB      0,0,0
;
        DS      0D000H-$
;
        .DEPHASE
