;***************************************************************************
;*                                                                         *
;*                      File Manager 4.0 boot block                        *
;*                                                                         *
;*   1.0    9609.02   altered from 1ST2BLK4.ASM for HARDDISK 4.2           *
;*                                                                         *
;***************************************************************************

PROGSTART       EQU     256
PROGSIZE        EQU     16

CURRENT_DEV     EQU     0FD6Fh
EOS_STACK       EQU     0FE58H
VDP_REG_1       EQU     0FD62H
WRITE_REGISTER  EQU     0FD20H
FILL_VRAM       EQU     0FD26H
MODE1ON         EQU     01F85H
LDASCII         EQU     01F7FH
XYPOS           EQU     00204H
SETFRME         EQU     0080BH
EOSFCB          EQU     0D390H
THREEBLKS       EQU     0D400H
_FMGR_INIT      EQU     0FCBAH
TURN_OFF_SOUND  EQU     0FD53H
_OPEN_FILE      EQU     0FCC0H
_GOTO_WP        EQU     0FCE7H
_CLOSE_FILE     EQU     0FCC3H
_READ_FILE      EQU     0FCD2H
WRITE_VRAM      EQU     0FD1AH

;
;REPORT MACRO TO SHOW WHERE THINGS ARE
;
REPORT  MACRO   MESSAGE,VALUE
.PRINTX MESSAGE = VALUE
        ENDM
;
;**************************************************


        ORG  0C800H
;
        JR      STARTX          ;skip over program data
;***************************************************************************
BOOT_FLG:
        DB      0
PRGNAM:
        DB      'FILEMAN',2,3,'     ' ;program name
PRGDATA:
        DW      PROGSTART       ;where program starts
        DW      PROGSIZE        ;length of program
;***************************************************************************
STARTX:

        DI
        LD      SP,EOS_STACK
        PUSH    AF                      ;save it
;
        LD      A,B
        LD      (CURRENT_DEV),A
;added 9506.25
        XOR A                       ;A=0
        OUT (66),A                  ;reset to bank 0 of XRAM
;end
        LD      BC,003FH            ;select SmartWriter ROM
                                    ;if memory configuration 0 is chosen
        OUT     (C),B
        LD      BC,037FH            ;lo32K OS7/RAM, hi32K RAM
        OUT     (C),B
        LD      A,(VDP_REG_1)
        RES     5,A
        LD      C,A
        LD      B,1
        CALL    WRITE_REGISTER
        LD      HL,0
        LD      DE,03FFFH
        XOR     A
        CALL    FILL_VRAM
        CALL    MODE1ON
        CALL    LDASCII
        LD      IX,ADAM
        CALL    SETLOGO
        LD      IX,COLORS
        CALL    SETLOGO
        LD      HL,FRMEDATA
        LD      DE,XYPOS
        LD      B,(HL)
        INC     HL
        LD      C,(HL)
        INC     HL
        CALL    SETFRME
        LD      HL,COLECO
        CALL    ADVRTZE
        LD      BC,001C0H       ;DISPLAY ON
        CALL    WRITE_REGISTER
        LD      BC,0017FH       ;lo32K RAM, hi32K RAM
        OUT     (C),B

        LD      HL,EOSFCB
        LD      DE,THREEBLKS    ;3 1K buffers
        CALL    _FMGR_INIT      ;set up file buffers
        XOR     A
        LD      (0FD75H),A      ;clear keyboard buffer
        CALL    TURN_OFF_SOUND
;
        LD      A,(CURRENT_DEV) ;get current device
        LD      B,1             ;do a mode 1 open
        LD      HL,PRGNAM       ;point to program name
        CALL    _OPEN_FILE      ;open the file
        JP      NZ,_GOTO_WP     ;if unable to open
        LD      (DATA+4),A      ;save FCB number
        CALL    RDFILE          ;read the file
        JP      NZ,_GOTO_WP     ;if bad read
        LD      A,(DATA+4)      ;get back FCB number
        CALL    _CLOSE_FILE     ;close the file
        JP      NZ,_GOTO_WP     ;if unable to close
;
        LD      HL,(PRGDATA)    ;get start of program
;
        LD      A,(CURRENT_DEV) ;get current device
        JP      (HL)            ;jump to it
;****************************************************************************
RDFILE:
        LD      HL,PRGDATA
        LD      DE,DATA
        LD      BC,4
        LDIR
;
RDFIL2:
        LD      HL,DATA+2       ;point to file size (in K)
        DEC     (HL)            ;decrement it
        LD      A,(DATA+4)      ;get FCB number
        LD      HL,(DATA)       ;get file buffer (initialized to start of file)
        LD      BC,0400H        ;read 1K of
        CALL    _READ_FILE      ;read from file
        JR      NZ,BADRD        ;if bad read
        LD      BC,0400H        ;increment file buffer
        ADD     HL,BC
        LD      (DATA),HL       ;and save it
        LD      A,(DATA+2)      ;have we read all the
        OR      A
        JR      NZ,RDFIL2       ;no, read some more
        RET
;****************************************************************************
BADRD:
        LD      A,1             ;set A to non-zero to indicate bad read
        OR      A
        RET
;
;       SET UP BACKGROUND LOGO
SETLOGO:
        LD      H,(IX+1)
        LD      L,(IX+0)
        LD      D,(IX+3)
        LD      E,(IX+2)
        LD      B,(IX+5)
        LD      C,(IX+4)
        PUSH    BC
        PUSH    HL
        PUSH    DE
        INC     C
        DEC     C
        JR      Z,NEXT1
        LD      B,0
        CALL    WRITE_VRAM
NEXT1:
        POP     DE
        POP     HL
        POP     BC
        INC     B
        DEC     B
        RET     Z
        PUSH    BC
        LD      B,0
        ADD     HL,BC
        EX      DE,HL
        ADD     HL,BC
        EX      DE,HL
        POP     BC
        LD      C,0
        CALL    WRITE_VRAM
        RET
;****************************************************************************
;SEND OUT DEFINITION OF FRAME

ADVRTZE:
        LD      A,(HL)
        INC     A
        RET     Z
        LD      D,(HL)
        INC     HL
        LD      E,(HL)
        INC     HL
        LD      C,(HL)
        INC     HL
        PUSH    HL
;D = LINE IN FRAME
;E = HOW FAR IN ON LINE
;C = NUMBER OF CHARACTERS IN TEXT
;NEXT ENTRY FOLLOWS IN SAME FORM OR FF TO END
        LD      B,0
        ADD     HL,BC
        EX      (SP),HL
        LD      B,1
        CALL    SETFRME
        POP     HL
        JR      ADVRTZE
;****************************************************************************

COLORS: DW COLORS+6
        DB 0,32,20,0,80,80,80,80
        DB 240,240,240,240,240,240,240,240
ADAMCOLOR:
        DB 0A0H,0A0H,0A0H,0A0H,0A0H,0A0H,0A0H,0A0H            ;YELLOW
FRMEDATA:
        DB 5,24,0,97,99,99,100,0
        DB 97,99,99,99,110,0,97,99
        DB 99,100,0,97,99,100,0,122
        DB 99,123,0,98,96,102,101,0
        DB 98,96,111,112,96,0,98,96
        DB 102,101,0,98,96,101,0,106
        DB 96,0,0,105,103,104,96,124
        DB 0,96,113,114,96,0,105,103
        DB 104,96,124,0,96,96,121,96
        DB 96,0,0,106,96,96,96,101
        DB 0,96,115,116,96,0,106,96
        DB 96,96,101,0,96,117,96,119
        DB 96,0,105,96,107,108,109,96
        DB 124,96,96,96,125,105,96,107
        DB 108,109,96,124,96,118,96,120
        DB 96,0
COLECO:
        DB 9,12,8,'PRESENTS'
RE$BOOT EQU     $+16
;
        DB 12,4,23,'   FILE MANAGER V4.0   '
        DB 14,2,28,'     FOR ADAMSERVE          '
        DB 16,13,5,'^1996'
        DB 18,10,12,'AJM SW / RFD'
        DB 255
ADAM:
        DW ADAM+6
        DB 224,2,16,1,0,250
        DB 35,34,0,0,0,0,0,32
        DB 96,160,0,0,0,0,124,130
        DB 186,162,186,130,124,0,60,66
        DB 185,165,185,173,66,60,255,255
        DB 255,255,255,255,255,255,0,0
        DB 0,0,15,15,31,31,63,63
        DB 127,127,1,0,0,0,0,0
        DB 0,0,255,255,255,255,0,0
        DB 0,0,192,192,224,224,240,240
        DB 248,248,252,252,254,254,255,255
        DB 255,255,207,207,135,135,255,255
        DB 255,255,254,254,252,252,135,3
        DB 3,3,1,1,0,0,0,0
        DB 1,1,3,3,7,7,15,15
        DB 31,31,63,63,127,127,255,255
        DB 192,192,128,128,0,0,255,255
        DB 0,0,0,0,0,0,255,255
        DB 3,3,1,1,0,0,0,0
        DB 0,0,240,252,254,254,255,255
        DB 255,255,255,128,128,128,255,255
        DB 255,255,255,3,1,1,128,128
        DB 128,128,128,128,128,128,1,1
        DB 1,1,1,1,1,1,128,128
        DB 128,128,128,128,128,255,1,1
        DB 1,1,1,1,3,255,127,127
        DB 63,63,31,31,15,15,7,7
        DB 3,3,1,1,0,0,254,254
        DB 252,252,248,248,240,240,224,224
        DB 192,192,128,128,0,0,0,0
        DB 129,129,195,195,231,231,0,0
        DB 0,0,3,3,7,7,243,85
        DB 81,81,0,0,0,0,0,0
        DB 128,128,192,192,224,224,255,255
        DB 255,255,254,254,252,240,0,0
;
DATA    EQU     $
;
BOOTSPACE EQU   0CC00H-$
        DS      BOOTSPACE       ;zero-fill rest of block
        REPORT  <BOOT BLOCK SPACE>,%BOOTSPACE
;****************************************************************************

