;***************************************************************************
;***************************************************************************
;***                                                                     ***
;***                                                                     ***
;***                   FILE MANAGER for the Coleco ADAM                  ***
;***                            by Tony Morehen                          ***
;***                      original version 3.1 (EOS)                     ***
;***                                                                     ***
;***                                                                     ***
;*** Source re-created by Z80DIS 2.2                                     ***
;*** Z80DIS was written by Kenneth Gielow, Palo Alto, CA                 ***
;***                                                                     ***
;***                                                                     ***
;*** source code cleaned up manually and formatted for Z80ASM+ assembler ***
;*** by Richard F. Drushel 9602.10                                       ***
;***                                                                     ***
;***                                                                     ***
;***************************************************************************
;***************************************************************************

;version history

;023    9609.02         ;disabled FORMAT menu.  Also removed some orphaned code.
;022    9609.02         ;finally got the directory size bug licked.
;                       ;Production version except for disabling FORMAT menu.
;021    9609.01         ;try to fix bugs in 020.
;020    9608.31         ;last few bugs in 019.  Everything but nagging
;                       ;directory size bug.
;019    9608.31         ;try to debug 018.  (only a few kinks remain:  why
;                       ;default disk sizes of >720K aren't saved, icky
;                       ;cursor stuff.  Still haven't patched out port 64
;                       ;printer to be device 13.
;018    9608.31         ;try to debug 017.  (works, but doesn't find DISK_2;
;                       ;also is icky in block edit mode with the character
;                       ;disappearing under the cursor.)
;                       ;added a missing POP HL in CHECK_FOR_ADAMNET_DEVICE
;017    9608.31         ;begin ADAMserve changes!  (didn't work 1st time)
;                       ;remove all Mini Wini HD code
;                       ;remove patch to CONS_DISP which is only for EOS5

;***************************************************************************
;***************************************************************************

;016    9608.29         ;final comments before making changes for ADAMserve.
;015    9608.04         ;even more comments for ADAMnet stuff.  Also made
;                       ;paramter block writing relocatable as memory map
;                       ;changes--no longer hard-coded for block 10.
;014    9608.01         ;more comments for Tony's evil ADAMnet bit-banging
;013    9607.31         ;more comments; some XRAM label changes
;012    9607.31         ;memory configuration equates; some comments
;011    9606.12         ;SmartKey and other ADAM keyboard symbol equates
;010    9606.09         ;fancy header added; conditional assembly to
;                       ;calculate SEGMENT0 (which Z80ASM+ will not allow
;                       ;us to forward reference in .PHASE directives).
;                       ;Basically what we must do is assemble it once
;                       ;with SEGMENT0 set to an arbitrary absolute
;                       ;number, to determine what the real SEGMENT0 is
;                       ;supposed to be.  Then we reassemble and input the
;                       ;correct SEGMENT0 as a parameter.  Brutal, but it
;                       ;will work (does work).
;009    9605.05         ;(hopefully) last relocatable memory stuff fixed (no)
;008    9602.16         ;functional subroutine labelling
;007    9602.15         ;begin STRING$xxx labels for strings
;006    9602.15         ;continuing 005 cleanup
;005    9602.11         ;continuing 004 cleanup
;004    9602.11         ;continuing 003 cleanup
;003    9602.11         ;more memory map fixing, begin to get rid of
;                       ;excess I.xxxx references which aren't addresses
;002    9602.11         ;fixing overlay areas
;001    9602.11         ;more EOS equates
;000    9602.10         ;stable


	.Z80
	ORG      0100H

NMI_VECTOR              EQU     0066H
DBUF                    EQU     0080H
RETN$                   EQU     45EDH
XRAM_RESIDENT           EQU     0100H

STACK2    EQU      START_UP+320
BUFF0     EQU      STACK2+2
BUFF1     EQU      BUFF0+( 6*BLOCKSIZE)
BUFF2     EQU      BUFF1+( 1*BLOCKSIZE)
BUFF3     EQU      BUFF2+(31*BLOCKSIZE)
STACK1    EQU      SEGMENT0-2

;; D.F658                  EQU     0F658H   ; --SL-        ;these are EOS-5 code
;; D.F659                  EQU     0F659H   ; --S--        ;absolute addresses!

FACE$                   EQU     0FACEH
SOUNDPORT               EQU     0FC2FH
_READ_BLOCK             EQU     0FCF3H
_WRITE_BLOCK            EQU     0FCF6H
_RD_DEV_DEP_STAT        EQU     0FCE4H
_REQUEST_STATUS         EQU     0FC7EH
_FIND_DCB               EQU     0FC54H
_CONS_DISP              EQU     0FC33H
_CONS_INIT              EQU     0FC36H
_CONS_OUT               EQU     0FC39H
_END_RD_KBD             EQU     0FC4BH
_PR_CH                  EQU     0FC66H
_START_RD_KBD           EQU     0FCA8H
_GOTO_WP                EQU     0FCE7H
_WR_CH_DEV              EQU     0FCB7H
PUT_ASCII               EQU     0FD17H
WRITE_VRAM              EQU     0FD1AH
WRITE_REGISTER          EQU     0FD20H
FILL_VRAM               EQU     0FD26H
INIT_TABLE              EQU     0FD29H
LOAD_ASCII              EQU     0FD38H
EOS_STACK               EQU     0FE58H
CURSOR_Y                EQU     0FEA5H
CURSOR_X                EQU     0FEA6H
PCB                     EQU     0FEC0H
P_NUM_DCBS              EQU     03H
DCBS                    EQU     0FEC4H
D_COM_STAT              EQU     00H
D_BUF_ADR               EQU     01H
D_BUF_ADR_LO            EQU     D_BUF_ADR+00H
D_BUF_ADR_HI            EQU     D_BUF_ADR+01H
D_BUF_LEN               EQU     03H
D_BUF_LEN_LO            EQU     D_BUF_LEN+00H
D_BUF_LEN_HI            EQU     D_BUF_LEN+01H
D_SECT_NUM              EQU     05H
D_SEC_DEV_ID            EQU     09H
D_RET_COUNT             EQU     0EH
D_RET_COUNT_LO          EQU     D_RET_COUNT+00H
D_RET_COUNT_HI          EQU     D_RET_COUNT+01H
D_DEV_ADDR              EQU     10H
D_MAX_MSG_LEN           EQU     11H
D_MAX_MSG_LEN_LO        EQU     D_MAX_MSG_LEN+00H
D_MAX_MSG_LEN_HI        EQU     D_MAX_MSG_LEN+01H
D_DEV_TYPE              EQU     13H
D_STATUS_FLAGS          EQU     14H
D_SIZE                  EQU     15H
TIME_OUT_ERR            EQU     9BH
NO_ERR                  EQU     80H
DCB_STATUS_REQ          EQU     01H
DCB_RESET_REQ           EQU     02H
DCB_WRITE_REQ           EQU     03H
DCB_READ_REQ            EQU     04H

BLOCKSIZE               EQU     0400H
PARALLEL_PORT           EQU     40H
XRAM_MAGIC_NUMBER       EQU     2680H                   ;used by XRAM_INIT
XRAM_DTA                EQU     0400H

;ADAMserve equates

HD_CURRENT_VOLUME       EQU     58343
PRINT_UNDERLINE_FLAG    EQU     64863

;ADAMnet device equates

KEYBOARD                EQU     01H
ADAM_PRINTER            EQU     02H
DISK_1                  EQU     04H
DISK_2                  EQU     05H
DISK_3                  EQU     06H     ;EPROM upgrade
DISK_4                  EQU     07H     ;EPROM upgrade
TAPE_1                  EQU     08H
TAPE_3                  EQU     09H
ADAMNET_PARALLEL        EQU     0DH
ADAMNET_SERIAL          EQU     0EH
TAPE_2                  EQU     18H
TAPE_4                  EQU     19H
RAM_DISK                EQU     1AH     ;emulated ADAMnet device

;Floppy disk type equates

SINGLE_SIDED            EQU     00H
DOUBLE_SIDED            EQU     01H
QUAD_DENSITY            EQU     02H
HIGH_1200K              EQU     03H
HIGH_DENSITY            EQU     04H

;ADAM memory configuration equates

XRAM_BANK_PORT          EQU     42H
MEMORY_SWITCH_PORT      EQU     7FH
MEM_SWEOS_RAM           EQU     0
MEM_RAM_RAM             EQU     1
MEM_XRAM_RAM            EQU     2
MEM_OS7RAM_RAM          EQU     3
MEM_SWEOS_XROM          EQU     4
MEM_RAM_XROM            EQU     5
MEM_XRAM_XROM           EQU     6
MEM_OS7RAM_XROM         EQU     7
MEM_SWEOS_XRAM          EQU     8
MEM_RAM_XRAM            EQU     9
MEM_XRAM_XRAM           EQU     10
MEM_OS7RAM_XRAM         EQU     11
MEM_SWEOS_CROM          EQU     12
MEM_RAM_CROM            EQU     13
MEM_XRAM_CROM           EQU     14
MEM_OS7RAM_CROM         EQU     15

;ADAM keyboard character equates

CTRL_B$                 EQU     02H                     ;^B
CTRL_C$                 EQU     03H                     ;^C
CTRL_S$                 EQU     13H                     ;^S

BACKSPACE$              EQU     08H                     ;backspace
TAB$                    EQU     09H                     ;tab
LF$                     EQU     0AH                     ;line feed
FF$                     EQU     0CH                     ;form feed
CR$                     EQU     0DH                     ;carriage return
ESC$                    EQU     1BH                     ;escape
SPACE$                  EQU     20H                     ;space bar

CTRL_DELETE$            EQU     7FH                     ;^Delete (ASCII DEL)
HOME$                   EQU     80H                     ;Home

SMARTKEY_1$             EQU     81H                     ;SmartKey I
SMARTKEY_2$             EQU     82H                     ;SmartKey II
SMARTKEY_3$             EQU     83H                     ;SmartKey III
SMARTKEY_4$             EQU     84H                     ;SmartKey IV
SMARTKEY_5$             EQU     85H                     ;SmartKey V
SMARTKEY_6$             EQU     86H                     ;SmartKey VI

SHIFT_SMARTKEY_1$       EQU     89H                     ;Shift-SmartKey I
SHIFT_SMARTKEY_2$       EQU     8AH                     ;Shift-SmartKey II
SHIFT_SMARTKEY_3$       EQU     8BH                     ;Shift-SmartKey III
SHIFT_SMARTKEY_4$       EQU     8CH                     ;Shift-SmartKey IV
SHIFT_SMARTKEY_5$       EQU     8DH                     ;Shift-SmartKey V
SHIFT_SMARTKEY_6$       EQU     8EH                     ;Shift-SmartKey VI

WILD_CARD$              EQU     90H                     ;Wild Card
UNDO$                   EQU     91H                     ;Undo
MOVE$                   EQU     92H                     ;Move
STORE_GET$              EQU     93H                     ;Store/Get
INSERT$                 EQU     94H                     ;Insert
PRINT$                  EQU     95H                     ;Print
CLEAR$                  EQU     96H                     ;Clear
DELETE$                 EQU     97H                     ;Delete

SHIFT_WILD_CARD$        EQU     98H                     ;Shift-Wild Card
SHIFT_UNDO$             EQU     99H                     ;Shift-Undo
SHIFT_MOVE$             EQU     9AH                     ;Shift-Move
SHIFT_STORE_GET$        EQU     9BH                     ;Shift-Store/Get
SHIFT_INSERT$           EQU     9CH                     ;Shift-Insert
SHIFT_PRINT$            EQU     9DH                     ;Shift-Print
SHIFT_CLEAR$            EQU     9EH                     ;Shift-Clear
SHIFT_DELETE$           EQU     9FH                     ;Shift-Delete

UP_ARROW$               EQU     0A0H                    ;Up Arrow
RIGHT_ARROW$            EQU     0A1H                    ;Right Arrow
DOWN_ARROW$             EQU     0A2H                    ;Down Arrow
LEFT_ARROW$             EQU     0A3H                    ;Left Arrow

CTRL_UP_ARROW$          EQU     0A4H                    ;^Up Arrow
CTRL_RIGHT_ARROW$       EQU     0A5H                    ;^Right Arrow
CTRL_DOWN_ARROW$        EQU     0A6H                    ;^Down Arrow
CTRL_LEFT_ARROW$        EQU     0A7H                    ;^Left Arrow

UP_RIGHT_ARROW$         EQU     0A8H                    ;Up-Right Arrow
DOWN_RIGHT_ARROW$       EQU     0A9H                    ;Down-Right Arrow
DOWN_LEFT_ARROW$        EQU     0AAH                    ;Down-Left Arrow
UP_LEFT_ARROW$          EQU     0ABH                    ;Up-Left Arrow

HOME_UP_ARROW$          EQU     0ACH                    ;Home-Up Arrow
HOME_RIGHT_ARROW$       EQU     0ADH                    ;Home-Right Arrow
HOME_DOWN_ARROW$        EQU     0AEH                    ;Home-Down Arrow
HOME_LEFT_ARROW         EQU     0AFH                    ;Home-Left Arrow

;***************************************************************************
;***************************************************************************

;stuff to accept SEGMENT0 from the console, etc.

FALSE   EQU     0
TRUE    EQU     NOT FALSE

PRINTX  MACRO   XX
	.PRINTX XX
	ENDM

IF1

	.PRINTX
	.PRINTX ******************************************************************
	.PRINTX ******************************************************************
	.PRINTX ***                                                            ***
	.PRINTX ***                                                            ***
	.PRINTX ***                IMPORTANT ASSEMBLY NOTICE!!                 ***
	.PRINTX ***                                                            ***
	.PRINTX ***                                                            ***
	.PRINTX ******************************************************************
	.PRINTX ******************************************************************
	.PRINTX
	.PRINTX Z80ASM+ cannot deal with forward references in .PHASE directives.
	.PRINTX File Manager needs such references.  Hence, the only workaround
	.PRINTX is two assembly runs:  the first to determine the absolute value
	.PRINTX of the forward reference, and the second to do the "real" assembly
	.PRINTX using the previously-determined absolute value.  The variable
	.PRINTX required is called SEGMENT0.
	.PRINTX

ELSE
ENDIF

.ACCEPT "Calculate SEGMENT0 (TRUE or FALSE)",DO_CALC_SEGMENT0

IF DO_CALC_SEGMENT0

	SEGMENT0        EQU     0E000H                  ;old 0D941H
	SEGMENT00       EQU     BUFF3+( 1*BLOCKSIZE)

	IF1
		.PRINTX
		.PRINTX You must reassemble using the calculated value.
		.PRINTX
	ELSE
	ENDIF

ELSE

	.ACCEPT "Value for SEGMENT0",SEGMENT0

ENDIF

;***************************************************************************
;***************************************************************************


MAIN_START:
	LD       BC,RETN$
	LD       (NMI_VECTOR),BC
	LD       SP,STACK1
	CALL     START_UP
CENTRAL_LOOP:
	LD       SP,STACK2
	CALL     C.1FF8
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$009
	CALL     C.1FD3
	LD       DE,0E18H
	LD       BC,(D.2965)
	CALL     C.1E4C
J$0126:
	LD       DE,0709H
	CALL     C$0296
	LD       DE,0A09H
	CALL     PRINT_CURRENT_SOURCE_NAME
	CALL     READ_KEYBOARD
	CP       CTRL_C$ 
	JP       Z,ABORT_TO_SMARTWRITER
	LD       DE,CENTRAL_LOOP
	PUSH     DE
	CP       SMARTKEY_3$
	JP       Z,SETUP_MENU
	CP       SMARTKEY_2$
	JP       Z,MEDIA_FUNCTIONS_MENU
	CP       SMARTKEY_1$
	JR       Z,J.0176
	CP       CR$ 
	JR       Z,J.0176
	POP      DE
	CP       SMARTKEY_4$
	CALL     Z,C$0289
	CP       SMARTKEY_5$
	CALL     Z,CHANGE_SOURCE_DRIVE
	JR       J$0126
;        -----------------
J$015D:
	CALL     C.0A3E
	LD       E,(IX+19)
	LD       D,(IX+20)
	LD       (COPY_BLOCK_COUNT),DE
	LD       L,(IX+13)
	LD       H,(IX+14)
	LD       (SOURCE_START_BLOCK),HL
	JP       MEDIA_FUNCTIONS_MENU
;        -----------------
J.0176:
	XOR      A
	LD       (D.2995),A
	LD       (D.2996),A
	LD       (D.2997),A
	CALL     C.0964
	CALL     C.0A7E
	JR       C,J.01A9
	CALL     CLS_PRINT_COPYRIGHT
	CALL     INVERSE_VIDEO
	LD       HL,STRING$020          ;"Not an EOS media"
	LD       DE,0506H
	CALL     PRINT_STRING_1
	CALL     NORMAL_VIDEO
	CALL     READ_KEYBOARD
	CP       ESC$
	JP       Z,CENTRAL_LOOP
	CP       CTRL_C$ 
	JP       Z,ABORT_TO_SMARTWRITER
	JR       J.0176
;        -----------------
J.01A9:
	CALL     C.045A
J.01AC:
	LD       A,(D.2995)
	LD       B,A
	LD       A,(D.2997)
	CP       B
	JR       NC,J$01B7
	LD       B,A
J$01B7:
	CALL     C.1FF7
	LD       A,01H    ; 1 
	CALL     C.02AD
	CALL     C.052B
	CALL     C.053F
	CALL     READ_KEYBOARD
	PUSH     AF
	XOR      A
	CALL     C.02AD
	CALL     C.1FF8
	CALL     C.052B
	POP      AF
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       ESC$
	JP       Z,CENTRAL_LOOP
	LD       DE,J.0176
	PUSH     DE
	CP       SMARTKEY_2$
	JP       Z,J$015D
	CP       CLEAR$
	JP       Z,J$054E
	CP       INSERT$
	JP       Z,C.0964
	POP      DE
	LD       DE,J.01A9
	PUSH     DE
	CP       CR$ 
	JP       Z,J$024C
	CP       MOVE$
	JP       Z,J.05AC
	CP       PRINT$
	JP       Z,J$19BB
	CP       WILD_CARD$
	JP       Z,J$02BD
	CP       DELETE$
	JP       Z,J$092F
	CP       SHIFT_PRINT$
	JP       Z,J$0365
	CP       SMARTKEY_1$
	JP       Z,J$0FC0
	POP      DE
	LD       DE,J.01AC
	PUSH     DE
	CP       UP_ARROW$
	JP       Z,J$02CE
	CP       DOWN_ARROW$
	JP       Z,J$02E0
	CP       HOME_UP_ARROW$
	JP       Z,J.02EC
	CP       HOME_DOWN_ARROW$
	JP       Z,J$02F9
	CP       LEFT_ARROW$
	JP       Z,J$02D3
	CP       RIGHT_ARROW$
	JP       Z,C.02E1
	CP       HOME$
	JP       Z,J$02E8
	CP       STORE_GET$
	JP       Z,J$033D
	CP       UNDO$
	JP       Z,J$0351
	RET      
;        -----------------
J$024C:
	LD       C,02H
J$024E:
	INC      C
	LD       A,(D.2987)
	CP       C
	POP      DE
	JP       Z,J.01AC
	PUSH     DE
	CALL     C.0A3E
	BIT      7,(IX+15)
	JR       Z,J$024E
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$018          ;"Copy Tagged Files" etc.
	LD       DE,0500H
	CALL     PRINT_STRING_1
J$026D:
	CALL     READ_KEYBOARD
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       SMARTKEY_1$
	JP       Z,J.05E3
	CP       SMARTKEY_2$
	JP       Z,J$197F
	CP       SMARTKEY_3$
	JP       Z,J$090C
	JR       J$026D
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0289:
	LD       A,(D.297C)
	INC      A
	CP       CTRL_C$ 
	JR       C,J$0292
	XOR      A
J$0292:
	LD       (D.297C),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0296:
	LD       HL,STRING$012
	LD       A,(D.297C)
	OR       A
	JP       Z,PRINT_STRING_1
	LD       HL,STRING$011
	DEC      A
	JP       Z,PRINT_STRING_1
	LD       HL,STRING$010
	JP       PRINT_STRING_1
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.02AD:
	PUSH     BC
	PUSH     DE
	PUSH     HL
	LD       DE,0001H
	LD       HL,3882H
	CALL     FILL_VRAM
	POP      HL
	POP      DE
	POP      BC
	RET      
;        -----------------
J$02BD:
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$017
	CALL     C.1FD3
	JP       READ_KEYBOARD
;        -----------------
J.02C9:
	LD       A,B
	LD       (D.2995),A
	RET      
;        -----------------
J$02CE:
	LD       A,B
	OR       A
	JR       Z,J.02DA
	DEC      B
J$02D3:
	LD       A,B
	OR       A
	JR       Z,J.02DA
	DEC      B
	JR       J.02C9
;        -----------------
J.02DA:
	LD       A,(D.2997)
	LD       B,A
	JR       J.02C9
;        -----------------
J$02E0:
	INC      B
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.02E1:
	INC      B
	LD       A,(D.2997)
	CP       B
	JR       NC,J.02C9
J$02E8:
	LD       B,00H
	JR       J.02C9
;        -----------------
J.02EC:
	LD       A,(D.2996)
	OR       A
	JR       Z,J.02C9
	SUB      1AH
	JR       NC,J.0306
	XOR      A
	JR       J.0306
;        -----------------
J$02F9:
	LD       A,(D.2996)
	ADD      A,1AH
	LD       D,A
	LD       A,(D.2998)
	CP       D
	JR       C,J.0306
	LD       A,D
J.0306:
	LD       (D.2996),A
	LD       B,00H
	PUSH     BC
	CALL     C.045A
	POP      BC
	JR       J.02C9
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0312:
	LD       A,(D.2987)
	LD       B,A
	LD       C,CTRL_C$ 
J$0318:
	CALL     C$0349
	LD       A,(D.297A)
	OR       A
	JR       Z,J.0339
	DEC      A
	JR       Z,J.032F
	CALL     C.0A27
	CP       60H      ; "`"
	JR       C,J.032F
	SET      2,(IX+12)
J.032F:
	BIT      2,(IX+12)
	JR       Z,J.0339
	RES      7,(IX+15)
J.0339:
	INC      C
	DJNZ     J$0318
	RET      
;        -----------------
J$033D:
	CALL     C.052B
	INC      E
	LD       A,2AH    ; "*"
	CALL     C.20CA
	CALL     C.02E1
;
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0349:
	CALL     C.0A3E
	SET      7,(IX+15)
	RET      
;        -----------------
J$0351:
	CALL     C.052B
	INC      E
	LD       A,SPACE$
	CALL     C.20CA
	CALL     C.02E1
	CALL     C.0A3E
	RES      7,(IX+15)
	RET      
;        -----------------
J$0365:
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$024          ;"PRINT DIRECTORY"
	LD       DE,0401H
	CALL     PRINT_STRING_1
	CALL     C.1FB1
	LD       DE,1612H
	LD       HL,STRING$105          ;"Printing"
	CALL     PRINT_STRING_1
	CALL     PRINT_ESCAPE_TO_EXIT
J$0380:
	LD       DE,0609H
	CALL     PRINT_PRINTER_NAME
	CALL     READ_KEYBOARD
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       CR$ 
	JR       Z,J$039C
	CP       SMARTKEY_1$
	CALL     Z,TOGGLE_PRINTER
	JR       J$0380
;        -----------------
J$039C:
	CALL     CLEAR_SCREEN
	LD       A,(CURRENT_PRINTER)
	OR       A
	JR       Z,J$03AB
	LD       HL,STRING$035
	CALL     C.1FC4
J$03AB:
	LD       HL,STRING$008
	CALL     C.1FC4
	LD       A,01H    ; 1 
	LD       (D.295B),A
	LD       C,00H
	CALL     C.0A3E
	CALL     C.2146
	LD       HL,CR_LF_SP3_0$
	CALL     C.1FC4
	LD       B,0FFH
J$03C6:
	LD       A,(CURRENT_PRINTER)
	OR       A
	JR       Z,J$03CE
	LD       A,03H    ; 3 
J$03CE:
	LD       (D$03E0),A
	INC      B
	LD       HL,START_UP
	LD       A,B
	CALL     ADD_A_TO_HL
	LD       A,(HL)
	OR       A
	JR       Z,J$040B
	LD       C,A
	LD       A,B
	AND      03H      ; 3 
D$03E0   EQU      $-1
	JR       NZ,J$03FE
	LD       A,(CURRENT_PRINTER)
	OR       A
	JR       NZ,J$03F8
	LD       A,(D.295B)
	INC      A
	CP       18H
	JR       NZ,J$03F5
	CALL     READ_KEYBOARD
	XOR      A
J$03F5:
	LD       (D.295B),A
J$03F8:
	LD       HL,CR_LF_SP3_0$
	CALL     C.1FC4
J$03FE:
	CALL     C.0A3E
	CALL     C.2146
	PUSH     BC
	CALL     C.0442
	POP      BC
	JR       J$03C6
;        -----------------
J$040B:
	LD       A,(D.2987)
	LD       C,A
	CALL     C.0A3E
	LD       HL,LF_CR_LF_SP3_0$
	CALL     C.1FC4
	LD       A,(CURRENT_PRINTER)
	OR       A
	JR       Z,J$0424
	LD       HL,STRING$035
	CALL     C.1FC4
J$0424:
	LD       HL,STRING$025
	CALL     C.1FC4
	CALL     C.0442
	LD       HL,CR_LF_SP3_0$
	CALL     C.1FC4
	LD       A,(CURRENT_PRINTER)
	OR       A
	RET      NZ
	JP       READ_KEYBOARD
;        -----------------
LF_CR_LF_SP3_0$:
	DB     LF$
CR_LF_SP3_0$:
	DB     CR$,LF$,'   ',00H
;        -----------------
;
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0442:
	LD       C,(IX+17)
	LD       B,(IX+18)
	CALL     C.1E3E
	LD       HL,STRING$026
	JP       C.1FC4
;****************************************************************************
;Abort to SmartWriter.

ABORT_TO_SMARTWRITER:
	CALL     CLEAR_SCREEN
	LD       SP,EOS_STACK
	JP       _GOTO_WP
;****************************************************************************
C.045A:
	CALL     CLS_PRINT_COPYRIGHT
	CALL     C$0507
	LD       A,(D.2996)
	LD       D,A
	LD       A,(D.2998)
	CP       D
	JP       C,J.02EC
	LD       DE,1400H
	LD       HL,STRING$016
	CALL     PRINT_STRING_1
	CALL     C.1FB1
	LD       DE,160FH
	LD       HL,STRING$023
	CALL     PRINT_STRING_1
	CALL     PRINT_ESCAPE_TO_EXIT
	LD       HL,STRING$008
	LD       DE,0301H
	CALL     PRINT_STRING_1
	LD       HL,BUFF0
	LD       DE,0311H
	LD       C,00H
	CALL     C.0A3E
	CALL     C.2152
	LD       A,(D.2987)
	CP       04H
	JR       C,J.04DA
	LD       A,(D.2998)
	INC      A
	JR       Z,J.04DA
	LD       D,05H
	LD       B,00H
J$04AB:
	LD       E,03H
	CALL     C.04E3
	RET      Z
	LD       E,12H
	CALL     C.04E3
	RET      Z
	INC      D
	LD       A,11H
	CP       D
	JR       NC,J$04AB
	LD       A,(D.2996)
	LD       D,A
	LD       A,(D.2997)
	ADD      A,D
	LD       D,A
	LD       A,(D.2998)
	CP       D
	RET      Z
	CALL     INVERSE_VIDEO
	LD       HL,STRING$022
	LD       DE,120FH
	CALL     PRINT_STRING_1
	JP       NORMAL_VIDEO
;        -----------------
J.04DA:
	LD       HL,STRING$019
	LD       DE,0504H
	JP       PRINT_STRING_1
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.04E3:
	CALL     C.053F
	LD       A,C
	OR       A
	RET      Z
	CALL     C.0A3E
	BIT      7,(IX+15)
	JR       Z,J$04FA
	PUSH     DE
	DEC      E
	LD       A,2AH    ; "*"
	CALL     C.20CA
	POP      DE
J$04FA:
	PUSH     IX
	POP      HL
	CALL     C.2152
	LD       A,B
	LD       (D.2997),A
	INC      B
	INC      A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0507:
	LD       HL,START_UP
	LD       BC,0FF02H
J.050D:
	LD       A,(D.2987)
	DEC      A
	CP       C
	JR       Z,J$0524
	INC      C
	CALL     C.0A3E
	LD       A,(IX+12)
	AND      04H      ; 4 
	JR       NZ,J.050D
	LD       (HL),C
	INC      HL
	INC      B
	JR       J.050D
;        -----------------
J$0524:
	LD       A,B
	LD       (D.2998),A
	LD       (HL),00H
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.052B:
	PUSH     BC
	SRL      B
	JR       C,J$0534
	LD       E,01H    ; 1 
	JR       J$0536
;        -----------------
J$0534:
	LD       E,10H    ; 16 
J$0536:
	LD       A,05H    ; 5 
	ADD      A,B
	LD       D,A
	CALL     C.1FA2
	POP      BC
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.053F:
	LD       HL,START_UP
	LD       A,(D.2996)
	CALL     ADD_A_TO_HL
	LD       A,B
	CALL     ADD_A_TO_HL
	LD       C,(HL)
	RET      
;        -----------------
J$054E:
	LD       A,C
	CP       CTRL_C$ 
	RET      C
	CALL     C.0A3E
	PUSH     IX
	POP      IY
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$021          ;"INITIALIZE DIRECTORY"
	CALL     C.1FD3
	LD       DE,060DH
	CALL     C.2152
	CALL     PAUSE_CHECK_DRIVES     ;wait for keypress
	CP       ESC$                   ;did I hit escape?
					;this test is redundant, since
					;PAUSE_CHECK_DRIVES exits with ZF=1
					;already if escape was pressed.
	RET      Z                      ;yes
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
;
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0573:
	CALL     C.0A7E
	LD       E,(IY+13)
	LD       D,(IY+14)
	LD       (IX+13),E
	LD       (IX+14),D
	LD       HL,(D.3D62)
	OR       A
	SBC      HL,DE
	LD       (IX+17),L
	LD       (IX+18),H
	PUSH     IY
	POP      DE
	PUSH     IX
	POP      HL
	PUSH     BC
	LD       BC,001AH               ;length of directory entry
	LDIR                            ;copy it
	LD       H,D
	LD       L,E
	INC      DE
	LD       (HL),00H
	LD       BC,2000H               ;8192=length of 8-block directory
	LDIR     
	POP      BC
	LD       A,C
	LD       (D.2987),A
	JP       C.09EF
;        -----------------
J.05AC:
	PUSH     BC
	CALL     COPY_FILE_MENU
	POP      BC
	CP       ESC$
	RET      Z
	CALL     PAUSE_CHECK_DRIVES     ;wait for keypress
	JP       Z,J.05AC               ;escape was pressed
	CALL     C.1F6A
	PUSH     BC
	CALL     C.0625
	POP      BC
	PUSH     BC
	CALL     C.0706
	POP      BC
	JR       Z,J.05D8
	CALL     C.0666
	PUSH     IX
	POP      DE
	CALL     C.0674
	CALL     C.0A3E
	CALL     C.0692
J.05D8:
	LD       A,(D.298E)
	OR       A
	RET      Z
	CALL     C$0A13
	JP       C.0964
;        -----------------
J.05E3:
	CALL     COPY_FILE_MENU
	CP       ESC$
	RET      Z
	CALL     PAUSE_CHECK_DRIVES     ;wait for keypress
	JP       Z,J.05E3               ;escape was pressed
	CALL     C.1F6A
;
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$05F2:
	CALL     C.0625
	RET      Z
	LD       B,A
	LD       C,02H    ; 2 
J$05F9:
	CALL     C.0767
	JR       Z,J$0608
	INC      B
	PUSH     BC
	CALL     C.0706
	POP      BC
	JR       NZ,J$05F9
	JR       J.05D8
;        -----------------
J$0608:
	CALL     C.0666
	PUSH     IX
	LD       C,02H    ; 2 
J.060F:
	POP      DE
	CALL     C.0674
	JR       NC,J.05D8
	CALL     C.0767
	JR       Z,J.05D8
	RES      7,(IX+15)
	CALL     C.0692
	PUSH     IX
	JR       J.060F
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0625:
	XOR      A
	LD       (D.298E),A
	LD       A,(D.297E)
	OR       A
	JR       Z,J.0639
	LD       A,(D.297B)
	OR       A
	JR       NZ,J.0639
	DEC      A
	LD       (D.298F),A
J.0639:
	CALL     C.1759
	CALL     C.0977
	LD       A,(D$298A)
	LD       B,A
	LD       A,(D.2989)
	CP       B
	JP       Z,J.074C
	PUSH     HL
	PUSH     DE
	PUSH     BC
	CALL     C.0A78
	LD       L,(IX+13)
	LD       H,(IX+14)
	LD       (DEST_START_BLOCK),HL
	LD       HL,(BUFF1+17)
	LD       (D.2990),HL
	POP      BC
	POP      DE
	POP      HL
	LD       A,01H    ; 1 
	OR       A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0666:
	PUSH     BC
	CALL     C.2232
	CALL     C.0977
	CALL     C.0A78
	POP      HL
	LD       B,C
	LD       C,L
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0674:
	INC      B
	PUSH     BC
	LD       C,B
	CALL     C.0A34
	PUSH     IX
	POP      HL
	POP      BC
	RET      NC
	PUSH     HL
	PUSH     DE
	EX       DE,HL
	PUSH     BC
	LD       BC,001AH               ;26=length of directory entry
	LDIR                            ;copy it
	POP      BC
	POP      DE
	POP      HL
	LD       A,0FFH
	LD       (D.298E),A
	SCF      
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0692:
	PUSH     HL
	PUSH     DE
	PUSH     IX
	POP      HL
	POP      DE
	PUSH     DE
	PUSH     BC
	LD       BC,001AH               ;26=length of directory entry
	LDIR                            ;copy it
	POP      BC
	POP      IY
	POP      IX
	LD       L,(IX+13)
	LD       (IY+13),L
	LD       H,(IX+14)
	LD       (IY+14),H
	LD       E,(IY+19)
	LD       D,(IY+20)
	LD       (IY+17),E
	LD       (IY+18),D
	ADD      HL,DE
	LD       (IX+13),L
	LD       (IX+14),H
	LD       DE,(D.2990)
	EX       DE,HL
	OR       A
	SBC      HL,DE
	LD       (IX+17),L
	LD       (IX+18),H
	LD       A,(D.298F)
	OR       A
	RET      Z
	PUSH     IX
	PUSH     IY
	POP      IX
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$042          ;"Old Filename: New Filename:"
	CALL     C.1FD3
	LD       DE,060FH
	CALL     C.2152
	LD       DE,080FH
	CALL     C.1FA2
	PUSH     IX
	POP      HL
	CALL     C$118C
	POP      IX
	RET      
;        -----------------
?.06FA:
	LD       C,02H
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.06FC:
	CALL     C.0767
	RET      Z
	RES      7,(IX+15)
	JR       C.06FC
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0706:
	LD       A,(D.2989)
	CP       B
	JR       Z,J.074C
	CALL     CLS_PRINT_COPYRIGHT
	CALL     C.0A3E
	LD       HL,STRING$047          ;"Copying"
	LD       DE,0602H
	CALL     PRINT_STRING_1
	INC      HL
	CALL     C.1FD3
	LD       DE,060BH
	CALL     C.2152
	LD       E,(IX+19)
	LD       D,(IX+20)
	LD       (COPY_BLOCK_COUNT),DE
	LD       L,(IX+13)
	LD       H,(IX+14)
	LD       (SOURCE_START_BLOCK),HL
	LD       HL,(DEST_START_BLOCK)
	ADD      HL,DE
	LD       DE,(D.2990)
	EX       DE,HL
	OR       A
	SBC      HL,DE
	JR       C,J.074C
	CALL     C.21FB
	XOR      A
	INC      A
	RET      
;        -----------------
J.074C:
	DEC      C
	CALL     C.06FC
	CALL     CLS_PRINT_COPYRIGHT
	CALL     INVERSE_VIDEO
	LD       HL,STRING$045          ;"Target Media is Full"
	LD       DE,0601H
	CALL     PRINT_STRING_1
	CALL     READ_KEYBOARD
	CALL     NORMAL_VIDEO
	XOR      A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0767:
	INC      C
	LD       A,(D.2987)
	CP       C
	RET      Z
	CALL     C.0A3E
	XOR      A
	BIT      7,(IX+15)
	JR       Z,C.0767
	RET      
;****************************************************************************
;Copy File Menu.

COPY_FILE_MENU:
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$041
	LD       DE,0401H
	CALL     C.1FD3
	CALL     C.1FB1
	LD       DE,1612H
	LD       HL,STRING$047
	CALL     PRINT_STRING_1
	CALL     PRINT_ESCAPE_TO_EXIT
J$0793:
	LD       DE,0609H
	CALL     C$07CC
	LD       DE,0909H
	CALL     PRINT_CURRENT_DEST_NAME
	LD       DE,0B04H
	CALL     C.1764
	CALL     READ_KEYBOARD
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       CR$ 
	RET      Z
	CP       SMARTKEY_1$
	CALL     Z,C$07C4
	CP       SMARTKEY_2$
	CALL     Z,CHANGE_DEST_DRIVE
	CP       SMARTKEY_6$
	CALL     Z,C.174C
	JR       J$0793
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$07C4:
	LD       A,(D.298F)
	CPL      
	LD       (D.298F),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$07CC:
	LD       HL,STRING$043
	LD       A,(D.298F)
	OR       A
	JP       NZ,PRINT_STRING_1
	LD       HL,STRING$044
	JP       PRINT_STRING_1
;****************************************************************************
;Copy Block Menu.

COPY_BLOCK_MENU:
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$046
	CALL     C.1FD3
	CALL     C.1FB1
	LD       DE,1612H
	LD       HL,STRING$047          ;"Copying"
	CALL     PRINT_STRING_1
	CALL     PRINT_ESCAPE_TO_EXIT
J$07F4:
	LD       DE,0709H
	CALL     PRINT_CURRENT_SOURCE_NAME
	LD       DE,0809H
	CALL     PRINT_SOURCE_DISK_TYPE
	LD       DE,091BH
	LD       BC,(SOURCE_START_BLOCK)
	CALL     C.1E4C
	LD       DE,0A1BH
	LD       BC,(COPY_BLOCK_COUNT)
	CALL     C.1E4C
	LD       DE,0D09H
	CALL     PRINT_CURRENT_DEST_NAME
	LD       DE,0E09H
	CALL     PRINT_DEST_DISK_TYPE
	LD       DE,0F1BH
	LD       BC,(DEST_START_BLOCK)
	CALL     C.1E4C
	LD       DE,1104H
	CALL     C.1764
	CALL     READ_KEYBOARD
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       CR$ 
	JR       Z,J$0869
	CP       SMARTKEY_1$
	CALL     Z,CHANGE_SOURCE_DRIVE
	CP       SHIFT_SMARTKEY_1$
	CALL     Z,TOGGLE_SOURCE_DISK_TYPE
	CP       SMARTKEY_2$
	CALL     Z,C$267C
	CP       SMARTKEY_3$
	CALL     Z,C$2692
	CP       SMARTKEY_4$
	CALL     Z,CHANGE_DEST_DRIVE
	CP       SHIFT_SMARTKEY_4$
	CALL     Z,TOGGLE_DEST_DISK_TYPE
	CP       SMARTKEY_5$
	CALL     Z,C$2687
	CP       SMARTKEY_6$
	CALL     Z,C.174C
	JR       J$07F4
;        -----------------
J$0869:
	CALL     C.1759
	LD       HL,(SOURCE_START_BLOCK)
	LD       DE,SOURCE_1
	PUSH     HL
	PUSH     DE
	CALL     CHECK_BLOCK_RANGE
	POP      DE
	POP      HL
	JR       NC,J.08A3
	CALL     CHECK_BLOCK_END_RANGE
	JR       NC,J.08A3
	LD       HL,(DEST_START_BLOCK)
	LD       DE,DEST_1
	PUSH     HL
	PUSH     DE
	CALL     CHECK_BLOCK_RANGE
	POP      DE
	POP      HL
	JR       NC,J.08A8
	CALL     CHECK_BLOCK_END_RANGE
	JR       NC,J.08A8
	CALL     PAUSE_CHECK_DRIVES     ;wait for keypress
	JP       Z,COPY_BLOCK_MENU      ;escape was pressed
	CALL     C.1F6A
	CALL     C.222F
	JP       COPY_BLOCK_MENU
;        -----------------
J.08A3:
	LD       HL,STRING$097          ;"SOURCE"
	JR       J$08AB
;        -----------------
J.08A8:
	LD       HL,STRING$098          ;"TARGET"
J$08AB:
	PUSH     HL
	LD       A,08H    ; 8 
	CALL     C.191F
	CALL     C.1969
	CALL     INVERSE_VIDEO
	POP      HL
	LD       DE,1500H
	CALL     PRINT_STRING_1
	LD       HL,STRING$099          ;"BLOCK ERROR"
	CALL     C.1FD3
	CALL     BEEPER
	CALL     NORMAL_VIDEO
	CALL     READ_KEYBOARD
	CALL     C.1966
	CALL     C.191C
	JP       COPY_BLOCK_MENU
;****************************************************************************
;Check Block End Range.
;  On entry, HL=start block, (COPY_BLOCK_COUNT)=number of blocks, DE=
;source/destination parameter base address.  On exit, if the desired block
;is in range, CF=1; otherwise, CF=0.

CHECK_BLOCK_END_RANGE:
	LD       BC,(COPY_BLOCK_COUNT)  ;# of blocks to get
	ADD      HL,BC                  ;get final block to test
;bug!!! we should now do a
	DEC      HL                     ;to get true final block
;****************************************************************************
;Check Block Range.
;  On entry, HL=desired block, DE=source/destination parameter base address.
;On exit, if the block is in range, CF=1; otherwise, CF=0.

CHECK_BLOCK_RANGE:
	CALL     GET_MEDIA_SIZE         ;BC=maximum block size
	OR       A                      ;CF=0
	SBC      HL,BC                  ;is there enough space?
	RET                             ;if yes, CF=1; if not, CF=0
;****************************************************************************
;Get Media Size.
;  On entry, DE=source/destination parameter base address.  On exit,
;BC=maximum size of the requested medium in blocks.  Note once again
;the hard-coded limit of 65535 blocks as the maximum size of a block device!
;Also note the hard-coded assumption that tape drives are only 256K!
;Definitely needs patching for 1200K and 1440K disks.

GET_MEDIA_SIZE:
	LD       BC,256                 ;let's guess that it's 256K
	INC      DE                     ;point to device #
	LD       A,(DE)                 ;get device #
	INC      DE                     ;point to disk type
	CP       TAPE_1                 ;is it a floppy disk?
	JR       C,G_M_S_FLOPPY         ;yes, so get its size
	BIT      7,A                    ;no, is it a tape?
	RET      Z                      ;yes, so exit, assuming it's 256K
					;so much for the 320K tapes!
	PUSH     HL                     ;no, it's a hard disk
	AND      0FH                    ;wipe hi nibble
	LD       HL,HD_VOL_DIRSIZE_TABLE ;point to HD directory size table
	CALL     ADD_A_TO_HL            ;offset to desired volume
	LD       B,(HL)                 ;get the size for this volume
	LD       C,00H                  ;in BC
	POP      HL
	RET      
;        -----------------
G_M_S_FLOPPY:
	LD       BC,160                 ;let's guess 160K
	LD       A,(DE)                 ;get the disk type
	OR       A                      ;was it SINGLE_SIDED?
	RET      Z                      ;yes, so exit 160K
	LD       BC,320                 ;no, let's try 320K
	DEC      A                      ;was it DOUBLE_SIDED?
	RET      Z                      ;yes, so exit 320K
	LD       BC,720                 ;no, try 720K
	DEC      A                      ;was it QUAD_DENSITY?
	RET      Z                      ;yes
	LD       BC,1200                ;no, try 1200K
	DEC      A                      ;was it HIGH_1200K?
	RET      Z                      ;yes
	LD       BC,1440                ;no, must be HIGH_DENSITY
	RET                             ;so exit 1440K
;****************************************************************************
J$090C:
	CALL     CLS_PRINT_COPYRIGHT
	LD       C,02H 
J.0911:
	INC      C
	LD       A,(D.2987)
	CP       C
	JR       Z,J$0935
	CALL     C.0A3E
	BIT      7,(IX+15)
	JR       Z,J.0911
	RES      7,(IX+15)
	PUSH     BC
	CALL     C.0938
	POP      BC
	CP       ESC$
	RET      Z
	JR       J.0911
;        -----------------
J$092F:
	CALL     CLS_PRINT_COPYRIGHT
	CALL     C.0938
J$0935:
	JP       C.09EF
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0938:
	LD       A,C
	CP       CTRL_C$ 
	RET      C
	CALL     C.0A3E
	LD       DE,0602H
	CALL     C.2152
	LD       DE,0610H
	LD       HL,STRING$048
	CALL     PRINT_STRING_1
	CALL     READ_KEYBOARD
	CALL     C.1FEE
	CP       4EH      ; "N"
	RET      Z
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	SET      2,(IX+12)
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0964:
	PUSH     BC
	PUSH     DE
	PUSH     HL
	LD       BC,D.2985
	LD       DE,BUFF0
	LD       HL,C.0A7E
	CALL     C.099F
	POP      HL
	POP      DE
	POP      BC
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0977:
	CALL     C.1F13
	PUSH     BC
	PUSH     DE
	PUSH     HL
	LD       A,(SOURCE_CURRENT_DEVICE)
	LD       (D.298B),A
	LD       A,(DEST_CURRENT_DEVICE)
	LD       (SOURCE_CURRENT_DEVICE),A
	LD       HL,C.0A78
	LD       DE,BUFF1
	LD       BC,D.2988
	CALL     C.099F
	LD       A,(D.298B)
	LD       (SOURCE_CURRENT_DEVICE),A
	POP      HL
	POP      DE
	POP      BC
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.099F:
	LD       (D$09DB),HL
	LD       (D$09CA),BC
	LD       (D$09E2),BC
	INC      BC
	LD       (D$09EC),BC
	INC      BC
	LD       (D$09DF),BC
	PUSH     DE
	LD       HL,0001H
	LD       BC,0001H
	CALL     READ_BLOCK_COUNTED
	POP      IX
	LD       A,(IX+69)
	CP       07H      ; 7 
	JR       C,J$09C9
	LD       A,06H    ; 6 
J$09C9:
	LD       (D.2985),A
D$09CA   EQU      $-2
	OR       A
	RET      Z
	LD       L,A
	LD       H,00H
	DEC      HL
	LD       BC,0002H
J$09D5:
	CALL     READ_BLOCK_COUNTED
	JR       NZ,J$09D5
	CALL     C.0A7E
D$09DB   EQU      $-2
	LD       A,C
	LD       (D.2987),A
D$09DF   EQU      $-2
	LD       A,(D.2985)
D$09E2   EQU      $-2
	LD       B,A
	XOR      A
J$09E6:
	ADD      A,27H    ; "'"
	DJNZ     J$09E6
	DEC      A
	LD       (D.2986),A
D$09EC   EQU      $-2
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.09EF:
	LD       A,(DEST_CURRENT_DEVICE)
	LD       (D.298B),A
	LD       A,(SOURCE_CURRENT_DEVICE)
	LD       (DEST_CURRENT_DEVICE),A
	LD       DE,BUFF0
	LD       HL,(D.2985)
	CALL     C.0A1C
	LD       A,(D.298B)
	LD       (DEST_CURRENT_DEVICE),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0A0B:
	LD       DE,BUFF0
	LD       HL,(D.2985)
	JR       C.0A1C
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0A13:
	CALL     C.1F13
	LD       DE,BUFF1
	LD       HL,(D.2988)
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0A1C:
	LD       H,00H
	LD       BC,0001H
J$0A21:
	CALL     C.2356
	JR       NZ,J$0A21
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0A27:
	PUSH     IX
	POP      HL
J$0A2A:
	LD       A,(HL)
	INC      HL
	CP       CTRL_C$ 
	JR       NZ,J$0A2A
	DEC      HL
	DEC      HL
	LD       A,(HL)
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0A34:
	LD       IX,BUFF1
	PUSH     HL
	LD       HL,D.2988
	JR       J$0A46
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0A3E:
	LD       IX,BUFF0
	PUSH     HL
	LD       HL,D.2985
J$0A46:
	LD       (D$0A5D),HL
	POP      HL
	PUSH     BC
	PUSH     DE
	LD       DE,BLOCKSIZE
	LD       B,01H    ; 1 
	LD       A,C
J$0A52:
	SUB      27H      ; "'"
	JR       C,J$0A5B
	ADD      IX,DE
	INC      B
	JR       J$0A52
;        -----------------
J$0A5B:
	PUSH     AF
	LD       A,(D.2985)
D$0A5D   EQU      $-2
	CP       B
	JR       C,J$0A73
	POP      AF
	ADD      A,27H    ; "'"
	JR       Z,J$0A6F
	LD       B,A
	LD       DE,001AH
J$0A6B:
	ADD      IX,DE
	DJNZ     J$0A6B
J$0A6F:
	POP      DE
	POP      BC
	SCF      
	RET      
;        -----------------
J$0A73:
	POP      AF
	POP      DE
	POP      BC
	OR       A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0A78:
	PUSH     HL
	LD       HL,C.0A34
	JR       J$0A82
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0A7E:
	PUSH     HL
	LD       HL,C.0A3E
J$0A82:
	LD       (D$0A8C),HL
	LD       (D$0AAE),HL
	POP      HL
	LD       C,01H    ; 1 
	CALL     C.0A3E
D$0A8C   EQU      $-2
	LD       A,(IX)
	CP       42H      ; "B"
	JR       NZ,J.0ABB
	LD       A,(IX+1)
	CP       4FH      ; "O"
	JR       NZ,J.0ABB
	LD       A,(IX+2)
	CP       4FH      ; "O"
	JR       NZ,J.0ABB
	LD       A,(IX+3)
	CP       54H      ; "T"
	JR       NZ,J.0ABB
	LD       C,02H    ; 2 
J$0AAC:
	INC      C
	CALL     C.0A3E
D$0AAE   EQU      $-2
	JR       NC,J.0ABB
	LD       A,(IX+12)
	AND      01H      ; 1 
	JR       Z,J$0AAC
	SCF      
	RET      
;        -----------------
J.0ABB:
	DEC      C
	OR       A
	RET      
;****************************************************************************
;Media Functions Menu.

MEDIA_FUNCTIONS_MENU:
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$057
	CALL     C.1FD3
	LD       DE,1702H
	CALL     PRINT_PRESS
	CALL     PRINT_ESCAPE_TO_EXIT
	CALL     READ_KEYBOARD
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       SMARTKEY_1$
	CALL     Z,BACKUP_MENU
	CP       SMARTKEY_2$
	CALL     Z,KRUNCH_MENU
	CP       SMARTKEY_3$
	CALL     Z,COPY_BLOCK_MENU
	CP       SMARTKEY_4$
	CALL     Z,EDIT_BLOCK_MENU
	CP       SMARTKEY_5$
	CALL     Z,FORMAT_MENU
	CP       SMARTKEY_6$
	CALL     Z,INIT_MENU
	LD       A,(SOURCE_CURRENT_DEVICE)
	OR       A
	JR       NZ,MEDIA_FUNCTIONS_MENU
	CALL     CHANGE_SOURCE_DRIVE
	JR       MEDIA_FUNCTIONS_MENU
;****************************************************************************
;Backup Menu.

BACKUP_MENU:
	XOR      A
	LD       (D.3102),A
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$049
	CALL     C.1FD3
	CALL     C.1FB1
	LD       DE,1612H
	LD       HL,STRING$054
	CALL     PRINT_STRING_1
	CALL     PRINT_ESCAPE_TO_EXIT
J$0B20:
	LD       A,(D.297A)
	CP       03H      ; 3 
	JR       NZ,J.0B3B
	LD       A,(SOURCE_CURRENT_DEVICE)
	BIT      7,A
	JR       Z,J$0B33
	CALL     C.1708
	JR       J.0B3B
;        -----------------
J$0B33:
	LD       A,(DEST_CURRENT_DEVICE)
	BIT      7,A
	CALL     NZ,C.1708
J.0B3B:
	LD       DE,0709H
	CALL     PRINT_CURRENT_SOURCE_NAME
	LD       DE,0809H
	CALL     PRINT_SOURCE_DISK_TYPE
	LD       DE,0B09H
	CALL     PRINT_CURRENT_DEST_NAME
	LD       DE,0C09H
	CALL     PRINT_DEST_DISK_TYPE
	LD       DE,0E09H
	CALL     C$171E
	LD       DE,0F09H
	CALL     C$0C84
	CALL     READ_KEYBOARD
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       CR$ 
	JR       Z,J$0B8E
	CP       SMARTKEY_1$
	CALL     Z,CHANGE_SOURCE_DRIVE
	CP       SMARTKEY_2$
	CALL     Z,TOGGLE_SOURCE_DISK_TYPE
	CP       SMARTKEY_3$
	CALL     Z,CHANGE_DEST_DRIVE
	CP       SMARTKEY_4$
	CALL     Z,TOGGLE_DEST_DISK_TYPE
	CP       SMARTKEY_5$
	CALL     Z,C.1708
	CP       SMARTKEY_6$
	CALL     Z,C$0C7C
	JR       J$0B20
;        -----------------
J$0B8E:
	LD       A,(SOURCE_CURRENT_DEVICE)
	BIT      7,A
	JR       Z,J.0BB7
	LD       B,A
	LD       A,(DEST_CURRENT_DEVICE)
	CP       B
	JR       NZ,J.0BB7
	CALL     BEEPER
	CALL     C.1F6A
	CALL     INVERSE_VIDEO
	LD       DE,1300H
	LD       HL,STRING$101
	CALL     PRINT_STRING_1
	CALL     NORMAL_VIDEO
	CALL     C.20A5
	JP       BACKUP_MENU
;        -----------------
J.0BB7:
	CALL     PAUSE_CHECK_DRIVES     ;wait for keypress
	CALL     C.1F6A
	LD       A,(D.297A)
	CP       03H      ; 3 
	JR       Z,J$0BDF
	LD       A,(D.3102)
	OR       A
	CALL     NZ,C$0C17
	XOR      A
	LD       (D.298F),A
	DEC      A
	LD       (D.297B),A
	CALL     C.0964
	CALL     C$0312
	CALL     C$05F2
	JP       BACKUP_MENU
;        -----------------
J$0BDF:
	CALL     C.0964
	CALL     C.0A7E
	JR       NC,J$0BEF
	LD       C,(IX+13)
	LD       B,(IX+14)
	JR       J$0BF5
;        -----------------
J$0BEF:
	LD       DE,SOURCE_1
	CALL     GET_MEDIA_SIZE
J$0BF5:
	LD       L,C
	LD       H,B
	LD       (COPY_BLOCK_COUNT),HL
	LD       DE,DEST_1
	CALL     GET_MEDIA_SIZE
	SBC      HL,BC
	JR       C,J$0C08
	LD       (COPY_BLOCK_COUNT),BC
J$0C08:
	LD       HL,0000H
	LD       (SOURCE_START_BLOCK),HL
	LD       (DEST_START_BLOCK),HL
	CALL     C.222F
	JP       BACKUP_MENU
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0C17:
	CALL     C.1F6A
	LD       A,(SOURCE_CURRENT_DEVICE)
	PUSH     AF
	LD       B,A
	LD       A,(DEST_CURRENT_DEVICE)
	CP       B
	PUSH     AF
	JR       NZ,J$0C42
	CALL     INVERSE_VIDEO
	LD       HL,STRING$093
	LD       DE,1600H
	CALL     PRINT_STRING_1
	CALL     NORMAL_VIDEO
	CALL     READ_KEYBOARD
	CP       ESC$
	JP       Z,CENTRAL_LOOP
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
J$0C42:
	LD       A,(DEST_CURRENT_DEVICE)
	LD       (SOURCE_CURRENT_DEVICE),A
	CALL     C.0964
	LD       A,03H    ; 3 
	LD       C,A
	CALL     C.0A3E
	PUSH     IX
	POP      IY
	CALL     C$0573
	POP      AF
	JR       NZ,J$0C77
	CALL     INVERSE_VIDEO
	LD       HL,STRING$094
	LD       DE,1600H
	CALL     PRINT_STRING_1
	CALL     NORMAL_VIDEO
	CALL     READ_KEYBOARD
	CP       ESC$
	JP       Z,CENTRAL_LOOP
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
J$0C77:
	POP      AF
	LD       (SOURCE_CURRENT_DEVICE),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0C7C:
	LD       A,(D.3102)
	CPL      
	LD       (D.3102),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0C84:
	LD       A,(DEST_CURRENT_DEVICE)
	SUB      0F0H
	JR       NZ,J$0C8E
	LD       (D.3102),A
J$0C8E:
	LD       A,(D.297A)
	LD       HL,STRING$036
	CP       03H      ; 3 
	JP       Z,PRINT_STRING_1
	LD       HL,STRING$055
	LD       A,(D.3102)
	OR       A
	JP       Z,PRINT_STRING_1
	LD       HL,STRING$056
	JP       PRINT_STRING_1
;****************************************************************************
;EDIT BLOCKS Menu.

EDIT_BLOCK_MENU:
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$058
	CALL     C.1FD3
	CALL     C.1FB1
	LD       DE,1612H
	LD       HL,STRING$059
	CALL     PRINT_STRING_1
	CALL     PRINT_ESCAPE_TO_EXIT
E_B_GET_PARAMS:
	LD       DE,0609H
	CALL     PRINT_CURRENT_SOURCE_NAME
	LD       DE,0709H
	CALL     PRINT_SOURCE_DISK_TYPE
	LD       DE,081AH
	LD       BC,(SOURCE_START_BLOCK)
	CALL     C.1E4C
	CALL     READ_KEYBOARD
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       CR$                     
	JR       Z,DO_EDIT_BLOCK        ;get the block and edit it
	CP       SMARTKEY_1$
	CALL     Z,CHANGE_SOURCE_DRIVE
	CP       SMARTKEY_2$
	CALL     Z,TOGGLE_SOURCE_DISK_TYPE
	CP       SMARTKEY_3$
	LD       DE,081AH
	CALL     Z,C$267F               ;change block # if requested
	JR       E_B_GET_PARAMS
;        -----------------
DO_EDIT_BLOCK:
	CALL     C.1F6A                         ;wipe screen fields, INVERSE
	LD       HL,(SOURCE_START_BLOCK)        ;get block to read
	LD       DE,SOURCE_1                    ;point to drive parameters
	CALL     CHECK_BLOCK_RANGE              ;is the block in range?
	JP       NC,E_B_OUT_OF_RANGE            ;no, so error exit
	CALL     CLS_PRINT_COPYRIGHT            ;yes, so wipe screen etc.
	LD       DE,BUFF1
	LD       (D.2963),DE                    ;save read buffer address
	LD       BC,(SOURCE_START_BLOCK)        ;BC=start block
	LD       HL,0001H                       ;HL=1 block to read
	CALL     READ_BLOCK_COUNTED             ;read the block
	XOR      A                              ;A=0
	LD       (D.2992),A                     ;wipe a bunch of stuff
	LD       (D.2981),A
	LD       (D.2982),A
	LD       (D.2983),A
	LD       (D.2984),A
	LD       DE,1702H
	CALL     PRINT_PRESS                    ;"Press"
	CALL     PRINT_ESCAPE_TO_EXIT           ;"ESCAPE to exit"
	LD       DE,170FH
	LD       HL,STRING$063                  ;"when done"
	CALL     PRINT_STRING_1
	CALL     C.0E72
	CALL     C.1FF7
E_B_NEXT_BLOCK:
	CALL     C$0EE4
	CALL     C.0F1C
	CALL     READ_KEYBOARD
	CP       CTRL_C$                        ;abort without writing?
	JP       Z,CENTRAL_LOOP                 ;yes
	CP       ESC$                           ;done, wanna write it?
	JR       Z,E_B_ESC                      ;yes
	CP       CR$ 
	CALL     Z,C$0E38
	CP       UP_ARROW$
	CALL     Z,C$0DFD
	CP       DOWN_ARROW$
	CALL     Z,C.0E09
	CP       HOME_UP_ARROW$
	CALL     Z,C$0E48
	CP       HOME_DOWN_ARROW$
	CALL     Z,C$0E4E
	CP       LEFT_ARROW$
	CALL     Z,C$0E10
	CP       RIGHT_ARROW$
	CALL     Z,C.0E2A
	CP       HOME$
	CALL     Z,C$0E6A
	CP       CTRL_UP_ARROW$
	JR       Z,J$0DDC
	CP       CTRL_DOWN_ARROW$
	JR       Z,J$0DE7
	CP       TAB$
	CALL     Z,C.0DF1
	CP       PRINT$
	CALL     Z,PRINT_SECTOR_MENU
	CP       SPACE$
	JR       C,E_B_NEXT_BLOCK
	CP       CTRL_DELETE$
	JR       NC,E_B_NEXT_BLOCK
	CALL     C$0F4C
	JR       E_B_NEXT_BLOCK
;        -----------------
E_B_ESC:
	CALL     C.1FF8
	CALL     C.21DC
	JP       Z,EDIT_BLOCK_MENU
	LD       DE,BUFF1
	LD       BC,(SOURCE_START_BLOCK)
	LD       A,(SOURCE_CURRENT_DEVICE)
	CALL     WRITE_BLOCK_TONY
J$0DB4:
	JP       EDIT_BLOCK_MENU
;        -----------------
E_B_OUT_OF_RANGE:
	LD       A,08H    ; 8 
	CALL     C.191F
	CALL     C.1969
	CALL     INVERSE_VIDEO
	LD       HL,STRING$060          ;"Block out of range"
	LD       DE,1500H
	CALL     PRINT_STRING_1
	CALL     BEEPER
	CALL     NORMAL_VIDEO
	CALL     READ_KEYBOARD
	CALL     C.1966
	CALL     C.191C
	JR       J$0DB4
;        -----------------
J$0DDC:
	LD       HL,(SOURCE_START_BLOCK)
	LD       A,H
	OR       L
	JP       Z,DO_EDIT_BLOCK
	DEC      HL
	JR       J$0DEB
;        -----------------
J$0DE7:
	LD       HL,(SOURCE_START_BLOCK)
	INC      HL
J$0DEB:
	LD       (SOURCE_START_BLOCK),HL
	JP       DO_EDIT_BLOCK
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0DF1:
	XOR      A
	LD       (D.2982),A
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0DF5:
	LD       A,(D.2981)
	CPL      
	LD       (D.2981),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0DFD:
	LD       A,(D.2983)
	SUB      08H      ; 8 
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0E02:
	AND      7FH
	LD       (D.2983),A
	XOR      A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0E09:
	LD       A,(D.2983)
	ADD      A,08H    ; 8 
	JR       C.0E02
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0E10:
	LD       A,(D.2982)
	OR       A
	JR       NZ,C.0E1D
	LD       A,(D.2983)
	DEC      A
	CALL     C.0E02
;
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0E1D:
	LD       A,(D.2981)
	OR       A
	RET      NZ
	LD       A,(D.2982)
	CPL      
	LD       (D.2982),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0E2A:
	CALL     C.0E1D
	LD       A,(D.2982)
	OR       A
	RET      NZ
	LD       A,(D.2983)
	INC      A
	JR       C.0E02
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0E38:
	XOR      A
	LD       (D.2982),A
	LD       A,(D.2983)
	ADD      A,08H    ; 8 
	AND      78H      ; "x"
	LD       (D.2983),A
	XOR      A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0E48:
	LD       A,(D.2984)
	DEC      A
	JR       J$0E52
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0E4E:
	LD       A,(D.2984)
	INC      A
J$0E52:
	AND      07H      ; 7 
	LD       (D.2984),A
	LD       HL,BUFF1
	OR       A
	JR       Z,J$0E64
	LD       B,A
	LD       DE,0080H
J$0E61:
	ADD      HL,DE
	DJNZ     J$0E61
J$0E64:
	LD       (D.2963),HL
	CALL     C.0E72
;
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0E6A:
	XOR      A
	LD       (D.2982),A
	LD       (D.2983),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0E72:
	LD       HL,STRING$061                  ;"Block Sector" etc.
	LD       DE,0301H
	CALL     PRINT_STRING_1
	LD       DE,030AH
	LD       BC,(SOURCE_START_BLOCK)
	CALL     C.1E4C
	LD       A,(D.2984)
	LD       C,A
	LD       B,00H
	LD       DE,031AH
	CALL     C.1E54
	LD       HL,(D.2963)
	LD       DE,0602H
	LD       B,10H    ; 16 
J$0E99:
	CALL     C$0EA2
	INC      D
	LD       E,02H    ; 2 
	DJNZ     J$0E99
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0EA2:
	PUSH     BC
	LD       IX,0013H
	ADD      IX,DE
	LD       B,08H    ; 8 
J$0EAB:
	LD       A,(HL)
	LD       C,A
	CP       SPACE$
	JR       NC,J$0EB3
	LD       A,2EH    ; "."
J$0EB3:
	PUSH     DE
	PUSH     IX
	POP      DE
	INC      IX
	CALL     C.20CA
	POP      DE
	LD       A,C
	AND      0F0H
	RRCA     
	RRCA     
	RRCA     
	RRCA     
	ADD      A,30H    ; "0"
	CP       3AH      ; ":"
	JR       C,J$0ECC
	ADD      A,07H    ; 7 
J$0ECC:
	CALL     C.20CA
	INC      DE
	LD       A,C
	AND      0FH      ; 15 
	ADD      A,30H    ; "0"
	CP       3AH      ; ":"
	JR       C,J$0EDB
	ADD      A,07H    ; 7 
J$0EDB:
	CALL     C.20CA
	INC      DE
	INC      HL
	DJNZ     J$0EAB
	POP      BC
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0EE4:
	LD       DE,0406H
	LD       C,00H
	LD       A,(D.2984)
	LD       B,A
	SRL      B
	RR       C
	LD       A,(D.2983)
	ADD      A,C
	LD       C,A
	CALL     C.1E4C
	LD       A,3AH    ; ":"
	CALL     SCREEN_PRINT_A
	LD       A,B
	CALL     C.1F08
	LD       A,C
	CALL     C.1EFF
	LD       DE,0414H
	LD       B,00H
	LD       A,(D.2983)
	LD       C,A
	CALL     C.1E50
	LD       A,3AH    ; ":"
	CALL     SCREEN_PRINT_A
	LD       A,C
	CALL     C.1EFF
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.0F1C:
	LD       DE,0602H
	LD       A,(D.2983)
	PUSH     AF
	SRL      A
	SRL      A
	SRL      A
	ADD      A,D
	LD       D,A
	LD       A,(D.2981)
	OR       A
	JR       Z,J$0F3B
	POP      AF
	AND      07H      ; 7 
	ADD      A,13H    ; 19 
	ADD      A,E
	LD       E,A
	JP       C.1FA2
;        -----------------
J$0F3B:
	POP      AF
	AND      07H      ; 7 
	ADD      A,A
	ADD      A,E
	LD       E,A
	LD       A,(D.2982)
	OR       A
	JP       Z,C.1FA2
	INC      E
	JP       C.1FA2
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$0F4C:
	PUSH     AF
	LD       HL,(D.2963)
	LD       A,(D.2983)
	CALL     ADD_A_TO_HL
	LD       A,(D.2981)
	OR       A
	JR       Z,J$0F75
	CALL     C.21D4
	POP      AF
	PUSH     AF
	LD       (HL),A
	CALL     SCREEN_PRINT_A
	CALL     C.0DF1
	CALL     C.0F1C
	POP      AF
	CALL     C.1EFF
	CALL     C.0DF1
	JP       C.0E2A
;        -----------------
J$0F75:
	POP      AF
	CALL     C.1FEE
	SUB      30H      ; "0"
	RET      C
	CP       0AH      ; 10 
	JR       C,J$0F86
	SUB      07H      ; 7 
	RET      C
	CP       10H      ; 16 
	RET      NC
J$0F86:
	PUSH     AF
	CALL     C.21D4
	CALL     C.1F08
	POP      AF
	LD       C,A
	LD       B,(HL)
	LD       A,(D.2982)
	OR       A
	JR       Z,J$0F9A
	LD       A,0F0H
	JR       J$0FA6
;        -----------------
J$0F9A:
	LD       A,C
	SLA      A
	SLA      A
	SLA      A
	SLA      A
	LD       C,A
	LD       A,0FH    ; 15 
J$0FA6:
	AND      B
	OR       C
	LD       (HL),A
	CP       SPACE$
	JR       NC,J$0FAF
	LD       A,2EH    ; "."
J$0FAF:
	PUSH     AF
	CALL     C.0DF5
	CALL     C.0F1C
	POP      AF
	CALL     SCREEN_PRINT_A
	CALL     C.0DF5
	JP       C.0E2A
;        -----------------
J$0FC0:
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$062          ;"Directory Entry" etc.
	CALL     C.1FD3
	XOR      A
	LD       (D.2992),A
J.0FCD:
	CALL     C.1FB1
	LD       DE,160FH
	LD       HL,STRING$063          ;"When Done"
	CALL     PRINT_STRING_1
	CALL     PRINT_ESCAPE_TO_EXIT
	CALL     C.0A3E
	LD       DE,0411H
	PUSH     BC
	LD       B,00H
	CALL     C.1E50
	LD       DE,0610H
	CALL     C$10A6
	LD       DE,0816H
	CALL     C$10B7
	LD       DE,1016H
	LD       C,(IX+13)
	LD       B,(IX+14)
	CALL     C.1E49
	LD       DE,1116H
	LD       C,(IX+17)
	LD       B,(IX+18)
	CALL     C.1E49
	LD       DE,1216H
	LD       C,(IX+19)
	LD       B,(IX+20)
	CALL     C.1E49
	LD       DE,1316H
	LD       C,(IX+21)
	LD       B,(IX+22)
	CALL     C.1E49
	LD       A,(IX+23)
	LD       DE,1416H
	CALL     C.1EFA
	LD       A,(IX+24)
	LD       DE,1419H
	CALL     C.1EFA
	LD       A,(IX+25)
	LD       DE,141CH
	CALL     C.1EFA
	POP      BC
	CALL     READ_KEYBOARD
	PUSH     AF
	CALL     C.1F6A
	POP      AF
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       CR$ 
	JR       Z,J$109F
	LD       DE,J.0FCD
	PUSH     DE
	CP       HOME$
	JP       Z,J$1219
	CP       UP_ARROW$
	JP       Z,J$127C
	CP       DOWN_ARROW$
	JP       Z,J$1287
	CP       HOME_UP_ARROW$
	JP       Z,J$1283
	CP       HOME_DOWN_ARROW$
	JP       Z,J$1290
	POP      DE
	PUSH     BC
	LD       DE,J$109B
	PUSH     DE
	CP       SMARTKEY_1$
	JP       Z,J$117E
	CP       SMARTKEY_2$
	JP       Z,J$10F9
	CP       SMARTKEY_3$
	JP       Z,J$122A
	CP       SMARTKEY_4$
	JP       Z,J$123D
	CP       SMARTKEY_5$
	JP       Z,J$1256
	CP       SHIFT_SMARTKEY_5$
	JP       Z,J$1269
	CP       SMARTKEY_6$
	JP       Z,J$11D8
	POP      DE
J$109B:
	POP      BC
	JP       J.0FCD
;        -----------------
J$109F:
	CALL     C.21DC
	CALL     NZ,C.09EF
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$10A6:
	PUSH     DE
	CALL     C.1FA2
	LD       B,0CH    ; 12 
J$10AC:
	LD       A,SPACE$
	CALL     SCREEN_PRINT_A
	DJNZ     J$10AC
	POP      DE
	JP       C.2152
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$10B7:
	LD       A,(IX+12)
	BIT      7,A
	CALL     C.10E6
	INC      D
	BIT      6,A
	CALL     C.10E6
	INC      D
	BIT      5,A
	CALL     C.10E6
	INC      D
	BIT      4,A
	CALL     C.10E6
	INC      D
	BIT      3,A
	CALL     C.10E6
	INC      D
	BIT      2,A
	CALL     C.10E6
	INC      D
	BIT      1,A
	CALL     C.10E6
	INC      D
	BIT      0,A
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.10E6:
	PUSH     AF
	PUSH     AF
	PUSH     DE
	CALL     C.1FA2
	POP      DE
	POP      AF
	LD       A,59H    ; "Y"
	JR       NZ,J$10F4
	LD       A,4EH    ; "N"
J$10F4:
	CALL     SCREEN_PRINT_A
	POP      AF
	RET      
;        -----------------
J$10F9:
	CALL     C.21D4
	CALL     C.1FB1
	LD       DE,160FH
	LD       HL,STRING$063
	CALL     PRINT_STRING_1
	PUSH     BC
	LD       DE,0818H
	LD       A,(IX+12)
	LD       C,80H
	JR       J.111C
;        -----------------
J$1113:
	POP      DE
	LD       A,C
	CP       80H
	JR       Z,J.111C
	SLA      C
	DEC      D
J.111C:
	PUSH     DE
J$111D:
	LD       A,02H    ; 2 
	CALL     C.02AD
	CALL     C.1FF7
	CALL     C.1FA2
	CALL     READ_KEYBOARD
	PUSH     AF
	XOR      A
	CALL     C.02AD
	CALL     C.1FF8
	POP      AF
	CP       ESC$
	JR       Z,J.1175
	CP       CR$ 
	JR       Z,J.1175
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       UP_ARROW$
	JR       Z,J$1113
	CP       DOWN_ARROW$
	JR       Z,J$1168
	CALL     C.1FEE
	CP       59H      ; "Y"
	JR       NZ,J$1156
	LD       A,(IX+12)
	OR       C
	JR       J$115F
;        -----------------
J$1156:
	CP       4EH      ; "N"
	JR       NZ,J$111D
	LD       A,C
	CPL      
	AND      (IX+12)
J$115F:
	LD       (IX+12),A
	DEC      E
	DEC      E
	AND      C
	CALL     C.10E6
J$1168:
	POP      DE
	INC      D
	SRL      C
	LD       A,C
	OR       A
	JR       NZ,J.111C
	DEC      D
	LD       C,01H    ; 1 
	JR       J.111C
;        -----------------
J.1175:
	POP      DE
	LD       HL,STRING$039
	CALL     PRINT_STRING_1
	POP      BC
	RET      
;        -----------------
J$117E:
	CALL     C.21D4
	PUSH     IX
	POP      HL
	LD       DE,0610H
	LD       A,C
	CP       03H      ; 3 
	JR       C,J$1191
;
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$118C:
	LD       A,0AH    ; 10 
	LD       (D.11CD),A
J$1191:
	CALL     C$11BB
	CP       ESC$
	RET      Z
	LD       A,0BH    ; 11 
	LD       (D.11CD),A
	LD       A,C
	CP       CTRL_C$ 
	RET      C
	LD       A,SPACE$
	CALL     SCREEN_PRINT_A
	CALL     C.0A27
	INC      HL
	PUSH     HL
	CALL     C.1FF7
	CALL     READ_KYBD_WITH_ECHO
	POP      HL
	LD       (HL),A
	INC      HL
	LD       (HL),03H ; 3 
	JP       C.1FF8
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$11B8:
	LD       HL,DIRECTORY
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$11BB:
	PUSH     BC
	PUSH     DE
	PUSH     HL
	LD       HL,STRING$037
	CALL     PRINT_STRING_1
	POP      HL
	POP      DE
	CALL     C.1FA2
	CALL     C.1FF7
	LD       B,0BH    ; 11 
D.11CD   EQU      $-1
	CALL     C.2051
	PUSH     AF
	CALL     C.1FF8
	POP      AF
	POP      BC
	RET      
;        -----------------
J$11D8:
	CALL     C.21D4
	LD       DE,1416H
	CALL     C.1E8C
	LD       (IX+23),L
J$11E4:
	LD       DE,1419H
	CALL     C.1E8C
	LD       A,L
	CALL     C.1209
	CP       CR$ 
	JR       NC,J$11E4
	LD       A,L
	LD       (IX+24),A
J$11F6:
	LD       DE,141CH
	CALL     C.1E8C
	LD       A,L
	CALL     C.1209
	CP       SPACE$
	JR       NC,J$11F6
	LD       A,L
	LD       (IX+25),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1209:
	PUSH     BC
	LD       B,A
	AND      0F0H
	RRCA     
	LD       C,A
	RRCA     
	RRCA     
	ADD      A,C
	LD       C,A
	LD       A,B
	AND      0FH      ; 15 
	ADD      A,C
	POP      BC
	RET      
;        -----------------
J$1219:
	LD       DE,0411H
	CALL     C.269D
	CP       ESC$
	RET      Z
	LD       C,L
	LD       A,(D.2987)
	CP       C
	RET      NC
	LD       C,A
	RET      
;        -----------------
J$122A:
	CALL     C.21D4
	LD       DE,1016H
	CALL     C.269D
	CP       ESC$
	RET      Z
	LD       (IX+13),L
	LD       (IX+14),H
	RET      
;        -----------------
J$123D:
	CALL     C.21D4
	LD       DE,1116H
	CALL     C.269D
	CP       ESC$
	RET      Z
	LD       (IX+17),L
	LD       (IX+18),H
	LD       (IX+19),L
	LD       (IX+20),H
	RET      
;        -----------------
J$1256:
	CALL     C.21D4
	LD       DE,1216H
	CALL     C.269D
	CP       ESC$
	RET      Z
	LD       (IX+19),L
	LD       (IX+20),H
	RET      
;        -----------------
J$1269:
	CALL     C.21D4
	LD       DE,1316H
	CALL     C.269D
	CP       ESC$
	RET      Z
	LD       (IX+21),L
	LD       (IX+22),H
	RET      
;        -----------------
J$127C:
	LD       A,C
	OR       A
	JR       Z,J.1294
	DEC      C
	JR       J.1294
;        -----------------
J$1283:
	LD       C,00H
	JR       J.1294
;        -----------------
J$1287:
	INC      C
	LD       A,(D.2986)
	CP       C
	JR       NC,J.1294
	JR       J$1293
;        -----------------
J$1290:
	LD       A,(D.2987)
J$1293:
	LD       C,A
J.1294:
	XOR      A
	RET      
;****************************************************************************
;Temporary Format Menu.

FORMAT_MENU:
	CALL    CLS_PRINT_COPYRIGHT
	LD      DE,0300H
	LD      HL,FORMAT_DISABLED$
	CALL    PRINT_STRING_1
	CALL    PRINT_ESCAPE_TO_EXIT
F_TRY_AGAIN:
	CALL    READ_KEYBOARD
	CP      ESC$
	RET     Z
	CP      CTRL_C$
	JP      Z,CENTRAL_LOOP
	JR      F_TRY_AGAIN
;****************************************************************************
FORMAT_DISABLED$:
	DB      '   FORMAT / ADAMserve ONLY',CR$,LF$,LF$
	DB      '   Use the MS-DOS FORMAT',CR$,LF$
	DB      '   command with the options',CR$,LF$
	DB      '   below to format disks:',CR$,LF$,LF$
	DB      '     DISK SIZE    OPTIONS',CR$,LF$
	DB      '     160K 5-1/4  /U/1/4/8',CR$,LF$
	DB      '     320K 5-1/4  /U/4/8',CR$,LF$
	DB      '     720K 3-1/2  /U/F:720',CR$,LF$
	DB      '    1200K 5-1/4  /U/F:1200',CR$,LF$
	DB      '    1440K 3-1/2  /U/F:1440',CR$,LF$,LF$
	DB      '   NOTE: use only DSDD disks',CR$,LF$
	DB      '   for 160K and 320K sizes!!',CR$,LF$,LF$
	DB      "   Then use File Manager's",CR$,LF$
	DB      '   Initialize Media menu to',CR$,LF$
	DB      '   initialize the disk.',00H
;****************************************************************************
;Format Menu Disabled.

FORMAT_MENU_DISABLED:
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$069          ;FORMAT menu string
	CALL     C.1FD3
	CALL     C.1FB1
	LD       DE,1612H
	LD       HL,STRING$070          ;"Format"
	CALL     PRINT_STRING_1
	CALL     PRINT_ESCAPE_TO_EXIT   ;"Press ESCAPE to exit"
J.12AE:
	LD       A,(SOURCE_CURRENT_DEVICE)
	BIT      7,A
	JR       Z,J$12BA
	CALL     C.26B5
	JR       J.12AE
;        -----------------
J$12BA:
	LD       DE,0609H
	CALL     PRINT_CURRENT_SOURCE_NAME
	LD       DE,0709H
	CALL     PRINT_SOURCE_DISK_TYPE
	LD       DE,0809H
	CALL     PRINT_VERIFY_FLAG_STATUS
	CALL     READ_KEYBOARD
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       CR$ 
	JR       Z,J$12EC
	CP       SMARTKEY_1$
	CALL     Z,C.26B5
	CP       SMARTKEY_2$
	CALL     Z,TOGGLE_SOURCE_DISK_TYPE
	CP       SMARTKEY_3$
	CALL     Z,TOGGLE_VERIFY_FLAG
	JR       J.12AE
;        -----------------
J$12EC:
	CALL     C.1F6A
	LD       A,(SOURCE_DISK_TYPE)
	OR       A
	LD       A,01H    ; 1 
	JR       Z,J$12F9
	LD       A,02H    ; 2 
J$12F9:
	LD       (BUFF1),A
	CALL     PAUSE_CHECK_DRIVES     ;wait for keypress
	JP       Z,FORMAT_MENU          ;escape was pressed
	CALL     C.1F6A
	CALL     INVERSE_VIDEO
	LD       A,(SOURCE_CURRENT_DEVICE)
	CP       TAPE_1                 ;is it a disk?
	JR       C,FORMAT_DISK          ;yes, so format it
	LD       HL,0100H               ;no, it's a tape
					;so we'll just write 256 blocks of
					;0E5H onto the tape
	LD       (INIT_VOLSIZE),HL      ;save the count
	LD       HL,BUFF1               ;start address to fill
	LD       (HL),0E5H              ;0E5H=blank disk filler data value
	LD       D,H                    
	LD       E,L                    ;into DE
	INC      DE                     ;one more=destination address
	LD       BC,BLOCKSIZE           ;1 block's worth
	LDIR                            ;fill the block with 0E5H
	LD       DE,1300H
	LD       HL,STRING$068          ;"Formatting Tape"
	CALL     PRINT_STRING_1
	LD       BC,0000H               ;zero the block counter
TAPE_FORMAT_LOOP:
	LD       DE,131BH
	CALL     C.1E50
	PUSH     BC                             ;save count/block #
	LD       DE,BUFF1                       ;DTA
	LD       A,(SOURCE_CURRENT_DEVICE)      ;device #
	CALL     WRITE_BLOCK_TONY               ;write the 0E5H block
	POP      BC                             ;restore count
	INC      BC                             ;next count
	LD       A,(INIT_VOLSIZE)       ;are we done?
	CP       C                      ;let's see...
	JR       NZ,TAPE_FORMAT_LOOP    ;not yet
	LD       A,(INIT_VOLSIZE+1)     ;are we done?
	CP       B                      ;let's see...
	JR       NZ,TAPE_FORMAT_LOOP    ;not yet
	JR       FORMAT_COMMON          ;yes, we're done!
;        -----------------
FORMAT_DISK:
	LD       DE,1300H
	LD       HL,STRING$066          ;"Formatting Disk"
	CALL     PRINT_STRING_1
	CALL     DO_FORMAT_DISK         ;format the disk
FORMAT_COMMON:
	LD       A,(VERIFY_FORMAT_FLAG) ;get our verify flag
	OR       A                      ;do we verify?
	JP       Z,J$138E               ;no, so skip ahead
	LD       DE,SOURCE_1            ;point to our parameter block
	CALL     GET_MEDIA_SIZE         ;get the media size
	LD       (INIT_VOLSIZE),BC      ;save it for the directory
	LD       DE,1300H
	LD       HL,STRING$067          ;"Verifying Block"
	CALL     PRINT_STRING_1
	LD       BC,0000H               ;zero our counter again
J.1376:
	LD       DE,131BH
	CALL     C.1E50
	PUSH     BC
	CALL     VERIFY_DISK_BLOCK
	POP      BC
	INC      BC
	LD       A,(INIT_VOLSIZE)
	CP       C
	JR       NZ,J.1376
	LD       A,(INIT_VOLSIZE+1)
	CP       B
	JR       NZ,J.1376
J$138E:
	CALL     CALC_DIR_SIZE                  ;figure out the directory size
	LD       (DIR_ALLOC_LENGTH),A           ;save the allocated length
	LD       (DIR_USED_LENGTH),A            ;save the used length
	LD       DE,1300H
	CALL     INIT_AFTER_FORMAT
	CALL     BEEPER
	JP       FORMAT_MENU
;****************************************************************************
;Calculate Directory Size.
;  On exit, A=directory size in blocks, based on (SOURCE_CURRENT_DEVICE).

CALC_DIR_SIZE:
	LD       A,(SOURCE_CURRENT_DEVICE)      ;get current device
	CP       TAPE_1                         ;is it a tape?
	LD       A,1                            ;1-block directory for tape
	RET      NC                             ;yes
	LD       A,(SOURCE_DISK_TYPE)           ;no, a floppy disk, so get disk type
	CP       DOUBLE_SIDED                   ;is it single-sided?
	LD       A,1                            ;1-block directory for ss disk
	RET      C                              ;yes
	LD       A,3                            ;3-block directory for ds disk
	RET      Z                              ;no, it's double-sided
	LD       A,(SOURCE_DISK_TYPE)           ;try again, get disk type
	CP       HIGH_1200K
	LD       A,6                            ;6-block directory for qd disk
	RET      C                              ;yes
	LD       A,8                            ;8-block directory
						;for 1200K and 1440K disks
	RET
;****************************************************************************
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$13B8:
	PUSH     HL
	PUSH     BC
	CALL     ABORT_RETRY_IGNORE
	POP      BC
	POP      HL
	JR       Z,J$13C6
	POP      BC
	POP      HL
	PUSH     BC
	JR       J$13D5
;        -----------------
J$13C6:
	PUSH     AF
	PUSH     BC
	PUSH     HL
	LD       DE,1300H
	LD       HL,STRING$067          ;"Verifying block"
	CALL     PRINT_STRING_1
	POP      HL
	POP      BC
	POP      AF
J$13D5:
	DEC      A
	RET      
;****************************************************************************
;Toggle Verify Flag.
;  Alternates between 00H and 0FFH.

TOGGLE_VERIFY_FLAG:
	LD       A,(VERIFY_FORMAT_FLAG)         ;get the flag
	CPL                                     ;invert it
	LD       (VERIFY_FORMAT_FLAG),A         ;save it back
	RET      
;****************************************************************************
;Print Verify Flag Status.
;  Prints either "With Verification" or "With No Verification", depending
;upon whether the VERIFY_FORMAT_FLAG is 0FFH or 00H, respectively.

PRINT_VERIFY_FLAG_STATUS:
	LD       A,(VERIFY_FORMAT_FLAG)         ;get the flag
	OR       A                              ;are we verifying?
	LD       HL,STRING$064                  ;assume we are "With Verification"
	JP       NZ,PRINT_STRING_1              ;yes
	LD       HL,STRING$065                  ;sorry, "With No Verification"
	JP       PRINT_STRING_1
;****************************************************************************
;Do Format Disk.
;  Handles either 1 disk or 2 disks simultaneously, depending upon the value
;in (SOURCE_CURRENT_DEVICE) (0=do both disk 1 and disk 2 simultaneously).
;
;  Patched for ADAMserve FM017.ASM 9608.31
;  Removes DCB-banging.  The result is that the formatting of 2 disks
;"simultaneously" won't be simultaneous any more.

DO_FORMAT_DISK:
	LD       A,(SOURCE_CURRENT_DEVICE)      ;get what we're to format
	OR       A                              ;format both at once?
	JR       Z,FORMAT_DISKS_12_SIMULT       ;yes, so do both
F_COMMON:
	LD       BC,FACE$                       ;no, so get magic format code
	LD       DE,BUFF1                       ;DTA address
	JP       WRITE_BLOCK_TONY               ;do the format
						;RET is in WRITE_BLOCK_TONY
;****************************************************************************
FORMAT_DISKS_12_SIMULT:
	LD       A,DISK_1                       ;disk 1
	LD       BC,FACE$                       ;get magic format code
	LD       DE,BUFF1                       ;DTA address
	CALL     WRITE_BLOCK_TONY               ;do the format
	LD       A,DISK_2                       ;disk 2
	JR       F_COMMON                       ;and finish it out
;****************************************************************************
;Verify Disk Block.
;  On entry, BC=block to verify.  On exit, ZF=1 if the block was verified;
;otherwise, ZF=0.

VERIFY_DISK_BLOCK:
	LD       A,(SOURCE_CURRENT_DEVICE)      ;get current device #
	OR       A                              ;is it just one disk?
	JR       NZ,J$1444                      ;yes
	LD       A,DISK_1                       ;no, both, so start with disk 1
	PUSH     BC
	CALL     C$1433
	POP      BC
	LD       A,DISK_2                       ;and now do disk 2
						;fall into next routine
;****************************************************************************
C$1433:
	PUSH     AF
	PUSH     DE
	ADD      A,2DH                  ;45 decimal
					;this converts the device # (4 or 5)
					;into an ASCII digit ("1" or "2")
	LD       DE,1318H
	CALL     C.20CA
	LD       A,3EH                  ;">"
	CALL     SCREEN_PRINT_A         ;print it
	POP      DE
	POP      AF
J$1444:
	LD       DE,BUFF1               ;DTA
	CALL     READ_BLOCK_TONY        ;read the block in BC
	LD       HL,BUFF1               ;start of verify buffer
	LD       BC,BLOCKSIZE           ;# of bytes to check
J$1450:
	LD       A,0E5H                 ;format byte to look for
	CPI                             ;test the byte
	PUSH     DE
	CALL     NZ,C$13B8
	POP      DE
	OR       A
	JR       Z,VERIFY_DISK_BLOCK
	LD       A,B
	OR       C                      ;are we done yet?
	JR       NZ,J$1450              ;no, keep going
	RET                             ;all done!  ZF=1
;****************************************************************************
;Init After Format.
;  Does either 1 disk or 2 disks, depending on what's requested.

INIT_AFTER_FORMAT:
	LD       A,(SOURCE_CURRENT_DEVICE)      ;get device #
	OR       A                              ;is it a single device?
	JP       NZ,DO_INIT_MEDIA               ;yes, so init and exit
	LD       A,DISK_1                       ;no, both, so start with disk 1
	LD       (SOURCE_CURRENT_DEVICE),A      ;save it
	CALL     DO_INIT_MEDIA                  ;init it
	LD       A,DISK_2                       ;now get disk 2
	LD       (SOURCE_CURRENT_DEVICE),A      ;save it
	CALL     DO_INIT_MEDIA                  ;init it
	XOR      A                              ;A=0
	LD       (SOURCE_CURRENT_DEVICE),A      ;flag that we're doing both at once
	RET      
;****************************************************************************
;Init Menu.

INIT_MENU:
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$071
	CALL     C.1FD3
	CALL     C.1FB1
	LD       DE,1612H
	LD       HL,STRING$072
	CALL     PRINT_STRING_1
	CALL     PRINT_ESCAPE_TO_EXIT
J.1495:
	LD       A,(SOURCE_CURRENT_DEVICE)
	BIT      7,A
	JR       Z,J$14A1
	CALL     CHANGE_SOURCE_DRIVE
	JR       J.1495
;        -----------------
J$14A1:
	LD       DE,0611H
	CALL     C$214C
	LD       DE,0809H
	CALL     PRINT_CURRENT_SOURCE_NAME
	LD       DE,0909H
	CALL     PRINT_SOURCE_DISK_TYPE
	LD       DE,0718H
	CALL     PRINT_DIR_SIZE
	CALL     READ_KEYBOARD
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       CR$ 
	JR       Z,J$14E7
	CP       SMARTKEY_1$
	LD       DE,0611H
	CALL     Z,C$11B8
	CP       SMARTKEY_2$
	CALL     Z,TOGGLE_DIR_SIZE
	CP       SMARTKEY_3$
	CALL     Z,CHANGE_SOURCE_DRIVE
	CP       SMARTKEY_4$
	CALL     Z,TOGGLE_SOURCE_DISK_TYPE
	LD       DE,0200H
	CALL     C.1FA2
	JR       J.1495
;        -----------------
J$14E7:
	CALL     PAUSE_CHECK_DRIVES     ;wait for keypress
	JP       Z,INIT_MENU            ;escape was pressed
	CALL     C.1F6A
	LD       DE,1300H
	CALL     DO_INIT_MEDIA
	JP       INIT_MENU
;****************************************************************************
;Print Directory Size.
;  Takes the value from (DIR_ALLOC_LENGTH).

PRINT_DIR_SIZE:
	PUSH     BC
	LD       A,(DIR_ALLOC_LENGTH)
	LD       C,A
	LD       B,00H
	LD       DE,0718H
	CALL     C.1E54
	POP      BC
	RET      
;****************************************************************************
;Toggle Directory Size.
;  Increments value in (DIR_ALLOC_LENGTH).  Wraps around to 1 if greater
;than 8.

TOGGLE_DIR_SIZE:
	LD       A,(DIR_ALLOC_LENGTH)
	INC      A
;****************************************************************************
;Update Directory Parameters #1.
;  On entry, A=directory block count.  Wraps around to 1 if greater than 8.

SET_DIR_SIZE_TO_A:
	CP       9              ;8 is maximum # of directory blocks
	JR       C,J$1512
	LD       A,01H
J$1512:
	LD       (DIR_ALLOC_LENGTH),A
	LD       (DIR_USED_LENGTH),A
	SET      7,A
	LD       (D.3553),A
	RES      7,A
	RET      
;****************************************************************************
;Krunch Menu.

KRUNCH_MENU:
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$075
	CALL     C.1FD3
	CALL     C.1FB1
	LD       DE,1612H
	LD       HL,STRING$076
	CALL     PRINT_STRING_1
	CALL     PRINT_ESCAPE_TO_EXIT
J.1538:
	LD       A,(SOURCE_CURRENT_DEVICE)
	BIT      7,A
	JR       Z,J.1544
	CALL     CHANGE_SOURCE_DRIVE
	JR       J.1538
;        -----------------
J.1544:
	LD       A,(DEST_CURRENT_DEVICE)
	BIT      7,A
	JR       Z,J$1550
	CALL     CHANGE_DEST_DRIVE
	JR       J.1544
;        -----------------
J$1550:
	LD       DE,0709H
	CALL     PRINT_CURRENT_SOURCE_NAME
	LD       DE,0A09H
	CALL     PRINT_CURRENT_DEST_NAME
	LD       DE,0B09H
	CALL     PRINT_DEST_DISK_TYPE
	LD       DE,0D09H
	CALL     C$173C
	LD       DE,0F04H
	CALL     C.1764
	CALL     READ_KEYBOARD
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       CR$ 
	JR       Z,J$1598
	CP       SMARTKEY_1$
	CALL     Z,CHANGE_SOURCE_DRIVE
	CP       SMARTKEY_2$
	CALL     Z,CHANGE_DEST_DRIVE
	CP       SMARTKEY_3$
	CALL     Z,TOGGLE_DEST_DISK_TYPE
	CP       SMARTKEY_4$
	CALL     Z,C$1711
	CP       SMARTKEY_6$
	CALL     Z,C.174C
	JR       J.1538
;        -----------------
J$1598:
	CALL     PAUSE_CHECK_DRIVES     ;wait for keypress
	JR       Z,KRUNCH_MENU          ;escape was pressed
	CALL     C.1F6A
	CALL     C.1759
	XOR      A
	LD       (D.297D),A
	CALL     C.0964
	CALL     C.0A7E
	LD       L,(IX+13)
	LD       H,(IX+14)
	LD       DE,DEST_1
	CALL     CHECK_BLOCK_RANGE
	JP       NC,J$16E3
	LD       A,(D.2985)
	INC      A
	LD       (D.2967),A
	XOR      A
	LD       (D$2968),A
	LD       C,02H    ; 2 
	PUSH     BC
J.15CA:
	POP      BC
	INC      C
	CALL     C.0A3E
	JP       NC,J.1663
	LD       A,(IX+12)
	AND      01H      ; 1 
	JP       NZ,J.1663
	PUSH     BC
	LD       A,(D.297A)
	OR       A
	JR       Z,J.15EC
	CALL     C.0A27
	CP       60H      ; "`"
	JR       C,J.15EC
	LD       (IX+12),04H       ; 4 
J.15EC:
	LD       A,(IX+12)
	AND      04H      ; 4 
	JR       NZ,J.15CA
	LD       L,(IX+13)
	LD       H,(IX+14)
	LD       E,(IX+19)
	LD       D,(IX+20)
	LD       (IX+17),E
	LD       (IX+18),D
	PUSH     HL
	LD       BC,(D.2967)
	OR       A
	SBC      HL,BC
	LD       H,B
	LD       L,C
	ADD      HL,DE
	LD       (D.2967),HL
	POP      HL
	JR       Z,J.15CA
	PUSH     BC
	PUSH     DE
	PUSH     HL
	LD       A,(D.297D)
	OR       A
	JR       NZ,J.1648
	LD       (DEST_START_BLOCK),BC
	LD       A,(SOURCE_1)
	LD       H,A
	LD       A,(DEST_1)
	CP       H
	JR       NZ,J$1633
	LD       A,(D.297E)
	OR       A
	JR       Z,J.1648
J$1633:
	LD       A,0FFH
	LD       (D.297D),A
	LD       HL,0000H
	LD       (SOURCE_START_BLOCK),HL
	LD       (DEST_START_BLOCK),HL
	LD       (COPY_BLOCK_COUNT),BC
	CALL     C.21FB
J.1648:
	POP      HL
	LD       (SOURCE_START_BLOCK),HL
	POP      DE
	LD       (COPY_BLOCK_COUNT),DE
	POP      BC
	LD       (IX+13),C
	LD       (IX+14),B
	CALL     C.21FB
	LD       A,0FFH
	LD       (D.297D),A
	JP       J.15CA
;        -----------------
J.1663:
	LD       A,(D.297D)
	OR       A
	JR       NZ,J.1687
	LD       A,(D.297E)
	OR       A
	JR       Z,J.1687
	LD       HL,0000H
	LD       (SOURCE_START_BLOCK),HL
	LD       (DEST_START_BLOCK),HL
	CALL     C.0A7E
	LD       L,(IX+13)
	LD       H,(IX+14)
	LD       (COPY_BLOCK_COUNT),HL
	CALL     C.21FB
J.1687:
	CALL     C.2232
	LD       DE,DEST_1
	CALL     GET_MEDIA_SIZE
	LD       H,B
	LD       L,C
	LD       (D.3D62),HL
	LD       BC,(D.2967)
	LD       (IX+13),C
	LD       (IX+14),B
	OR       A
	SBC      HL,BC
	LD       (IX+17),L
	LD       (IX+18),H
	LD       C,03H    ; 3 
	LD       B,C
J$16AB:
	CALL     C.0A3E
	JR       NC,J.16D3
	LD       A,(IX+12)
	AND      04H      ; 4 
	JR       NZ,J$16D0
	PUSH     BC
	PUSH     IX
	POP      HL
	LD       C,B
	CALL     C.0A3E
	PUSH     IX
	POP      DE
	LD       BC,001AH               ;26=length of directory entry
	LDIR                            ;copy it
	POP      BC
	LD       A,(IX+12)
	AND      01H      ; 1 
	JR       NZ,J.16D3
	INC      B
J$16D0:
	INC      C
	JR       J$16AB
;        -----------------
J.16D3:
	LD       H,D
	LD       L,E
	INC      DE
	LD       (HL),00H
	LD       BC,2000H               ;8192=length of 8-block directory
	LDIR                            ;copy it
	CALL     C$0A0B
J$16E0:
	JP       KRUNCH_MENU
;        -----------------
J$16E3:
	LD       A,08H    ; 8 
	CALL     C.191F
	CALL     C.1969
	CALL     INVERSE_VIDEO
	LD       DE,1500H
	LD       HL,STRING$081
	CALL     PRINT_STRING_1
	CALL     BEEPER
	CALL     NORMAL_VIDEO
	CALL     READ_KEYBOARD
	CALL     C.1966
	CALL     C.191C
	JR       J$16E0
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1708:
	LD       A,(D.297A)
	CP       03H      ; 3 
	JR       Z,J$1714
	JR       J$1719
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1711:
	LD       A,(D.297A)
J$1714:
	OR       A
	LD       A,00H
	JR       NZ,J$171A
J$1719:
	INC      A
J$171A:
	LD       (D.297A),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$171E:
	LD       HL,STRING$050
	LD       A,(D.297A)
	OR       A
	JP       Z,PRINT_STRING_1
	LD       HL,STRING$051
	DEC      A
	JP       Z,PRINT_STRING_1
	LD       HL,STRING$052
	DEC      A
	JP       Z,PRINT_STRING_1
	LD       HL,STRING$053
	JP       PRINT_STRING_1
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$173C:
	LD       A,(D.297A)
	OR       A
	LD       HL,STRING$077
	JP       NZ,PRINT_STRING_1
	LD       HL,STRING$078
	JP       PRINT_STRING_1
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.174C:
	LD       A,(D.297E)
	OR       A
	RET      Z
	LD       A,(D.297B)
	CPL      
	LD       (D.297B),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1759:
	PUSH     HL
	LD       HL,D.297E
	LD       A,(D.297B)
	AND      (HL)
	LD       (HL),A
	POP      HL
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1764:
	LD       HL,STRING$034
	LD       A,(SOURCE_CURRENT_DEVICE)
	OR       A
	JP       M,PRINT_STRING_1
	LD       A,(D.297E)
	OR       A
	JP       Z,PRINT_STRING_1
	LD       A,(D.297B)
	OR       A
	LD       HL,STRING$079
	JP       Z,PRINT_STRING_1
	LD       HL,STRING$080
	JP       PRINT_STRING_1
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1785:
	PUSH     HL
	LD       HL,SOURCE_1
	LD       A,(DEST_1)
	CP       (HL)
	LD       A,00H
	JR       NZ,J$1792
	DEC      A
J$1792:
	LD       (D.297E),A
	POP      HL
	RET      
;****************************************************************************
;Setup Menu.

SETUP_MENU:
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$082
	CALL     C.1FD3
	CALL     C.1FB1
	LD       DE,1612H
	LD       HL,STRING$007
	CALL     PRINT_STRING_1
	CALL     PRINT_ESCAPE_TO_EXIT
SETUP_GET_PARAM_LOOP:
	CALL     C.1FF7
	LD       A,(D.294A)
	LD       DE,0719H
	CALL     C.18F4
	LD       A,(D.294B)
	LD       DE,0819H
	CALL     C.18F4
	LD       A,(D.294C)
	LD       DE,0919H
	CALL     C.18F4
	LD       A,(D.294D)
	LD       DE,0A19H
	CALL     C.18F4
	LD       A,(D.294E)
	LD       DE,0B19H
	CALL     C.18F4
	LD       A,(D.2A00)
	LD       DE,0C19H
	CALL     C.18F4
	LD       DE,0F09H
	CALL     PRINT_CURRENT_SOURCE_NAME
	LD       DE,1009H
	CALL     PRINT_SOURCE_DISK_TYPE
	LD       DE,1209H
	CALL     PRINT_CURRENT_DEST_NAME
	LD       DE,1309H
	CALL     PRINT_DEST_DISK_TYPE
	LD       DE,0C15H
	CALL     C.1FA2
	CALL     READ_KEYBOARD
	PUSH     AF
	CALL     C.1FF8
	POP      AF
	CP       ESC$
	JP       Z,CENTRAL_LOOP
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       CR$ 
	JR       Z,J.1851
	CP       SMARTKEY_1$
	CALL     Z,C$1913
	CP       SMARTKEY_2$
	CALL     Z,C$1925
	CP       SHIFT_SMARTKEY_2$
	CALL     Z,C$1930
	CP       SMARTKEY_3$
	CALL     Z,C$1952
	CP       SHIFT_SMARTKEY_3$
	CALL     Z,C$195D
	CP       SMARTKEY_4$
	CALL     Z,C$1901
	CP       SMARTKEY_5$
	CALL     Z,CHANGE_SOURCE_DRIVE
	CP       SHIFT_SMARTKEY_5$
	CALL     Z,TOGGLE_SOURCE_DISK_TYPE
	CP       SMARTKEY_6$
	CALL     Z,CHANGE_DEST_DRIVE
	CP       SHIFT_SMARTKEY_6$
	CALL     Z,TOGGLE_DEST_DISK_TYPE
	JP       SETUP_GET_PARAM_LOOP
;        -----------------
J.1851:
	LD       A,(SOURCE_CURRENT_DEVICE)
	LD       (D.298B),A
J$1857:
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$073          ;"SAVE CHANGES TO"
	CALL     C.1FD3
J$1860:
	LD       DE,0609H
	CALL     PRINT_CURRENT_SOURCE_NAME
	CALL     READ_KEYBOARD
	CP       ESC$
	JP       Z,CENTRAL_LOOP         ;abort
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP         ;abort
	CP       SMARTKEY_1$
	CALL     Z,CHANGE_SOURCE_DRIVE
	CP       CR$ 
	JR       NZ,J$1860
	LD       HL,FILEMAN_NAME$
	CALL     GET_FILEMAN_START_BLOCK        ;in DE; CF=1 if found
	LD       A,(SOURCE_CURRENT_DEVICE)
	LD       B,A
	LD       A,(D.298B)
	LD       (SOURCE_CURRENT_DEVICE),A
	LD       A,B
	JR       C,J$18A4               ;we found File Manager, so save config
	CALL     INVERSE_VIDEO
	LD       DE,1300H
	LD       HL,STRING$100          ;"File Manager not found"
	CALL     PRINT_STRING_1
	CALL     NORMAL_VIDEO
	CALL     C.20A5
	JP       J$1857
;        -----------------
J$18A4:
	LD       HL,BLOCK_SDA_START     ;start block of saved data area
	ADD      HL,DE                  ;offset to block #
	LD       B,H                    ;into BC for WRITE_BLOCK_TONY
	LD       C,L
	LD       DE,256+BLOCK_SDA_START*1024    ;start address to dump
	CALL     WRITE_BLOCK_TONY               ;save the data area
	JP       CENTRAL_LOOP
;****************************************************************************
;Find start block of FILEMAN.  If found, DE=block and CF=1, else CF=0.

GET_FILEMAN_START_BLOCK:
	CALL     C.0964
	LD       HL,BUFF0
	LD       DE,FILEMAN_NAME$
	LD       A,(D.2987)             ;# of directory entries in this block
	LD       B,A                    ;into B
J$18C0:
	PUSH     BC
	PUSH     DE
	PUSH     HL
	LD       B,0CH                  ;max length of file name in directory
J$18C5:
	LD       A,(DE)                 ;get a character
	CP       03H                    ;is it ETX? (end of name)
	JR       Z,J$18D1               ;yes
	CP       (HL)                   ;no, does it match our template?
	JR       NZ,J$18D4              ;no, so offset to next directory entry
	INC      HL                     ;yes, so point to next
	INC      DE
	DJNZ     J$18C5                 ;keep going until done
J$18D1:
	CP       (HL)                   ;does it match?
	JR       Z,J$18E0               ;yes, so keep going
J$18D4:
	POP      HL                     ;sorry, no match
	POP      DE
	POP      BC
J$18D7:
	LD       A,1AH                  ;length of directory entry
	CALL     ADD_A_TO_HL            ;offset to next entry
	DJNZ     J$18C0                 ;keep going until all entries are checked
	OR       A                      ;no match found, error exit CF=0
	RET      
;        -----------------
J$18E0:
	POP      HL
	POP      DE
	POP      BC
	PUSH     HL                     ;save base of directory entry
	POP      IX                     ;into IX
	BIT      2,(IX+12)              ;check file attribute
	JR       NZ,J$18D7              ;wrong attribute, no match
	LD       E,(IX+13)              ;right attribute, so get DE=start block
	LD       D,(IX+14)
	SCF                             ;CF=1 for found
	RET      
;****************************************************************************
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.18F4:
	ADD      A,A
	LD       L,A
	ADD      A,A
	ADD      A,L
	LD       HL,STRING$083
	CALL     ADD_A_TO_HL
	JP       PRINT_STRING_1
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1901:
	LD       A,(D.2A00)
	INC      A
	AND      0FH      ; 15 
	LD       (D.2A00),A
	LD       DE,0001H
	LD       HL,3883H
	JP       FILL_VRAM
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1913:
	LD       A,(D.294A)
	INC      A
	AND      0FH      ; 15 
	LD       (D.294A),A
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.191C:
	LD       A,(D.294A)
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.191F:
	LD       C,A
	LD       B,07H    ; 7 
	JP       WRITE_REGISTER
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1925:
	LD       A,(D.294B)
	INC      A
	AND      0FH      ; 15 
	LD       (D.294B),A
	JR       C.1939
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1930:
	LD       A,(D.294C)
	INC      A
	AND      0FH      ; 15 
	LD       (D.294C),A
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1939:
	LD       A,(D.294B)
	SLA      A
	SLA      A
	SLA      A
	SLA      A
	LD       D,A
	LD       A,(D.294C)
	OR       D
	LD       DE,0010H
	LD       HL,0340H
	JP       FILL_VRAM
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1952:
	LD       A,(D.294D)
	INC      A
	AND      0FH      ; 15 
	LD       (D.294D),A
	JR       C.1966
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$195D:
	LD       A,(D.294E)
	INC      A
	AND      0FH      ; 15 
	LD       (D.294E),A
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1966:
	LD       A,(D.294E)
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1969:
	LD       D,A
	LD       A,(D.294D)
	SLA      A
	SLA      A
	SLA      A
	SLA      A
	OR       D
	LD       DE,0010H
	LD       HL,0350H
	JP       FILL_VRAM
;        -----------------
J$197F:
	CALL     PRINT_FILE_MENU
	CP       ESC$
	RET      Z
	CALL     CLS_PRINT_COPYRIGHT
	LD       C,02H    ; 2 
J.198A:
	INC      C
	LD       A,(D.2987)
	CP       C
	RET      Z
	CALL     C.0A3E
	BIT      7,(IX+15)
	JR       Z,J.198A
	RES      7,(IX+15)
	PUSH     BC
	LD       HL,STRING$104
	CALL     C.1FC4
	INC      HL
	CALL     C.1FC4
	CALL     C.0A3E
	CALL     C.2146
	XOR      A
	LD       (D.2954),A
	CALL     C$1B53
	CALL     C$19C8
	POP      BC
	JR       J.198A
;        -----------------
J$19BB:
	PUSH     BC
	CALL     PRINT_FILE_MENU
	PUSH     AF
	CALL     CLS_PRINT_COPYRIGHT
	POP      AF
	POP      BC
	CP       ESC$
	RET      Z
;
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$19C8:
	XOR      A
	LD       (D.2959),A
	LD       (D.295B),A
	LD       (D.295C),A
	LD       A,05H    ; 5 
	LD       (D.2954),A
	LD       A,3DH    ; "="
	LD       (D.1AEE),A
	CALL     C.0A3E
	CALL     C.0A27
	CALL     C.1FEE
	CP       41H      ; "A"
	JR       Z,J$19F1
	CP       48H      ; "H"
	JP       NZ,J.1BD9
	LD       (D.2959),A
J$19F1:
	LD       L,(IX+13)
	LD       H,(IX+14)
	LD       E,(IX+19)
	LD       D,(IX+20)
	LD       C,(IX+21)
	LD       B,(IX+22)
	LD       (SOURCE_START_BLOCK),HL
	LD       (COPY_BLOCK_COUNT),DE
	LD       (D.294F),BC
J.1A0E:
	LD       HL,(COPY_BLOCK_COUNT)
	LD       A,H
	OR       L
	JP       Z,J$1B36
	LD       BC,(SOURCE_START_BLOCK)
	LD       DE,BUFF1
	PUSH     HL
	PUSH     DE
	PUSH     BC
	LD       HL,0001H
	CALL     READ_BLOCK_COUNTED
	POP      BC
	POP      HL
	POP      DE
	DEC      DE
	LD       (COPY_BLOCK_COUNT),DE
	INC      BC
	LD       (SOURCE_START_BLOCK),BC
	LD       A,D
	OR       E
	JR       NZ,J$1A3D
	LD       DE,(D.294F)
	JR       J$1A40
;        -----------------
J$1A3D:
	LD       DE,BLOCKSIZE
J$1A40:
	LD       A,(D.295C)
	OR       A
	JR       NZ,J.1A97
	LD       A,(D.2959)
	OR       A
	JP       Z,J$1A86
	LD       A,(BUFF1+2)
	CP       01H      ; 1 
	JP       NZ,J.1BD9
	LD       BC,(BUFF1)
	INC      BC
	INC      BC
	INC      BC
	ADD      HL,BC
	EX       DE,HL
	SBC      HL,BC
	EX       DE,HL
	LD       A,(BUFF1+3)
	SRL      A
	LD       (D.2954),A
	LD       A,(BUFF1+4)
	SRL      A
	LD       (D.1AEE),A
	LD       A,(BUFF1+5)
	LD       (D.2953),A
	LD       A,(BUFF1+6)
	INC      A
	LD       (D.2952),A
	LD       A,(BUFF1+7)
	DEC      A
	DEC      A
	LD       (D.2957),A
J$1A86:
	LD       A,0FFH
	LD       (D.295C),A
	CALL     C$1B9B
	LD       A,CR$    ; 13 
	CALL     C.20FF
	DEC      HL
	INC      DE
	JR       J.1AF1
;        -----------------
J.1A97:
	LD       A,D
	OR       E
	JP       Z,J.1A0E
	LD       A,(HL)
J$1A9D:
	LD       B,A
	LD       A,(USER_ESCAPE_CHAR)
	CP       B
	LD       A,B
	JR       NZ,J$1AA7
	LD       A,ESC$
J$1AA7:
	CP       SPACE$
	CALL     NC,C.20FF
	CP       FF$      ; 12 
	JR       Z,J.1AF1
	CP       ESC$
	CALL     Z,C.20FF
	CP       BACKSPACE$ 
	CALL     Z,C.20FF
	CP       CR$ 
	JR       NZ,J$1B1B
	CALL     C.20FF
	LD       A,LF$    ; 10 
	CALL     C.20FF
	LD       A,(D.2957)
	OR       A
	JR       Z,J$1AD1
	LD       A,LF$    ; 10 
	CALL     C.20FF
J$1AD1:
	LD       A,(D.2956)
	OR       A
	JR       Z,J.1B09
	LD       A,(D.295B)
	INC      A
	LD       C,A
	LD       A,(D.2957)
	OR       A
	JR       Z,J$1AE3
	INC      C
J$1AE3:
	LD       A,(CURRENT_PRINTER)
	OR       A
	LD       A,C
	LD       (D.295B),A
	JR       Z,J$1AF6
	CP       3DH      ; "="
D.1AEE   EQU      $-1
	JR       C,J.1B06
J.1AF1:
	CALL     C$1B4D
	JR       J.1B09
;        -----------------
J$1AF6:
	CP       17H
	JR       C,J.1B06
	CALL     READ_KEYBOARD
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       ESC$
	RET      Z
	XOR      A
J.1B06:
	LD       (D.295B),A
J.1B09:
	LD       A,(D.2953)
	OR       A
	JR       Z,J.1B1F
	PUSH     AF
	LD       B,A
J$1B11:
	LD       A,SPACE$
	CALL     C.20FF
	DJNZ     J$1B11
	POP      AF
	JR       J.1B1F
;        -----------------
J$1B1B:
	LD       A,(D.295A)
	INC      A
J.1B1F:
	LD       (D.295A),A
	LD       C,A
	LD       A,(D.2952)
	CP       C
	LD       A,CR$    ; 13 
	JP       Z,J$1A9D
	INC      HL
	DEC      DE
	LD       A,D
	OR       E
	JP       NZ,J.1A97
	JP       J.1A0E
;        -----------------
J$1B36:
	LD       A,(CURRENT_PRINTER)
	OR       A
	JP       Z,READ_KEYBOARD
	LD       HL,PICA_CODE$
	CALL     C.1BCA
	LD       HL,NLQOFF_CODE$
	CALL     C.1BCA
	XOR      A
	LD       (D.2954),A
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1B4D:
	LD       A,(D.295B)
	OR       A
	JR       Z,J.1B87
;
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1B53:
	LD       A,(D.2956)
	OR       A
	RET      Z
	CP       02H      ; 2 
	JR       NZ,J$1B6A
	CALL     READ_KEYBOARD
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       ESC$
	JR       NZ,J.1B87
	POP      AF
	RET      
;        -----------------
J$1B6A:
	LD       A,(CURRENT_PRINTER)
	CP       02H      ; 2 
	JR       Z,J$1B82
	LD       A,(D.295B)
	LD       B,A
	LD       A,42H    ; "B"
	SUB      B
	LD       B,A
J$1B79:
	LD       A,LF$    ; 10 
	CALL     C.20FF
	DJNZ     J$1B79
	JR       J.1B87
;        -----------------
J$1B82:
	LD       A,FF$    ; 12 
	CALL     C.20FF
J.1B87:
	LD       A,(D.2954)
	OR       A
	JR       Z,J$1B97
	LD       B,A
	PUSH     AF
J$1B8F:
	LD       A,LF$    ; 10 
	CALL     C.20FF
	DJNZ     J$1B8F
	POP      AF
J$1B97:
	LD       (D.295B),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1B9B:
	LD       A,(CURRENT_PRINTER)
	CP       02H      ; 2 
	RET      NZ
	PUSH     HL
	LD       A,(D.2952)
	CP       51H      ; "Q"
	LD       HL,PICA_CODE$
	JR       C,J.1BB6
	LD       HL,ELITE_CODE$
	CP       61H      ; "a"
	JR       C,J.1BB6
	LD       HL,CONDON_CODE$
J.1BB6:
	CALL     C.1BCA
	LD       A,(D.2958)
	OR       A
	LD       HL,NLQOFF_CODE$
	JR       Z,J$1BC5
	LD       HL,NLQON_CODE$
J$1BC5:
	CALL     C.1BCA
	POP      HL
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1BCA:
	LD       A,(HL)
	OR       A
	RET      Z
	CP       04H      ; 4 
	RET      NC
	LD       B,A
J$1BD1:
	INC      HL
	LD       A,(HL)
	CALL     PRINTER_PRINT_A
	DJNZ     J$1BD1
	RET      
;        -----------------
J.1BD9:
	CALL     INVERSE_VIDEO
	LD       A,(CURRENT_PRINTER)
	LD       B,A
	XOR      A
	LD       (CURRENT_PRINTER),A
	LD       HL,STRING$103
	LD       DE,0500H
	CALL     PRINT_STRING_1
	LD       DE,0511H
	CALL     C.2152
	CALL     READ_KEYBOARD
	LD       A,B
	LD       (CURRENT_PRINTER),A
	JP       NORMAL_VIDEO
;****************************************************************************
;Print File Menu.

PRINT_FILE_MENU:
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$102
	LD       DE,0401H
	CALL     PRINT_STRING_1
	CALL     C.1FB1
	LD       DE,1612H
	LD       HL,STRING$105
	CALL     PRINT_STRING_1
	CALL     PRINT_ESCAPE_TO_EXIT
P_F_GET_PARAM_LOOP:
	LD       DE,0609H
	CALL     PRINT_PRINTER_NAME
	LD       DE,0809H
	CALL     C$1C82
	LD       DE,0A15H
	CALL     C$1D2D
	LD       DE,0C15H
	CALL     C$1D46
	LD       DE,0E09H
	CALL     C$1C9F
	LD       DE,1009H
	CALL     C$1CE2
	LD       DE,121BH
	CALL     C$1D05
	CALL     READ_KEYBOARD
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       CR$ 
	RET      Z
	CP       SMARTKEY_1$
	CALL     Z,TOGGLE_PRINTER
	CP       SMARTKEY_2$
	CALL     Z,C$1C75
	CP       SMARTKEY_3$
	CALL     Z,C$1D0B
	CP       SMARTKEY_4$
	CALL     Z,C$1D39
	CP       SMARTKEY_5$
	CALL     Z,C$1C92
	CP       SMARTKEY_6$
	CALL     Z,C$1CDA
	CP       SHIFT_SMARTKEY_6$
	CALL     Z,C$1CF2
	JR       P_F_GET_PARAM_LOOP
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1C75:
	LD       A,(D.2957)
	OR       A
	JR       Z,J$1C7D
	LD       A,0FFH
J$1C7D:
	INC      A
	LD       (D.2957),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1C82:
	LD       A,(D.2957)
	LD       HL,STRING$112
	OR       A
	JP       Z,PRINT_STRING_1
	LD       HL,STRING$113
	JP       PRINT_STRING_1
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1C92:
	LD       A,(D.2956)
	INC      A
	CP       03H      ; 3 
	JR       C,J$1C9B
	XOR      A
J$1C9B:
	LD       (D.2956),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1C9F:
	LD       A,(D.2956)
	LD       HL,STRING$111
	OR       A
	JP       Z,PRINT_STRING_1
	DEC      A
	LD       HL,STRING$109
	JP       Z,PRINT_STRING_1
	LD       HL,STRING$110
	JP       PRINT_STRING_1
;****************************************************************************
;Toggle Printer.
;  Wraps around to zero when the end is reached.

TOGGLE_PRINTER:
	LD       A,(CURRENT_PRINTER)    ;get our printer
	INC      A                      ;toggle next
	CP       4                      ;too far?
					;changed FM020.ASM 9609.01 
					;to allow Dev14 printer
	JR       C,T_P_COMMON           ;no
	XOR      A                      ;yes, so wrap back to zero
T_P_COMMON:
	LD       (CURRENT_PRINTER),A    ;save new printer
	RET      
;****************************************************************************
;Print Current Printer Name.
;  Updated for Dev14 Printer  FM020.ASM  9609.01

PRINT_PRINTER_NAME:
	LD       A,(CURRENT_PRINTER)    ;get our printer
	OR       A                      ;is it screen?
	LD       HL,STRING$106          ;guess it is
	JR       Z,P_P_N_COMMON         ;yes
	DEC      A                      ;no, is it ADAM printer?
	LD       HL,STRING$107          ;guess it is
	JR       Z,P_P_N_COMMON         ;yes
	DEC      A                      ;no, is it Dev13 printer?
	LD       HL,STRING$108          ;guess it is
	JR       Z,P_P_N_COMMON         ;yes
	LD       HL,STRING$108A         ;no, must be Dev14 printer
P_P_N_COMMON:
	JP       PRINT_STRING_1
;****************************************************************************
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1CDA:
	LD       A,(D.2958)
	CPL      
	LD       (D.2958),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1CE2:
	LD       A,(D.2958)
	OR       A
	LD       HL,STRING$115
	JP       Z,PRINT_STRING_1
	LD       HL,STRING$114
	JP       PRINT_STRING_1
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1CF2:
	LD       DE,121BH
	CALL     C.1FA2
	CALL     C.1FF7
	CALL     READ_KEYBOARD
	LD       (USER_ESCAPE_CHAR),A
	CALL     C.1FF8
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1D05:
	LD       A,(USER_ESCAPE_CHAR)
	JP       C.20CA
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1D0B:
	LD       A,(D.2952)
	CP       1EH
	JR       NZ,J$1D16
	LD       A,50H    ; "P"
	JR       J.1D28
;        -----------------
J$1D16:
	CP       50H      ; "P"
	JR       NZ,J$1D1E
	LD       A,60H    ; "`"
	JR       J.1D28
;        -----------------
J$1D1E:
	CP       60H      ; "`"
	JR       NZ,J$1D26
	LD       A,84H
	JR       J.1D28
;        -----------------
J$1D26:
	LD       A,1EH
J.1D28:
	LD       (D.2952),A
	XOR      A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1D2D:
	PUSH     BC
	LD       A,(D.2952)
	LD       C,A
	LD       B,00H
	CALL     C.1E50
	POP      BC
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1D39:
	LD       A,(D.2953)
	INC      A
	CP       09H      ; 9 
	JR       C,J$1D42
	XOR      A
J$1D42:
	LD       (D.2953),A
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1D46:
	PUSH     BC
	LD       BC,(D.2953)
	LD       B,00H
	CALL     C.1E54
	POP      BC
	RET      
;****************************************************************************
;Print Sector Menu.

PRINT_SECTOR_MENU:
	CALL     C.1FF8
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$013
	LD       DE,0401H
	CALL     PRINT_STRING_1
	CALL     C.1FB1
	LD       DE,1612H
	LD       HL,STRING$105
	CALL     PRINT_STRING_1
	CALL     PRINT_ESCAPE_TO_EXIT
P_S_GET_PARAM_LOOP:
	LD       DE,0609H
	CALL     PRINT_PRINTER_NAME
	CALL     READ_KEYBOARD
	CP       ESC$
	JP       Z,DO_EDIT_BLOCK
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CP       CR$ 
	JR       Z,J$1D8E
	CP       SMARTKEY_1$
	CALL     Z,TOGGLE_PRINTER
	JR       P_S_GET_PARAM_LOOP
;        -----------------
J$1D8E:
	LD       HL,STRING$014
	CALL     C.1FC4
	LD       BC,(SOURCE_START_BLOCK)
	CALL     C.1E3E
	LD       HL,STRING$015
	CALL     C.1FC4
	LD       A,(D.2984)
	LD       C,A
	LD       B,00H
	CALL     C.1E3E
	LD       HL,STRING$027
	CALL     C.1FC4
	LD       HL,(D.2963)
	LD       B,08H    ; 8 
J$1DB5:
	CALL     C$1DBD
	DJNZ     J$1DB5
	JP       DO_EDIT_BLOCK
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1DBD:
	PUSH     BC
	PUSH     HL
	CALL     C.20FD
	LD       A,08H    ; 8 
	SUB      B
	SLA      A
	SLA      A
	SLA      A
	SLA      A
	CALL     C.1E09
	CALL     C.20FD
	CALL     C.20FD
	LD       B,10H    ; 16 
J$1DD8:
	LD       A,(HL)
	CALL     C.1E09
	CALL     C.20FD
	INC      HL
	DJNZ     J$1DD8
	CALL     C.20FD
	CALL     C.20FD
	CALL     C.20FD
	POP      HL
	LD       B,10H    ; 16 
J$1DEE:
	LD       A,(HL)
	CP       SPACE$
	JR       C,J$1DF7
	CP       CTRL_DELETE$
	JR       C,J$1DF9
J$1DF7:
	LD       A,2EH    ; "."
J$1DF9:
	CALL     C.20FF
	INC      HL
	DJNZ     J$1DEE
	PUSH     HL
	LD       HL,STRING$028
	CALL     C.1FC4
	POP      HL
	POP      BC
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1E09:
	PUSH     AF
	AND      0F0H
	RRCA     
	RRCA     
	RRCA     
	RRCA     
	CALL     C$1E16
	POP      AF
	AND      0FH      ; 15 
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1E16:
	ADD      A,30H    ; "0"
	CP       3AH      ; ":"
	JR       C,J$1E1E
	ADD      A,07H    ; 7 
J$1E1E:
	JP       C.20FF
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1E21:
	LD       B,0FFH
	OR       A
J$1E24:
	SBC      HL,DE
	INC      B
	JR       NC,J$1E24
	ADD      HL,DE
	LD       A,B
	OR       A
	JR       Z,J$1E2F
	LD       C,A
J$1E2F:
	LD       A,C
	OR       A
	JR       NZ,C.1E38
	LD       A,SPACE$
	JP       SCREEN_PRINT_A
D$1E36   EQU      $-2
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1E38:
	LD       A,30H    ; "0"
	ADD      A,B
	JP       SCREEN_PRINT_A
D$1E3C   EQU      $-2
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1E3E:
	XOR      A
	LD       (D.1E6C),A
	PUSH     BC
	PUSH     HL
	LD       HL,C.20FF
	JR       J$1E61
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1E49:
	XOR      A
	JR       J.1E56
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1E4C:
	LD       A,06H    ; 6 
	JR       J.1E56
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1E50:
	LD       A,0CH    ; 12 
	JR       J.1E56
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1E54:
	LD       A,12H    ; 18 
J.1E56:
	LD       (D.1E6C),A
	CALL     C.1FA2
	PUSH     BC
	PUSH     HL
	LD       HL,SCREEN_PRINT_A
J$1E61:
	LD       (D$1E36),HL
	LD       (D$1E3C),HL
	LD       H,B
	LD       L,C
	LD       C,00H
	JR       J$1E6D
D.1E6C   EQU      $-1
;        -----------------
J$1E6D:
	LD       DE,2710H       ;10000
	CALL     C.1E21
	LD       DE,03E8H       ;1000
	CALL     C.1E21
	LD       DE,0064H       ;100
	CALL     C.1E21
	LD       DE,000AH       ;10
	CALL     C.1E21
	LD       B,L
	CALL     C.1E38
	POP      HL
	POP      BC
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1E8C:
	CALL     C.1FA2
	LD       A,SPACE$
	CALL     SCREEN_PRINT_A
	CALL     SCREEN_PRINT_A
	CALL     C.1FF7
	LD       B,02H    ; 2 
	CALL     C$1EA2
	JP       C.1FF8
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1EA2:
	CALL     C.1FA2
	LD       HL,BUFF1
	PUSH     HL
	CALL     C.2051
	POP      HL
	CP       ESC$
	RET      Z
	EX       DE,HL
	LD       HL,0000H
J.1EB4:
	LD       A,(DE)
	CP       03H      ; 3 
	RET      Z
	INC      DE
	CP       SPACE$
	JR       Z,J.1EB4
	SUB      30H      ; "0"
	RET      C
	CP       0AH      ; 10 
	RET      NC
	ADD      HL,HL
	ADD      HL,HL
	ADD      HL,HL
	ADD      HL,HL
	CALL     ADD_A_TO_HL
	JR       J.1EB4
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1ECC:
	LD       B,05H    ; 5 
	CALL     C.1FA2
	LD       HL,BUFF1
	PUSH     HL
	CALL     C.2051
	POP      HL
	CP       ESC$
	RET      Z
	EX       DE,HL
	LD       HL,0000H
J.1EE0:
	LD       A,(DE)
	CP       03H      ; 3 
	RET      Z
	INC      DE
	CP       SPACE$
	JR       Z,J.1EE0
	SUB      30H      ; "0"
	RET      C
	CP       0AH      ; 10 
	RET      NC
	LD       B,H
	LD       C,L
	ADD      HL,HL
	ADD      HL,HL
	ADD      HL,BC
	ADD      HL,HL
	CALL     ADD_A_TO_HL
	JR       J.1EE0
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1EFA:
	PUSH     AF
	CALL     C.1FA2
	POP      AF
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1EFF:
	PUSH     AF
	RRA      
	RRA      
	RRA      
	RRA      
	CALL     C.1F08
	POP      AF
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1F08:
	AND      0FH      ; 15 
	ADD      A,90H
	DAA      
	ADC      A,40H    ; "@"
	DAA      
	JP       SCREEN_PRINT_A
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1F13:
	LD       A,(D.297E)
	OR       A
	RET      Z
	LD       A,(D.297F)
	OR       A
	RET      NZ
	CALL     INVERSE_VIDEO
	LD       HL,STRING$093
	LD       DE,1600H
	CALL     PRINT_STRING_1
	CALL     NORMAL_VIDEO
	CALL     READ_KEYBOARD
	CP       ESC$
	JP       Z,CENTRAL_LOOP
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	LD       A,0FFH
	LD       (D.297F),A
	JR       C.1F6A
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$1F40:
	LD       A,(D.297E)
	OR       A
	RET      Z
	LD       A,(D.297F)
	OR       A
	RET      Z
	CALL     INVERSE_VIDEO
	LD       HL,STRING$094
	LD       DE,1600H
	CALL     PRINT_STRING_1
	CALL     NORMAL_VIDEO
	CALL     READ_KEYBOARD
	CP       ESC$
	JP       Z,CENTRAL_LOOP
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	XOR      A
	LD       (D.297F),A
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1F6A:
	PUSH     AF
	LD       A,(VIDEO_STATE)
	OR       A
	PUSH     AF
	CALL     NORMAL_VIDEO
	LD       DE,1500H
	LD       HL,STRING$033          ;some blanks and CR/LFs
	CALL     PRINT_STRING_1
	POP      AF
	CALL     NZ,INVERSE_VIDEO
	POP      AF
	RET      
;****************************************************************************
;Clear Screen and Print Copyright String.

CLS_PRINT_COPYRIGHT:
	CALL     CLEAR_SCREEN
	CALL     INVERSE_VIDEO
	LD       HL,STRING$001          ;"File Manager 4.0"
	CALL     C.1FD3
	CALL     NORMAL_VIDEO
	LD       HL,STRING$002          ;"(c) AJM Software"
	JR       C.1FD3
;****************************************************************************
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1FA2:
	PUSH     DE
	LD       A,D
	LD       D,E
	LD       E,A
	INC      D
	LD       A,1CH
	CALL     SCREEN_PRINT_A
	CALL     C.2003
	POP      DE
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1FB1:
	LD       DE,1602H
	CALL     PRINT_PRESS
	LD       DE,1608H
	LD       HL,STRING$030
	JR       PRINT_STRING_1
;****************************************************************************
PRINT_PRESS:
	LD       HL,STRING$029          ;"Press"
	JR       PRINT_STRING_1
;****************************************************************************
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1FC4:
	PUSH     HL
	LD       HL,C.20FF
	JR       J$1FD7
;****************************************************************************
PRINT_ESCAPE_TO_EXIT:
	LD       HL,STRING$031          ;"ESCAPE to exit"
	LD       DE,1708H
;****************************************************************************
PRINT_STRING_1:
	CALL     C.1FA2
;****************************************************************************
C.1FD3:
	PUSH     HL
	LD       HL,SCREEN_PRINT_A
J$1FD7:
	LD       (D$1FE0),HL
	POP      HL
J$1FDB:
	LD       A,(HL)
	CP       00H
	RET      Z
	CALL     SCREEN_PRINT_A
D$1FE0   EQU      $-2
	INC      HL
	JR       J$1FDB
;****************************************************************************
NORMAL_VIDEO:
	XOR      A
	JR       J$1FEA
;****************************************************************************
INVERSE_VIDEO:
	LD       A,80H
J$1FEA:
	LD       (VIDEO_STATE),A
	RET      
;****************************************************************************
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1FEE:
	CP       61H      ; "a"
	RET      C
	CP       7BH      ; "{"
	RET      NC
	AND      5FH      ; "_"
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.1FF7:
	LD       A,0AFH
C.1FF8   EQU      $-1
	LD       (D.2993),A
	OR       A
	JR       NZ,C.2003
	LD       A,0D0H
	JR       J$200E
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.2003:
	LD       A,(D.2993)
	OR       A
	RET      Z
	LD       A,(CURSOR_Y)
	ADD      A,A
	ADD      A,A
	ADD      A,A
J$200E:
	PUSH     BC
	PUSH     DE
	PUSH     HL
	LD       DE,0001H
	LD       HL,3880H
	CALL     FILL_VRAM
	LD       A,(CURSOR_X)
	ADD      A,A
	ADD      A,A
	ADD      A,A
	LD       DE,0001H
	LD       HL,3881H
	CALL     FILL_VRAM
	POP      HL
	POP      DE
	POP      BC
	RET      
;****************************************************************************
CLEAR_SCREEN:
	LD       A,FF$    ; 12 
	JP       SCREEN_PRINT_A
;****************************************************************************
BEEPER:
	LD       A,(SOUNDPORT)
	LD       C,A
	LD       A,8FH                  ;Mini Wini port
	OUT      (C),A
	LD       A,11H    ; 17 
	OUT      (C),A
	LD       A,90H                  ;Mini Wini port
	OUT      (C),A
	LD       HL,0F00H
J$2045:
	EX       (SP),HL
	EX       (SP),HL
	DEC      HL
	LD       A,L
	OR       H
	JR       NZ,J$2045
	LD       A,9FH                  ;Mini Wini port
	OUT      (C),A
	RET      
;****************************************************************************
C.2051:
	LD       C,00H
J.2053:
	CALL     READ_KEYBOARD
	CP       CR$ 
	JR       Z,J$2082
	CP       BACKSPACE$ 
	JR       Z,J.208D
	CP       LEFT_ARROW$
	JR       Z,J.208D
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CALL     SCREEN_PRINT_A
	LD       (HL),A
	INC      C
	INC      HL
	DJNZ     J.2053
	CP       BACKSPACE$ 
	JR       Z,J.208D
	CP       LEFT_ARROW$
	JR       Z,J.208D
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
J$2082:
	LD       (HL),03H ; 3 
	LD       A,B
	OR       A
	RET      Z
J$2087:
	INC      HL
	LD       (HL),20H ; " "
	DJNZ     J$2087
	RET      
;        -----------------
J.208D:
	LD       A,C
	OR       A
	JR       Z,J.2053
	LD       A,08H    ; 8 
	CALL     SCREEN_PRINT_A
	LD       A,SPACE$
	CALL     SCREEN_PRINT_A
	LD       A,08H    ; 8 
	CALL     SCREEN_PRINT_A
	DEC      HL
	DEC      C
	INC      B
	JR       J.2053
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.20A5:
	LD       DE,1500H
	LD       HL,STRING$004
	CALL     PRINT_STRING_1
;****************************************************************************
READ_KEYBOARD:
	PUSH     BC
	PUSH     DE
	PUSH     HL
J$20B1:
	CALL     _END_RD_KBD
	JR       NC,J$20B1
	PUSH     AF
	CALL     _START_RD_KBD
	POP      AF
	POP      HL
	POP      DE
	POP      BC
	RET      
;****************************************************************************
READ_KYBD_WITH_ECHO:
	CALL     READ_KEYBOARD
	CP       CTRL_DELETE$
	RET      NC
	CP       SPACE$
	RET      C
	JR       SCREEN_PRINT_A
;****************************************************************************
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.20CA:
	PUSH     AF
	CALL     C.1FA2
	POP      AF
;****************************************************************************
SCREEN_PRINT_A:
	PUSH     AF
	PUSH     BC
	PUSH     DE
	PUSH     HL
	CP       SPACE$
	JR       NC,J$20DC
	CALL     _CONS_OUT
	JR       J$20E1
;        -----------------
J$20DC:
	OR       00H
VIDEO_STATE   EQU      $-1
	CALL     _CONS_DISP
J$20E1:
	CALL     C.2003
	CALL     _END_RD_KBD
	JR       NC,J.20F8
	CALL     READ_KEYBOARD
	CP       CTRL_S$
	JR       NZ,J.20F8
	CALL     READ_KEYBOARD
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
J.20F8:
	POP      HL
	POP      DE
	POP      BC
	POP      AF
	RET      
;****************************************************************************
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.20FD:
	LD       A,SPACE$
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.20FF:
	CALL     SCREEN_PRINT_A
	PUSH     BC
	PUSH     AF
	LD       A,(CURRENT_PRINTER)
	OR       A
	POP      BC
	LD       A,B
	POP      BC
	RET      Z
;****************************************************************************
;Printer Print Character in A.
;  Wipes bit 7 of character before it's printed.

PRINTER_PRINT_A:
	PUSH     AF
	PUSH     BC
	PUSH     DE
	PUSH     HL
	AND      7FH                    ;wipe bit 7
	LD       C,A                    ;save character in C
	LD       A,(CURRENT_PRINTER)    ;get our printer
	CP       2                      ;is it Dev13 printer?
	JR       Z,DO_DEV1314_PRINTER   ;yes
	CP       3                      ;is it Dev14 printer?
	JR       Z,DO_DEV1314_PRINTER   ;yes
	LD       A,(USER_ESCAPE_CHAR)   ;get our escape character
	CP       C                      ;does it match?
	JR       NZ,J$2122              ;no
	LD       C,ESC$                 ;yes, so remap it to ESCAPE
J$2122:
	LD       A,C                    ;get our character
	CALL     _PR_CH                 ;print it to ADAM printer
	JR       P_P_A_EXIT             ;and exit
;        -----------------
DO_DEV1314_PRINTER:
	CALL     DEV1314_PRINT_C
P_P_A_EXIT:
	POP      HL
	POP      DE
	POP      BC
	POP      AF
	RET      
;****************************************************************************
;Parallel Print Character (in C).
;  On entry, C=character to print, and A=printer name code (2=Dev13 printer,
;(3=Dev14 printer).

DEV1314_PRINT_C:
	CP       2                      ;is it Dev13?
	LD      A,ADAMNET_PARALLEL      ;assume it is
	JR      Z,EL_PRINTO             ;yes
	LD      A,ADAMNET_SERIAL        ;no, it's Dev14
EL_PRINTO:
	PUSH    HL
	PUSH    BC
	LD      HL,DEV1314_BUFFER       ;point to buffer
	LD      (HL),C                  ;save the character
	LD      BC,1                    ;length of buffer
	CALL    _WR_CH_DEV              ;write the character
	POP     BC
	POP     HL
	RET      
;****************************************************************************
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.2146:
	PUSH     HL
	LD       HL,C.20FF
	JR       J$2159
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$214C:
	LD       IX,DIRECTORY
	LD       C,00H
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.2152:
	PUSH     HL
	CALL     C.1FA2
	LD       HL,SCREEN_PRINT_A
J$2159:
	LD       (D$2178),HL
	LD       (D$218E),HL
	LD       (D$2196),HL
	LD       (D$21A1),HL
	PUSH     DE
	PUSH     BC
	PUSH     IX
	POP      HL
	LD       B,0CH    ; 12 
J$216C:
	LD       A,(HL)
	LD       D,A
	INC      HL
	LD       A,(HL)
	CP       03H      ; 3 
	JR       Z,J$217C
	LD       A,D
	CP       SPACE$
	CALL     NC,C.20FF
D$2178   EQU      $-2
	DJNZ     J$216C
J$217C:
	CP       03H      ; 3 
	JR       NZ,J$2198
	LD       A,C
	CP       03H      ; 3 
	JR       C,J.2192
	LD       A,B
	CP       01H      ; 1 
	JR       C,J.2192
	DEC      B
J$218B:
	LD       A,SPACE$
	CALL     C.20FF
D$218E   EQU      $-2
	DJNZ     J$218B
J.2192:
	LD       A,D
	CP       SPACE$
	CALL     NC,C.20FF
D$2196   EQU      $-2
J$2198:
	LD       A,B
	CP       01H      ; 1 
	JR       C,J$21A5
	DEC      B
J$219E:
	LD       A,SPACE$
	CALL     C.20FF
D$21A1   EQU      $-2
	DJNZ     J$219E
J$21A5:
	POP      BC
	POP      DE
	POP      HL
	RET      
;****************************************************************************
;Pause to Check Drives.
;  Waits for a keypress.  If you hit ^C, it aborts.  On exit, A=key pressed.
;If escape was pressed, ZF=1; else ZF=0.

PAUSE_CHECK_DRIVES:
	XOR      A                      ;A=0
	LD       (D.297F),A             ;wipe some stuff
	LD       (D.295D),A
	CALL     INVERSE_VIDEO
	LD       DE,1300H
	PUSH     DE
	LD       HL,STRING$040          ;"Check Drive(s)"
	CALL     PRINT_STRING_1
	CALL     NORMAL_VIDEO
	CALL     READ_KYBD_WITH_ECHO    ;wait for a keypress
	POP      DE
	PUSH     AF
	LD       HL,STRING$034          ;some spaces
	CALL     PRINT_STRING_1
	POP      AF
	CP       CTRL_C$                ;was it ^C?
	JP       Z,CENTRAL_LOOP         ;yes, so let's abort!
	CP       ESC$                   ;was it escape?
	RET                             ;exit with ZF=1 if so
;****************************************************************************
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.21D4:
	PUSH     AF
	LD       A,0FFH
	LD       (D.2992),A
	POP      AF
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.21DC:
	LD       A,(D.2992)
	OR       A
	RET      Z
	CALL     CLS_PRINT_COPYRIGHT
	CALL     INVERSE_VIDEO
	LD       DE,0601H
	LD       HL,STRING$032          ;"Save Changes?"
	CALL     PRINT_STRING_1
	CALL     NORMAL_VIDEO
	CALL     READ_KEYBOARD
	AND      5FH      ; "_"
	CP       4EH      ; "N"
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.21FB:
	LD       A,(D.295D)
	OR       A
	CALL     Z,C$2256
J$2202:
	CALL     C$1F40
	LD       A,0FFH
	LD       (D.295D),A
	CALL     INVERSE_VIDEO
	LD       HL,STRING$091                  ;"Reading Source"
	LD       DE,1300H
	CALL     PRINT_STRING_1
	LD       HL,(COPY_BLOCK_COUNT)
	LD       BC,(SOURCE_START_BLOCK)
	CALL     C.2280
	LD       (SOURCE_START_BLOCK),BC
	LD       (COPY_BLOCK_COUNT),HL
	LD       A,L
	OR       H
	RET      Z
	CALL     C.223C
	JR       J$2202
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.222F:
	CALL     C.21FB
;
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.2232:
	XOR      A
	LD       (D.295D),A
	CALL     C.223C
	JP       NORMAL_VIDEO
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.223C:
	CALL     C.1F13
	CALL     INVERSE_VIDEO
	LD       HL,STRING$092          ;"Writing Target"
	LD       DE,1400H
	CALL     PRINT_STRING_1
	LD       BC,(DEST_START_BLOCK)
	CALL     C$22E1
	LD       (DEST_START_BLOCK),BC
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$2256:
	LD       DE,BUFF1
	LD       (D.2963),DE
	LD       HL,0000H
	LD       (XRAM_BLOCK),HL
	LD       BC,0020H
	LD       A,(D.297C)
	OR       A
	JR       Z,J.2278
	LD       HL,003EH
	DEC      A
	JR       Z,J.2278
	LD       HL,(D.2965)
	OR       A
	SBC      HL,BC
J.2278:
	LD       (D.2960),BC
	LD       (D.2961),HL
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.2280:
	LD       DE,(D.2963)
	LD       A,(D.2960)
	OR       A
	JR       Z,J.229B
	DEC      A
	LD       (D.2960),A
	CALL     C.2341
	CALL     READ_BLOCK_COUNTED
	LD       (D.2963),DE
	JR       NZ,C.2280
	RET      
;        -----------------
J.229B:
	PUSH     HL
	LD       HL,(D.2961)
	LD       A,L
	OR       H
	JR       Z,J$22CB
	DEC      HL
	LD       (D.2961),HL
	POP      HL
	PUSH     HL
	CALL     C.2341
	LD       A,(SOURCE_CURRENT_DEVICE)
	LD       DE,BUFF3
	CALL     READ_BLOCK_TONY
	INC      BC
	PUSH     BC
	CALL     XRAM_WRITE_BLOCK
	LD       BC,(XRAM_BLOCK)
	INC      BC
	LD       (XRAM_BLOCK),BC
	POP      BC
	POP      HL
	DEC      HL
	LD       A,L
	OR       H
	JR       NZ,J.229B
	RET      
;        -----------------
J$22CB:
	POP      HL
	RET      
;****************************************************************************
;Read Block (Counted).
;  On entry, HL=block count, BC=block #, DE=DTA.  On exit, ZF=1 if all blocks
;have been read successfully.  HL is decremented, BC is incremented, DE is
;advanced by 1024.

READ_BLOCK_COUNTED:
	LD       A,L
	OR       H                              ;does HL=0? (are we done?)
	RET      Z                              ;yes
	LD       A,(SOURCE_CURRENT_DEVICE)      ;no, so get device #
	PUSH     HL                             ;save count
	CALL     READ_BLOCK_TONY                ;read the block
	POP      HL                             ;restore count
	LD       A,04H
	ADD      A,D                            ;add 1024 to DE
	LD       D,A
	INC      BC                             ;next block
	DEC      HL                             ;one less count
	LD       A,L
	OR       H                              ;ZF=1 if count is now zero
	RET      
;****************************************************************************
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$22E1:
	LD       A,SPACE$
	LD       HL,D.2960
	SUB      (HL)
	RET      Z
	LD       L,A
	LD       H,00H
	LD       DE,BUFF1
	LD       BC,(DEST_START_BLOCK)
J$22F2:
	CALL     C.2347
	CALL     C.2356
	JR       NZ,J$22F2
	LD       HL,(D.2965)
	LD       A,(D.297C)
	OR       A
	RET      Z
	DEC      A
	JR       NZ,J$2308
	LD       HL,005EH
J$2308:
	LD       DE,0020H
	OR       A
	SBC      HL,DE
	LD       DE,(D.2961)
	SBC      HL,DE
	LD       A,H
	OR       L
	RET      Z
	LD       DE,0000H
	LD       (XRAM_BLOCK),DE
J$231E:
	PUSH     HL
	PUSH     BC
	CALL     XRAM_READ_BLOCK
	LD       BC,(XRAM_BLOCK)
	INC      BC
	LD       (XRAM_BLOCK),BC
	POP      BC
	CALL     C.2347
	LD       A,(DEST_CURRENT_DEVICE)
	LD       DE,BUFF3
	CALL     WRITE_BLOCK_TONY
	INC      BC
	POP      HL
	DEC      HL
	LD       A,L
	OR       H
	JR       NZ,J$231E
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.2341:
	PUSH     DE
	LD       DE,1318H
	JR       J$234B
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.2347:
	PUSH     DE
	LD       DE,1418H
J$234B:
	CALL     C.1E49
	POP      DE
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$2350:
	PUSH     HL
	LD       HL,SOURCE_CURRENT_DEVICE
	JR       J$235A
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.2356:
	PUSH     HL
	LD       HL,DEST_CURRENT_DEVICE
J$235A:
	LD       (D$2362),HL
	POP      HL
	LD       A,L
	OR       H
	RET      Z
	LD       A,(DEST_CURRENT_DEVICE)
D$2362   EQU      $-2
	PUSH     HL
	CALL     WRITE_BLOCK_TONY
	POP      HL
	LD       A,04H    ; 4 
	ADD      A,D
	LD       D,A
	INC      BC
	DEC      HL
	LD       A,L
	OR       H
	RET      
;****************************************************************************
ABORT_RETRY_IGNORE:
	PUSH     BC
	LD       A,08H
	CALL     C.191F
	CALL     C.1969
	LD       DE,1600H
	LD       HL,STRING$096          ;"Ignore, Abort or Retry"
	CALL     PRINT_STRING_1
	CALL     READ_KEYBOARD
	PUSH     AF
	CALL     C.1966
	CALL     C.191C
	POP      AF
	POP      BC
	CP       ESC$
	JP       Z,CENTRAL_LOOP
	CP       CTRL_C$ 
	JP       Z,CENTRAL_LOOP
	CALL     C.1F6A
	AND      5FH
	SUB      41H
	JP       Z,CENTRAL_LOOP
	SUB      08H
	RET      Z
	SUB      09H
	JR       NZ,ABORT_RETRY_IGNORE
	INC      A
	RET      
;****************************************************************************
;Tony's Write Block routine.
;On entry, A=device number, BC=block # lo (hi is forced to 0), and DE=DTA.
;On exit, CF=1 if the read was successful, otherwise it falls into the
;Abort, Retry mode.

WRITE_BLOCK_TONY:
	LD       HL,DO_WRITE_BLOCK      ;write block routine vector
	JR       J$23B5
;****************************************************************************
;Tony's Read Block routine.
;On entry, A=device number, BC=block # lo (hi is forced to 0), and DE=DTA.
;On exit, CF=1 if the read was successful, otherwise it falls into the
;Abort, Retry mode.

READ_BLOCK_TONY:
	LD       HL,DO_READ_BLOCK       ;read block routine vector
J$23B5:
	LD       (READ_OR_WRITE_BLOCK),HL       ;save the vector
J$23B8:
	PUSH     BC
	PUSH     AF
	PUSH     DE
	CALL     DO_READ_BLOCK          ;gets overwritten with r/w vector
READ_OR_WRITE_BLOCK   EQU      $-2
	LD       H,A
	POP      DE
	POP      BC
	LD       A,B                    ;restore A=device #; keeps flags intact
	POP      BC
	RET      C                      ;R/W was okay, exit CF=1
	PUSH     BC
	PUSH     AF
	PUSH     DE
	LD       A,H                    ;this returns the A returned by the
					;DO_READ_BLOCK routine; supposed to
					;be the D_STATUS_FLAGS byte
	AND      0FH                    ;wipe hi nibble
	JR       NZ,J$23D5              ;there's stuff there
	LD       A,H                    ;sorry, restore original error code
	SRL      A                      ;move hi nibble to lo nibble
	SRL      A
	SRL      A
	SRL      A
J$23D5:
	PUSH     BC
	PUSH     AF
	LD       A,(VIDEO_STATE)        ;find out if we're NORMAL or INVERSE
	OR       A                      ;which is it?
	POP      BC
	LD       A,B                    ;preserve A=D_STATUS_FLAGS byte
	POP      BC
	PUSH     AF
	CALL     INVERSE_VIDEO
	POP      AF
	PUSH     AF
	LD       D,A                    ;D=D_STATUS_FLAGS byte
	INC      D                      ;make a count
	LD       A,00H                  ;end-of-string character
	LD       HL,STRING$095          ;drive error strings
J$23EB:
	LD       B,0FFH                 ;counter for CPIR
	CPIR                            ;look for a zero
	DEC      D                      ;one less count
	JR       NZ,J$23EB              ;keep going until we found it
	LD       DE,1500H
	CALL     PRINT_STRING_1         ;print the error message
	CALL     ABORT_RETRY_IGNORE
	PUSH     AF
	POP      BC
	POP      AF                     ;now B=device #, C=flags from <A,R,I>
	PUSH     BC                     ;save <A,R,I> flags
	CALL     Z,NORMAL_VIDEO
	POP      AF                     ;get back F=<A,R,I> flags
	POP      DE
	POP      BC                     ;B=device #
	LD       A,B                    ;now A=device # without killing flags
	POP      BC
	JR       NZ,J$23B8              ;if Retry, do it all over again
	RET                             ;sorry, Abort or Ignore
;****************************************************************************
;Add A to HL.
;  On exit, HL=A+entry HL.

ADD_A_TO_HL:
	ADD      A,L
	LD       L,A
	RET      NC
	INC      H
	RET      
;****************************************************************************
;Do Read Block.
;  Modified for ADAMserve FM017.ASM 9608.31
;
;  The original routine has the following entries and exits:
;
;  On entry:
;
;    BC=block # loword (hiword assumed to be 0000H)
;    DE=DTA
;    A=device number, except HD which has a special code: 1111 xxxx b
;                                                          HD  vol
;  On exit:
;
;    if successful, CF=1
;    if failed, CF=0 and A=correct nibble from D_STATUS_FLAGS byte
;
;  EOS _READ_BLOCK wants:
;
;  On entry:
;
;    DE=block # loword
;    BC=block # hiword
;    HL=DTA
;    A=device #
;    (HD_CURRENT_VOLUME)=desired HD volume if A=TAPE_2
;
;  On exit:
;
;    if successful, ZF=1
;    if failed, ZF=0, A=EOS error code, and the DCB has the D_STATUS_FLAGS byte
;
;  This revised code makes the appropriate translation between the two
;parameter passing mechanisms, so that the higher levels of code do not
;need to be rewritten, while still enabling *ONLY* EOS function calls to
;be used for I/O.

DO_READ_BLOCK:

	OR      A               ;is it a hard drive?
	CALL    M,HD_VOL_FUDGE  ;yes, so translate to TAPE_2 and correct volume
	PUSH    HL              ;save device #
	PUSH    AF
	LD      H,B             ;HL=block # loword
	LD      L,C
	EX      DE,HL           ;DE=block # loword, HL=DTA
	LD      BC,0000H        ;BC=block # hiword (assumed to be 0)
	CALL    _READ_BLOCK     ;EOS function call
	JR      NZ,R_W_FAILED   ;failed, so error exit
	POP     AF
	POP     HL
	SCF                     ;CF=1 for okay exit
	RET
;        -----------------
R_W_FAILED:
	POP     AF                      ;restore device #
	LD      H,A                     ;save it
	CALL    _RD_DEV_DEP_STAT        ;get the D_STATUS_FLAGS byte
	LD      L,A                     ;save it
	LD      A,H                     ;get back device #
	CP      16                      ;is it a secondary device?
	LD      A,L                     ;restore D_STATUS_FLAGS
	POP     HL
	JR      C,R_W_USE_LOW           ;no, primary device
	SRL     A                       ;yes, so shift hi nibble to lo
	SRL     A
	SRL     A
	SRL     A
	OR      A                       ;CF=0 for error exit
	RET
;        -----------------
R_W_USE_LOW:
	AND     0FH                     ;wipe the hi nibble, CF=0 for error
	RET
;****************************************************************************
;Hard Drive Volume Fudge.
;  On entry, A=hard drive device number in form 1111 xxxx b
;                                                HD   vol
;  On exit, (HD_CURRENT_VOLUME) has the desired volume, and A=TAPE_2.

HD_VOL_FUDGE:
	AND     0FH                     ;get the volume #
	LD      (HD_CURRENT_VOLUME),A   ;save it
	LD      A,TAPE_2                ;make it TAPE_2
	RET
;****************************************************************************
;Do Write Block.

;  Modified for ADAMserve FM017.ASM 9608.31
;
;  The original routine has the following entries and exits:
;
;  On entry:
;
;    BC=block # loword (hiword assumed to be 0000H)
;    DE=DTA
;    A=device number, except HD which has a special code: 1111 xxxx b
;                                                          HD  vol
;  On exit:
;
;    if successful, CF=1
;    if failed, CF=0 and A=correct nibble from D_STATUS_FLAGS byte
;
;  EOS _WRITE_BLOCK wants:
;
;  On entry:
;
;    DE=block # loword
;    BC=block # hiword
;    HL=DTA
;    A=device #
;    (HD_CURRENT_VOLUME)=desired HD volume if A=TAPE_2
;
;  On exit:
;
;    if successful, ZF=1
;    if failed, ZF=0, A=EOS error code, and the DCB has the D_STATUS_FLAGS byte
;
;  This revised code makes the appropriate translation between the two
;parameter passing mechanisms, so that the higher levels of code do not
;need to be rewritten, while still enabling *ONLY* EOS function calls to
;be used for I/O.

DO_WRITE_BLOCK:

	OR      A               ;is it a hard drive?
	CALL    M,HD_VOL_FUDGE  ;yes, so translate to TAPE_2 and correct volume
	PUSH    HL              ;save device #
	PUSH    AF
	LD      H,B             ;HL=block # loword
	LD      L,C
	EX      DE,HL           ;DE=block # loword, HL=DTA
	LD      BC,0000H        ;BC=block # hiword (assumed to be 0)
	CALL    _WRITE_BLOCK    ;EOS function call
	JR      NZ,R_W_FAILED   ;failed, so error exit
	POP     AF
	POP     HL
	SCF                     ;CF=1 for okay exit
	RET
;****************************************************************************
DO_INIT_MEDIA:
	CALL     INVERSE_VIDEO
	LD       HL,STRING$074          ;"Initializing Media"
	CALL     PRINT_STRING_1
	CALL     NORMAL_VIDEO
	LD       DE,SOURCE_1
	CALL     GET_MEDIA_SIZE
	LD       (INIT_VOLSIZE),BC
	LD       H,B
	LD       L,C
	LD       DE,(DIR_ALLOC_LENGTH)
	LD       A,E
	SET      7,A
	LD       (D.3553),A
	INC      DE
	SBC      HL,DE
	LD       (D$35A6),HL
	LD       (D.35A2),DE
	LD       B,E
	LD       DE,BUFF1
	PUSH     DE
	CALL     C$266A
	LD       HL,BLOCK0_BOOT_CODE
	POP      DE
	PUSH     DE
	LD       BC,LEN_BLOCK0_BOOT
	LDIR     
	LD       HL,DIRECTORY           ;This was missing in the original
					;FILEMAN 3.1
	LD       DE,BUFF2
	LD       BC,LEN_DIRECTORY
	LDIR     
	LD       A,(D.35A2)
	LD       L,A
	LD       H,00H
	LD       BC,0000H
	POP      DE
J$2664:
	CALL     C$2350
	JR       NZ,J$2664
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$266A:
	LD       A,B
	OR       A
	RET      Z
	LD       H,D
	LD       L,E
	INC      DE
J$2670:
	PUSH     BC
	LD       BC,BLOCKSIZE-1
	LD       (HL),00H
	LDIR     
	POP      BC
	DJNZ     J$2670
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$267C:
	LD       DE,091BH
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$267F:
	CALL     C.269D
	RET      Z
	LD       (SOURCE_START_BLOCK),HL
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$2687:
	LD       DE,0F1BH
	CALL     C.269D
	RET      Z
	LD       (DEST_START_BLOCK),HL
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C$2692:
	LD       DE,0A1BH
	CALL     C.269D
	RET      Z
	LD       (COPY_BLOCK_COUNT),HL
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.269D:
	PUSH     DE
	LD       HL,STRING$038
	CALL     PRINT_STRING_1
	CALL     C.1FF7
	POP      DE
	CALL     C$1ECC
	PUSH     AF
	PUSH     HL
	CALL     C.1FF8
	POP      HL
	POP      AF
	CP       ESC$
	RET      
;        -----------------
;          Subroutine __________________________
;             Inputs  ________________________
;             Outputs ________________________
;
C.26B5:
	LD       A,(FLOPPY_DRIVE_COUNT)
	CP       02H
	JR       C,CHANGE_SOURCE_DRIVE
	LD       BC,SOURCE_1            ;base of parameter table
	LD       A,(TOTAL_DEVICE_COUNT)
	INC      A
	JR       C_D_COMMON_2
;****************************************************************************
;Change Destination Drive.
;  Each pass through, the destination drive is incremented, cycling through
;all possible valid destination drives.

CHANGE_DEST_DRIVE:
	LD       BC,DEST_1              ;base of parameter table
	JR       C_D_COMMON
;****************************************************************************
;Change Source Drive.
;  Each pass through, the source drive is incremented, cycling through all
;possible valid source drives.

CHANGE_SOURCE_DRIVE:
	LD       BC,SOURCE_1            ;base of parameter table
C_D_COMMON:
	LD       A,(TOTAL_DEVICE_COUNT) ;get the count
C_D_COMMON_2:
	LD       (TEMP_DRIVE_COUNT),A   ;stash it in the code
	LD       HL,STRING$034          ;some spaces
	LD       DE,1400H
	CALL     PRINT_STRING_1
	LD       A,(BC)                 ;get device index
	INC      A                      ;one more
	CP       04H                    ;is it past the end?
TEMP_DRIVE_COUNT   EQU      $-1
	JR       C,J$26E3               ;no, so keep it
	XOR      A                      ;yes, so make it zero
J$26E3:
	LD       (BC),A                 ;and save back index
	LD       HL,VALID_DEVICE_TABLE  ;point to table
	CALL     ADD_A_TO_HL            ;offset into table
	LD       A,(HL)                 ;get device number
	INC      BC                      ;point at 2nd element in param table
	LD       (BC),A                  ;save device # (CURRENT_SOURCE or
					 ;CURRENT_DEST)
	PUSH     AF                      ;save the device #
	LD       A,1
	CALL     SET_DIR_SIZE_TO_A       ;set directory size to 1 block default
	POP      AF
	OR       A                       ;is it a hard drive?
	JP       P,J$2733                ;no
	AND      0FH                     ;yes, so wipe hi nibble to get volume
	LD       HL,HD_VOL_DIRSIZE_TABLE ;point to volume size table
	CALL     ADD_A_TO_HL             ;offset into table
	LD       A,(HL)                  ;get size
	JP       SET_DIR_SIZE_TO_A       ;HD directory entry size
;        -----------------
J$2733:
	CP       TAPE_1
	RET      NC
	INC      BC
	SUB      4
	LD       HL,FLOPPY_MAX_SIZES
	CALL     ADD_A_TO_HL
	LD       A,(HL)
	PUSH AF
;C$2740:
	DEC      A
	PUSH     BC
	LD       C,A
	CP       DOUBLE_SIDED                   ;is it single-sided?
	LD       A,1                            ;1-block directory for ss disk
	JR       C,EXIT_66                      ;yes
	LD       A,3                            ;3-block directory for ds disk
	JR       Z,EXIT_66                      ;no, it's double-sided
	LD       A,C                            ;try again, get disk type
	CP       HIGH_1200K
	LD       A,6                            ;6-block directory for qd disk
	JR       C,EXIT_66                      ;yes
	LD       A,8                            ;8-block directory
EXIT_66:
	POP      BC
	CALL     SET_DIR_SIZE_TO_A      ;set the directory size
	POP      AF
	DEC      A
	LD       (BC),A
	RET      
;***************************************************************************
;Print Current Destination Device Name.

PRINT_CURRENT_DEST_NAME:
	PUSH     BC
	LD       BC,DEST_CURRENT_DEVICE
	JR       P_C_N_COMMON
;***************************************************************************
;Print Current Source Device Name.

PRINT_CURRENT_SOURCE_NAME:
	PUSH     BC
	LD       BC,SOURCE_CURRENT_DEVICE
P_C_N_COMMON:
	PUSH     DE
	PUSH     BC
	INC      BC
	INC      BC                     ;point to disk type byte
					;why?  it isn't used by CALL routine
	CALL     C$1785
	POP      BC
	POP      DE
	LD       A,(BC)                 ;get requested device #
	OR       A                      ;test it
	POP      BC
	JP       P,J$276C               ;plus, it was disk or tape
	LD       HL,STRING$084          ;minus, it was "Hard Drive Volume"
	AND      0FH                    ;wipe hi nibble 
	ADD      A,30H                  ;make into an ASCII digit
	LD       (CURRENT_HD_VOLUME$),A ;and save it
	JP       PRINT_STRING_1
;        -----------------
J$276C:
	OR       A                      ;is it both disk drives? (A=0)
	LD       HL,STRING$087          ;"Disk Drives 1 and 2"
	JP       Z,PRINT_STRING_1       ;yes, so to it
	CP       TAPE_1                 ;no, is it a tape?
	JR       NC,J$2782              ;yes
	LD       HL,STRING$086          ;no, "Disk Drive"
	ADD      A,2DH                  ;make device # into an ASCII digit
	LD       (CURRENT_DISK$),A      ;and save it
	JP       PRINT_STRING_1
;        -----------------
J$2782:
	LD       HL,STRING$085          ;"Tape Drive"
	LD       A,31H                  ;make device # into an ASCII digit
	JR       Z,J$278A               ;if TAPE_1, leave it as-is
	INC      A                      ;else add one
J$278A:
	LD       (CURRENT_TAPE$),A      ;and save it
	JP       PRINT_STRING_1
;****************************************************************************
;Toggle Destination Disk Type.
;  Each time through, goes to the next available disk type, wrapping around
;when necessary.

TOGGLE_DEST_DISK_TYPE:
	LD       BC,DEST_CURRENT_DEVICE
	JR       T_D_T_COMMON
;****************************************************************************
;Toggle Source Disk Type.
;  Each time through, goes to the next available disk type, wrapping around
;when necessary.

TOGGLE_SOURCE_DISK_TYPE:
	LD       BC,SOURCE_CURRENT_DEVICE
T_D_T_COMMON:
	LD       A,(BC)
	OR       A
	RET      Z
	CP       TAPE_1
	RET      NC
	INC      BC
	LD       A,(BC)
	INC      A
	CP       5              ;changed FM019.ASM 9608.31
				;reflects 5 available disk types,
				;including 1200K and 1440K
	JR       C,J$27A6
	XOR      A              ;too far, reset to zero
J$27A6:
	LD       (BC),A                 ;save new current device
	CALL     CALC_DIR_SIZE          ;find new default directory size
	JP       SET_DIR_SIZE_TO_A    ;save it
;****************************************************************************
;Print Destination Disk Type.

PRINT_DEST_DISK_TYPE:
	LD       BC,DEST_DISK_TYPE
	LD       HL,DEST_CURRENT_DEVICE
	JR       PRINT_DISK_TYPE_COMMON
;****************************************************************************
;Print Source Disk Type.

PRINT_SOURCE_DISK_TYPE:
	LD       BC,SOURCE_DISK_TYPE
	LD       HL,SOURCE_CURRENT_DEVICE
PRINT_DISK_TYPE_COMMON:
	LD       A,(HL)                 ;get current device #
	LD       HL,STRING$037          ;some spaces
					;(actually has current string?)
	CP       TAPE_1                 ;is it a tape?
	JR       NC,P_D_T_C_2           ;yes
	LD       HL,STRING$088          ;no, a disk; try "160K 5-1/4"
	LD       A,(BC)                 ;get disk type
	OR       A                      ;is it 160K?
	JR       Z,P_D_T_C_2            ;yes
	LD       HL,STRING$089          ;no, try "320K 5-1/4"
	DEC      A                      ;is it 320K?
	JR       Z,P_D_T_C_2            ;yes
	LD       HL,STRING$090          ;no, try "720K 3-1/2"
	DEC      A                      ;is it 720K?
	JR       Z,P_D_T_C_2            ;yes
	LD       HL,STRING$090A         ;no, try "1200K 5-1/4"
	DEC      A                      ;is it 1200K?
	JR       Z,P_D_T_C_2            ;yes
	LD       HL,STRING$090B         ;no, must be "1440K 3-1/2"
P_D_T_C_2:
	JP       PRINT_STRING_1         ;print it
;****************************************************************************
FILEMAN_NAME$:
	DB     'FILEMAN',02H,03H
STRING$001:
	DB     ' FILE MANAGER v4.0 / ADAMserve ',00H
STRING$002:
	DB     CR$,LF$
	DB     '   AJM Software (c) 1996 RFD   ',CR$,LF$,00H
STRING$003:
	DB     CR$,LF$,LF$
	DB     'This is the first time that'   ,CR$,LF$
	DB     'you have run this copy of'     ,CR$,LF$
	DB     'FILE MANAGER.  Please answer'  ,CR$,LF$
	DB     'the following questions about' ,CR$,LF$
	DB     'your disk drives.'             ,00H
STRING$004:
	DB     'Press any key to continue...',00H
STRING$005:
	DB     CR$,LF$,LF$
	DB     'SELECT SIZE OF DISK '
WHICH_DISK$:
	DB     '1'
	DB     CR$,LF$,LF$
	DB     '   I -  160K  5-1/4 inch',CR$,LF$,LF$
	DB     '  II -  320K  5-1/4 inch',CR$,LF$,LF$
	DB     ' III -  720K  3-1/2 inch',CR$,LF$,LF$
	DB     '  IV - 1200K  5-1/4 inch',CR$,LF$,LF$
	DB     '   V - 1440K  3-1/2 inch',00H
STRING$007:
	DB     'Save Changes',00H
	DB     'Continue',00H
;****************************************************************************
;Forward pad area for SDA.  If needed, uncomment this and add the correct
;count for the DS.

;        DS      <amount of BLOCK_SDA_PAD reported during assembly>

;****************************************************************************
;User Saved Data Area (SDA).  Must be saved as part of a contiguous data
;block.

SAVE_DATA_AREA_START    EQU     $                               ;the address
BLOCK_SDA_START         EQU     (SAVE_DATA_AREA_START-256)/1024 ;the block;

D.294A:
	DB     04H
D.294B:
	DB     01H
D.294C:
	DB     0FH
D.294D:
	DB     01H
D.294E:
	DB     07H
D.294F:
	DW     0000H
CURRENT_PRINTER:
	DB     00H
DEV1314_BUFFER
	DB     00H
D.2952:
	DB     1EH
D.2953:
	DB     00H
D.2954:
	DB     05H
USER_ESCAPE_CHAR:
	DB     7EH
D.2956:
	DB     01H
D.2957:
	DB     00H
D.2958:
	DB     00H
D.2959:
	DB     00H
D.295A:
	DB     00H
D.295B:
	DB     00H
D.295C:
	DB     00H
D.295D:
	DB     00H
XRAM_BLOCK:
	DW     0000H
D.2960:
	DB     20H
D.2961:
	DB     00H
	DB     00H
D.2963:
	DB     51H
	DB     55H
D.2965:
	DW     005EH
D.2967:
	DB     00H
D$2968:
	DB     00H
SOURCE_START_BLOCK:
	DW     0000H
DEST_START_BLOCK:
	DW     0000H
COPY_BLOCK_COUNT:
	DW     0000H
	DB     00H
SOURCE_1:
	DB     0AH
SOURCE_CURRENT_DEVICE:
	DB     DISK_1
SOURCE_DISK_TYPE:
	DB     HIGH_DENSITY
DEST_1:
	DB     01H
DEST_CURRENT_DEVICE:
	DB     0F1H
DEST_DISK_TYPE:
	DB     HIGH_1200K

;; removed FM017.ASM  9608.31
;;
;;DISK_1_DCB_ADDR:
;;        DW     0000H
;;DISK_2_DCB_ADDR:
;;        DW     0000H
;;

D.297A:
	DB     00H
D.297B:
	DB     0FFH
D.297C:
	DB     00H
D.297D:
	DB     00H
D.297E:
	DB     00H
D.297F:
	DB     00H
VERIFY_FORMAT_FLAG:
	DB     0FFH     ;0=don't verify, anything else=verify
D.2981:
	DB     00H
D.2982:
	DB     00H
D.2983:
	DB     00H
D.2984:
	DB     00H
D.2985:
	DB     01H
D.2986:
	DB     26H
D.2987:
	DB     05H
D.2988:
	DB     00H
D.2989:
	DB     00H
D$298A:
	DB     00H
D.298B:
	DB     04H,00H,00H
D.298E:
	DB     00H
D.298F:
	DB     00H
D.2990:
	DW     0000H
D.2992:
	DB     00H
D.2993:
	DB     00H,00H
D.2995:
	DB     00H
D.2996:
	DB     00H
D.2997:
	DB     00H
D.2998:
	DB     00H
PICA$:        
	DB     'PICA->'
PICA_CODE$:
	DB     03H,12H,ESC$,50H,00H,00H,00H
ELITE$:
	DB     'ELITE->'
ELITE_CODE$:
	DB     03H,12H,ESC$,4DH,00H,00H,00H
CONDON$:
	DB     'CONDON->'
CONDON_CODE$:
	DB     01H,0FH,00H,00H,00H,00H,00H
NLQON$:
	DB     'NLQON->'
NLQON_CODE$:
	DB     03H,ESC$,78H,31H,00H,00H,00H
NLQOFF$:
	DB     'NLQOFF->'
NLQOFF_CODE$:
	DB     03H,ESC$,78H,30H,00H,00H,00H
FLOPPY_DRIVE_COUNT:
	DB     02H      ;# of ADAMnet floppy drives
FLOPPY_MAX_SIZES:
;        DB     02H,03H,00H,00H
	DB      00H,00H,00H,00H
VRAM_DATA_01:
	DB     00H ,00H ,00H ,00H ,10H ,38H ,7CH ,0FEH
	DB     0F8H,0FCH,0FEH,0FFH,0FEH,0FCH,0F8H,00H
	DB     1FH ,3FH ,7FH ,0FFH,7FH ,3FH ,1FH ,00H
LEN_VRAM_DATA_01        EQU     $-VRAM_DATA_01

VRAM_DATA_02:
	DB     03H,03H,00H
D.2A00:
	DB     CR$,0D0H
LEN_VRAM_DATA_02        EQU     $-VRAM_DATA_02

SAVE_DATA_AREA_END      EQU     $                               ;the address
BLOCK_SDA_END           EQU     (SAVE_DATA_AREA_END-257)/1024   ;the block (inclusive)

IF1

	IF BLOCK_SDA_START<>BLOCK_SDA_END

		.PRINTX BLOCK_SDA_START is not the same as BLOCK_SDA_END!
		BLOCK_SDA_PAD   EQU     ((BLOCK_SDA_END*1024)+256)-SAVE_DATA_AREA_START
		.PRINTX You must pad the SDA forward by
		PRINTX %BLOCK_SDA_PAD
		.PRINTX bytes to make the SDA fall within a single disk block.

	ELSE

		.PRINTX BLOCK_SDA_START is the same as BLOCK_SDA_END.

	ENDIF

	PRINTX %BLOCK_SDA_START
	PRINTX %BLOCK_SDA_END

ELSE
ENDIF

;end of Saved Data Area

;****************************************************************************
STRING$008:
	DB     '   Directory of ',00H
STRING$009:
	DB     CR$,LF$,LF$
	DB     '     I - File Functions'      ,CR$,LF$
	DB     '    II - Media Functions'     ,CR$,LF$
	DB     '   III - Change Default Setup',CR$,LF$
	DB     '    IV - '                    ,CR$,LF$,LF$
	DB     ' Source:'                     ,CR$,LF$
	DB     '     V -'                     ,CR$,LF$,LF$,LF$,LF$
	DB     '   Maximum buffer size:     K',00H
STRING$010:
	DB     'Use All Expansion Ram',00H
STRING$011:
	DB     'Use 1 Bank of E-Ram  ',00H
STRING$012:
	DB     'Ignore Expansion Ram ',00H
STRING$013:
	DB     'PRINT SECTOR',CR$,LF$,LF$
	DB     '     I -',00H
STRING$014:
	DB     CR$,LF$,LF$
	DB     '                              SECTOR DUMP',CR$,LF$,LF$
	DB     'Addr                Block #:',00H
STRING$015:
	DB     '   Sector #:',00H
STRING$016:
	DB     '    I - Edit Catalog'   ,CR$,LF$
	DB     '   II - Media Functions',00H
STRING$017:
	DB     CR$,LF$,LF$
	DB     '   MOVE - Copy File'        ,CR$,LF$
	DB     '  STORE - Tag File'         ,CR$,LF$
	DB     '   UNDO - UnTag File'       ,CR$,LF$
	DB     '  CLEAR - Init Directory'   ,CR$,LF$
	DB     '  PRINT - Print File'       ,CR$,LF$
	DB     ' sPRINT - Print Directory'  ,CR$,LF$
	DB     ' DELETE - Delete File'      ,CR$,LF$
	DB     ' ESC,^C - Exit to Main Menu',CR$,LF$
	DB     ' RETURN - Copy/Print/Delete',CR$,LF$
	DB     '          Tagged Files'     ,CR$,LF$
	DB     '      I - Edit Catalog'     ,CR$,LF$
	DB     '     II - Media Functions'  ,CR$,LF$
	DB     '            Backup'         ,CR$,LF$
	DB     '            Krunch'         ,CR$,LF$
	DB     '            Copy Block(s)'  ,CR$,LF$
	DB     '            Edit Block'     ,CR$,LF$
	DB     '            Format'         ,CR$,LF$
	DB     '            Init'           ,00H
STRING$018:
	DB     '   I - Copy Tagged Files'  ,CR$,LF$,LF$
	DB     '  II - Print Tagged Files' ,CR$,LF$,LF$
	DB     ' III - Delete Tagged Files',00H
STRING$019:
	DB     'No Files',00H
STRING$020:
	DB     ' Not an EOS Medium ',00H
STRING$021:
	DB     CR$,LF$,LF$
	DB     ' INITIALIZE DIRECTORY',CR$,LF$,LF$
	DB     '    at File:',00H
STRING$022:
	DB     'MORE',00H
STRING$023:
	DB     'for Tagged C/P/D',00H
STRING$024:
	DB     'PRINT DIRECTORY',CR$,LF$,LF$
	DB     '     I -',00H
STRING$025:
	DB     'Blocks Left:',00H
STRING$026:
	DB     'K ',00H
STRING$027:
	DB     LF$
STRING$028:
	DB     CR$,LF$,00H
STRING$029:
	DB     'Press',00H
STRING$030:
	DB     'RETURN to',00H
	DB     'Continue  ',00H
STRING$031:
	DB     'ESCAPE to Exit',00H
STRING$032:
	DB     ' Save Changes? (Y/N)? ',00H
STRING$033:
	DB     '                        '
	DB     '       ',CR$,LF$
	DB     '                               ',CR$,LF$
STRING$034:
	DB     '         '
STRING$035:
	DB     '    '
STRING$036:
	DB     '  '
STRING$037:
	DB     '           '
STRING$038:
	DB     '   '
STRING$039:
	DB     '  ',00H
	DB     CR$
	DB     LF$
	DB     ESC$
	DB     'J',00H
STRING$040:
	DB     '        Check Drive(s)         ',00H
STRING$041:
	DB     CR$,LF$,LF$
	DB     ' COPY FILE',CR$,LF$,LF$
	DB     '     I -'  ,CR$,LF$,LF$
	DB     ' Target:'  ,CR$,LF$
	DB     '    II -'  ,00H
STRING$042:
	DB     CR$,LF$,LF$,LF$,LF$
	DB     ' Old Filename:',CR$,LF$,LF$
	DB     ' New Filename:',00H
STRING$043:
	DB     'Rename File      ',00H
STRING$044:
	DB     'Use Same Filename',00H
STRING$045:
	DB     '     Target Medium is Full     ',00H
STRING$046:
	DB     CR$,LF$,LF$
	DB     ' COPY BLOCK(S)'            ,CR$,LF$,LF$
	DB     ' Source:'                  ,CR$,LF$
	DB     '     I -'                  ,CR$,LF$
	DB     '    sI -'                  ,CR$,LF$
	DB     '    II - Start Block:'     ,CR$,LF$
	DB     '   III - Number of Blocks:',CR$,LF$,LF$
	DB     ' Target:'                  ,CR$,LF$
	DB     '    IV -'                  ,CR$,LF$
	DB     '   sIV -'                  ,CR$,LF$
	DB     '     V - Start Block:'     ,00H
STRING$047:
	DB     'Copy',00H
	DB     'ing',00H
STRING$048:
	DB     'Delete? (Y/N)?',00H
STRING$049:
	DB     CR$,LF$,LF$
	DB     ' BACKUP'  ,CR$,LF$,LF$
	DB     ' Source:' ,CR$,LF$
	DB     '     I -' ,CR$,LF$
	DB     '    II -' ,CR$,LF$,LF$
	DB     ' Target:' ,CR$,LF$
	DB     '   III -' ,CR$,LF$
	DB     '    IV -' ,CR$,LF$,LF$
	DB     '     V -' ,CR$,LF$
	DB     '    VI -' ,00H
STRING$050:
	DB     'Copy All Files       ',00H
STRING$051:
	DB     'Exclude Deleted Files',00H
STRING$052:
	DB     'Exc. Del. and Backup ',00H
STRING$053:
	DB     'Image Copy           ',00H
STRING$054:
	DB     'Backup',00H
STRING$055:
	DB     'Do NOT Init Target',00H
STRING$056:
	DB     'Initialize Target ',00H
D.3102:
	DB     00H
STRING$057:
	DB     CR$,LF$,LF$
	DB     ' MEDIA FUNCTIONS'          ,CR$,LF$,LF$
	DB     '     I - Backup'           ,CR$,LF$
	DB     '    II - Krunch'           ,CR$,LF$
	DB     '   III - Copy Block(s)'    ,CR$,LF$
	DB     '    IV - Edit Block'       ,CR$,LF$
	DB     '     V - Format Media'     ,CR$,LF$
	DB     '    VI - Initialize Media' ,00H
STRING$058:
	DB     CR$,LF$,LF$
	DB     ' EDIT BLOCK'           ,CR$,LF$,LF$
	DB     '     I -'              ,CR$,LF$
	DB     '    II -'              ,CR$,LF$
	DB     '   III - Block Number:',00H
STRING$059:
	DB     'Edit',00H
STRING$060:
	DB     '       Block Out of Range      ',00H
STRING$061:
	DB     ' Block #:       Sector #:'      ,CR$,LF$
	DB     ' Byte:    :   h/Blk    :  h/Sec',00H
STRING$062:
	DB     CR$,LF$,LF$
	DB     ' Directory Entry'               ,CR$,LF$,LF$
	DB     '      I - Name:'                ,CR$,LF$
	DB     '     II - Attributes'           ,CR$,LF$
	DB     '              locked:'          ,CR$,LF$
	DB     '       write protect:'          ,CR$,LF$
	DB     '        read protect:'          ,CR$,LF$
	DB     '           user file:'          ,CR$,LF$
	DB     '         system file:'          ,CR$,LF$
	DB     '             deleted:'          ,CR$,LF$
	DB     '       exec. protect:'          ,CR$,LF$
	DB     '         blocks left:'          ,CR$,LF$
	DB     '    III - Starts at :       BLK',CR$,LF$
	DB     '     IV - Length    :       BLK',CR$,LF$
	DB     '      V - Used      :       BLK',CR$,LF$
	DB     '     sV -   in last :       BYT',CR$,LF$
	DB     '     VI - Date      :   /  /'   ,00H
STRING$063:
	DB     'When Done',00H
STRING$064:
	DB     'With Verification   ',00H
STRING$065:
	DB     'With No Verification',00H
STRING$066:
	DB     '        Formatting Disk        ',00H
STRING$067:
	DB     '       Verifying  Block        ',00H
STRING$068:
	DB     '        Formatting Tape        ',00H
STRING$069:
	DB     CR$,LF$,LF$
	DB     ' FORMAT'  ,CR$,LF$,LF$
	DB     '     I -' ,CR$,LF$
	DB     '    II -' ,CR$,LF$
	DB     '   III -' ,00H
STRING$070:
	DB     'Format',00H

;; removed FM017.ASM 9608.31
;;
;;DCB_FORMAT_SETUP:
;;        DW     BUFF1
;;        DW     BLOCKSIZE
;;        DW     FACE$
;;        DW     0000H
;;LEN_DCB_FORMAT_SETUP      EQU     $-DCB_FORMAT_SETUP
;;

STRING$071:
	DB     CR$,LF$,LF$
	DB     ' INITIALIZE MEDIA'           ,CR$,LF$,LF$
	DB     '     I - Volume:'            ,CR$,LF$
	DB     '    II - Directory Size: 1K' ,CR$,LF$
	DB     '   III -'                    ,CR$,LF$
	DB     '    IV -'                    ,00H
STRING$072:
	DB     'Initialize',00H
STRING$073:
	DB     CR$,LF$,LF$
	DB     ' SAVE CHANGES TO:' ,CR$,LF$,LF$
	DB     '     I -'          ,00H
STRING$074:
	DB     '      Initializing Medium      ',CR$,00H
;****************************************************************************
BLOCK0_BOOT_CODE:
	LD       BC,RETN$
	LD       (NMI_VECTOR),BC
	JP       _GOTO_WP
;****************************************************************************
	DB     ' / '
	DB     'Initialized by File Manager 4.0 for ADAMserve / '
	DB     'File Manager (c) 1996 by AJM Software / '
	DB     'ADAMserve (c) 1996 by Richard F. Drushel / '
LEN_BLOCK0_BOOT EQU     $-BLOCK0_BOOT_CODE
;****************************************************************************
DIRECTORY:
	DB     'ADAMserve',03H,20H,20H
D.3553:
	DB     83H
	DB     55H,0AAH,00H,0FFH
INIT_VOLSIZE:
	DW     320
	DB     00H,00H,00H,00H,00H,00H,00H
	DB     'BOOT',03H,'       '
	DB     90H
	DB     00H
	DB     00H
	DB     00H
	DB     00H
	DB     01H
	DB     00H
	DB     01H
	DB     00H
	DB     00H
	DB     04H
	DB     00H
	DB     00H
	DB     00H
	DB     'DIRECTORY',03H,'  '
	DB     0D8H
	DB     01H
	DB     00H
	DB     00H
	DB     00H
DIR_ALLOC_LENGTH:
	DB     03H
	DB     00H
DIR_USED_LENGTH:
	DB     03H
	DB     00H
	DB     00H
	DB     04H
	DB     00H
	DB     00H
	DB     00H
	DB     'BLOCKS LEFT',03H
	DB     01H
D.35A2:
	DB     04H,00H,00H,00H
D$35A6:
	DW     00F9H
	DW     0000H
	DW     0000H
	DW     0000H
	DB     00H
LEN_DIRECTORY   EQU     $-DIRECTORY

STRING$075:
	DB     CR$,LF$,LF$
	DB     ' KRUNCH'  ,CR$,LF$,LF$
	DB     ' Source:' ,CR$,LF$
	DB     '     I -' ,CR$,LF$,LF$
	DB     ' Target:' ,CR$,LF$
	DB     '    II -' ,CR$,LF$
	DB     '   III -' ,CR$,LF$,LF$
	DB     '    IV -' ,00H
STRING$076:
	DB     'Krunch',00H
STRING$077:
	DB     'Remove Backup Files',00H
STRING$078:
	DB     'Leave Backup Files ',00H
STRING$079:
	DB     'VI - Without Media Swap',00H
STRING$080:
	DB     'VI - With Media Swap   ',00H
STRING$081:
	DB     '   Source Larger Than Target   ',00H
STRING$082:
	DB     CR$,LF$,LF$
	DB     ' DEFAULT SETUP'           ,CR$,LF$,LF$
	DB     ' Screen Colors:'          ,CR$,LF$
	DB     '     I - Border:'         ,CR$,LF$
	DB     '    II - Normal Char:'    ,CR$,LF$
	DB     '   sII - Normal Bkgrnd:'  ,CR$,LF$
	DB     '   III - Inverse Char:'   ,CR$,LF$
	DB     '  sIII - Inverse Bkgrnd:' ,CR$,LF$
	DB     '    IV - Cursor:'         ,CR$,LF$,LF$
	DB     ' Source:'                 ,CR$,LF$
	DB     '     V -'                 ,CR$,LF$
	DB     '    sV -'                 ,CR$,LF$
	DB     ' Target:'                 ,CR$,LF$
	DB     '    VI -'                 ,CR$,LF$
	DB     '   sVI -'                 ,00H
STRING$083:
	DB     'Trans',00H
	DB     'Black',00H
	DB     'MdGrn',00H
	DB     'LtGrn',00H
	DB     'DkBlu',00H
	DB     'LtBlu',00H
	DB     'DkRed',00H
	DB     'Cyan ',00H
	DB     'MdRed',00H
	DB     'LtRed',00H
	DB     'DkYel',00H
	DB     'LtYel',00H
	DB     'DkGrn',00H
	DB     'Magen',00H
	DB     'Grey ',00H
	DB     'White',00H
TOTAL_DEVICE_COUNT:
	DB     01H
HD_VOL_DIRSIZE_TABLE   EQU      $
	DB     00H,00H,00H,00H,00H,00H,00H,00H,00H,00H
HD_VOL_OFFSET_TABLE   EQU      $
	DB     00H,00H,00H,00H,00H,00H,00H,00H,00H,00H
VALID_DEVICE_TABLE   EQU      $
	DB     00H,00H,00H,00H,00H,00H,00H,00H,00H,00H  ;10 HD volumes
	DB     00H,00H,00H,00H                          ;4 floppy drives
	DB     00H,00H                                  ;2 tape drives
	DB     00H                                      ;end-of-table
STRING$084:
	DB     'Hard Drive Volume '
CURRENT_HD_VOLUME$:
	DB     '0',00H
STRING$085:
	DB     'Tape Drive '
CURRENT_TAPE$:
	DB     '1       ',00H
STRING$086:
	DB     'Disk Drive '
CURRENT_DISK$:
	DB     '1       ',00H
STRING$087:
	DB     'Disk Drives 1 and 2',00H
STRING$088:
	DB     ' 160K  5-1/4 ',00H
STRING$089:
	DB     ' 320K  5-1/4 ',00H
STRING$090:
	DB     ' 720K  3-1/2 ',00H
STRING$090A:
	DB     '1200K  5-1/4 ',00H
STRING$090B:
	DB     '1440K  3-1/2 ',00H
STRING$091:
	DB     '        Reading Source         ',00H
STRING$092:
	DB     '        Writing Target         ',00H
STRING$093:
	DB     '         Insert Target         ',00H
STRING$094:
	DB     '         Insert Source         ',00H
STRING$095 EQU $-1
	DB     '         UNKNOWN ERROR         ',00H
	DB     '           CRC ERROR           ',00H
	DB     '  MISSING BLOCK, ADJUST MEDIA  ',00H
	DB     '         MISSING MEDIA         ',00H
	DB     '        MISSING DRIVE          ',00H
	DB     '       WRITE PROTECTED         ',00H
	DB     '         DRIVE ERROR           ',00H
STRING$096:
	DB     '    Ignore, Abort or Retry     ',CR$,LF$
	DB     '          (I, A or R)          ',00H
STRING$097:
	DB     '       SOURCE',00H
STRING$098:
	DB     '       TARGET',00H
STRING$099:
	DB     ' BLOCK ERROR      '             ,CR$,LF$
	DB     ' Check Start, Number of Blocks ',CR$,LF$
	DB     '    or Drive specifications    ',00H
STRING$100:
	DB     '    File Manager not found!    ',00H
STRING$101:
	DB     '    Invalid drive selection    ',00H
STRING$102:
	DB     'PRINT FILE'                ,CR$,LF$,LF$
	DB     '     I -'                  ,CR$,LF$,LF$
	DB     '    II -'                  ,CR$,LF$,LF$
	DB     '   III - Line Length:'     ,CR$,LF$,LF$
	DB     '    IV - Left Margin:'     ,CR$,LF$,LF$
	DB     '     V -'                  ,CR$,LF$,LF$  
	DB     '    VI -'                  ,CR$,LF$,LF$
	DB     '   sVI - Escape Character:',00H
STRING$103:
	DB     CR$,LF$,LF$,LF$,' Unable to print ',00H
STRING$104:
	DB     CR$,LF$,LF$,LF$,LF$,LF$
STRING$105:
	DB     'Print',00H
	DB     'ing ',00H
STRING$106:
	DB     'to Screen       ',00H
STRING$107:
	DB     'to ADAM Printer ',00H
STRING$108:
	DB     'to Dev13 Printer',00H
STRING$108A:
	DB     'to Dev14 Printer',00H
STRING$109:
	DB     'Use Form-Feeds      ',00H
STRING$110:
	DB     'Pause at End of Page',00H
STRING$111:
	DB     'Continuous Printing ',00H
STRING$112:
	DB     'Single-Spaced',00H
STRING$113:
	DB     'Double-Spaced',00H
STRING$114:
	DB     'Near-Letter Quality',00H
STRING$115:
	DB     'Draft Quality      ',00H
;****************************************************************************
START_UP:
	LD       HL,I.3E43
	LD       DE,SEGMENT0
	LD       BC,XRAM_INIT_SIZE
	LDIR     
	CALL     XRAM_INIT
	LD       HL,I.3DE4
	LD       DE,SEGMENT0
	LD       BC,XRAM_COPY_SIZE
	LDIR     
	CALL     C.191C
	LD       BC,0000H
	CALL     WRITE_REGISTER
	LD       BC,01C0H
	CALL     WRITE_REGISTER
	LD       HL,0000H
	LD       A,02H    ; 2 
	CALL     INIT_TABLE
	LD       HL,0340H
	LD       A,04H    ; 4 
	CALL     INIT_TABLE
	LD       HL,0800H
	LD       A,03H    ; 3 
	CALL     INIT_TABLE
	LD       HL,3800H
	LD       A,01H    ; 1 
	CALL     INIT_TABLE
	LD       HL,3880H
	XOR      A
	CALL     INIT_TABLE
	LD       BC,LEN_VRAM_DATA_01
	LD       DE,3800H
	LD       HL,VRAM_DATA_01
	CALL     WRITE_VRAM
	LD       BC,LEN_VRAM_DATA_02
	LD       DE,3880H
	LD       HL,VRAM_DATA_02
	CALL     WRITE_VRAM
	CALL     C.1939
	CALL     C.1966
	LD       A,SPACE$
	LD       DE,0300H
	LD       HL,0000H
	PUSH     HL
	CALL     FILL_VRAM
	CALL     LOAD_ASCII
	POP      HL
	PUSH     HL
	LD       BC,0080H
	LD       DE,0C00H
	CALL     PUT_ASCII
	LD       BC,1F17H
	POP      HL
	LD       DE,0100H
	CALL     _CONS_INIT
	CALL     C.1FF8
	CALL     _START_RD_KBD

;;;this is the patch for _CONS_DISP
;;;it only works if native EOS-5 is in RAM
;;;omit for use with non-EOS-5
;;
;; wiped in FM017.ASM and above 9608.31
;;
;;        LD       HL,(D.F658)
;;        LD       BC,0DACDH
;;        OR       A
;;        SBC      HL,BC
;;        JR       NZ,J$3CB7
;;        LD       (D.F658),HL    ;wipes out CALL F7DA which
;;        LD       (D.F659),HL    ;displays underline cursor
;;
;;;end _CONS_DISP patch

;; added equivalent for use with EOS551.ASM and above

	LD      A,255
	LD      (PRINT_UNDERLINE_FLAG),A        ;flag that we shouldn't
						;print any underlines
;;; end patch  FM020.ASM  9609.01

J$3CB7:
	XOR      A
	LD       (HD_VOLCOUNT),A
	
;; removed search for Mini Wini HD  FM017.ASM 9608.31
;; we are assuming that an ADAMserve HD is present as TAPE_2
;; unfortunately, volume 0/block 0 does not include a unique HD identifier,
;; so we can't dynamically test for this.  We could go through the ANET2SERVER
;; table and look for a remapped TAPE_2; maybe I'll do that sometime later.
	
	
	LD      A,0F0H                  ;device=HD, volume 0
	LD      BC,0000H                ;block 0
	LD      DE,BUFF1                ;DTA
	CALL    READ_BLOCK_TONY         ;read volume 0/block 0
	JP      NC,_GOTO_WP             ;failed, so abort to SmartWriter
	LD      HL,BUFF1+9              ;point at # of HD volumes
	LD      A,(HL)                  ;get it
	LD      (HD_VOLCOUNT),A         ;save it
	LD      HL,BUFF1+10             ;point at partition table
	LD      DE,HD_VOL_DIRSIZE_TABLE ;where we want to copy it to
	LD      BC,0014H                ;length of hard drive partition table
	LDIR                            ;copy it

;check for floppy disks

	LD       HL,FLOPPY_DRIVE_COUNT
	LD       (HL),00H               ;wipe the initial floppy count
	LD       A,DISK_1
	CALL     CHECK_FOR_ADAMNET_DEVICE
	LD       A,DISK_2
	CALL     CHECK_FOR_ADAMNET_DEVICE
	LD       A,DISK_3
	CALL     CHECK_FOR_ADAMNET_DEVICE
	LD       A,DISK_4
	CALL     CHECK_FOR_ADAMNET_DEVICE

;check for tape drives

	LD       HL,TAPE_DRIVE_COUNT
	LD       (HL),00H               ;wipe the initial tape drive count
	LD       A,TAPE_1
	CALL     CHECK_FOR_ADAMNET_DEVICE

;; removed check for TAPE_2 FM019.ASM  9608.31
;;
;;        LD       A,TAPE_2
;;        CALL     CHECK_FOR_ADAMNET_DEVICE


;; deal with TAPE_3 and TAPE_4 sometime in future
;;
;;        LD       A,TAPE_3
;;        CALL     CHECK_FOR_ADAMNET_DEVICE
;;        LD       A,TAPE_4
;;        CALL     CHECK_FOR_ADAMNET_DEVICE

;; check for RAMdisk
;; finish RAMdisk stuff sometime later
;;
;;        LD      A,RAM_DISK
;;        CALL    CHECK_FOR_ADAMNET_DEVICE
;;

	LD       HL,VALID_DEVICE_TABLE  ;point at valid device table
	LD       A,00H                  ;get # of HD volumes
HD_VOLCOUNT   EQU      $-1
	LD       C,A                    ;into C
	OR       A                      ;any volumes?
	JR       Z,J$3D2B               ;no
	LD       B,A                    ;yes, so put count in B
	LD       A,0F0H                 ;11110000b 1111=HD, 0000=volume 0
J$3D26:
	LD       (HL),A                 ;save the HD device #
	INC      HL                     ;next slot
	INC      A                      ;next device #
	DJNZ     J$3D26                 ;keep going until done
J$3D2B:
	LD       A,(FLOPPY_DRIVE_COUNT) ;get number floppy drives
	OR       A                      ;are there any?
	JR       Z,J$3D3B               ;no
	LD       B,A                    ;yes, so save count in B
	ADD      A,C                    ;add number of HD volumes
	LD       C,A                    ;save final device count in C
	LD       A,DISK_1               ;start with disk 1
J$3D36:
	LD       (HL),A                 ;now write the floppy device #s
	INC      HL                     ;next slot in table
	INC      A                      ;next device #
	DJNZ     J$3D36                 ;keep going until done
J$3D3B:
	LD       A,00H                  ;get number of tape drives
TAPE_DRIVE_COUNT   EQU      $-1
	OR       A                      ;are there any tapes?
	JR       Z,J.3D4B               ;no
	INC      C                      ;yes, so increment device count
	LD       (HL),TAPE_1            ;save tape 1's ID
	INC      HL                     ;point to next slot
	DEC      A                      ;one less tape
					;there was a bug here in the original
					;FILEMAN:  it had DEC B  thus TAPE_2
					;was *ALWAYS* enabled!
	JR       Z,J.3D4B               ;no more tapes
	INC      C                      ;one more device
	LD       (HL),TAPE_2            ;save tape 2's ID
	INC      HL                     ;point to next
J.3D4B:
	XOR      A                      ;A=0
	LD       (HL),A                 ;mark end of table
	LD       A,C                    ;get total number of devices
	LD       (TOTAL_DEVICE_COUNT),A ;and save it
	LD       A,(SOURCE_1)
	DEC      A
	LD       (SOURCE_1),A
	LD       A,(DEST_1)
	DEC      A
	LD       (DEST_1),A
	CALL     CHANGE_SOURCE_DRIVE
D.3D62:
	CALL     CHANGE_DEST_DRIVE
	LD       A,(FLOPPY_DRIVE_COUNT)
	OR       A
	LD       B,A
	RET      Z
	LD       DE,FLOPPY_MAX_SIZES
	LD       A,(DE)
	OR       A
	RET      NZ
	CALL     CLS_PRINT_COPYRIGHT
	PUSH     DE
	LD       HL,STRING$003
	CALL     C.1FD3
	CALL     C.20A5
	POP      DE
	LD       A,31H                  ;"1"
	LD       (WHICH_DISK$),A
J.3D84:
	CALL     CLS_PRINT_COPYRIGHT
	LD       HL,STRING$005          ;"SELECT SIZE OF DISK"
	CALL     C.1FD3
	CALL     READ_KEYBOARD
	CP       ESC$
	RET      Z
	CP       CTRL_C$ 
	RET      Z
	SUB      81H
	JR       C,J.3D84
	CP       5                      ;changed FM019.ASM 9608.31 
					;for 5 choices for disk types
					;including 1200K and 1440K
	JR       NC,J.3D84
	INC      A
	LD       (DE),A
	INC      DE
	LD       A,(WHICH_DISK$)
	INC      A
	LD       (WHICH_DISK$),A
	DJNZ     J.3D84
	JP       J.1851
;****************************************************************************
;Check for ADAMnet Device.
;  On entry, A=device number, and HL=address of a count.  On exit, if the
;device exists, the count at (HL) is incremented.

CHECK_FOR_ADAMNET_DEVICE:
	PUSH    AF                      ;save device #
	CALL    _REQUEST_STATUS         ;get EOS device status
	JR      NZ,C_A_D_ERROR          ;failed, so error exit
	POP     AF                      ;restore device #
	PUSH    HL
	PUSH    AF
	CALL    _RD_DEV_DEP_STAT        ;get D_STATUS_FLAGS byte
	LD      L,A                     ;save it in L
	POP     AF                      ;restore device #
	CP      16                      ;is it a primary device?
	LD      A,L                     ;restore D_STATUS_FLAGS
	POP     HL                      ;restore count address
	JR      C,C_A_D_COMMON          ;yes
	SRL     A                       ;no, so move hi nibble to lo nibble
	SRL     A
	SRL     A
	SRL     A
C_A_D_COMMON:
	AND      0FH                    ;wipe hi nibble (the desired status is
					;in the lo nibble)
	CP       04H                    ;was it a non-existent drive?
	RET      Z                      ;yes, so we don't count this device
	INC      (HL)                   ;no, so one more count
	RET
;        -----------------
C_A_D_ERROR:
	POP     AF
	RET

;****************************************************************************
;****************************************************************************

;end of static code

;****************************************************************************
;****************************************************************************

;XRAM routines begin here.

I.3DE4:
.PHASE SEGMENT0
XRAM_WRITE_BLOCK:
	CALL     XRAM_RW_COMMON
	LD       HL,BUFF3                       ;data source
	LD       A,MEM_XRAM_RAM
	OUT      (MEMORY_SWITCH_PORT),A         ;switch to XRAM-RAM
	LD       DE,BLOCKSIZE                   ;this is evil:  XRAM_DTA=BLOCKSIZE by luck
	LD       B,D                            ;should be LD DE,XRAM_DTA
	LD       C,E                            ;LD BC,BLOCKSIZE
	LDIR                                    ;copy the block
	LD       A,MEM_RAM_RAM
	OUT      (MEMORY_SWITCH_PORT),A         ;back to regular RAM
	CALL     XRAM_RW_COMMON
	EX       DE,HL
	LD       A,MEM_XRAM_RAM
	OUT      (MEMORY_SWITCH_PORT),A         ;switch to XRAM-RAM
	LD       BC,XRAM_WRITE_RETURN           ;return address
	JP       XRAM_RESIDENT                  ;do the copy
;        -----------------
XRAM_READ_BLOCK:
	CALL     XRAM_RW_COMMON
	LD       BC,XRAM_READ_RETURN            ;return address
	LD       A,MEM_XRAM_RAM
	OUT      (MEMORY_SWITCH_PORT),A         ;switch to XRAM-RAM
	JP       XRAM_RESIDENT                  ;do the copy
;        -----------------
XRAM_READ_RETURN:
	LD       HL,BLOCKSIZE                   ;evil source address
	LD       DE,BUFF3                       ;data destination
	LD       B,H                            ;lucky count
	LD       C,L
	LDIR                                    ;copy the data
XRAM_WRITE_RETURN:
	LD       A,MEM_RAM_RAM
	OUT      (MEMORY_SWITCH_PORT),A         ;switch back to RAM-RAM
	XOR      A
	OUT      (XRAM_BANK_PORT),A             ;and back to XRAM bank 0
	RET      
;        -----------------
XRAM_RW_COMMON:
	XOR      A                              ;A=0
	LD       HL,(XRAM_BLOCK)                ;get block number to R/W
	LD       DE,003EH                       ;# of blocks per XRAM bank
XRAM_DIVIDE_LOOP:
	SBC      HL,DE                          ;62 less blocks
	INC      A                              ;one more XRAM bank
	JR       NC,XRAM_DIVIDE_LOOP            ;keep subtracting 'til done
	ADD      HL,DE                          ;add it back 'cause we went too far
	OUT      (XRAM_BANK_PORT),A             ;select desired XRAM bank
	LD       A,L                            ;A=block offset
	INC      A
	INC      A                              ;add 2 to skip system blocks
	RLA                                     ;*2
	RLA                                     ;*4
	AND      0FCH                           ;11111100  wipe rotated bits
	LD       H,A                            ;into H
	LD       L,00H                          ;thus HL=block*1024=byte offset
	LD       DE,BLOCKSIZE
	RET      
;        -----------------

XRAM_COPY_SIZE  EQU     $-XRAM_WRITE_BLOCK
.DEPHASE

;        -----------------
I.3E43:
.PHASE SEGMENT0
XRAM_INIT:
	LD       A,MEM_XRAM_RAM
	OUT      (MEMORY_SWITCH_PORT),A         ;do the bank switch
	LD       B,00H                          ;start at XRAM bank 0
J$3E49:
	LD       A,B                            ;XRAM bank to switch to
	OUT      (XRAM_BANK_PORT),A             ;do the switch
	OR       A                              ;clear CF
	LD       HL,(DBUF+6)                    ;look for magic number
	LD       DE,XRAM_MAGIC_NUMBER           ;it has to match this
	SBC      HL,DE                          ;does it match?
	JR       Z,J.3E86                       ;yes, so we already inited this XRAM bank
	LD       HL,DBUF+4                      ;no, so point to test byte
	LD       DE,BLOCKSIZE                   ;size of 1 block
	LD       C,05H                          ;check 5 blocks per bank
J$3E5F:
	LD       A,(HL)                         ;get my test byte

;this is the test code to see if there's a real XRAM

	XOR      55H                            ;01010101 change some bits
	LD       (HL),A                         ;try save it back
	CP       (HL)                           ;did it save? (i.e., is there XRAM?)
	JR       NZ,J.3E86                      ;no, so no XRAM here
	XOR      55H                            ;01010101 change some more bits
	LD       (HL),A                         ;try to save it back again
	CP       (HL)                           ;did it save?
	JR       NZ,J.3E86                      ;no, so no XRAM here

;end tests

	ADD      HL,DE                          ;yes, so offset to next block
	DEC      C                              ;one less block
	JR       NZ,J$3E5F                      ;keep going until done
	LD       HL,XRAM_MAGIC_NUMBER           ;get back the magic number
	LD       (DBUF+6),HL                    ;and store it in XRAM
	INC      B                              ;next XRAM bank (for next loop)
	LD       HL,XRAM_RESIDENT_SRC           ;source
	LD       DE,XRAM_RESIDENT               ;XRAM destination
	LD       A,B                            ;save XRAM bank
	LD       BC,XRAM_RESIDENT_LEN           ;code length
	LDIR                                    ;copy driver to XRAM
	LD       B,A                            ;restore B=next XRAM bank
	JR       J$3E49                         ;and keep going until done
;        -----------------
J.3E86:
	LD       A,B                            ;save last XRAM bank found
	LD       HL,0000H                       ;big zero
	OR       A                              ;did we find any XRAM at all?
	JR       Z,J$3E97                       ;no, so skip
J$3E8D:
	OUT      (XRAM_BANK_PORT),A             ;select an XRAM bank
	LD       (DBUF+6),HL                    ;wipe our magic number
	DEC      A                              ;one less bank
	CP       0FFH                           ;are we done?
	JR       NZ,J$3E8D                      ;no, so keep wiping
J$3E97:
	LD       A,MEM_RAM_RAM
	OUT      (MEMORY_SWITCH_PORT),A         ;back to RAM-RAM configuration
	LD       A,B                            ;restore A=highest XRAM bank
	OR       A                              ;any XRAM found?
	JR       Z,J$3EA5                       ;no, so skip
	LD       DE,003EH                       ;yes, so DE=62 (# of blocks per XRAM bank)
J$3EA2:
	ADD      HL,DE                          ;calculate highest block number
	DJNZ     J$3EA2                         ;keep going 'til done
J$3EA5:
	LD       DE,0020H                       ;DE=32 (# of blocks in RAM)
	ADD      HL,DE                          ;add it in to total
	LD       (D.2965),HL                    ;save total
	RET      
;        -----------------
;XRAM driver code.  Copied to every bank of XRAM at address 256.
;On entry, BC=return address in RAM (must be 32768-65535), HL=XRAM source
;address, DE=XRAM buffer destination address.  On exit, memory is in the
;XRAM-RAM configuration, and the desired block of data has been copied to
;the XRAM transfer buffer.

XRAM_RESIDENT_SRC:
	LD       A,MEM_XRAM_XRAM
	OUT      (MEMORY_SWITCH_PORT),A         ;do the bank switch
	LD       (DBUF),BC                      ;save our return address
	LD       BC,BLOCKSIZE                   ;size of block in bytes
	LDIR                                    ;copy the block
	LD       HL,(DBUF)                      ;get back our return address
	LD       A,MEM_XRAM_RAM
	OUT      (MEMORY_SWITCH_PORT),A         ;switch to XRAM-RAM
	JP       (HL)                           ;return to our app code

XRAM_RESIDENT_LEN       EQU     $-XRAM_RESIDENT_SRC
;        -----------------
XRAM_INIT_SIZE  EQU     $-SEGMENT0
.DEPHASE

	DS       (16384+256-$)

;***************************************************************************
;***************************************************************************

;now tell us about SEGMENT0

IF2

	IF DO_CALC_SEGMENT0

		.PRINTX Actual value of SEGMENT0 to use is:
		PRINTX %SEGMENT00
		.RADIX 16
		PRINTX %SEGMENT00
		.PRINTX Please reassemble using this value.

	ELSE

		.PRINTX Assembly with correct SEGMENT0 complete!
		PRINTX %SEGMENT0
		.RADIX 16
		PRINTX %SEGMENT0

	ENDIF

ENDIF

;***************************************************************************
;***************************************************************************

END
