
int writeSector(int,int,int,unsigned char*);
int writeBlock(int,unsigned char*);

/****************************************************************
* writeSector - returns 0 if OK, error # if error
****************************************************************/
int writeSector(track,sector,head,buffer)
	int	track;
	int	sector;
	int	head;
	unsigned char *buffer;
{
	int	eCount;
	int	result;

	eCount=3;
	do {
		result=biosdisk(BDWRITE,FLOPPY1,head,track,sector,ONESECTOR,buffer);
		eCount--;
	} while(result && eCount);
	return(result);
}



/*****************************************************
* WriteBlock - writes 1 block of data to the ADAM disk
*	      blockNum is which block to write
*	      buffer contains data
*	      Returns 0 if OK, otherwise error number
*
*     Note: blocks are composed of 2 512 byte sectors.
*	    Each block's sectors are 5 sectors apart and
*	    1 sector seperates the block from the next.
*	    ie block 0 uses sectors 1 and 6, block 1
*	    uses sectors 3 and 8.
*****************************************************/
writeBlock(blockNum,buffer)
	int		blockNum;
	unsigned char	*buffer;
{
	int	sector;
	int	track;
	int	head;
	int	result;

	track=blockNum/4;	    	    /* 4 blocks per track */
	if(track>39) {
		head=HEAD1;                       /* higher tracks on side 2 */
		track-=40;
	}
	else
		head=HEAD0;

	sector=((blockNum % 4)*2)+1;         /* blocks start on odd sectors */

	result=writeSector(track,sector,head,buffer);
	if (result)
		return(result);

	sector+=5;                  /* compute second sector of block */
	if(sector>8)
		sector-=8;

	return(writeSector(track,sector,head,buffer+512));
}

