/************************************************************
* Converts a SmartWriter file
* to a plain ASCII file.
*************************************************************
* 1.00	12/1/94	Chris Braymen	Creation under Borland C 3.1
*************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define	CR	0x0D
#define	LF	0x0A
#define	FF	0x0C
#define 	TRUE	1
#define 	FALSE	0

// Prototypes
int  processWordWrap(FILE*);
void startNewLine(void);

char	tempFileName[]="xxxcbxxx.tmp";
char	version[]="1.00";

char	lineBuffer[255];
int	leftMargin,rightMargin;
int	curPosition;
int	lastSpace;

main(argc,argv)
	int	argc;
	char	**argv;
{
	char	inChar;
	FILE	*inFile;
	FILE	*outFile;
	char	*inFileName;
	int	headerSize,i;

	if (argc!=2) {
		printf("SW2TEXT %s - Public Domain from Bonafide Systems\n",version);
		puts("\nUsage: SW2TEXT <infile>");
		puts("Converts a SmartWriter file to a DOS text file.");
		exit(0);
	}
	inFileName=*(argv+1);	/* get ptr to second argument */

	if((inFile=fopen(inFileName,"rb")) == NULL) {
		printf("Error opening input file: %s\n",inFileName);
		exit(0);
	}

	headerSize=getc(inFile);
	headerSize=getc(inFile)*256;
	if(getc(inFile) != 1) {		/* SW ID byte */
		puts("Not a SmartWriter file!");
		exit(0);
	}

	getc(inFile);  /* skip top margin */
	getc(inFile);  /* and bottom margin */
	leftMargin=getc(inFile);
	rightMargin=getc(inFile);

	for(i=4;i<headerSize;i++) {     /* skip by rest of header */
		if(getc(inFile)==EOF) {
			puts("Error reading SmartWriter file");
			exit(0);
		}
	}

	if((outFile=fopen(tempFileName,"wb")) == NULL) {
		printf("Error opening temporary output file: %s\n",tempFileName);
		fclose(inFile);
		exit(0);
	}

	puts("Processing...");
	startNewLine();
	while((inChar=getc(inFile)) != EOF) {
		inChar &= 0x7F;
		if(inChar == CR || inChar == FF) {
			if(fputs(lineBuffer,outFile)==EOF) {
			   puts("Error writing file");
				fclose(outFile);
			   unlink(tempFileName);
			   exit(0);
			}
			putc(CR,outFile);
			putc(LF,outFile);
			startNewLine();
		}
		else  {
			if(inChar>=' ') {
				if(inChar==' ')
					lastSpace=curPosition;
				lineBuffer[curPosition]=inChar;
				if(curPosition>rightMargin) {
					if(!processWordWrap(outFile))
						exit(0);
				}
				else {
					curPosition++;
				}
		   }
		}
	}

	fclose(inFile);
	fclose(outFile);

	if(unlink(inFileName)) {
		printf("Error deleting source file: %s\n",inFileName);
		unlink(tempFileName);
		exit(0);
	}
	if(rename(tempFileName,inFileName)) {
		printf("Error renaming temp file to %s\n",inFileName);
		unlink(tempFileName);
		exit(0);
	}
	puts("Complete.");
	return(0);
}

/*****************************************************
* startNewLine - NULLS out buffer, sets up new margin
*****************************************************/
void startNewLine() {
   int	i;

   for(i=0;i<255;i++)
      lineBuffer[i]='\0';

   for(curPosition=0;curPosition<leftMargin;curPosition++)
      lineBuffer[curPosition]=' ';

   lastSpace=rightMargin;	/* if there is no space, break the line
										at the right margin */
}


/*****************************************************
* processWordWrap
******************************************************/
processWordWrap(outFile)
	FILE	*outFile;
{
	char	tempBuf[255];
	char	*p1;

	strcpy(tempBuf,lineBuffer+lastSpace+1);	/* save wrap string */
	lineBuffer[lastSpace+1]='\0';
	if(fputs(lineBuffer,outFile)==EOF) {
	   puts("Error writing file");
		fclose(outFile);
	   unlink(tempFileName);
	   return(FALSE);
	}
	putc(CR,outFile);
	putc(LF,outFile);
	startNewLine();

	p1=tempBuf;
	while(*p1) {		/* copy wrap back to buffer */
	   lineBuffer[curPosition] = *p1;
		p1++;
	   curPosition++;
	}
	return(TRUE);
}

