/************************************************************
*  Dump a group of ADAM blocks to a PC file
*************************************************************
* 1.00	12/1/94	Chris Braymen	Creation under Borland C 3.1
*************************************************************/

#define TRUE	1
#define FALSE 	0
#define BUFSIZE		1024

#define	BDRESET	   0x00
#define	BDSTATUS    0x01
#define	BDREAD	   0x02
#define	BDWRITE	   0x03
#define	BDVERIFY    0x04
#define	BDFORMAT    0x05

#define	FLOPPY1	   0x00
#define	HEAD0	      0x00
#define 	HEAD1			0x01
#define	ONESECTOR	0x01



#include	<stdio.h>
#include <stdlib.h>
#include	<string.h>
#include	<bios.h>
#include	<ctype.h>
#include	"adamfcb.h"

unsigned char	buffer[BUFSIZE];
int		startBlock;
int		numberBlocks;
char		outFileName[255];

char version[] = "v1.00";

/*******************
* Prototypes
*******************/
int processArgs(int,char**);
int copyBlocks(int,int,FILE*);


#include	"readblk.c"

int main(argc,argv)
	int	argc;
	char	*argv[];
{
	int	block;
	int	result;
	FILE	*outFileP;

	if(!processArgs(argc,argv)) {
		exit(0);
   }

	if((outFileP=fopen(outFileName,"wb"))==NULL) {
		fprintf(stderr,"Error opening output file: %s\n",outFileName);
		exit(0);
	}

	result=copyBlocks(startBlock,numberBlocks,outFileP);
	fclose(outFileP);
	if(!result) {
		unlink(outFileName);
		fprintf(stderr,"Output file deleted.\n");
	}
	return 0;
}

/*******************************************************
* processArgs - process the command line args
*		sets global blockNumber
********************************************************/
int processArgs(argc,argv)
	int	argc;
	char	*argv[];
{
	if(argc != 4) {
		printf("BLK2FILE %s - Public Domain from Bonafide Systems\n\n",version);
		printf("\nUsage: BLK2FILE <Start block><Number blocks><filename>\n\n");
		return(FALSE);
	}

	startBlock=atoi(argv[1]);
	if(startBlock<0 || startBlock > 319) {
		fprintf(stderr,"Bad starting block: %d\n",startBlock);
		return(FALSE);
	}

	numberBlocks=atoi(argv[2]);
	if(numberBlocks<1 || numberBlocks > 320-startBlock) {
		fprintf(stderr,"Bad number of blocks: %d\n",numberBlocks);
		return(FALSE);
	}

	strcpy(outFileName,argv[3]);
	return(TRUE);
}


/*********************************************************
* copyBlocks
*********************************************************/
int copyBlocks(start,number,fp)
	int	start;
	int	number;
	FILE	*fp;
{
	int	i;

	printf("Processing...\n");
	for(i=start;i<start+number;i++) {
		printf("\r%d",i);
		if(readBlock(i,buffer)) {
			fprintf(stderr,"\nError reading block %d\n",i);
			return(FALSE);
		}
		if(fwrite(buffer,1,1024,fp)!=1024) {
			fprintf(stderr,"\nError writing file\n");
			return(FALSE);
		}
	}
	return(TRUE);
}




