*Sydmodem interface routines
*Written July 24, 88
*Syd Carter
*This overlay supports many rouitnes to 
*configure the Sydmodem 1200 to most everyday
*applications.  A Mini terminal program has
*been included to help facilitate understanding
*of the individual routines.
*This file is Public Domain.  However it is
*not intended as a spring board to a commercial
*product and cannot be used as such except by 
*explicit permission granted by
*Trisyd Video Games
*Contact 26 Florence Cres,
*Toronto, Ontario.
*Canada  M6N 4E4.
*---  Do not alter this file in anyway without
*---  Permission from Trisyd Video Games.
*-----------------------------
*This program was written with the basic
*programmer in mind.  All routines have
*parameters passed through specific memory
*locations. If the compiled version is
*supposed to be "BLOAD" able, then the
*Asterisk "*" should be removed from the
*Line just after the PGM statement.
*This source code was written to take advantage
*of the MACADAM assembler pgm.
*
	PGM	#6D60	;Change to suit.
*Add -5 after PGM address if using bload
*BLOAD	DATA	1,0,2
*	DW	TESTOV
DATAP	EQU	#58	;data port
CTRLP	EQU	DATAP+5	;status
RCVB	EQU	1	;receive bit
RCVR	EQU	1	;receive rdy
SNDB	EQU	#20	;send bit
SNDR	EQU	#20	;send rdy
C_PEND	EQU	1	;Character pending flag
XMTRE	EQU	#20	;Transmitter buffer empty
CDSTAT	EQU	#80	;carrier detect bit
CD_ON	EQU	#80	;carrier detect 
ONLINE	EQU	1	;modem online via carrier
OFLINE	EQU	0	;modem offline via carrier
RINGB	EQU	#40	;ring bit
RINGR	EQU	#40	;ring rdy
BUFLEN	EQU	#1F	;buffer length
B300	EQU	1	;300 baud
B1200	EQU	0	;1200 baud
SUCCES	EQU	0	;sucessful xmit flag
FAIL	EQU	1	;failure xmit flag
C_NPND	EQU	0	;Character not pending flag.
*Word size equates
DB7	EQU	0	;7 data bits
DB8	EQU	1	;8 data bits
NP	EQU	0	;No parity
EP	EQU	#18	;Even parity
OP	EQU	#28	;odd parity
ST1	EQU	0	;1 stop bit
ST2	EQU	4	;2 stop bits
*Terminal Program for testing
*Overlay workings
TESTOV	JP	TERPGM
*Jump, Peeks & Pokes table
WHERET	DW	DATBLE
*Xmit data Routine.  Used to indicate if the 
*modem can accept new character for
*transmission and if so, send it.
**Input:  CTLBUF location
*poke data into CTLBUF for transmittransmit
*Output:  CTLBUF location
*if successfully transferred, peek =0
*if unsuccessful, peek =1
XMIT	PUSH	AF
	PUSH	HL
	IN	A,(CTRLP)
	AND	SNDB
	CP	SNDR
	JR	Z,THRE
THRF	LD	A,FAIL
	LD	(CTLBUF),A
	JP	EXITXM
THRE	LD	A,(MDWCHR)
	OUT	(DATAP),A
	LD	A,SUCCES
	LD	(CTLBUF),A
EXITXM	POP	HL
	POP	AF
	RET
*Check Buffer Routine:
*Checks character buffer to determine if the
*modem has placed a character there for us to
*read. Preserves registers
*Input: None
*Output: CTLBUF location. 
*        0- Buffer empty.
*        1- Buffer not empty.
CHKBUF	PUSH	AF
	PUSH	HL
	LD	HL,WRPOS
	LD	A,(RDPOS)
	CP	(HL)
	JR	Z,SETNT1
SET1	LD	A,C_PEND
	JR	EXITCH
SETNT1	LD	A,C_NPND
EXITCH	LD	(CTLBUF),A
	POP	HL
	POP	AF
	RET
*Parameter Configuration:
*Takes Data bits, Parity and Stop bit
*information from data table.  Interrupt is 
*always on when character comes in.
*The speed is set to 1200 baud yet will shift
*down to 300 if incoming call is so.
*Call this routine to reset max speed to 1200.
*NOTE: THIS ROUTINE SHOULD NOT BE CALLED UNTIL
*THE INTERRUPT HANDLING ROUTINE.
PARMS	PUSH	AF
	PUSH	HL
	DI
BAUD	LD	A,#82
	OUT	(DATAP+3),A
	OUT	(DATAP+3),A
LOWSP	LD	A,(LOWSPD)
	OUT	(DATAP),A
HISP	LD	A,(HISPD)
	OUT	(DATAP+1),A
DATABT	LD	A,(DATAB)
PARITY	LD	HL,PAR
	ADD	A,(HL)
STOPBT	LD	HL,STB
	ADD	A,(HL)
WORD	OUT	(DATAP+3),A
INT_ON	LD	A,1
	OUT	(DATAP+1),A
DTR_ON	LD	A,9
	OUT	(DATAP+4),A
	POP	HL
	POP	AF
	IM	1
	EI	;I hope you read the warning!
	RET
*---- Modem interrupt off ----
*Puts modem offline so other programs won't
*get affected by it's interrupt capability
*Input: None
*Output: None
*Preserves registers, modem requires 
*parameters reset before going online after 
*issuing this call
OFFINT	PUSH	AF
	DI
	LD	A,0
	OUT	(DATAP+1),A
	EI
	POP	AF
	RET
*Interrupt routine:
*Modem read through interrupt generated.
*Preserves registers.  Do not call this, it is
*Already set up elsewhere.
INTRTN	PUSH	AF
	IN	A,(CTRLP)
	AND	RCVB
	CP	RCVR
	JR	NZ,EXITIN
*Valid Data
	PUSH	HL
	PUSH	DE
	LD	HL,CBUF
	LD	A,(WRPOS)
	LD	D,0
	LD	E,A
	ADD	HL,DE
GETCHR	IN	A,(DATAP)
	LD	(HL),A
ADJWPS	LD	A,(WRPOS)
	INC	A
	AND	BUFLEN
	LD	(WRPOS),A
	POP	DE
	POP	HL
EXITIN	IN	A,(DATAP)
	POP	AF
	EI
	RETI
*Read buffer routine:
*Call this to read the characters pending in
*buffer as indicated by CHKBUF routine.
*Registers preserved
*Input: NONE
*Output: Character in MDMCHR storage location
*
RDBUF	DI
	PUSH	AF
	PUSH	DE
	PUSH	HL
	LD	A,(RDPOS)
	LD	D,0
	LD	E,A
	LD	HL,CBUF
	ADD	HL,DE
ADJRPS	INC	A
	AND	BUFLEN
	LD	(RDPOS),A
GET_IT	LD	A,(HL)
	LD	(MDRCHR),A
	POP	HL
	POP	DE
	POP	AF
	EI
	RET
*Carrier detect:
*Places a 1 in CD storage location if carrier.
*present, a zero if not
Registers preserved
*Input: None
*Output: CD storage location value
*
CD_DET	PUSH	AF
	PUSH	HL
	IN	A,(CTRLP+1)
	AND	CDSTAT
	CP	CD_ON
	JR	NZ,NO_CD
YES_CD	LD	A,ONLINE
	JR	EXITCD
NO_CD	LD	A,OFLINE
EXITCD	LD	(CD),A
	POP	HL
	POP	AF
	RET
*Hang Up:
*Input: None
*Output: None
*Preserves registers, Preforms Dtr drop.
HANGUP	DI
	PUSH	AF
	LD	A,0
	OUT	(DATAP+4),A
	CALL	DELAY
	LD	A,9
	OUT	(DATAP+4),A
	POP	AF
	EI
	RET
*Delay:
*Preforms a 10ms delay to allow the dropping 
*of DTR to take effect.
*Input: None
*Output: None
*Preserves registers
DELAY	PUSH	AF
	PUSH	BC
	PUSH	DE
	PUSH	HL
	LD	HL,0
	LD	DE,0
	LD	BC,#1590
	LDIR
	POP	HL
	POP	DE
	POP	BC
	POP	AF
	RET
*Data buffers and storage location area.
*Referenced by a jump table below
WRPOS	DATA	0
RDPOS	DATA	0
CBUF	DS	BUFLEN+1
MDRCHR	DATA	0
MDWCHR	DATA	0
CTLBUF	DATA	0
CD	DATA	0
RD	DATA	0
DATAB	DATA	DB8	;8 data bits
PAR	DATA	NP	;no parity
STB	DATA	ST1	;1 stop bit
HISPD	DATA	B1200	;1200 baud
LOWSPD	DATA	B300	;300 baud
*This area is a jump table that points 
*to the various tables and buffers
*used through out the overlay.  The address of
*This table is located in the fourth byte of
*This overlay. It was done so in order to
*allow it's deletion in the event the memory
*it takes up is too demanding.
*------Jump Table-----------
DATBLE	DW	TESTOV	;Start of overlay
	DW	END_OV	;end of overlay
	DW	END_TP	;end of terminal pgm
	DW	PARMS	;Init modem settings
	DW	CD_DET	;carrier detect
	DW	HANGUP	;Hang up
	DW	CHKBUF	;Check character pending
	DW	RDBUF	;Read character from buf.
	DW	XMIT	;Transmit character
	DW	RINGDT	;Ring Detect
	DW	INTHDR	;Interrupt vector load
	DW	DELAY	;10ms delay
*---- Peek table ----
	DW	MDRCHR	;Chr read from buffer.
	DW	CTLBUF	;Status for send/ recv
	DW	CD	;carrier detect
	DW	RD	;ring detect
*---- Poke table ----
	DW	MDWCHR	;Chr sent to modem.
	DW	DATAB	;Data bits
	DW	PAR	;Parity
	DW	STB	;Stop bits
	DW	HISPD	;High speed for modem
	DW	LOWSPD	;Low speed for modem
*Ring Detect:
*Use to detect incoming calls if so desired
*It is being placed at the end because it
*can be handled by the modem and all the
*terminal programmer need do ischeck for
*carrier to tell if someone is online.
*Registers preserved:
*Input: None
*Output: RD 1 if ring, 0 no ring
RINGDT	PUSH	AF
	PUSH	HL
	IN	A,(CTRLP+1)
	AND	RINGB
	CP	RINGR
	JR	NZ,NORING
YESRNG	LD	A,1
	JR	EXITRI
NORING	LD	A,0
EXITRI	LD	(RD),A
	POP	HL
	POP	AF
	RET
*Interrupt Handler routine:
*Sets Vector at location #38 to point to
*modem interrupt driven read routine.
*This pgm need only be called once so it
*has been placed at the end of this overlay
*in order that the user can reuse the memory.
*Input: None
*Output: None, Registers preserved
INTHDR	PUSH	AF
	PUSH	HL
*---- Keep interrupt off until modem is
*installed or expect weird results
	DI	;Disable interrupt
	LD	HL,INTRTN
	LD	(#39),HL
	LD	A,#C3
	LD	(#38),A
	POP	HL
	POP	AF
END_OV	RET
*-----------------------------
*Mini Terminal Program.
*Follow the sequence of events here in
*order to gain detailed information leading
*up to proper initialization and use of 
*the Sydmodem 1200.
*
WIZ	EQU	#FCE7	;Smart writer
CONOUT	EQU	#FC39	;Console output
CONINT	EQU	#FC36	;Console init
WVDPR	EQU	#FD20	;Write VDP register
RESCHR	EQU	#FD38	;Load ascii to VDP
VDPT	EQU	#FD29	;Init Vram table
FILLV	EQU	#FD26	;Fill Vram
CR	EQU	#0D	;Carriage return
LF	EQU	#0A	;Linefeed
KBSRD	EQU	#FCA8
KBERD	EQU	#FC4B
EOT	EQU	3	;End of text
INTBON	EQU	1	;Receive data interrupt bit
*---- Key codes ---- 
SK1	EQU	129	;Smart key 1
SK2	EQU	SK1+1	;Smart key 2
SK3	EQU	SK1+2	;Smart key 3
SK4	EQU	SK1+3	;Smart key 4
SK5	EQU	SK1+4	;Smart key 5
SK6	EQU	SK1+5	;Smart key 6
ESC	EQU	27	;Escape key
WCARD	EQU	144	;Wild card
*--- Terminal Source ---
TERPGM	CALL	INTHDR
INITMD	CALL	PARMS	;set 8n1
*now clear modem of any garbage
INTKBD	CALL	KBSRD	;Start reading Keyboard
CLRMDM	CALL	CHKBUF
	LD	A,(CTLBUF)
	CP	C_PEND
	JR	NZ,SETSPC
	CALL	RDBUF
	JR	CLRMDM
*Set Special:
*Turn on my preferences which are dialtone and
*busy signal detect on
SETSPC	LD	HL,SPCCMD
SETSP1	LD	A,(HL)
	CP	EOT
	JR	Z,VIDEO
	LD	(MDWCHR),A
	CALL	XMIT
	LD	A,(CTLBUF)
	CP	SUCCES
	JR	NZ,SETSP1
	INC	HL
	JR	SETSP1
SPCCMD	ASC	'ATX4'
	DATA	CR,EOT
*------  32 cloumns Video ---
*Delete if your basic program
*is configured to 40 columns since this is
*not setto other than 32.  It has been
*set up to use the Basic table set up
*so you can leave it in with ill effect
*if your using standard 32 columns in basic
VIDEO	LD	BC,0000
	CALL	WVDPR
* Graphics 1 mode 
	LD	BC,#01C0
	CALL	WVDPR
* Background Color YELLOW
	LD	BC,#070A
	CALL	WVDPR
* Sprite Table
	LD	A,0
	LD	HL,#3800
	CALL	VDPT
*Zero sprites
	LD	A,#D0
	LD	DE,#FF
	LD	HL,#3800
	CALL	FILLV
*Set Pattern Name Table
	LD	A,2
	LD	HL,#1800
	CALL	VDPT
*Set Pattern Gen Table
	LD	A,3
	LD	HL,#00
	CALL	VDPT
*Load ascii into pattern gen table
	LD	HL,0
	CALL	RESCHR
*Color table of the Gen
	LD	A,4
	LD	HL,#2000
	CALL	VDPT
*Color Character Set 
*Lower 128 characters are black with yellow
	LD	A,#1A
	LD	DE,#10
	LD	HL,#2000
	CALL	FILLV
*Upper 128 characters are yellow with black.
	LD	A,#A1
	LD	DE,#10
	LD	HL,#2010
	CALL	FILLV
*Now set console window
	LD	BC,#1D16
	LD	DE,#0200
	LD	HL,#1800
	CALL	CONINT
*------------------------
INSTR	CALL	D_INST	;Initial key overlay
MAIN	CALL	KBINSP
	JR	NC,MAIN1
	CP	ESC
	JP	Z,EXITMP	;EXIT TO BASIC ?
	LD	(MDWCHR),A
	CALL	XMIT
MAIN1	CALL	CHKBUF
	LD	A,(CTLBUF)
	CP	C_PEND
	JR	NZ,MAIN
	CALL	RDBUF
	LD	A,(MDRCHR)
	CALL	CONOUT
	JP	MAIN
INIT03	PUSH	AF
	LD	A,B300
	LD	(HISPD),A
	CALL	PARMS
	POP	AF
	CALL	D_INST
	RET
INIT12	PUSH	AF
	LD	A,B1200
	LD	(HISPD),A
	CALL	PARMS
	POP	AF
	CALL	D_INST
	RET
KBINSP	CALL	KBERD	;End read keyboard
	RET	NC
	PUSH	AF
	CALL	KBSRD
	POP	AF
*Special keys
SPCKYS	CP	WCARD
	CALL	Z,HANGUP
	CALL	Z,D_INST
	CP	SK1
	CALL	Z,OFFINT
	CALL	Z,D_INST
	CP	SK2
	CALL	Z,PARMS
	CALL	Z,D_INST
	CP	SK3
	CALL	Z,D_INST
	CP	SK4
	CALL	Z,INIT03
	CP	SK5
	CALL	Z,INIT12
	CP	SK6
	CALL	Z,WHOIAM
	RET
*Parameter change notifier
D_INST	PUSH	AF
	PUSH	HL
	LD	A,CR
	CALL	CONOUT
	LD	HL,INSMSG
	CALL	SCNPRT
	LD	A,(HISPD)
	CP	B1200
	JR	Z,SAY12
SAY3	LD	HL,MSG03
	JR	SBAUD
SAY12	LD	HL,MSG12
SBAUD	CALL	SCNPRT
SONLIN	CALL	CD_DET
	LD	A,(CD)
	CP	ONLINE
	JR	Z,SAY_ON
SAY_OF	LD	HL,OFLMSG
	JR	SAY_CD
SAY_ON	LD	HL,ONLMSG
SAY_CD	CALL	SCNPRT
SINTST	IN	A,(DATAP+1)
	BIT	0,A
	CP	INTBON
	JR	Z,SAYION
SAYIOF	LD	HL,INOFMS
	JR	SAYINT
SAYION	LD	HL,INONMS
SAYINT	CALL	SCNPRT
	POP	HL
	POP	AF
	RET
INSMSG	DATA	CR,LF,LF
	ASC	'Trisyd Video Games Terminal'
	DATA	CR,LF
	ASC	'tester for Sydmodem Overlay '
	DATA	CR,LF
	ASC	'Release date 07/30/88'
	DATA	CR,LF,LF
	ASC	'The following keys are'
	DATA	CR,LF
	ASC	'supported :'
	DATA	CR,LF,LF
	ASC	'Escape    : Exit program.'
	DATA	CR,LF
	ASC	'Wild Card : Hang up.'
	DATA	CR,LF
	ASC	'SmartKey 1: Mdm Interrupt off'
	DATA	CR,LF
	ASC	'SmartKey 2: Mdm Interrupt on'
	DATA	CR,LF
	ASC	'SmartKey 3: Display this Msg'
	DATA	CR,LF
	ASC	'SmartKey 4: 300 baud init'
	DATA	CR,LF
	ASC	'SmartKey 5: 1200 baud init'
	DATA	CR,LF
	ASC	'SmartKey 6: Who is Trisyd?'
	DATA	CR,LF,LF
	ASC	'Configured at 8 data bits, '
	DATA	CR,LF
	ASC	'No parity/ 1stopbit/'
	DATA	EOT
MSG03	ASC	'300 Baud'
	DATA	CR,LF,EOT
MSG12	ASC	'1200 Baud'
	DATA	CR,LF,EOT
WHOIAM	PUSH	HL
	LD	HL,WHOMSG
	CALL	SCNPRT
	POP	HL
	RET
WHOMSG	DATA	CR,LF,LF
	ASC	'I am Trisyd Video Games'
	DATA	CR,LF
	ASC	'I design and manufacture'
	DATA	CR,LF
	ASC	'Adam computer parts.'
	DATA	CR,LF
	ASC	'Why not request a catalog'
	DATA	CR,LF
	ASC	'Contact me at:'
	DATA	CR,LF
	ASC	'26 Florence Cres,'
	DATA	CR,LF
ASC	'Toronto, Ontario.'
	DATA	CR,LF
	ASC	'Canada  M6N 4E4'
	DATA	CR,LF
	ASC	'Phone (416) 769-6446'
	DATA	CR,LF,LF,EOT
OFLMSG	ASC	'No carrier present'
	DATA	CR,LF,EOT
ONLMSG	ASC	'Carrier detected'
	DATA	CR,LF,EOT
INONMS	ASC	'Modem interrupt enabled'
	DATA	CR,LF,EOT
INOFMS	ASC	'Modem interrupt disabled'
	DATA	CR,LF,EOT
*Screen Print:
*Places text on screen without going to modem
SCNPRT	PUSH	AF
	PUSH	HL
LOADCH	LD	A,(HL)
	CP	EOT
	JR	Z,EXITSC
	CALL	CONOUT
	INC	HL
	JR	LOADCH
EXITSC	POP	HL
	POP	AF
	RET
EXITMP	JP	WIZ	;Replace with a RET to get
*back into basic if called from there.
END_TP	NOP
	END
 