5TEXT
10GOSUB 1000
20REM     ** HPLOT DRAWING SYSTEM**
30REM     by John Mesiavech
40REM     program for Coleco SmartBASIC V1.0
50GOSUB 8000:REM   initialization
55SCALE =1:HCOLOR =3:DRAW 1 AT x, y
60VTAB 21:? "Move cursor to starting point."
70VTAB 22:? "Move cursor w/joystick"
75VTAB 23:? "Press side button to draw."
80 d=PDL(5)
90IF d=6 THEN  d=d-1
100IF d=8 OR d=9 THEN  d=d-2
110IF d=12 THEN  d=d-4
120 s1=PDL(7): s2=PDL(9)
130IF s1 OR s2 THEN 2800
140ON d GOSUB 2000, 2100, 2200, 2300, 2400, 2500, 2600, 2700
150GOTO 60
1000REM   instructions
1005HOME
1010VTAB 10:? TAB(3); "** HPLOT DRAWING SYSTEM **"
1020VTAB 12:? "Do you want instructions? (y/n) ":GET k$
1030IF k$="n" OR k$="N" THEN RETURN
1040HOME:? TAB(5); "This is a drawing system to "; 
1050? "create drawings using HPLOT "; 
1060? "commands.  The joystick is used "; 
1070? "to move the square cursor around the screen.  Once you "; 
1080? "have placed the cursor where you want to draw, press either side "; 
1090? "button on the controller.  If you want to draw your drawing in white, "; 
1100? "press Key I to begin drawing.  Move the cursor as before, and it will leave a white line"; 
1110? " behind it.  To change color or to stop drawing, press the side buttons."
1120?:?:? "Press any key to continue.":GET k$
1130HOME:? TAB(5); "This will return you to the menu, where you can change the color by "; 
1140? " pressing Key II.  This will change the screen to a color menu.  Choose the color you want "; 
1150? " by inputting the color's number.  This will automatically "; 
1160? "return you to the drawing screen, where you will be able to start where you left off before."; 
1170?:?:? "Press any key to continue.  ":GET k$
1180HOME:? TAB(5); "To stop the program, press Key III when the menu is displayed."; 
1190? "  This will print out a list of the HPLOT coordinates and colors used, so that you "; 
1200? "can recreate any drawing that you have made.  Control-C will always abort this program, "; 
1210? "and pressing the CLEAR key will clear the screen and all coordinates from memory.  "; 
1220? "Pressing the PRINT key when the menu is displayed is the same as pressing Key III."
1230?:?:? "Press <e> to stop now, or any other key to start drawing.  ":GET k$
1240IF k$="e" OR k$="E" THEN HOME:? TAB(8); "HAVE A GOOD ONE!!":END
1250RETURN
2000 x1=x: y1=y-3:IF y1<=3 THEN  y1=y
2010XDRAW 1 AT x, y:HCOLOR =6:DRAW 1 AT x1, y1: x=x1: y=y1
2020RETURN
2100 x1=x+3: y1=y:IF x1>=250 THEN  x1=x
2110XDRAW 1 AT x, y:HCOLOR =6:DRAW 1 AT x1, y1: x=x1: y=y1
2120RETURN
2200 x1=x+3: y1=y-3:IF x1>=250 THEN  x1=x
2210IF y1<=3 THEN  y1=y
2220XDRAW 1 AT x, y:SCALE =1:HCOLOR =6:DRAW 1 AT x1, y1: x=x1: y=y1
2230RETURN
2300 x1=x: y1=y+3:IF y>=144 THEN  y1=y
2310XDRAW 1 AT x, y:HCOLOR =6:SCALE =1:DRAW 1 AT x1, y1: x=x1: y=y1
2320RETURN
2400 x1=x+3: y1=y+3:IF x1>=250 THEN  x1=x
2410IF y1>=144 THEN  y1=y
2420XDRAW 1 AT x, y:SCALE =1:HCOLOR =6:DRAW 1 AT x1, y1: x=x1: y=y1
2430RETURN
2500 x1=x-3: y1=y:IF x1<=3 THEN  x1=x
2510XDRAW 1 AT x, y:HCOLOR =6:SCALE =1:DRAW 1 AT x1, y1: y=y1: x=x1
2520RETURN
2600 x1=x-3: y1=y-3:IF x1<=3 THEN  x1=x
2610IF y1<=3 THEN  y1=y
2620XDRAW 1 AT x, y:HCOLOR =6:SCALE =1:DRAW 1 AT x1, y1: x=x1: y=y1
2630RETURN
2700 x1=x-3: y1=y+3:IF x1<=3 THEN  x1=x
2710IF y1>=144 THEN  y1=y
2720XDRAW 1 AT x, y:SCALE =1:HCOLOR =6:DRAW 1 AT x1, y1: x=x1: y=y1
2730RETURN
2800REM    menu routine
2810HOME:VTAB 21:? "  I      II     III"
2820VTAB 22:? "Enter  Color  Print"
2830GET k$:IF k$=CHR$(129) OR k$=CHR$(137) THEN 3000
2840IF k$=CHR$(130) OR k$=CHR$(138) THEN 4000
2850IF k$=CHR$(131) OR k$=CHR$(139) OR k$=CHR$(149) OR k$=CHR$(157) THEN 4500
2860IF k$=CHR$(150) OR k$=CHR$(158) THEN  subscript=1: xc=0:GOSUB 8030:GOTO 55
2870END
3000REM   drawing routine
3002GOSUB 8030
3005 d2=PDL(5)
3010 s1=PDL(7): s2=PDL(9): d=PDL(5)
3015IF d<d2 OR d>d2 THEN  subscript=subscript+1: x(subscript)=x: y(subscript)=y: d2=d: xc=xc+1
3020IF s1 OR s2 THEN 2800
3030IF d=6 THEN  d=d-1
3040IF d=8 OR d=9 THEN  d=d-2
3050IF d=12 THEN  d=d-4
3060ON d GOSUB 3100, 3200, 3300, 3400, 3500, 3600, 3700, 3800
3070VTAB 22:? TAB(2); "Press side button for menu."
3080GOTO 3010
3100 x1=x: y1=y-3:IF y1<=10 THEN  y1=y
3110XDRAW 1 AT x, y:HCOLOR =col(subscript):HPLOT x, y TO x1, y1
3120HCOLOR =6:DRAW 1 AT x1, y1: x=x1: y=y1
3130RETURN
3200 x1=x+3: y1=y:IF x1>=247 THEN  x1=x
3210XDRAW 1 AT x, y:HCOLOR =col(subscript):HPLOT x, y TO x1, y1
3220HCOLOR =6:DRAW 1 AT x1, y1: x=x1: y=y1
3230RETURN
3300 x1=x+3: y1=y-3:IF x1>=247 THEN  x1=x
3310IF y1<=10 THEN  y1=y
3320XDRAW 1 AT x, y:HCOLOR =col(subscript):HPLOT x, y TO x1, y1
3330HCOLOR =6:DRAW 1 AT x1, y1: x=x1: y=y1
3340RETURN
3400 x1=x: y1=y+3:IF y1>=147 THEN  y1=y
3410XDRAW 1 AT x, y:HCOLOR =col(subscript):HPLOT x, y TO x1, y1
3420HCOLOR =6:DRAW 1 AT x1, y1: x=x1: y=y1
3430RETURN
3500 x1=x+3: y1=y+3:IF x1>=247 THEN  x1=x
3510IF y1>=147 THEN  y1=y
3520XDRAW 1 AT x, y:HCOLOR =col(subscript):HPLOT x, y TO x1, y1
3530HCOLOR =6:DRAW 1 AT x1, y1: x=x1: y=y1
3540RETURN
3600 x1=x-3: y1=y:IF x1<=5 THEN  x1=x
3610XDRAW 1 AT x, y:HCOLOR =col(subscript):HPLOT x, y TO x1, y1
3620HCOLOR =6:DRAW 1 AT x1, y1: x=x1: y=y1
3630RETURN
3700 x1=x-3: y1=y-3:IF x1<=5 THEN  x1=x
3710IF y1<=10 THEN  y1=y
3720XDRAW 1 AT x, y:HCOLOR =col(subscript):HPLOT x, y TO x1, y1
3730HCOLOR =6:DRAW 1 AT x1, y1: x=x1: y=y1
3740RETURN
3800 x1=x-3: y1=y+3:IF x1<=5 THEN  x1=x
3810IF y1>=147 THEN  y1=y
3820XDRAW 1 AT x, y:HCOLOR =col(subscript):HPLOT x, y TO x1, y1
3830HCOLOR =6:DRAW 1 AT x1, y1: x=x1: y=y1
3840RETURN
4000REM   color subroutine
4010TEXT:? TAB(3); "The number codes of the colors are as follows:"
4020?:? TAB(3); "0 = eraser color (Black)"
4030? TAB(3); "1 = Green"
4040? TAB(3); "2 = Violet"
4050? TAB(3); "3 = White"
4060? TAB(3); "4 = Orange"
4070? TAB(3); "5 = Blue"
4080? TAB(3); "6 = Brown"
4090? TAB(3); "7 = Dark Blue"
4100? TAB(3); "8 = Gray"
4110? TAB(3); "9 = Pink"
4120? TAB(2); "10 = Dark Green"
4130? TAB(2); "11 = Yellow"
4140? TAB(2); "12 = Aqua"
4150? TAB(2); "13 = Magenta"
4160?:INPUT "Which color do you want? "; c
4170IF c<0 OR c>13 THEN ? "I don't know that color.  Press any key to see list again.":GET k$:GOTO 4000
4180IF c=4 OR c=5 THEN  c=c+1:FOR x3=subscript TO max: col(x3)=c:NEXT x3:GOTO 3000
4190IF c>5 THEN  c=c+2:FOR x3=subscript TO max: col(x3)=c:NEXT x3:GOTO 3000
4200IF c<4 THEN FOR x3=subscript TO max: col(x3)=c:NEXT x3:GOTO 3000
4500REM   printout subroutine
4510TEXT:VTAB 10:? TAB(3); "Do you have paper in printer?  If so, press any key."
4520GET k$
4530PR #1
4540FOR p=2 TO xc
4550? "HPLOT "; x(p); ","; y(p); " TO "; x(p+1); ","; y(p+1); "     HCOLOR = "; col(p-1)
4560NEXT p
4570PR #0
4580HOME:? TAB(3); " Press <c> to continue, <s> to start over, or <e> to end."
4590GET k$
4600IF k$="c" OR k$="C" THEN GOSUB 8030:GOTO 2800
4610IF k$="s" OR k$="S" THEN  subscript=1: xc=0:GOSUB 8030:GOTO 55
4620IF k$="e" OR k$="E" THEN HOME:? TAB(8); "HAVE A GOOD ONE!":END
8000REM     initialization
8010 max=300: x=120: y=75: subscript=1
8020DIM x(max), y(max), xc(1), col(max)
8022FOR s=1 TO max
8025 col(s)=3
8027NEXT s
8030HGR
8035HCOLOR =3
8040FOR x5=1 TO 250 STEP 10
8050HPLOT x5, 3 TO x5, 4
8060NEXT x5
8070FOR y3=1 TO 150 STEP 10
8080HPLOT 10, y3 TO 12, y3
8090NEXT y3
8100HPLOT 5, 1 TO 255, 1 TO 255, 153 TO 5, 153 TO 5, 1
8120IF  NOT xc THEN RETURN
8130FOR d1=2 TO xc
8140HCOLOR =col(d1-1)
8150HPLOT x(d1), y(d1) TO x(d1+1), y(d1+1)
8160NEXT d1
8170RETURN
