;***********************************************
;   					       *
; EOS Routines with entry and exit parameters  *
;					       *
;***********************************************

; End Keyboard read
; This will check the result of the previous start Keyboard read and
;  restart if NAKed
; In:	Nothing
; Out:	Condiation Flags
;	Carry : Command has finished 
;	No Carry : command has not been finished
;	Zero:	No Error has occured
;	No Zero : Error has occured
;	 A- Has error code 
;	Carry and Zero- A- Has key
EndKeyRead EQU	0FC4Bh
	ENTRY	EndKeyRead

; Find,Get DCB
; Find the DCB of the desired device
; In:	A- Device ID
; Out:	IY- Holds address of DCB if found
;	No Error- Z=1, A=0
;	Error- Z=0, A=error code
FindDCB EQU	0FC54h
	ENTRY	FindDCB
GetDCB	EQU	0FC54h
	ENTRY	GetDCB

; Get the location of the Processor control block
; In:	Nothing
; Out:	IY- Address of the PCB
GetPCB	EQU	0FC5Ah
	ENTRY	GetPCB

; Hard Initialization
; Relocate PCB to default (FEC0), reset ADAMnet, Synch master node,
;  setup DCB's and scan for active devices.
; In:	Nothing
; Out:	PCB address set to default
; Possible error if PCB is not at default!!
HardInit EQU	0FC5Dh
	ENTRY	HardInit

; Hard Reset ADAMnet
;  Do a hard reset to ADAMnet
; In:	nothing
; Out:	Hard Reset Applied to network
HardResetNet	EQU	0FC60h
	ENTRY	HardResetNet

; Relocate Processor Control Block
;  change the location of the Master device processor control block
; In:	HL- New location of the command block
;	Old location must be in Current_PCB (0FD70h)
; Out:	PCB relocated as desired
RelPCB	EQU	0FC7Bh
	ENTRY	RelPCB

; Request Device Status
; It will initiate a status request command, and will return the result of the
;  command
; In:	A- Device ID
; Out:	No Error- Z=1, IY- DCB Address, A= Status reply
;	Error- Z=0, A=Status result, IY- unknown
ReqStatus EQU	0FC7Eh
	ENTRY	ReqStatus

; Soft Reset Device
; do a soft reset on the specificed device
; In:	A- device to reset
; Out:	No Error- Z=1, A= DCB completion value
;	Error- Z=0, A= error or invalid completion value
SResDev	EQU	0FC90h
	ENTRY	SResDev

; Soft reset the Keyboard
; In:	Nothing
; Out:	No Error- Z=1, A= DCB completion value
;	Error- Z=0, A= error or invalid completion value
SoftKeyReset EQU 0FC93h
	ENTRY	SoftKeyReset

; Soft reset the printer
; Parameters same as keyboard
SResPrinter EQU	0FC96h
	ENTRY	SResPrinter

; Soft reset the tapes
; Parameters same as keyboard
SResTape EQU	0FC99h
	ENTRY	SResTape

; Start a keyboard read
; In:	Nothing
; Out:	No Error- Z=1
;	Error- Z=0
StartKeyRead EQU 0FCA8h
	ENTRY	StartKeyRead

; Synchronize Z80 and Master 6801
; In:	Correct PCB address must be in CurrentPCB (0FD70h)
; Out:	Master Node is in synch with Z80, # of DCB's is set to 0 so
;	master node is not scanning. 
Sync	EQU	0FCB1h
	ENTRY	Sync

; Initialize Directory
; In:	A- Device ID
;	C- # of blocks in directory
;	DE- Numbers of blocks on device
;	HL- Address of volume name (3 ending)
; Out:	No Error- Z=1, A=0
;	Error- Z=0, A= error code
InitDir	EQU	0FCBDh
	ENTRY	InitDir

; Open a File
; Sets up an FCB for the caller to access a file
; In:	A- Device ID
;	HL- Address of file name
;	B- Open Mode
; Out:	No error- Z=1, A= File #
;	Error- Z=0 , A= error Code, B is junk
OpenFile EQU	0FCC0h
	ENTRY	OpenFile

; Close open file
; does necessary clean up and marks the FCB as unused
; In:	A- FCB #
; Out:	No Error- Z=1, A=0
;	Error- Z=0, A= error Code
CloseFile EQU	0FCC3h
	ENTRY	CloseFile

; Make a new file
;  Creates a file in the directory 
; In:	A - Device ID
;	HL- Holds address of name string
;	BCDE- Length of New file entry
;        If BCDE = 0 then remainder of the tape is allocated
; Out:	No Errors Z=1
;	Error Z=0, A= error code
MakeFile EQU	0FCC9h
	ENTRY	MakeFile

; Read the Files directory entry
;  compares base file names
; In:	A- Device #
;	DE- Address of Name String ( 3 is end )
;	HL- File Directory Buffer
; Out:	No Errors- Z = 1 , A=0, BCDE = Starting Block of File
;	  Buffer holds Directory information
;	Error- Z = 0, A= error code, DE is junk
ReadDirForFile	EQU	0FCCCh
	ENTRY	ReadDirForFile

; Re-Write file directory entry
; In:	A -	Device #
;	DE-	File Name Address
;	HL-	Directory Entry Data
; Out:	No error- Z=1, A=0
;	 Directory is updated
;	Error- Z=0, A = error code
;	 Directory is unchanged
SetFile	EQU	0FCCFh
	ENTRY	SetFile

; Read File
; read some data from a file into the users's buffer
; In:	A- FCB # to read from
;	HL- Buffer Address
;	BC- # of bytes to read
; Out:	No Errors- Z=1, A=0
;	Errors- Z=0, A= error code
;	BC- # of bytes transfered
ReadFile EQU	0FCD2h
	ENTRY	ReadFile

; Write data to a file
; write some bytes to a file
; In:	A- FCB #
;	HL- starting address of data to write
;	BC- # of bytes to write
; Out:	No errors- Z=1, A=0
;	Error- Z=0, A=error code
WriteFile EQU	0FCD5h
	ENTRY	WriteFile

; Goto to Word Processor Rom
; In:	Nothing
; Out:	Starts Execution of SmartWriter
GoWP	EQU	0FCE7h
	ENTRY	GoWP

; Trim File 
; Releases the unused blocks in the specified file
;  if file being trimmed is the last file, unused blocks are returned to
;  to free blocks
; In:	A- Device ID
;	DE- Address of Filename to trim
; Out:	No Error- Z=1, A=0
;	Error- Z=0, A= error Code
TrimFile EQU	0FCEDh
	ENTRY	TrimFile

; Read the Files directory entry
;  compares full file names
; In:	A- Device #
;	DE- Address of Name String ( 3 is end )
;	HL- File Directory Buffer
; Out:	No Errors- Z = 1 , A=0, BCDE = Starting Block of File
;	  Buffer holds Directory information
;	Error- Z = 0, A= error code, DE is junk
FileQuery EQU	0FCFFh
	ENTRY	FileQuery
	
; Write Block to Vram
; Write to VRAM the contents of the data in a buffer area
; In:	BC- # of bytes to write
;	DE- Address in VRAM to write data to
;	HL- Address of buffer containing the data
; Out:	Nothing
; Used:	AF,BC,DE,HL
VMBW	EQU	0FD1Ah
	ENTRY	VMBW

; Read from VRAM
; Reads from VRAM and puts the read data into a buffer area
; In:	BC- # of bytes to be read
;	DE- Starting Vram address to read from
;	HL- Address in RAM to receive the data
; Out:	Nothing
; Used:	AF,BC,DE,HL
VMBR	EQU	0FD1Dh
	ENTRY	VMBR

; Write Video Register
; Write desired byte to VDP register
; In:	B- Register #
;	C- Value to Write
; Out:	If register is 0 or 1, byte of VDP mode is updated in EOS RAM table
; Used:	A,BC,E
WrtVreg	EQU	0FD20h
	ENTRY	WrtVreg

; Read Video Register 8
;  Get the contents of video register 8, reset the VDP (NMI) interrupt
; In:	None
; Out:	A- Data byte read in
; Format- Bit 7       : 6	     :  7               : 6-0
;	VDP interuppt : Five sprites : Sprite Collision : Fifth Sprite 
ReadVreg8 EQU	0FD23h
	ENTRY	ReadVreg8

; Fill Vram with one value
; Fill a VRAM memory buffer with a constant byte value
; In:	A - Constant Value
;	DE- # of bytes to write
;	HL- Adress in VRAM to write to
; Out:	None
; Used:	AF,C,DE
FillVram EQU	0FD26h
	ENTRY	FillVram

; Initialize VRAM Table
; Initializes the addresses of the VRAM tables.
;  The passed address is converted to the correct format needed to setup the 
;  the VDP address registers. The following table codes are used to indentify
;  which table address is being setup:
;   0 - Sprite Attribute Table
;   1 - Sprite Pattern Table
;   2 - Screen Image Table
;   3 - Pattern Descriptor Table
;   4 - Color Table
;
; In:	A - Table Code
;	HL- Table Address
; Out:	None
; Used:	AF,BC,HL,IX,IY
InitVramTable EQU	0FD29h
	ENTRY	InitVramTable

; Read game controllers
; Used to fill a table of values for the 2 controllers.
; Does some debouncing if called twice in succession
;
; In:	IX - Points to 1st byte of controller map ( 10 bytes )
;	A  - controller enable and spin enable
;		Bit 0- Set if controller 0 enabled
;		Bit 1- Set if controller 1 enabled
;		Bit 7- Set if spinner enabled for controllers
; Out:	Controller map referenced from IX
;	IX+0	Joystick 0
;	IX+1	Fire 0
;	IX+2	Arm 0
;	IX+3	Keyboard 0
;	IX+4	Spinner Count 0
;	IX+5	Joystick 1
;	IX+6-9 	Same as above
;	All registers are used
ReadController	EQU	0FD3Eh
	ENTRY	ReadController

; Initialize table of sounds (songs)
; In:	HL - Address of list of Sound addresses
;	B  - # of Sounds ( songs )
SoundInit	EQU	0FD50h
	ENTRY	SoundInit

; Turns off all channel voices
; In:	None
; Out:	sounds turned off.
;	A & C used
SoundOff	EQU	0FD53h
	ENTRY	SoundOff

; Start the playing of the sound ( song )
; In:	B- Sound (Song) # to start playing
StartSong	EQU	0FD56h
	ENTRY	StartSong

; Update the current song
; In:	None
; Out:	Everything trashed
UpdateSoundTable EQU	0FD59h
	ENTRY	UpdateSoundTable

; EOS Ram Table Addresses
SVreg0	EQU	0FD61h	; Save the value in VREG 0
	ENTRY	SVreg0
SVreg1	EQU	0FD62h	; Saves the contents of VREG 1
	ENTRY	SVreg1
Vreg8	EQU	0FD63h	; Holds the contents of VREG 8 ( Video Status )
	ENTRY	Vreg8
CurDev	EQU	0FD6Fh	; Holds Device # of Boot Device
	ENTRY	CurDev
FCBs	EQU	0FDFDh	; Address of FCB's
	ENTRY	FCBs
FCBdat	EQU	0FDFFh	; Address of 1k FCB buffers
	END
