               The Future of the Coleco ADAM:  1995
 
                perspectives by Richard F. Drushel
 
                           at ADAMcon 07
 
                         July 20-24, 1995
 
 
      First, I'd like to thank Dale Wick for asking me to    give
this year's "Future of the ADAM" speech.  Second, I promise  to
you that, although I have a Ph.D. and my job is biological
research, I will keep the technical jargon to a minimum.     Third,
I'd like to apologize in advance if some of what I have to   say
makes you angry or upset.  Fourth, I want to warn you that   it's
very likely you *will* be angry or upset at some point in    the
next half hour.  As you will see, this is both necessary and
good.  Fifth, I want to reassure you that I am *not* here to make
personal attacks, and I want to reassure you that I will     *not*
take any of your anger or distress as a personal attack      against
me.  And last of all, I need to include all the standard
disclaimers:  the views expressed are my own, and do not
necessarily reflect the views of the convention organizers   or
anybody else in the ADAM community, etc., etc.
 
      In this lecture, I will begin with a little ADAM       history. 
Next, I'll talk about the future of ADAM hardware and        software. 
Finally, I'll discuss some of what might best be called      community
issues, and try to bring everything together into a few      takehome
messages.
 
I.  History.
 
      Many of you here today have been part of the           international
Coleco ADAM community from its very beginnings.  You got a
ColecoVision video game system in 1982.  You watched ADAM
computer commercials on television, paid $600 US your R59    ADAM at
Christmas 1983, maybe had it sent back for repairs when it   was
dead out of the box.  You subscribed to Family Computing and
Computer Shopper because they published listings of          SmartBASIC
programs.  When Coleco went bankrupt, you joined NIAD (the
Northern Illiana ADAM users group) or some other users       group, or
you started your own users group.  You subscribed to         newsletters,
wrote articles for newsletters, or published your own.  You
bought an ADAMlink modem, joined CompuServe, and started     calling
BBSes, or maybe you started your own BBS.  You started to    talk
electronically to the people you were reading about in the
newsletters.  You saw Eve Computer Systems come and go, you  saw
the start of Orphanware Business Systems and Micro           Innovations. 
You saw the rise and fall Solomon Swift.  You went to the    first
ADAMcon in 1989.  You have seen all the important "firsts".
 
      I, however, came late to the ADAM, and even later to   the
ADAM community. Let me tell you a little about my history    with
the ADAM.  My first ADAM was my Dad's, an R59 bought that    first
Christmas in 1984, with a 160K disk drive no less, rescued   from
the trash in 1988 when he got sick of software bugs and      bought a
Tandy 1000 PC clone.  Dad had joined NIAD in its second      year, but
had given up on both them and the ADAM a year later because
NIAD's SmartBASIC programs kept locking up his system.  I    renewed
the NIAD subscription (mostly for the product line, I didn't get
too involved in the articles).  I bought a new version of
SmartBASIC 1.0, an R80 console, an extra tape drive, a       Panasonic
printer, and the two "Hacker's Guide to ADAM" books.  My     original
intention for the ADAM was as a home word processor:  I was
starting graduate school and had to generate lots of         paperwork,
and our lab had only 2 computers, which were always busy.    When I
found out that I could read blocks off a 160K ADAM disk in a PC
360K drive using Norton Utilities, I got motivated to write  a PC
program to copy ADAM files.  This led to lots of PC and Z80
assembly language hacking, and eventually disassembling      ADAM's
EOS operating system and SmartBASIC.  Eventually, I got too  busy
with school to play with my ADAM, and it was clear that I    could
never do enough bug fixing quickly enough to use my ADAM to  do
useful lab work (which had been my original intention).  I
dropped NIAD in early 1989, before ADAMcon 01 got off the    ground,
and that was my last contact with the ADAM public at large   until
the fall of 1990.  At that time, I was starting to write up  my
Ph.D. thesis, and I bought a laptop with an internal 2400    baud
modem.  I got an account on the Cleveland Freenet, and found an
ADAM sig, with sysops none other than our own Herman Mason,  Jr.
and George Koczwara.  When they found out how much I had     figured
out about EOS and SmartBASIC, with only slight help from the
"Hacker's Guide" books, and when they saw the preliminary    version
of SmartBASIC 1.x, they realized I had done something nobody else
had done, and which lots of ADAM users could benefit from. 
Through their BBSes and their contacts, they got me plugged  back
into the ADAM community.  They are responsible for my being  here
today.
 
      The reason I am telling you the history of my personal
involvement with the ADAM is to emphasize that, compared to  many
of you pioneers out there, I am a latecomer and even an      outsider. 
I believe that this gives me a certain unique objectivity,   but my
lack of seniority in the ADAM fraternity, if you will, may   make
it difficult for some of you to consider the comments I will make
shortly.
 
II.   Hardware.
 
      I know that I surprised and alarmed several of you at
ADAMcon 06, when I stated the fact that the read-only memory
chips in game cartridges, disk drives, and on the ADAM       system
board have a finite lifetime.  ROMs and EPROMS have a mean   time
before failure of 10 years.  This failure is a single-bit    error: 
a 1 becomes a 0 or a 0 becomes a 1 somewhere.  Since the     ADAM is
now 12 years old, and the ColecoVision 13 years old, we      should
expect to start seeing flaky game cartridges, or ADAMs with
obscure errors in SmartWriter (since SmartWriter is in       EPROMs),
or even ADAMs which crash all the time (since both the OS7   and
EOS operating systems are in ROMs).  There is no way to      predict
where or when one of these single-bit errors will occur, and it's
possible for one to occur and do no overt damage.  For       instance,
if the error occurs in an internal message string (like a    hidden
programmer's name or "Hi Cathy" message), you won't see any
effect.  If, however, the error occurs in a menu string, or  in a
screen data area, it might show up as a corrupted SmartKey   menu,
or some stray bits of garbage in one part of the screen      display;
but normal operations wouldn't be otherwise affected.  The   worst
case is, of course, an error in a code segment--the actual
machine code gets mutated to a different instruction, with
totally unpredictable results, and then the program          malfunctions. 
Imagine the effect of such an error in the EOS ROM routine
_WRITE_BLOCK under SmartBASIC:  you could load and run       existing
programs on tape or disk, but you couldn't save anything,    because
the _WRITE_BLOCK routine itself had become damaged.
 
      There is also ROM code stored inside the 6801
microcontrollers which control the operation of the tape     drives,
keyboard, printer, and the ADAMnet itself.  This ROM too is
subject to single-bit errors over time, and any failures     here
will have devastating consequences:  a dead tape drive, a    dead
printer, a dead ADAM.
 
      ADAMs beginning to lose their minds...a terrifying     thought. 
Fortunately, there are steps we can take now to guard        against the
day when one of these insidious single-bit errors happens to your
ADAM.  Devices exist which can read and write standard ROMs  and
EPROMs; they are common and relatively inexpensive (about    $150
US), as are blank EPROMS ($2 to $5 US apiece).  The strategy is,
read all your ROMs now, while they are still good, and save  the
data; when one goes bad, program a new one with the saved    data,
and you're set for another 10 years or so.  In the case of   the
EPROM (E for Erasable programmable read-only memory), you    don't
even have to buy a new one--just uncover its little quartz   window
(it's usually covered with a label), erase it with bright
ultraviolet light and reprogram it.
 
      For the 6801 microcontrollers, however, the task of
replacement is a bit more complicated.  The 6801s have their
programming built-in when they are manufactured; there is no way
to change it or replace it.  An EPROM version of the 6801,   the
68701, is available, but (a) it's expensive, about $25 US,   and
(b) the 68701 reader/writer is far more expensive than a     standard
EPROM burner, about $500 US, and (c) it's not exactly pin-
compatible with the 6801, so you can't just plug a 68701     into a
6801 socket without some extra jumper wiring.
 
      A final replacement headache is that your defective    chip may
not be socketed; it may be soldered directly into the        circuit
board.  In this case, you have to desolder the old chip in   order
to install the new chip (preferably in a socket to make it   easy
to replace next time).  Desoldering a 40-pin chip can be a
difficult skill to master, so the average ADAMite will       probably
have to pay a professional repairman to do it.  I have never seen
a game cartridge with socketed ROMs.  The EOS and            SmartWriter
ROMs and EPROMs are always socketed.  The 6801               microcontrollers
are sometimes socketed, sometimes not.
 
      There are copyright issues involved, but it certainly  would
be nice if we could form a centralized library of EPROM and  6801
binaries, so that when *your* SmartWriter ROM or *your*      Cabbage
Patch Kids Adventure In The Park game cartridge goes bad,    there
is a known good copy somewhere to restore it from.  Someone  with
the proper hardware could burn new EPROMs and supervise
replacement of defective 6801 microcontrollers with 68701s.  This
might be a good job for A.N.N. to coordinate, in cooperation with
the existing ADAM repair services, or interested hardware    hackers
like me who already have some of the necessary equipment.    Or
A.N.N. might buy the necessary equipment as a public good,   and
designate someone to operate it, providing services at cost  (that
is, non-profit) to any ADAMite.  Just to warn you, I shall   have
more to say about profit later in this talk.
 
      If your ADAM doesn't begin to lose its mind in the     next few
years, it's likely that some of its peripheral devices will  start
to break down.  Some of this is simply due to age, but age
effects are exacerbated by some of Coleco's bad designs for  the
hardware.  Nothing is fan-cooled and everything runs hot.    Try
touching the big aluminum heatsink at the back of the ADAM
printer sometime after it's been on for an hour, or a data   pack
that's been shut up in a tape drive.  The worst is the       original
160K disk drive--through cheap design, the power supply      circuitry
is badly overloaded, and you can boil water off some of the
components.  Chemistry tells us that for every 10 degrees    Celsius
(that's 18 degrees Fahrenheit) increase in temperature, the  rate
at which chemical reactions take place doubles.  This means  that
some parts of the poor disk drive are going bad about 128    times
faster than they would if they were kept cool to a more
reasonable 30 degrees Celsius (that's 86 degrees             Fahrenheit). 
The takehome lesson from this bit of CHEM 101 is that, if    you
want to make your ADAM last as long as possible, you should  keep
it cool.  Fans and air-conditioned rooms work best, but cold
basements are okay, too.
 
      What do you do when one of your peripheral devices     dies? 
Howard Pines and a few others can make some repairs.  Since
complete ADAM systems can still be had for less than $50 US, you
might consider picking up a spare ADAM (or two) at the local Good
Will or flea market.  I'm pretty sure there are spare ADAMs  for
sale somewhere around here :-)  This will give you an extra
keyboard, tape drive, printer, and system unit; you can use  the
backups while your original is sent off to be repaired.      Coleco
disk drives are very hard to come by, so if you have a       chance to
get one, grab it while you can.  As for third-party          hardware,
you'll probably have to find someone to fix it for you.      George
Koczwara and I are prepared to deal with Orphanware stuff,   and I
believe that Mark Gordon will still do repairs on Micro
Innovations stuff.  Since everything third-party except the
Orphanware serial board is now out of production, you'll     have a
harder time acquiring duplicates of this hardware, at any    price.
 
      Since the ADAM hardware is old and some of it is       scarce or
unobtainable, you should be worried about what you will do   if any
of it dies.  For those of you who have stuck with your base  ADAM
system and are contemplating upgrading to disk drives,       parallel
printers, serial modems, or even hard drives, scarcity and   age
are big impediments--you can't find it to buy; if you do     find it,
scarcity makes it expensive; and if you sink big bucks into  it,
it may turn around and repay your investment by dying of old age. 
This is enough to make even the most devout ADAMite heave    his
ADAM into the dustbin and buy a PowerPC or a Pentium.
 
      Technology can help solve the problem of scarce, aging ADAM
hardware, but the cost may be high.  Let's consider a few
possible hardware futures for the ADAM.
 
      We could build new hardware that's just like the old.  We
could design and build new, better hardware--how about a     SCSI
interface, or 24-bit color graphics, or 16-bit stereo sound? We
could redesign the ADAM system board to use a 25 mHz Z380    CPU and
16 megabytes of RAM.  We could have some kind of             "ADAM-on-a-card"
to plug into an expansion slot in a PC clone.  Do any of     these
excite you?  Mark Gordon has said that he would be only too  glad
to do any of these, if somebody will pay him enough to       design it,
and as long as *somebody else* makes the investment to       actually
build, sell, and support it.  This won't be cheap.  How      excited
are you now?
 
      Mark Gordon is a businessman, and a businessman wants  to
make a profit.  Given the high startup costs involved in
designing and debugging a new piece of hardware, or even     making
more of an existing design under license, I believe that     there
will *not* be any more new ADAM hardware in significant
quantities, because there's no way to make a profit from     ADAM
hardware anymore.  If there aren't at least 20 people ready  to
prepay in full, you won't even break even.  Few if any of us here
are sufficiently well-off that we can absorb those kinds of
monetary losses, simply for the "greater good" of the ADAM
community.
 
      This is not to say that there won't continue to be new
hardware developments for the ADAM.  People like Chris       Braymen or
Dale Wick or me will have have some new things from time to  time;
but these will be strictly build-it-yourself projects.  If   you
want one, the responsibility is yours to buy the components  from
JDR, wire wrap it, and test it yourself.  If you're not
technically adept, you may be able to convince somebody to
assemble one for you at cost or at a nominal fee; but nobody will
be making 50 of them for sale pre-assembled and ready to go. 
This is 1995, not 1986 (when, I'm told, Orphanware Business
Systems could make more than a few tens of thousands of      dollars
US in hardware sales).  The unpleasant fact is, in the ADAM
community of 1995, there's not enough market to justify the
investment for a businessman who wants to make a profit.
 
      To some of you, another unpleasant fact is that many
ADAMites have moved on to other computers, most frequently   IBM-PC
clones.  I actually view this as an unexpected benefit,      which can
be exploited to the benefit of ADAM users.  Modern PCs have
large-capacity hard drives and disk drives, high-resolution  video
displays, serial ports, parallel ports, the ability to       access
mice, CD-ROM drives, magneto-optical disk drives, scanners,  you
name it.  A typical 80286 PC, which is considered junk       nowadays,
often has more peripheral hardware on it than the most       advanced
ADAM with every available third-party bell and whistle.      Even the
lowly IBM-PC/XT has a 20 megabyte hard drive, a 360K disk    drive,
a parallel port, and a serial port.  And PCs are cheap, some
almost as cheap as a complete bare ADAM system.  The         ADAM-only
versions of this hardware, if they exist at all, are scarce  and
expensive.  A Micro Innovations 1.44 megabyte disk drive     cost
nearly $300 US when you could still get them; for the same   money,
I can get a used '286 with both 1.44 megabyte and 1.2        megabyte
disk drives, plus a 40 megabyte hard drive.  Given these     economic
incentives involved in increasing one's computing power, at  first
glance, the hands-down winner is the PC over the ADAM.  But  if I
had some way to allow my ADAM to use the advanced hardware   of my
PC, then maybe I would have some incentive to keep using my  ADAM. 
This is why I view the introduction of PC clones into the    ADAM
community as a benefit, because (shameless promotion mode    on) I
have developed a way to let ADAMs use IBM hardware.  I call  it
ADAMserve.
 
      As many of you saw at my demonstration, the basic idea
behind ADAMserve is, you let an ADAM communicate with a PC   via a
serial connection.  Whenever ADAM wants to access a disk or  tape
or printer, instead of looking for a genuine ADAMnet disk or tape
or printer, it instead asks the PC to look for one of *its*  disks
or printers.  The PC hardware does all the work; it "serves" the
ADAM (hence the name), and passes the results back to the    ADAM
over the serial connection.  The ADAM operating system       software
is rewritten so that your application programs never know    that
they aren't using "real" ADAM hardware; the switch is        totally
transparent to the user.  By extension, *any device* that    you can
attach to a PC which transfers either blocks or characters   can
effectively be used by the ADAM, as if it were ADAM's own.   Of
course, you need a genuine ADAM serial board in order to
establish the communications link; but serial boards are     common
(in fact, the Orphanware type is still in production by      HLM-GMK),
and the serial board is the *only* additional piece of       non-Coleco
hardware you need.  A 1-tape-drive ADAM, bare out of the     box,
when equipped with a serial port and ADAMserve software, can use
the PC hard drive, disk drives, parallel and serial ports,   and
real-time clock.  Collecting the ADAM-only equivalents of    this
hardware nowadays is a difficult and expensive task.         ADAMserve
is intended to be free except for distribution media         costs--you
provide the PC and a serial board.
 
      Since there isn't enough of a market to allow          production of
most ADAM-only hardware to continue, and since many people
already own PCs with advanced hardware capabilities, I       believe
that something like ADAMserve will be the average ADAMite's  only
hope for upgrades, and for replacing original ADAM           peripherals
which die of old age.
 
III.  Software.
 
      Just as for hardware, the twin issues of innovation    and
maintenance are important as we consider the future of ADAM
software.  Fortunately, this means that my remarks about     software
can be briefer than those about hardware :-)
 
      Innovation means writing new software that meets some  need
in the ADAM community.  Maintenance means keeping existing
application programs running despite any hardware or         operating
system innovations, as well as bug fixes for existing        problems. 
Since economic incentives apply equally to software and      hardware,
my prediction is that, from now on, there will be little or  no
new application software produced for the ADAM, and that     code
maintenance and minor bug fixing will be a necessary but
neglected job, relegated to the few programmers left among   us.  I
think it's a pity, but aside from perhaps games, there isn't
really any software class in the ADAM software library which is
crying out for a new program; there are already adequate     choices
for all.  On the EOS side, for word processing you have
SmartWriter and SpeedyWrite; for graphics, PowerPaint; for
databases, SmartFiler; for spreadsheets, ADAMcalc; for
telecommunications, ADAMlink V; for programming, SmartLOGO   and
several flavors of SmartBASIC; for music, VideoTunes and any of
Chris Braymen's software for the MIDI interface.  On the     CP/M and
TDOS sides, there are many fine choices in all categories    except
graphics and music, since CP/M and TDOS are text-based       operating
systems.  Even if none of the available choices in some      category
exactly suit you, it's unlikely that someone is going to     spend a
year writing the perfect version for you--unless you get     highly
motivated, highly educated about the guts of the ADAM, and   write
it yourself--because other than attaboys and the feeling of  well-
being which accompanies heroic acts of selfless altruism,    there
are no rewards to be had.
 
      Consider also the plight of the remaining ADAM         software
vendors.  They have stocks of software acquired when there   was
reasonable hope of sales, at full prices.  As the ADAM       community
has grown smaller and smaller, the remaining active ADAMites tend
to have more and more software, picked up when ADAM systems  are
liquidated.  Those who remain probably already have copies   of
what the vendors would like to sell.  This inventory is      virtually
unmovable, and the vendors can never recoup their losses.    Thus,
vendors have little incentive to add yet more unsalable      software
to their stagnant inventories, further limiting the market   for
new programs.
 
      At this point, new ADAM software can only arise out of the
goodness of someone's heart, or as a necessary part of some  new
bit of ADAM hardware which needs driver code.  Anybody who   thinks
he can recoup more than perhaps media and mailing costs will be
quite disappointed.  You can't sell software for what it's   worth,
either intrinsic worth to the ADAM community because it's    such an
improvement, or worth to you because you slaved over it for  a
year to get it working.  If you want as many people as       possible
to use it, your only real option is to give it away.  Given  the
shrinking ADAM community, the number of people willing to    vote
with dollars for new software is also shrinking.  Those of   us who
are programmers wish from time to time that this were not    so.  In
my own case, the $10 US per copy of my SmartBASIC 1.x that I
profited over my media and printing expenses was used to buy ADAM
hardware so that I could better support it through my        software. 
Of the 40-odd copies of SmartBASIC 1.x that I have sold      since its
introduction in 1991, probably 25 were sold in the first two
years, another 10 the third year, and an odd copy here and   there
thereafter.  More have been given away as door prizes for
ADAMcons lately than have been sold :-)  If SmartBASIC 1.x   were
new for ADAMcon 07, I would be lucky to sell 5 copies at the
convention itself, a few over the next year, and subsequent  "new"
copies would only move as ADAMcon door prizes.  I wouldn't   even
recoup the photocopy costs for a minimum run of 10 manuals.
 
      In 1995, if you are an active ADAM programmer, like    me,
there is no way that you can be doing it for hope of         financial
gain--by now, there's none to be had.  I'm an ADAM           programmer
because I'm intrinsically interested in the ADAM.  I write
software for *me*, and if other people find it useful,       that's
great, but I'll program whether anybody else cares about     what I'm
doing or not.  For me, it's been *fun* (though often         challenging
and frustrating) to learn about how the ADAM works, and how  to
make it do interesting things.  
 
      Unfortunately, I have not found many other people like me in
the ADAM community.  There aren't many of us programmers     left,
for a variety of personal and professional reasons.  *I*     don't
believe you need a Ph.D. in order to learn how to write your own
software in SmartBASIC or even assembler, but most of *you*  out
there believe otherwise; and I can't overcome the strength   of
your belief.  There are many practical benefits to doing     your own
programming, not the least of which is that you can make     your
program do exactly what *you* want it to do.  More important
nowadays, however, is that ADAM programming skills can be    part of
your maintenance toolkit.  If all the ADAM newsletters       disappear,
all the ADAM BBSes go off-line, no more ADAMcons are held,   and
you can't find anybody else who has an ADAM, then you, like
Robinson Crusoe, can be self-sufficient on your own desert
island.  For me, that is an important motivation--because    I'm
really worried that the ADAM is about to become a desert     island.
 
IV.   Community.
 
      The annual ADAMcons have been public celebrations of   the
community of Coleco ADAM users since 1989.  Attendance       peaked at
over 100 for ADAMcon 04, but geography severely hurt ADAMcon 05,
and both geography and international economics prevented     many
otherwise enthusiastic Canadians from attending ADAMcon 06.  The
extra 3-month interval between 05 and 06 made it harder to
sustain interest, and the subsequent hurry-up to hold        ADAMcon 07
in July again has, I'm certain, created logistical problems  for
Dale, Jill, and the other convention organizers.  And the
prospects for an ADAMcon 08 are far from clear.
 
      The ADAMcons are a public service to the ADAM          community. 
They aren't supposed to turn a profit, but they have to      break
even.  In order to break even, there has to be a certain     critical
mass of attendees.  In order to make it worth someone's      while, or
some users group's while, to put effort into planning and    running
an ADAMcon, you'd like to see a little more than the bare    minimum
attendance.  But I'm not sure that it's reasonable to expect much
attendance at all.  Already, the evidence is clear that      there are
not enough dollar votes to support new ADAM hardware and     software
development.  What's the attraction of yet another ADAMcon? 
There won't be much new to see, the sessions will be pretty  much
the same as they've always been, most of the big-name
personalities from the first 5 years of ADAM have moved on   to
other things, so those of you who like to hobnob with        royalty
will find only Johnny-come-latelies like me.  Unless this is your
first or second ADAMcon, everything is as familiar as an old
shoe, only the city and hotel are different.  Is it really   worth
$250 US for the same hamburger in a different bun?
 
      Well, it must be, since all of you are here now :-)    Unless
you are a first-timer just discovering that there is a wider ADAM
world, like me at ADAMcon 04, you must admit that the ADAM   per se
is only a flimsy excuse for your attendance this year.  The  real
reason you're here is social.  At past ADAMcons, or via now-
defunct newsletters, or through now-disconnected BBSes, you  met
people who have become your friends.  The ADAM brought you
together, originally for some concrete and practical purpose
(such as, you wrote some software that I want to buy), but   now
the ADAM connection is a historical artifact.  Some of you   would
keep in touch whether there were still ADAMcons or not,      whether
you ever used your ADAMs again or not.  There is nothing     wrong
with this; I merely state it as an important fact to         consider in
the planning of future ADAMcons, if there are to be any.
 
      At some point in the near future, maybe in a year or   two,
maybe even now, there will not be enough dollar votes from   the
ADAM community to justify holding another ADAMcon.  This is
inevitable; the ADAM community is not growing any more.      Just
look at the ages of the people sitting around you.  Growth   comes
from youth, and nowadays, the ADAM has little to offer the   12-
year-old video game wizard or embryonic computer geek.       Compared
to other computer and video game options currently           available, the
ADAM and ColecoVision have been completely surpassed.  This  was
not true as recently as the early 1990s, when sound cards    and
high-resolution color graphics were still relatively         uncommon on
IBM-PC clones, and Sega and Nintendo versions of video games
still weren't very different from the ColecoVision versions. But
today, if you're a kid, unless somebody gives you an ADAM,   or
your parents or grandparents have one already, you won't     even
know ADAMs exist; and once you've played DOOM on your        neighbor's
Pentium, the likes of Burger Time and even Spy Hunter (my    all-
time favorite game cartridge) look pretty lame.
 
      In his Future of the ADAM speech at ADAMcon 04, Rich   Clee
talked about the need to match people with ADAMs.  Don't let
people be tricked into buying expensive PCs if all they      really
need is an ADAM with SmartWriter.  It would be nice to do    this,
but marketing hype conquers all.  Something is wrong when    you
need a Pentium and a laser printer to write a simple letter, and
when the word processing program takes 20 megabytes of hard  disk
space and 8 megabytes of memory.  But like it or not, those  are
the standards of today.  If it doesn't have scalable,
proportional fonts and the ability to include fancy          graphics,
nobody wants it, even if they don't really *need* those      features. 
Worse, however, once all the nifty features are available,   people
will use them, become dependent upon them, and never again
conceive of doing their jobs without them.  At that point,   the
game is over.  For contrast, Wordstar 3.3 for CP/M is a 23K  .COM
file on a floppy disk, and runs in 64K of memory, but unless you
have a daisy-wheel printer, it won't "look" as good as the   laser-
printed version, and it will take 10 times longer to print   out. 
The floor has risen beyond what the ADAM can provide, I      think
needlessly so, but I can't win this argument with Bill       Gates, the
president of Microsoft Corporation, who's laughing all the   way to
the bank.
 
      Consequently, I now believe that the ADAM has ceased   to be a
computer that people would use to perform real work, as      their
system of choice, if they had access to more modern          machines. 
All the EOS software for doing real work, like SmartWriter,
SmartFiler and ADAMcalc, is more a "toy" than a productive   tool. 
"Gee, I'd never have thought you could do that on an ADAM,   but my
Mac does it better and faster."  The CP/M software has a     wider
usage, because there have been many other computers besides  the
ADAM which run CP/M, but it too isn't going to be found in
today's offices and businesses.
 
      If the ADAM is no longer a viable tool for today's     computing
needs, why do you bother with it any more?  Part of the      answer is
interia--you've invested so much time and money into it,     you're
in too deep to give it up.  Another component, as mentioned
above, is social--you've met some dear friends with the ADAM as a
catalyst, and thus you have an emotional attachment to the   ADAM. 
In my own case, have found the ADAM to be an ideal           environment
for learning about digital electronics and computer          programming. 
But I am a rare minority in this.
 
      Inertia and socializing are not sufficient, in the     long run,
to insure the growth of any organization, let alone maintain its
status quo.  The best evidence I can give of this is my own  users
group, B.A.S.I.C. (Best ADAM Support In Cleveland).  Our     monthly
meetings, held in my basement, begin happy and sociable, but when
it's time to talk about the ADAM, it gets quiet.  With few
exceptions, nobody has done anything with his ADAM since the last
meeting, nobody knows what he wants to do with it today,     nobody
says except in vague terms what he wants the group to do     next
time.  If someone creates a structured agenda, there is      little
interest.  Nobody seems interested in learning anything new. 
Soon, talk turns to what people are doing on their PCs at    home,
we break up and most go home.  Those who stay usually are    having
hardware problems, which are diagnosed and repaired if       possible. 
Those who are left after that eat pizza, and I'm usually     left
wondering why we're bothering to have these meetings, except to
collect dues for the annual Christmas dinner and to eat      pizza
once a month.
 
      In the case of B.A.S.I.C., there is blame on all sides for
our current state of affairs.  But I would argue that the    lack of
a desire to learn new things is the primary difficulty we    face. 
Since ADAM software in general often isn't as user-friendly  as
more modern software, and since the ADAM has its own         hardware
quirks, it *will* be harder to learn to use than the average Mac
or PC running Windows.  Given the economic realities I've    talked
about previously, this will never improve.  Thus, the        average
ADAMite will not be able to wait passively for someone else  to
work out all the bugs and kinks--he has to learn enough to   do
that himself.  Since this will require effort, if he isn't
internally motivated enough to do this, he might as well be
honest with himself, put his ADAM in the attic, and have     done
with it.
 
V.    Synthesis.
 
      I came into the ADAM community as a public person at   ADAMcon
04.  While this represents the peak of ADAMcon attendance,
probably this was on the downside of the peak of the ADAM
community in general.  The Solomon Swift debacle, which was
before my time, seems to have been the first breach of       trust. 
Since then, everything has been downhill.  The catfight over
FidoNet versus ADAM BBSes broke up the telecommunications    links
which had previously kept ADAMites in contact, and created
hostilities which still persist.  Important resource people  like
Tony Morehen and Guy Cousineau found better things to do     with
their lives and moved on, leaving a void of programming
experience.  One by one, the hardware vendors went out of
business.  People stopped writing new ADAM software because  there
was no money in it.  PCs and Macs got less expensive and     became
more powerful than ADAMs, inducing ADAMites to gravitate to  where
the action was, so to speak.  And soon, CompuServe will move to
an all-new graphical user interface, like Prodigy and        America
OnLine, which can never be accessed from an ADAM, so ADAM    and all
the other 8-bit microcomputers will be swept aside as
insignificant--as nowadays they are, in dollar terms.  When  this
happens, the last great connecting link for the ADAM         community
will be broken, and ADAM will be without a large-scale       electronic
voice.
 
      For those of us who choose to remain with the ADAM in  some
capacity, it may be painful to confront these realities.     That's
why I warned you at the outset that I might say things which
would make you angry or upset.  But confront them we must,   if we
wish to maintain some semblance of an ADAM community.  Rich
Clee's ADAMcon 04 dream of an ADAMcon 0E (that's 14 in
hexadecimal) seems quite improbable to me now, but it will
certainly be *impossible* if the status quo is allowed to
continue.
 
      Our best shot at changing the status quo is to         consciously
change our group philosophy from advocacy to maintenance.    It
doesn't matter how many good reasons we can think of for why
people should be using ADAMs instead of PC clones--the
uninitiated are not interested, and telling us over and over is
just preaching to the choir.  We've lost, get over it, and   move
on.  Circle the wagons and concentrate on taking care of the
people who are already here.  If we can't win globally, we   should
at least win locally.  If a lost ADAMite stumbles across us,
fine--welcome to the fraternity, we'll take good care of     you. 
But we can't afford to launch expeditions into the           wilderness to
find all the lost ADAMites.
 
      I realize that, with the loss of ADAM advocacy,        vendors are
effectively being told to eat their inventories--new, lost   ADAM
users are more likely to buy hardware and software than      veterans
of 4 or 5 ADAMcons, and no new users means no sales.  I      can't,
however, change this fact:  in 1995, there is no way to make a
living solely from the ADAM community.  Terry Fowler is      trying
it, and he claims he's doing it, but I have my doubts.  Ask  Rich
Clee how fast his inventory is moving; ask Herman Mason and
George Koczwara how brisk their sales are.  At this point,   these
gentlemen can't be in it for the money (unless they are      deluded);
they are basically providing a public service out of the     goodness
of their hearts, which they will continue to do as long as   they
can (mostly) break even.
 
      Maintenance philosophy means anticipating problems     before
they occur.  Picking up a spare ADAM system is good          preventive
maintenance.  Getting an account on your local Freenet, if   you
live near one, is another:  when CompuServe becomes unusable by
the ADAM, you can still send and receive Internet E-mail,    and
keep in contact with other ADAMites who are on the net.      Learning
how to program the ADAM, first in SmartBASIC, then in        assembler,
is a vital maintenance skill:  if you get cut off from the   rest
of the world, you can do your own troubleshooting, and       you'll
always be able to write your own software, and thus, your    ADAM
will always be able to do what *you* want it to do.          Remaining
active users groups and A.N.N. can coordinate repair         services,
software libraries, and technical support, and can make      necessary
technical information available.
 
      Think about your ADAM as if it were a 1957 Chevy
convertible.  It runs, and on sunny summer days you drive it
around to show it off.  It's a great car, and you could      probably
drive it back and forth to work every day, but if anything   broke,
it would be murder finding parts, or a garage with the       experience
to fix it.  So, you don't take too many chances; it stays    covered
in the garage most of the time.  You join a car club, learn  how
to do tuneups, how to change points and plugs, get reprints  of
the shop manual, and learn as much about the car as you can. You
become your own expert, and teach others what you know, just like
others taught you.  This requires energy and activity; if    you
aren't interested in maintaining it yourself, and if you     aren't
rich enough to pay somebody to do it for you, you'd better   stick
with a more modern automobile.  There is no shame in that,   but
you have to be willing to admit to yourself and to everybody else
that you don't want all the trouble.
 
      For me, the prime intellectual attraction of the ADAM  is
that it's a closed universe with definite limits:  since     it's a
commercially dead architecture, it isn't changing very much, and
it stays put long enough so that you can, in principle,      learn
everything there is to know about it.  It has interesting
complexities, yet it is simple enough that you can carry     almost
the entire machine and operating system around in your head. You
can teach it to yourself without trying too hard.  Compare   this
to a modern IBM-PC clone running MS-DOS and Windows.  Both   the
hardware architecture and DOS have stayed remarkably         constant
since 1981, so what you learned about the original PC/XT way back
then is still mostly valid for a Pentium, and you've had 14  years
to assimilate it all.  The Windows operating system,         however, is
so huge and complicated that it takes 10 tedious, highly
technical reference books from Microsoft to *begin* to       explain
it; and after late August, you can throw them all away,      because
the new Windows '95 introduces a host of changes and
incompatibilities.  Unless you are a professional programmer and
paid to look at those manuals all day, you have no hope of   ever
mastering their contents.  As amazing as it may sound to you
avowed non-programmers out there, ADAM programming can be    fun,
even though Windows programming is always terribly hard      work.
 
      I warned you at the outset of this speech that I would
probably make you angry or upset, but that this was both
necessary and good.  It was necessary because these strong
emotions are about the last motivating force we have left to get
ADAMites off their duffs.  Here is your wakeup call:  the    end of
ADAM may be inevitable, but how soon that end comes is       directly
under the control of every person sitting here tonight.      Each of
you is free to junk his ADAM and move on, no hard feelings.  But
those of you who choose to stay can't stay through intertia. You
don't have the luxury of passively waiting for other people  to do
things for you--you need to boost your own activity level.   Why
do you think that ADAMcon 07 is "The Year To Bond"?  If we   want
to continue to have some semblance of an ADAM community,     we'd
better start bonding, banding together to save our           community, or
it *will* disappear. The good which I want to come out of    your
feelings of depression about the current state of the ADAM
community is that you'll get inspired to become more active  in
your users group, inspired to start learning how to be self-
sufficient with your ADAM, and inspired to share what you    know
with the people in this room.
 
      Whether an ADAM community persists or not, *I* will    still
have fun with my ADAM, if only to please me myself.  Despite all
the gloom and doom I've been spouting up here, I want you to
remember that the ADAM is *fun*.  It's fun for *me*.  ADAM   isn't
a tool any more, it's a hobby; so we can all lower our
expectations.  It doesn't have to be efficient, it doesn't   have
to be fast, because we're not basing our livelihoods upon    it--it
just has to be interesting.
 
      Since I find it interesting, and I find all of you
interesting and friendly, I have a personal stake in seeing  the
ADAM community last for a long time.  You've heard about     World
War I army platoons which bought cases of champagne in 1918  and
agreed to meet every year to drink a bottle to the health of the
survivors and to the memory of the fallen.  Every year the
attendance gets smaller, and finally the year comes when     there is
just one old soldier and one last bottle.  "Here's to ya,    lads,"
he says, raising his glass to a room full of ghosts.
 
      I don't want to be that last man.  I don't want this   to be
my last glass.  I don't want this to be the last year for    the
ADAM.
 
      But even if it is, I will still say, "Here's to ya,    lads."
 
 
 
                     Richard F. Drushel, Ph.D.
                     ADAMcon 07, 23 July 1995
 

