program Print_RLE;

    {********************************************************
     *                                                      *
     *          Print Rle File                              *
     *                                                      *
     *          Bruce E. Westfall [73047,427]               *
     *          July 24, 1988                               *
     *                                                      *
     *          This program will read a RLE file and print *
     *          it on an Epson or Epson-like printer.       *
     *          Tested on an Epson MX-80F/T printer.        *
     *          Written in Turbo Pascal on a Coleco Adam    *
     *          computer using a CPM-80 operating system.   *
     *                                                      *
     *          Procedures and functions:                   *
     *            Strip_White -- Strips the white spaces    *
     *                           from the begining the Ram  *
     *                           tail.  Copied from page 211*
     *                           of 4Complete Turbo Pascal5   *
     *                                                      *
     *            Parse_Tail  -- Splits the Ram Tail into   *
     *                           individual filenames (upto *
     *                           10 names).                 *
     *                           Copied from page 211 - 212 *
     *                           of 4Complete Turbo Pascal5   *
     *                                                      *
     *            Init        -- Initializes the globel     *
     *                           array Pic to all 0         *
     *                                                      *
     *            SetLn       -- Converts the integer values*
     *                           Pic to the character values*
     *                           of FirPic and SecPic for   *
     *                           printing.                  *
     *                                                      *
     *            Open        -- Opens the Rle file for     *
     *                           reading.  Strips the first *
     *                           characters away.  They are *
     *                           used to tell if the file is*
     *                           a RLE.                     *
     *                                                      *
     *            Xlate       -- Translates the rle code    *
     *                           into values that can be    *
     *                           converted to ascii in SetLn*
     *                                                      *
     *            Draw        -- Prints the picture on the  *
     *                           printer.                   *
     *                                                      *
     *            Main        -- Main calling procedure.    *
     *                                                      *
     *       References:                                    *
     *            Clary, Tom [71330,3636] "Message #68795   *
     *               S10/Adam CP/M." 4Computor Club Forum.5   *
     *               Compuserve, July 16, 1988.             *
     *                                                      *
     *            Duntemann, Jeff 4Complete Turbo Pascal.5    *
     *               Scott, Foresman, and Company. Glenview *
     *               Illinios, 1986.                        *
     *                                                      *
     *            Lien, David A. 4Epson MX Printer Manual5    *
     *               4Graftrax plus.5 Compusoft Publishing.   *
     *               San Diego, California, 1982.           *
     *                                                      *
     ********************************************************}


  type
     PicType    = array [1..256] of integer;
     String255  = string[255];
     String200  = string[200];
     String128  = string[128];
     String56   = string[56];
     String14   = string[14];
     Parm_Array = array [1..10] of String14;

  var
     InFile     : Text;
     FirPic     : array [1..24] of String200;
     Pic        : PicType;
     Ram_Tail   : string128 absolute $80;  {Command Line input}
     SecPic     : array [1..24] of String56;

   function Strip_White(Target : String255) : String255;

      const
         WhiteSpace : set of char = [#8,#10,#12,#13,' '];

      begin
         while (Length(Target) > 0) and (Target[1] in whitespace) do
            delete(Target,1,1);
         Strip_White := Target;
         end {Strip_White};

   procedure Parse_Tail (var Count : integer;
                         var Parms : Parm_Array);

     var
        Marker   : integer;
        Tail     : String128;

     begin
        Tail := Ram_Tail;
        Count := 0;
        Tail := Strip_White(Tail);
        If (Length(Tail) > 0) then repeat
           Marker := pos(' ',Tail) - 1;
           If Marker <= 0 then Marker := Length(Tail);
           Count := Count + 1;
           Parms[Count] := copy(Tail,1,Marker);
           Delete(Tail,1,Marker);
           Tail := Strip_White(Tail);
           until (Count >= 10) or (Length(Tail) = 0);
        end;

   procedure Init;

     var
       I    : integer;

     begin
       for I := 1 to 256 do
         Pic[I] := 0;
       end {init};

   procedure SetLn (Line : integer);

     var
        J  : integer;

     begin
       FirPic[Line] := '';
       SecPic[Line] := '';
       FirPic[Line] := chr(Pic[1]);
       for j:= 2 to 200 do
           FirPic[Line] := FirPic[Line] + chr(Pic[J]);
       SecPic[Line] := chr(Pic[201]);
       for J := 202 to 256 do
           SecPic[Line] := SecPic[Line] + chr(Pic[J]);
       end {SetLn};

   procedure Open (FileName : String14);

      var
         Ch        : char;
         I         : integer;

      begin
         if (FileName = '') then begin
            write(output,'Filename: ');
            readln(input, filename);
            end {if};
         assign (InFile,FileName);
         reset (Infile);
         for I := 1 to 3 do begin
             read(InFile, Ch);
             end {for};
         end {for};

   procedure Xlate;

     var
        Ch       : char;
        Column   : integer;
        Done     : boolean;
        Dot      : integer;
        Line, I  : integer;
        Loop, X  : integer;
        Pixel    : boolean;
 
     begin  
        Init;
        Pixel := true;
        Line := 1;
        Done := false;
        Dot := 7;
        Column := 0;
        repeat
           if (not eof(InFile)) then begin
                read(InFile,Ch);
                Loop := ord(Ch) - 32;
                if (Loop <> 0) then begin
                   X := 2;
                   if (Pixel) then Begin
                      if (Dot = 0) then X := 1
                         else if (Dot > 1) then
                            for I := 2 to Dot do X:=X*2;
                      end else X := 0;
                   for I := 1 to Loop do begin
                      Column := Column + 1;
                      Pic[Column] := Pic[Column] + X;
                      if (Column = 256) then begin
                         if (Dot > 0) then begin
                            Dot := Dot - 1;
                            Column := 0;
                            end else begin
                                Column := 0;
                                Dot := 7;
                                SetLn (Line);
                                Init;
                                Line := Line + 1;
                                If (Line > 24) then Done := true;
                                end {else}; 
                         end {if};
                      end {for};
                   end {if};
                Pixel := not Pixel;
                end else Done := true;
            until (Done);
         end {Xlate};

   procedure Draw;

     var
        Line   : integer;
        LnSp   : string[3];
        Print  : string[4];
 
     begin
        Print := chr(27) + 'K' + chr(255) + chr(0);
        LnSp  := chr(27) + 'A' + chr(8);
        writeln(lst,LnSp);
        for Line := 1 to 24 do begin
            write(lst,Print);
            write(lst,FirPic[Line]);
            writeln(lst,SecPic[Line]);
            end {for};
        end {Draw};

   procedure Main;

     var
        I          : Integer;
        Parm_Count : integer;
        Parms      : Parm_Array;
 
     begin
        Parse_Tail(Parm_Count,Parms);
        if (Parm_Count = 0 ) then begin
           Parm_Count := 1;
           Parms[1] := '';
           end{if};
        for I := 1 to Parm_Count do begin
           Open (Parms[I]);
           Xlate;
           Draw;
           close(InFile);
           end;
        end {Main};

   begin
     Main;
     end.
 Xlate;
           Draw;
           close(InFile);
           end;
        end {Main};

   begin